/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FileSplitter {
    private RandomAccessFile file;
    private int dataChunkSize;
    private int lastChunkSize;

    public FileSplitter(String fileName, int dataChunkSize) throws IOException {
        this.file = new RandomAccessFile(fileName, "r");
        this.dataChunkSize = dataChunkSize;
        this.lastChunkSize = (int)(this.file.length() % (long)dataChunkSize);
    }

    public FileSplitter(File file, int dataChunkSize) throws IOException {
        this.file = new RandomAccessFile(file, "ra");
        this.dataChunkSize = dataChunkSize;
        this.lastChunkSize = (int)(file.length() % (long)dataChunkSize);
    }

    public boolean hasMoreData() {
        try {
            return this.file.getFilePointer() < this.file.length();
        }
        catch (Exception e) {
            return false;
        }
    }

    public byte[] getNextDataChunk() throws IOException {
        byte[] result = null;
        result = this.file.getFilePointer() < this.file.length() - (long)this.lastChunkSize ? new byte[this.dataChunkSize] : new byte[this.lastChunkSize];
        this.file.read(result);
        return result;
    }
}

