/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.result.impl.filter;

import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.result.impl.IBIResultSet;
import com.sap.ip.bi.sdk.dac.result.impl.IBISynchronizedResultSetFilter;
import com.sap.ip.bi.sdk.exception.BIRuntimeException;
import com.sap.ip.bi.sdk.exception.BISQLException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;

public class BIAddColumnsResultSetFilter
implements IBISynchronizedResultSetFilter {
    private static final String FILTER_NAME = "BIAddColumnsResultSetFilter";
    private static final String FILTER_DESCRIPTION = "Add columns to an existing resultset";
    private IBIResultSet source = null;
    private int sourceColumnCount = 0;
    private IBIResultSet additional = null;
    private ResultSetMetaData resultMeta = null;
    protected IBIConnectionInfo connectionInfo = IBIConnectionInfo.DEFAULT;

    private BIAddColumnsResultSetFilter() {
    }

    public BIAddColumnsResultSetFilter(IBIResultSet source, IBIResultSet additional) throws SQLException {
        this.assertResultSetNotNull(source, "sdk.dac.rel.result_7006");
        this.source = source;
        this.assertResultSetNotNull(additional, "sdk.dac.rel.result_7007");
        this.additional = additional;
        this.sourceColumnCount = source.getMetaData().getColumnCount();
        this.resultMeta = new BIAddColumnsResultSetFilterMetaData(source.getMetaData(), additional.getMetaData());
    }

    public BIAddColumnsResultSetFilter(IBIConnectionInfo connectionInfo, IBIResultSet source, IBIResultSet additional) throws SQLException {
        this.connectionInfo = connectionInfo;
        this.assertConnectionInfo();
        this.assertResultSetNotNull(source, "sdk.dac.rel.result_7006");
        this.source = source;
        this.assertResultSetNotNull(additional, "sdk.dac.rel.result_7006");
        this.additional = additional;
        this.sourceColumnCount = source.getMetaData().getColumnCount();
        this.resultMeta = new BIAddColumnsResultSetFilterMetaData(source.getMetaData(), additional.getMetaData());
    }

    public String getFilterName() {
        return FILTER_NAME;
    }

    public String getFilterDescription() {
        return FILTER_DESCRIPTION;
    }

    public void setSourceResultSet(IBIResultSet source) throws SQLException {
        this.assertResultSetNotNull(source, "sdk.dac.rel.result_7006");
        this.source = source;
        this.resultMeta = new BIAddColumnsResultSetFilterMetaData(source.getMetaData(), this.additional.getMetaData());
    }

    public void setAdditionalDataResultSet(IBIResultSet additional) throws SQLException {
        this.assertResultSetNotNull(additional, "sdk.dac.rel.result_7007");
        this.additional = additional;
        this.resultMeta = new BIAddColumnsResultSetFilterMetaData(this.source.getMetaData(), additional.getMetaData());
    }

    public boolean synchAbsolute(int arg0) throws SQLException {
        return this.source.synchAbsolute(arg0);
    }

    public boolean synchRelative(int arg0) throws SQLException {
        return this.source.synchRelative(arg0);
    }

    public void synchBeforeFirst() throws SQLException {
        this.source.synchBeforeFirst();
    }

    public void synchAfterLast() throws SQLException {
        this.source.synchAfterLast();
    }

    public int synchGetRow() throws SQLException {
        return this.source.synchGetRow();
    }

    public int synchGetColumnCount() throws SQLException {
        if (this.resultMeta == null) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2010");
        }
        return this.resultMeta.getColumnCount();
    }

    public int synchGetRowCount() throws SQLException {
        return this.source.synchGetRowCount();
    }

    public void setSynchronized(boolean synchronize) throws SQLException {
        if (this.resultMeta == null) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2010");
        }
        this.source.setSynchronized(synchronize);
    }

    public boolean isSynchronized() throws SQLException {
        if (this.resultMeta == null) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2010");
        }
        return this.source.isSynchronized();
    }

    public void synchronize() throws SQLException {
        this.source.synchronize();
    }

    public boolean next() throws SQLException {
        return this.source.next() && this.additional.next();
    }

    public void close() throws SQLException {
        this.source.close();
        this.additional.close();
    }

    public boolean wasNull() throws SQLException {
        return this.source.wasNull() || this.additional.wasNull();
    }

    public String getString(int arg0) throws SQLException {
        if (arg0 > this.sourceColumnCount) {
            return this.additional.getString(arg0);
        }
        return this.source.getString(arg0);
    }

    public boolean getBoolean(int arg0) throws SQLException {
        if (arg0 > this.sourceColumnCount) {
            return this.additional.getBoolean(arg0);
        }
        return this.source.getBoolean(arg0);
    }

    public byte getByte(int arg0) throws SQLException {
        if (arg0 > this.sourceColumnCount) {
            return this.additional.getByte(arg0);
        }
        return this.source.getByte(arg0);
    }

    public short getShort(int arg0) throws SQLException {
        if (arg0 > this.sourceColumnCount) {
            return this.additional.getShort(arg0);
        }
        return this.source.getShort(arg0);
    }

    public int getInt(int arg0) throws SQLException {
        if (arg0 > this.sourceColumnCount) {
            return this.additional.getInt(arg0);
        }
        return this.source.getInt(arg0);
    }

    public long getLong(int arg0) throws SQLException {
        if (arg0 > this.sourceColumnCount) {
            return this.additional.getLong(arg0);
        }
        return this.source.getLong(arg0);
    }

    public float getFloat(int arg0) throws SQLException {
        if (arg0 > this.sourceColumnCount) {
            return this.additional.getFloat(arg0);
        }
        return this.source.getFloat(arg0);
    }

    public double getDouble(int arg0) throws SQLException {
        if (arg0 > this.sourceColumnCount) {
            return this.additional.getDouble(arg0);
        }
        return this.source.getDouble(arg0);
    }

    public BigDecimal getBigDecimal(int arg0, int arg1) throws SQLException {
        if (arg0 > this.sourceColumnCount) {
            return this.additional.getBigDecimal(arg0, arg1);
        }
        return this.source.getBigDecimal(arg0, arg1);
    }

    public byte[] getBytes(int arg0) throws SQLException {
        if (arg0 > this.sourceColumnCount) {
            return this.additional.getBytes(arg0);
        }
        return this.source.getBytes(arg0);
    }

    public Date getDate(int arg0) throws SQLException {
        if (arg0 > this.sourceColumnCount) {
            return this.additional.getDate(arg0);
        }
        return this.source.getDate(arg0);
    }

    public Time getTime(int arg0) throws SQLException {
        if (arg0 > this.sourceColumnCount) {
            return this.additional.getTime(arg0);
        }
        return this.source.getTime(arg0);
    }

    public Timestamp getTimestamp(int arg0) throws SQLException {
        if (arg0 > this.sourceColumnCount) {
            return this.additional.getTimestamp(arg0);
        }
        return this.source.getTimestamp(arg0);
    }

    public InputStream getAsciiStream(int arg0) throws SQLException {
        if (arg0 > this.sourceColumnCount) {
            return this.additional.getAsciiStream(arg0);
        }
        return this.source.getAsciiStream(arg0);
    }

    public InputStream getUnicodeStream(int arg0) throws SQLException {
        if (arg0 > this.sourceColumnCount) {
            return this.additional.getUnicodeStream(arg0);
        }
        return this.source.getUnicodeStream(arg0);
    }

    public InputStream getBinaryStream(int arg0) throws SQLException {
        return this.source.getBinaryStream(arg0);
    }

    public String getString(String arg0) throws SQLException {
        return this.source.getString(arg0);
    }

    public boolean getBoolean(String arg0) throws SQLException {
        return this.source.getBoolean(arg0);
    }

    public byte getByte(String arg0) throws SQLException {
        return this.source.getByte(arg0);
    }

    public short getShort(String arg0) throws SQLException {
        return this.source.getShort(arg0);
    }

    public int getInt(String arg0) throws SQLException {
        return this.source.getInt(arg0);
    }

    public long getLong(String arg0) throws SQLException {
        return this.source.getLong(arg0);
    }

    public float getFloat(String arg0) throws SQLException {
        return this.source.getFloat(arg0);
    }

    public double getDouble(String arg0) throws SQLException {
        return this.source.getDouble(arg0);
    }

    public BigDecimal getBigDecimal(String arg0, int arg1) throws SQLException {
        return this.source.getBigDecimal(arg0, arg1);
    }

    public byte[] getBytes(String arg0) throws SQLException {
        return this.source.getBytes(arg0);
    }

    public Date getDate(String arg0) throws SQLException {
        return this.source.getDate(arg0);
    }

    public Time getTime(String arg0) throws SQLException {
        return this.source.getTime(arg0);
    }

    public Timestamp getTimestamp(String arg0) throws SQLException {
        return this.source.getTimestamp(arg0);
    }

    public InputStream getAsciiStream(String arg0) throws SQLException {
        return this.source.getAsciiStream(arg0);
    }

    public InputStream getUnicodeStream(String arg0) throws SQLException {
        return this.source.getUnicodeStream(arg0);
    }

    public InputStream getBinaryStream(String arg0) throws SQLException {
        return this.source.getBinaryStream(arg0);
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.source.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.source.clearWarnings();
    }

    public String getCursorName() throws SQLException {
        return this.source.getCursorName();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.source.getMetaData();
    }

    public Object getObject(int arg0) throws SQLException {
        return this.source.getObject(arg0);
    }

    public Object getObject(String arg0) throws SQLException {
        return this.source.getObject(arg0);
    }

    public int findColumn(String arg0) throws SQLException {
        return this.source.findColumn(arg0);
    }

    public Reader getCharacterStream(int arg0) throws SQLException {
        return this.source.getCharacterStream(arg0);
    }

    public Reader getCharacterStream(String arg0) throws SQLException {
        return this.source.getCharacterStream(arg0);
    }

    public BigDecimal getBigDecimal(int arg0) throws SQLException {
        return this.source.getBigDecimal(arg0);
    }

    public BigDecimal getBigDecimal(String arg0) throws SQLException {
        return this.source.getBigDecimal(arg0);
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.source.isBeforeFirst();
    }

    public boolean isAfterLast() throws SQLException {
        return this.source.isAfterLast();
    }

    public boolean isFirst() throws SQLException {
        return this.source.isFirst();
    }

    public boolean isLast() throws SQLException {
        return this.source.isLast();
    }

    public void beforeFirst() throws SQLException {
        this.source.beforeFirst();
    }

    public void afterLast() throws SQLException {
        this.source.afterLast();
    }

    public boolean first() throws SQLException {
        return this.source.first();
    }

    public boolean last() throws SQLException {
        return this.source.last();
    }

    public int getRow() throws SQLException {
        return this.source.getRow();
    }

    public boolean absolute(int arg0) throws SQLException {
        return this.source.absolute(arg0);
    }

    public boolean relative(int arg0) throws SQLException {
        return this.source.relative(arg0);
    }

    public boolean previous() throws SQLException {
        return this.source.previous();
    }

    public void setFetchDirection(int arg0) throws SQLException {
        this.source.setFetchDirection(arg0);
    }

    public int getFetchDirection() throws SQLException {
        return this.source.getFetchDirection();
    }

    public void setFetchSize(int arg0) throws SQLException {
        this.source.setFetchSize(arg0);
    }

    public int getFetchSize() throws SQLException {
        return this.source.getFetchSize();
    }

    public int getType() throws SQLException {
        return this.source.getType();
    }

    public int getConcurrency() throws SQLException {
        return this.source.getType();
    }

    public boolean rowUpdated() throws SQLException {
        return this.source.rowUpdated();
    }

    public boolean rowInserted() throws SQLException {
        return this.source.rowInserted();
    }

    public boolean rowDeleted() throws SQLException {
        return this.source.rowDeleted();
    }

    public void updateNull(int arg0) throws SQLException {
        this.source.updateNull(arg0);
    }

    public void updateBoolean(int arg0, boolean arg1) throws SQLException {
        this.source.updateBoolean(arg0, arg1);
    }

    public void updateByte(int arg0, byte arg1) throws SQLException {
        this.source.updateByte(arg0, arg1);
    }

    public void updateShort(int arg0, short arg1) throws SQLException {
        this.source.updateShort(arg0, arg1);
    }

    public void updateInt(int arg0, int arg1) throws SQLException {
        this.source.updateInt(arg0, arg1);
    }

    public void updateLong(int arg0, long arg1) throws SQLException {
        this.source.updateLong(arg0, arg1);
    }

    public void updateFloat(int arg0, float arg1) throws SQLException {
        this.source.updateFloat(arg0, arg1);
    }

    public void updateDouble(int arg0, double arg1) throws SQLException {
        this.source.updateDouble(arg0, arg1);
    }

    public void updateBigDecimal(int arg0, BigDecimal arg1) throws SQLException {
        this.source.updateBigDecimal(arg0, arg1);
    }

    public void updateString(int arg0, String arg1) throws SQLException {
        this.source.updateString(arg0, arg1);
    }

    public void updateBytes(int arg0, byte[] arg1) throws SQLException {
        this.source.updateBytes(arg0, arg1);
    }

    public void updateDate(int arg0, Date arg1) throws SQLException {
        this.source.updateDate(arg0, arg1);
    }

    public void updateTime(int arg0, Time arg1) throws SQLException {
        this.source.updateTime(arg0, arg1);
    }

    public void updateTimestamp(int arg0, Timestamp arg1) throws SQLException {
        this.source.updateTimestamp(arg0, arg1);
    }

    public void updateAsciiStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        this.source.updateAsciiStream(arg0, arg1, arg2);
    }

    public void updateBinaryStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        this.source.updateBinaryStream(arg0, arg1, arg2);
    }

    public void updateCharacterStream(int arg0, Reader arg1, int arg2) throws SQLException {
        this.source.updateCharacterStream(arg0, arg1, arg2);
    }

    public void updateObject(int arg0, Object arg1, int arg2) throws SQLException {
        this.source.updateObject(arg0, arg1, arg2);
    }

    public void updateObject(int arg0, Object arg1) throws SQLException {
        this.source.updateObject(arg0, arg1);
    }

    public void updateNull(String arg0) throws SQLException {
        this.source.updateNull(arg0);
    }

    public void updateBoolean(String arg0, boolean arg1) throws SQLException {
        this.source.updateBoolean(arg0, arg1);
    }

    public void updateByte(String arg0, byte arg1) throws SQLException {
        this.source.updateByte(arg0, arg1);
    }

    public void updateShort(String arg0, short arg1) throws SQLException {
        this.source.updateShort(arg0, arg1);
    }

    public void updateInt(String arg0, int arg1) throws SQLException {
        this.source.updateInt(arg0, arg1);
    }

    public void updateLong(String arg0, long arg1) throws SQLException {
        this.source.updateLong(arg0, arg1);
    }

    public void updateFloat(String arg0, float arg1) throws SQLException {
        this.source.updateFloat(arg0, arg1);
    }

    public void updateDouble(String arg0, double arg1) throws SQLException {
        this.source.updateDouble(arg0, arg1);
    }

    public void updateBigDecimal(String arg0, BigDecimal arg1) throws SQLException {
        this.source.updateBigDecimal(arg0, arg1);
    }

    public void updateString(String arg0, String arg1) throws SQLException {
        this.source.updateString(arg0, arg1);
    }

    public void updateBytes(String arg0, byte[] arg1) throws SQLException {
        this.source.updateBytes(arg0, arg1);
    }

    public void updateDate(String arg0, Date arg1) throws SQLException {
        this.source.updateDate(arg0, arg1);
    }

    public void updateTime(String arg0, Time arg1) throws SQLException {
        this.source.updateTime(arg0, arg1);
    }

    public void updateTimestamp(String arg0, Timestamp arg1) throws SQLException {
        this.source.updateTimestamp(arg0, arg1);
    }

    public void updateAsciiStream(String arg0, InputStream arg1, int arg2) throws SQLException {
        this.source.updateAsciiStream(arg0, arg1, arg2);
    }

    public void updateBinaryStream(String arg0, InputStream arg1, int arg2) throws SQLException {
        this.source.updateBinaryStream(arg0, arg1, arg2);
    }

    public void updateCharacterStream(String arg0, Reader arg1, int arg2) throws SQLException {
        this.source.updateCharacterStream(arg0, arg1, arg2);
    }

    public void updateObject(String arg0, Object arg1, int arg2) throws SQLException {
        this.source.updateObject(arg0, arg1, arg2);
    }

    public void updateObject(String arg0, Object arg1) throws SQLException {
        this.source.updateObject(arg0, arg1);
    }

    public void insertRow() throws SQLException {
        this.source.insertRow();
    }

    public void updateRow() throws SQLException {
        this.source.updateRow();
    }

    public void deleteRow() throws SQLException {
        this.source.deleteRow();
    }

    public void refreshRow() throws SQLException {
        this.source.refreshRow();
    }

    public void cancelRowUpdates() throws SQLException {
        this.source.cancelRowUpdates();
    }

    public void moveToInsertRow() throws SQLException {
        this.source.moveToInsertRow();
    }

    public void moveToCurrentRow() throws SQLException {
        this.source.moveToCurrentRow();
    }

    public Statement getStatement() throws SQLException {
        return this.source.getStatement();
    }

    public Object getObject(int arg0, Map arg1) throws SQLException {
        return this.source.getObject(arg0, arg1);
    }

    public Ref getRef(int arg0) throws SQLException {
        return this.source.getRef(arg0);
    }

    public Blob getBlob(int arg0) throws SQLException {
        return this.source.getBlob(arg0);
    }

    public Clob getClob(int arg0) throws SQLException {
        return this.source.getClob(arg0);
    }

    public Array getArray(int arg0) throws SQLException {
        return this.source.getArray(arg0);
    }

    public Object getObject(String arg0, Map arg1) throws SQLException {
        return this.source.getObject(arg0, arg1);
    }

    public Ref getRef(String arg0) throws SQLException {
        return this.source.getRef(arg0);
    }

    public Blob getBlob(String arg0) throws SQLException {
        return this.source.getBlob(arg0);
    }

    public Clob getClob(String arg0) throws SQLException {
        return this.source.getClob(arg0);
    }

    public Array getArray(String arg0) throws SQLException {
        return this.source.getArray(arg0);
    }

    public Date getDate(int arg0, Calendar arg1) throws SQLException {
        return this.source.getDate(arg0, arg1);
    }

    public Date getDate(String arg0, Calendar arg1) throws SQLException {
        return this.source.getDate(arg0, arg1);
    }

    public Time getTime(int arg0, Calendar arg1) throws SQLException {
        return this.source.getTime(arg0, arg1);
    }

    public Time getTime(String arg0, Calendar arg1) throws SQLException {
        return this.source.getTime(arg0, arg1);
    }

    public Timestamp getTimestamp(int arg0, Calendar arg1) throws SQLException {
        return this.source.getTimestamp(arg0, arg1);
    }

    public Timestamp getTimestamp(String arg0, Calendar arg1) throws SQLException {
        return this.source.getTimestamp(arg0, arg1);
    }

    public URL getURL(int arg0) throws SQLException {
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public URL getURL(String arg0) throws SQLException {
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public void updateRef(int arg0, Ref arg1) throws SQLException {
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public void updateRef(String arg0, Ref arg1) throws SQLException {
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public void updateBlob(int arg0, Blob arg1) throws SQLException {
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public void updateBlob(String arg0, Blob arg1) throws SQLException {
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public void updateClob(int arg0, Clob arg1) throws SQLException {
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public void updateClob(String arg0, Clob arg1) throws SQLException {
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public void updateArray(int arg0, Array arg1) throws SQLException {
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public void updateArray(String arg0, Array arg1) throws SQLException {
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    private void assertResultSetNotNull(IBIResultSet result, String message) throws SQLException {
        if (result == null) {
            throw new BISQLException(this.connectionInfo.getLocale(), message);
        }
    }

    private void assertConnectionInfo() {
        if (this.connectionInfo == null) {
            throw new BIRuntimeException(Locale.getDefault(), "sdk_0000");
        }
    }

    private class BIAddColumnsResultSetFilterMetaData
    implements ResultSetMetaData {
        private ResultSetMetaData sourceMeta = null;
        private ResultSetMetaData additionalMeta = null;
        private int sourceColumnCount = 0;

        private BIAddColumnsResultSetFilterMetaData() {
        }

        public BIAddColumnsResultSetFilterMetaData(ResultSetMetaData sourceMeta, ResultSetMetaData additionalMeta) throws SQLException {
            this.sourceMeta = sourceMeta;
            this.sourceColumnCount = sourceMeta.getColumnCount();
            this.additionalMeta = additionalMeta;
        }

        public int getColumnCount() throws SQLException {
            return this.sourceMeta.getColumnCount() + this.additionalMeta.getColumnCount();
        }

        public boolean isAutoIncrement(int arg0) throws SQLException {
            if (arg0 > this.sourceColumnCount) {
                return this.additionalMeta.isAutoIncrement(arg0 - this.sourceColumnCount);
            }
            return this.sourceMeta.isAutoIncrement(arg0);
        }

        public boolean isCaseSensitive(int arg0) throws SQLException {
            if (arg0 > this.sourceColumnCount) {
                return this.additionalMeta.isCaseSensitive(arg0 - this.sourceColumnCount);
            }
            return this.sourceMeta.isCaseSensitive(arg0);
        }

        public boolean isSearchable(int arg0) throws SQLException {
            if (arg0 > this.sourceColumnCount) {
                return this.additionalMeta.isSearchable(arg0 - this.sourceColumnCount);
            }
            return this.sourceMeta.isSearchable(arg0);
        }

        public boolean isCurrency(int arg0) throws SQLException {
            if (arg0 > this.sourceColumnCount) {
                return this.additionalMeta.isCurrency(arg0 - this.sourceColumnCount);
            }
            return this.sourceMeta.isCurrency(arg0);
        }

        public int isNullable(int arg0) throws SQLException {
            if (arg0 > this.sourceColumnCount) {
                return this.additionalMeta.isNullable(arg0 - this.sourceColumnCount);
            }
            return this.sourceMeta.isNullable(arg0);
        }

        public boolean isSigned(int arg0) throws SQLException {
            if (arg0 > this.sourceColumnCount) {
                return this.additionalMeta.isSigned(arg0 - this.sourceColumnCount);
            }
            return this.sourceMeta.isSigned(arg0);
        }

        public int getColumnDisplaySize(int arg0) throws SQLException {
            if (arg0 > this.sourceColumnCount) {
                return this.additionalMeta.getColumnDisplaySize(arg0 - this.sourceColumnCount);
            }
            return this.sourceMeta.getColumnDisplaySize(arg0);
        }

        public String getColumnLabel(int arg0) throws SQLException {
            if (arg0 > this.sourceColumnCount) {
                return this.additionalMeta.getColumnLabel(arg0 - this.sourceColumnCount);
            }
            return this.sourceMeta.getColumnLabel(arg0);
        }

        public String getColumnName(int arg0) throws SQLException {
            if (arg0 > this.sourceColumnCount) {
                return this.additionalMeta.getColumnName(arg0 - this.sourceColumnCount);
            }
            return this.sourceMeta.getColumnName(arg0);
        }

        public String getSchemaName(int arg0) throws SQLException {
            if (arg0 > this.sourceColumnCount) {
                return this.additionalMeta.getSchemaName(arg0 - this.sourceColumnCount);
            }
            return this.sourceMeta.getSchemaName(arg0);
        }

        public int getPrecision(int arg0) throws SQLException {
            if (arg0 > this.sourceColumnCount) {
                return this.additionalMeta.getPrecision(arg0 - this.sourceColumnCount);
            }
            return this.sourceMeta.getPrecision(arg0);
        }

        public int getScale(int arg0) throws SQLException {
            if (arg0 > this.sourceColumnCount) {
                return this.additionalMeta.getScale(arg0 - this.sourceColumnCount);
            }
            return this.sourceMeta.getScale(arg0);
        }

        public String getTableName(int arg0) throws SQLException {
            if (arg0 > this.sourceColumnCount) {
                return this.additionalMeta.getTableName(arg0 - this.sourceColumnCount);
            }
            return this.sourceMeta.getTableName(arg0);
        }

        public String getCatalogName(int arg0) throws SQLException {
            if (arg0 > this.sourceColumnCount) {
                return this.additionalMeta.getCatalogName(arg0 - this.sourceColumnCount);
            }
            return this.sourceMeta.getCatalogName(arg0);
        }

        public int getColumnType(int arg0) throws SQLException {
            if (arg0 > this.sourceColumnCount) {
                return this.additionalMeta.getColumnType(arg0 - this.sourceColumnCount);
            }
            return this.sourceMeta.getColumnType(arg0);
        }

        public String getColumnTypeName(int arg0) throws SQLException {
            if (arg0 > this.sourceColumnCount) {
                return this.additionalMeta.getColumnTypeName(arg0 - this.sourceColumnCount);
            }
            return this.sourceMeta.getColumnTypeName(arg0);
        }

        public boolean isReadOnly(int arg0) throws SQLException {
            if (arg0 > this.sourceColumnCount) {
                return this.additionalMeta.isReadOnly(arg0 - this.sourceColumnCount);
            }
            return this.sourceMeta.isReadOnly(arg0);
        }

        public boolean isWritable(int arg0) throws SQLException {
            if (arg0 > this.sourceColumnCount) {
                return this.additionalMeta.isWritable(arg0 - this.sourceColumnCount);
            }
            return this.sourceMeta.isWritable(arg0);
        }

        public boolean isDefinitelyWritable(int arg0) throws SQLException {
            if (arg0 > this.sourceColumnCount) {
                return this.additionalMeta.isDefinitelyWritable(arg0 - this.sourceColumnCount);
            }
            return this.sourceMeta.isDefinitelyWritable(arg0);
        }

        public String getColumnClassName(int arg0) throws SQLException {
            if (arg0 > this.sourceColumnCount) {
                return this.additionalMeta.getColumnClassName(arg0 - this.sourceColumnCount);
            }
            return this.sourceMeta.getColumnClassName(arg0);
        }
    }
}

