/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.result.impl;

import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.result.impl.IBIResultSet;
import com.sap.ip.bi.sdk.dac.result.impl.IBISynchronizeCursor;
import com.sap.ip.bi.sdk.exception.BIRuntimeException;
import com.sap.ip.bi.sdk.exception.BISQLException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;

public class BISQLResultSet
implements IBIResultSet,
IBISynchronizeCursor {
    private final IBIResultSet.Type resultSetType;
    private final boolean resultSetUpdateable;
    private ResultSet row = null;
    private int fetchDirection = 1002;
    private int fetchSize = 0;
    private boolean isSynchronized = false;
    private IBIConnectionInfo connectionInfo = IBIConnectionInfo.DEFAULT;

    private BISQLResultSet() {
        this.resultSetType = IBIResultSet.Type.UNRESTRICTED;
        this.resultSetUpdateable = false;
    }

    public BISQLResultSet(ResultSet row, IBIResultSet.Type resultSetType, boolean resultSetUpdateable) throws SQLException {
        this.resultSetType = resultSetType;
        this.resultSetUpdateable = resultSetUpdateable;
        this.row = row;
        if (resultSetType == null || resultSetType != IBIResultSet.Type.UNRESTRICTED && resultSetType != IBIResultSet.Type.ACCESS && resultSetType != IBIResultSet.Type.NAVIGATION) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2012", new Object[]{resultSetType});
        }
        if (resultSetUpdateable) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1001");
        }
    }

    public BISQLResultSet(IBIConnectionInfo connectionInfo, ResultSet row, IBIResultSet.Type resultSetType, boolean resultSetUpdateable) throws SQLException {
        this.connectionInfo = connectionInfo;
        this.assertConnectionInfo();
        this.resultSetType = resultSetType;
        this.resultSetUpdateable = resultSetUpdateable;
        this.row = row;
        if (resultSetType == null || resultSetType != IBIResultSet.Type.UNRESTRICTED && resultSetType != IBIResultSet.Type.ACCESS && resultSetType != IBIResultSet.Type.NAVIGATION) {
            throw new BISQLException(connectionInfo.getLocale(), "sdk.dac.rel.result_2012", new Object[]{resultSetType});
        }
        if (resultSetUpdateable) {
            throw new BISQLException(connectionInfo.getLocale(), "sdk.dac.rel.result_1001");
        }
    }

    public void setSynchronized(boolean synchronize) throws SQLException {
        throw new SQLException("method not supported");
    }

    public boolean isSynchronized() throws SQLException {
        throw new SQLException("method not supported");
    }

    public void synchronize() throws SQLException {
        if (this.isSynchronized) {
            throw new SQLException("method not supported");
        }
    }

    public boolean synchAbsolute(int arg0) throws SQLException {
        return this.row.absolute(arg0);
    }

    public boolean synchRelative(int arg0) throws SQLException {
        return this.row.relative(arg0);
    }

    public void synchBeforeFirst() throws SQLException {
        this.row.beforeFirst();
    }

    public void synchAfterLast() throws SQLException {
        this.row.afterLast();
    }

    public int synchGetRow() throws SQLException {
        return this.row.getRow();
    }

    public int synchGetColumnCount() throws SQLException {
        return this.row.getMetaData().getColumnCount();
    }

    public int synchGetRowCount() throws SQLException {
        try {
            int current = this.row.getRow();
            if (this.row.absolute(-1)) {
                int last = this.row.getRow();
                if (this.row.absolute(current)) {
                    return last - current + 1;
                }
                throw new SQLException("positioning failed");
            }
            throw new SQLException("positioning failed");
        }
        catch (SQLException ex) {
            throw new SQLException("rowcount not possible");
        }
    }

    public boolean next() throws SQLException {
        this.assertNavigation();
        boolean ret = this.row.next();
        this.synchronize();
        return ret;
    }

    public void close() throws SQLException {
        this.assertNavigation();
        this.row.close();
        this.synchronize();
    }

    public boolean wasNull() throws SQLException {
        this.assertAccess();
        return this.row.wasNull();
    }

    public String getString(int arg0) throws SQLException {
        this.assertAccess();
        return this.row.getString(arg0);
    }

    public boolean getBoolean(int arg0) throws SQLException {
        this.assertAccess();
        return this.row.getBoolean(arg0);
    }

    public byte getByte(int arg0) throws SQLException {
        this.assertAccess();
        return this.row.getByte(arg0);
    }

    public short getShort(int arg0) throws SQLException {
        this.assertAccess();
        return this.row.getShort(arg0);
    }

    public int getInt(int arg0) throws SQLException {
        this.assertAccess();
        return this.row.getInt(arg0);
    }

    public long getLong(int arg0) throws SQLException {
        this.assertAccess();
        return this.row.getLong(arg0);
    }

    public float getFloat(int arg0) throws SQLException {
        this.assertAccess();
        return this.row.getFloat(arg0);
    }

    public double getDouble(int arg0) throws SQLException {
        this.assertAccess();
        return this.row.getDouble(arg0);
    }

    public BigDecimal getBigDecimal(int arg0, int arg1) throws SQLException {
        this.assertAccess();
        return this.row.getBigDecimal(arg0, arg1);
    }

    public byte[] getBytes(int arg0) throws SQLException {
        this.assertAccess();
        return this.row.getBytes(arg0);
    }

    public Date getDate(int arg0) throws SQLException {
        this.assertAccess();
        return this.row.getDate(arg0);
    }

    public Time getTime(int arg0) throws SQLException {
        this.assertAccess();
        return this.row.getTime(arg0);
    }

    public Timestamp getTimestamp(int arg0) throws SQLException {
        this.assertAccess();
        return this.row.getTimestamp(arg0);
    }

    public InputStream getAsciiStream(int arg0) throws SQLException {
        this.assertAccess();
        return this.row.getAsciiStream(arg0);
    }

    public InputStream getUnicodeStream(int arg0) throws SQLException {
        this.assertAccess();
        return this.row.getUnicodeStream(arg0);
    }

    public InputStream getBinaryStream(int arg0) throws SQLException {
        this.assertAccess();
        return this.row.getBinaryStream(arg0);
    }

    public String getString(String arg0) throws SQLException {
        this.assertAccess();
        return this.row.getString(arg0);
    }

    public boolean getBoolean(String arg0) throws SQLException {
        this.assertAccess();
        return this.row.getBoolean(arg0);
    }

    public byte getByte(String arg0) throws SQLException {
        this.assertAccess();
        return this.row.getByte(arg0);
    }

    public short getShort(String arg0) throws SQLException {
        this.assertAccess();
        return this.row.getShort(arg0);
    }

    public int getInt(String arg0) throws SQLException {
        this.assertAccess();
        return this.row.getInt(arg0);
    }

    public long getLong(String arg0) throws SQLException {
        this.assertAccess();
        return this.row.getLong(arg0);
    }

    public float getFloat(String arg0) throws SQLException {
        this.assertAccess();
        return this.row.getFloat(arg0);
    }

    public double getDouble(String arg0) throws SQLException {
        this.assertAccess();
        return this.row.getDouble(arg0);
    }

    public BigDecimal getBigDecimal(String arg0, int arg1) throws SQLException {
        this.assertAccess();
        return this.row.getBigDecimal(arg0, arg1);
    }

    public byte[] getBytes(String arg0) throws SQLException {
        this.assertAccess();
        return this.row.getBytes(arg0);
    }

    public Date getDate(String arg0) throws SQLException {
        this.assertAccess();
        return this.row.getDate(arg0);
    }

    public Time getTime(String arg0) throws SQLException {
        this.assertAccess();
        return this.row.getTime(arg0);
    }

    public Timestamp getTimestamp(String arg0) throws SQLException {
        this.assertAccess();
        return this.row.getTimestamp(arg0);
    }

    public InputStream getAsciiStream(String arg0) throws SQLException {
        this.assertAccess();
        return this.row.getAsciiStream(arg0);
    }

    public InputStream getUnicodeStream(String arg0) throws SQLException {
        this.assertAccess();
        return this.row.getUnicodeStream(arg0);
    }

    public InputStream getBinaryStream(String arg0) throws SQLException {
        this.assertAccess();
        return this.row.getBinaryStream(arg0);
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.row.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.row.clearWarnings();
    }

    public String getCursorName() throws SQLException {
        return this.row.getCursorName();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.row.getMetaData();
    }

    public Object getObject(int arg0) throws SQLException {
        this.assertAccess();
        return this.row.getObject(arg0);
    }

    public Object getObject(String arg0) throws SQLException {
        this.assertAccess();
        return this.row.getObject(arg0);
    }

    public int findColumn(String arg0) throws SQLException {
        this.assertAccess();
        return this.row.findColumn(arg0);
    }

    public Reader getCharacterStream(int arg0) throws SQLException {
        this.assertAccess();
        return this.row.getCharacterStream(arg0);
    }

    public Reader getCharacterStream(String arg0) throws SQLException {
        this.assertAccess();
        return this.getCharacterStream(arg0);
    }

    public BigDecimal getBigDecimal(int arg0) throws SQLException {
        this.assertAccess();
        return this.row.getBigDecimal(arg0);
    }

    public BigDecimal getBigDecimal(String arg0) throws SQLException {
        this.assertAccess();
        return this.getBigDecimal(arg0);
    }

    public boolean isBeforeFirst() throws SQLException {
        this.assertNavigation();
        return this.row.isBeforeFirst();
    }

    public boolean isAfterLast() throws SQLException {
        this.assertNavigation();
        return this.row.isAfterLast();
    }

    public boolean isFirst() throws SQLException {
        this.assertNavigation();
        return this.row.isFirst();
    }

    public boolean isLast() throws SQLException {
        this.assertNavigation();
        return this.row.isLast();
    }

    public void beforeFirst() throws SQLException {
        this.assertNavigation();
        this.row.beforeFirst();
        this.synchronize();
    }

    public void afterLast() throws SQLException {
        this.assertNavigation();
        this.row.afterLast();
        this.synchronize();
    }

    public boolean first() throws SQLException {
        this.assertNavigation();
        boolean ret = this.row.first();
        this.synchronize();
        return ret;
    }

    public boolean last() throws SQLException {
        this.assertNavigation();
        boolean ret = this.row.last();
        this.synchronize();
        return ret;
    }

    public int getRow() throws SQLException {
        this.assertNavigation();
        return this.row.getRow();
    }

    public boolean absolute(int arg0) throws SQLException {
        this.assertNavigation();
        boolean ret = this.row.absolute(arg0);
        this.synchronize();
        return ret;
    }

    public boolean relative(int arg0) throws SQLException {
        this.assertNavigation();
        boolean ret = this.row.relative(arg0);
        this.synchronize();
        return ret;
    }

    public boolean previous() throws SQLException {
        this.assertNavigation();
        boolean ret = this.row.previous();
        this.synchronize();
        return ret;
    }

    public void setFetchDirection(int arg0) throws SQLException {
        this.assertNavigation();
        this.row.setFetchDirection(arg0);
    }

    public int getFetchDirection() throws SQLException {
        this.assertNavigation();
        return this.row.getFetchDirection();
    }

    public void setFetchSize(int arg0) throws SQLException {
        this.assertNavigation();
        this.row.setFetchSize(arg0);
    }

    public int getFetchSize() throws SQLException {
        this.assertNavigation();
        return this.row.getFetchSize();
    }

    public int getType() throws SQLException {
        this.assertNavigation();
        return this.row.getType();
    }

    public int getConcurrency() throws SQLException {
        this.assertNavigation();
        return this.row.getConcurrency();
    }

    public boolean rowUpdated() throws SQLException {
        this.assertUpdate();
        return this.row.rowUpdated();
    }

    public boolean rowInserted() throws SQLException {
        this.assertUpdate();
        return this.row.rowInserted();
    }

    public boolean rowDeleted() throws SQLException {
        this.assertUpdate();
        return this.row.rowDeleted();
    }

    public void updateNull(int arg0) throws SQLException {
        this.assertUpdate();
        this.row.updateNull(arg0);
    }

    public void updateBoolean(int arg0, boolean arg1) throws SQLException {
        this.assertUpdate();
        this.row.updateBoolean(arg0, arg1);
    }

    public void updateByte(int arg0, byte arg1) throws SQLException {
        this.assertUpdate();
        this.row.updateByte(arg0, arg1);
    }

    public void updateShort(int arg0, short arg1) throws SQLException {
        this.assertUpdate();
        this.row.updateShort(arg0, arg1);
    }

    public void updateInt(int arg0, int arg1) throws SQLException {
        this.assertUpdate();
        this.row.updateInt(arg0, arg1);
    }

    public void updateLong(int arg0, long arg1) throws SQLException {
        this.assertUpdate();
        this.row.updateLong(arg0, arg1);
    }

    public void updateFloat(int arg0, float arg1) throws SQLException {
        this.assertUpdate();
        this.row.updateFloat(arg0, arg1);
    }

    public void updateDouble(int arg0, double arg1) throws SQLException {
        this.assertUpdate();
        this.row.updateDouble(arg0, arg1);
    }

    public void updateBigDecimal(int arg0, BigDecimal arg1) throws SQLException {
        this.assertUpdate();
        this.row.updateBigDecimal(arg0, arg1);
    }

    public void updateString(int arg0, String arg1) throws SQLException {
        this.assertUpdate();
        this.row.updateString(arg0, arg1);
    }

    public void updateBytes(int arg0, byte[] arg1) throws SQLException {
        this.assertUpdate();
        this.row.updateBytes(arg0, arg1);
    }

    public void updateDate(int arg0, Date arg1) throws SQLException {
        this.assertUpdate();
        this.row.updateDate(arg0, arg1);
    }

    public void updateTime(int arg0, Time arg1) throws SQLException {
        this.assertUpdate();
        this.row.updateTime(arg0, arg1);
    }

    public void updateTimestamp(int arg0, Timestamp arg1) throws SQLException {
        this.assertUpdate();
        this.row.updateTimestamp(arg0, arg1);
    }

    public void updateAsciiStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        this.assertUpdate();
        this.row.updateAsciiStream(arg0, arg1, arg2);
    }

    public void updateBinaryStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        this.assertUpdate();
        this.row.updateBinaryStream(arg0, arg1, arg2);
    }

    public void updateCharacterStream(int arg0, Reader arg1, int arg2) throws SQLException {
        this.assertUpdate();
        this.row.updateCharacterStream(arg0, arg1, arg2);
    }

    public void updateObject(int arg0, Object arg1, int arg2) throws SQLException {
        this.assertUpdate();
        this.row.updateObject(arg0, arg1, arg2);
    }

    public void updateObject(int arg0, Object arg1) throws SQLException {
        this.assertUpdate();
        this.row.updateObject(arg0, arg1);
    }

    public void updateNull(String arg0) throws SQLException {
        this.assertUpdate();
        this.row.updateNull(arg0);
    }

    public void updateBoolean(String arg0, boolean arg1) throws SQLException {
        this.assertUpdate();
        this.row.updateBoolean(arg0, arg1);
    }

    public void updateByte(String arg0, byte arg1) throws SQLException {
        this.assertUpdate();
        this.row.updateByte(arg0, arg1);
    }

    public void updateShort(String arg0, short arg1) throws SQLException {
        this.assertUpdate();
        this.row.updateShort(arg0, arg1);
    }

    public void updateInt(String arg0, int arg1) throws SQLException {
        this.assertUpdate();
        this.row.updateInt(arg0, arg1);
    }

    public void updateLong(String arg0, long arg1) throws SQLException {
        this.assertUpdate();
        this.row.updateLong(arg0, arg1);
    }

    public void updateFloat(String arg0, float arg1) throws SQLException {
        this.assertUpdate();
        this.row.updateFloat(arg0, arg1);
    }

    public void updateDouble(String arg0, double arg1) throws SQLException {
        this.assertUpdate();
        this.row.updateDouble(arg0, arg1);
    }

    public void updateBigDecimal(String arg0, BigDecimal arg1) throws SQLException {
        this.assertUpdate();
        this.row.updateBigDecimal(arg0, arg1);
    }

    public void updateString(String arg0, String arg1) throws SQLException {
        this.assertUpdate();
        this.row.updateString(arg0, arg1);
    }

    public void updateBytes(String arg0, byte[] arg1) throws SQLException {
        this.assertUpdate();
        this.row.updateBytes(arg0, arg1);
    }

    public void updateDate(String arg0, Date arg1) throws SQLException {
        this.assertUpdate();
        this.row.updateDate(arg0, arg1);
    }

    public void updateTime(String arg0, Time arg1) throws SQLException {
        this.assertUpdate();
        this.row.updateTime(arg0, arg1);
    }

    public void updateTimestamp(String arg0, Timestamp arg1) throws SQLException {
        this.assertUpdate();
        this.row.updateTimestamp(arg0, arg1);
    }

    public void updateAsciiStream(String arg0, InputStream arg1, int arg2) throws SQLException {
        this.assertUpdate();
        this.row.updateAsciiStream(arg0, arg1, arg2);
    }

    public void updateBinaryStream(String arg0, InputStream arg1, int arg2) throws SQLException {
        this.assertUpdate();
        this.row.updateBinaryStream(arg0, arg1, arg2);
    }

    public void updateCharacterStream(String arg0, Reader arg1, int arg2) throws SQLException {
        this.assertUpdate();
        this.row.updateCharacterStream(arg0, arg1, arg2);
    }

    public void updateObject(String arg0, Object arg1, int arg2) throws SQLException {
        this.assertUpdate();
        this.row.updateObject(arg0, arg1, arg2);
    }

    public void updateObject(String arg0, Object arg1) throws SQLException {
        this.assertUpdate();
        this.row.updateObject(arg0, arg1);
    }

    public void insertRow() throws SQLException {
        this.assertUpdate();
        this.row.insertRow();
    }

    public void updateRow() throws SQLException {
        this.assertUpdate();
        this.row.updateRow();
    }

    public void deleteRow() throws SQLException {
        this.assertUpdate();
        this.row.deleteRow();
    }

    public void refreshRow() throws SQLException {
        this.assertUpdate();
        this.row.refreshRow();
    }

    public void cancelRowUpdates() throws SQLException {
        this.assertUpdate();
        this.row.cancelRowUpdates();
    }

    public void moveToInsertRow() throws SQLException {
        this.assertUpdate();
        this.row.moveToInsertRow();
    }

    public void moveToCurrentRow() throws SQLException {
        this.assertUpdate();
        this.row.moveToCurrentRow();
    }

    public Statement getStatement() throws SQLException {
        return this.row.getStatement();
    }

    public Object getObject(int arg0, Map arg1) throws SQLException {
        this.assertAccess();
        return this.row.getObject(arg0, arg1);
    }

    public Ref getRef(int arg0) throws SQLException {
        this.assertAccess();
        return this.row.getRef(arg0);
    }

    public Blob getBlob(int arg0) throws SQLException {
        this.assertAccess();
        return this.row.getBlob(arg0);
    }

    public Clob getClob(int arg0) throws SQLException {
        this.assertAccess();
        return this.row.getClob(arg0);
    }

    public Array getArray(int arg0) throws SQLException {
        this.assertAccess();
        return this.row.getArray(arg0);
    }

    public Object getObject(String arg0, Map arg1) throws SQLException {
        this.assertAccess();
        return this.row.getObject(arg0, arg1);
    }

    public Ref getRef(String arg0) throws SQLException {
        this.assertAccess();
        return this.row.getRef(arg0);
    }

    public Blob getBlob(String arg0) throws SQLException {
        this.assertAccess();
        return this.row.getBlob(arg0);
    }

    public Clob getClob(String arg0) throws SQLException {
        this.assertAccess();
        return this.row.getClob(arg0);
    }

    public Array getArray(String arg0) throws SQLException {
        this.assertAccess();
        return this.row.getArray(arg0);
    }

    public Date getDate(int arg0, Calendar arg1) throws SQLException {
        this.assertAccess();
        return this.row.getDate(arg0, arg1);
    }

    public Date getDate(String arg0, Calendar arg1) throws SQLException {
        this.assertAccess();
        return this.row.getDate(arg0, arg1);
    }

    public Time getTime(int arg0, Calendar arg1) throws SQLException {
        this.assertAccess();
        return this.row.getTime(arg0, arg1);
    }

    public Time getTime(String arg0, Calendar arg1) throws SQLException {
        this.assertAccess();
        return this.row.getTime(arg0, arg1);
    }

    public Timestamp getTimestamp(int arg0, Calendar arg1) throws SQLException {
        this.assertAccess();
        return this.row.getTimestamp(arg0, arg1);
    }

    public Timestamp getTimestamp(String arg0, Calendar arg1) throws SQLException {
        this.assertAccess();
        return this.row.getTimestamp(arg0, arg1);
    }

    public URL getURL(int arg0) throws SQLException {
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public URL getURL(String arg0) throws SQLException {
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public void updateRef(int arg0, Ref arg1) throws SQLException {
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public void updateRef(String arg0, Ref arg1) throws SQLException {
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public void updateBlob(int arg0, Blob arg1) throws SQLException {
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public void updateBlob(String arg0, Blob arg1) throws SQLException {
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public void updateClob(int arg0, Clob arg1) throws SQLException {
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public void updateClob(String arg0, Clob arg1) throws SQLException {
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public void updateArray(int arg0, Array arg1) throws SQLException {
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public void updateArray(String arg0, Array arg1) throws SQLException {
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    private void assertUpdate() throws SQLException {
        if (!this.resultSetUpdateable) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1001");
        }
        this.assertAccess();
    }

    private void assertAccess() throws SQLException {
        if (this.resultSetType != IBIResultSet.Type.ACCESS && this.resultSetType != IBIResultSet.Type.UNRESTRICTED) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2013");
        }
    }

    private void assertNavigation() throws SQLException {
        if (this.resultSetType != IBIResultSet.Type.NAVIGATION && this.resultSetType != IBIResultSet.Type.UNRESTRICTED) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2014");
        }
    }

    private void assertAccessNavigation() throws SQLException {
        this.assertAccess();
        this.assertNavigation();
    }

    private void assertConnectionInfo() {
        if (this.connectionInfo == null) {
            throw new BIRuntimeException(Locale.getDefault(), "sdk_0000");
        }
    }
}

