/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.result.impl;

import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.result.impl.IBIColumnMetaData;
import com.sap.ip.bi.sdk.exception.BISQLException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class BIResultSetMetaData
implements ResultSetMetaData {
    private IBIColumnMetaData[] meta;
    private IBIConnectionInfo connectionInfo = IBIConnectionInfo.DEFAULT;

    private BIResultSetMetaData() {
        this.meta = new IBIColumnMetaData[0];
    }

    public BIResultSetMetaData(IBIConnectionInfo connectionInfo, IBIColumnMetaData[] meta) {
        if (meta != null) {
            this.meta = meta;
        } else {
            meta = new IBIColumnMetaData[]{};
        }
        this.connectionInfo = connectionInfo;
    }

    public int getColumnCount() throws SQLException {
        return this.meta.length;
    }

    public boolean isAutoIncrement(int column) throws SQLException {
        this.assertColumnIndex(column);
        return this.meta[column - 1].isAutoIncrement();
    }

    public boolean isCaseSensitive(int column) throws SQLException {
        this.assertColumnIndex(column);
        return this.meta[column - 1].isCaseSensitive();
    }

    public boolean isSearchable(int column) throws SQLException {
        this.assertColumnIndex(column);
        return this.meta[column - 1].isSearchable();
    }

    public boolean isCurrency(int column) throws SQLException {
        this.assertColumnIndex(column);
        return this.meta[column - 1].isCurrency();
    }

    public int isNullable(int column) throws SQLException {
        this.assertColumnIndex(column);
        return this.meta[column - 1].isNullable();
    }

    public boolean isSigned(int column) throws SQLException {
        this.assertColumnIndex(column);
        return this.meta[column - 1].isSigned();
    }

    public int getColumnDisplaySize(int column) throws SQLException {
        this.assertColumnIndex(column);
        return this.meta[column - 1].getColumnDisplaySize();
    }

    public String getColumnLabel(int column) throws SQLException {
        this.assertColumnIndex(column);
        return this.meta[column - 1].getColumnLabel();
    }

    public String getColumnName(int column) throws SQLException {
        this.assertColumnIndex(column);
        return this.meta[column - 1].getColumnName();
    }

    public String getSchemaName(int column) throws SQLException {
        this.assertColumnIndex(column);
        return this.meta[column - 1].getSchemaName();
    }

    public int getPrecision(int column) throws SQLException {
        this.assertColumnIndex(column);
        return this.meta[column - 1].getPrecision();
    }

    public int getScale(int column) throws SQLException {
        this.assertColumnIndex(column);
        return this.meta[column - 1].getScale();
    }

    public String getTableName(int column) throws SQLException {
        this.assertColumnIndex(column);
        return this.meta[column - 1].getTableName();
    }

    public String getCatalogName(int column) throws SQLException {
        this.assertColumnIndex(column);
        return this.meta[column - 1].getCatalogName();
    }

    public int getColumnType(int column) throws SQLException {
        this.assertColumnIndex(column);
        return this.meta[column - 1].getColumnType();
    }

    public String getColumnTypeName(int column) throws SQLException {
        this.assertColumnIndex(column);
        return this.meta[column - 1].getColumnTypeName();
    }

    public boolean isReadOnly(int column) throws SQLException {
        this.assertColumnIndex(column);
        return this.meta[column - 1].isReadOnly();
    }

    public boolean isWritable(int column) throws SQLException {
        this.assertColumnIndex(column);
        return this.meta[column - 1].isWritable();
    }

    public boolean isDefinitelyWritable(int column) throws SQLException {
        this.assertColumnIndex(column);
        return this.meta[column - 1].isDefinitelyWritable();
    }

    public String getColumnClassName(int column) throws SQLException {
        this.assertColumnIndex(column);
        return this.meta[column - 1].getColumnClassName();
    }

    private void assertColumnIndex(int column) throws SQLException {
        if (column < 1 || column > this.meta.length) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2011", new Object[]{new Integer(column)});
        }
    }
}

