/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.result.impl;

import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.result.impl.BIResultSetDataException;
import com.sap.ip.bi.sdk.dac.result.impl.IBIResultSetData;
import com.sap.ip.bi.sdk.exception.BIRuntimeException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class BIResultSetData
implements IBIResultSetData {
    private List data = null;
    private int currentRow = -1;
    private IBIConnectionInfo connectionInfo = IBIConnectionInfo.DEFAULT;

    private BIResultSetData() {
        this.data = new ArrayList();
    }

    public BIResultSetData(List data) {
        this.data = data;
    }

    public BIResultSetData(IBIConnectionInfo connectionInfo, List data) {
        this.connectionInfo = connectionInfo;
        this.assertConnectionInfo();
        this.data = data;
    }

    public boolean supports(IBIResultSetData.Supports feature) {
        if (this.data == null) {
            return false;
        }
        if (feature == IBIResultSetData.Supports.ACCESS_RANDOM) {
            return true;
        }
        if (feature == IBIResultSetData.Supports.ACCESS_RESTART) {
            return true;
        }
        if (feature == IBIResultSetData.Supports.UPDATE_LOCAL) {
            return false;
        }
        if (feature == IBIResultSetData.Supports.UPDATE_WRITETHROUGH) {
            return false;
        }
        return false;
    }

    public Object getObject(int row, int column) throws BIResultSetDataException {
        if (this.supports(IBIResultSetData.Supports.ACCESS_RANDOM)) {
            return this.retrieveObject(row, column);
        }
        throw new BIResultSetDataException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1000");
    }

    public Object getObject(int column) throws BIResultSetDataException {
        return this.retrieveObject(this.currentRow + 1, column);
    }

    public void updateObject(Object obj, int row, int column) throws BIResultSetDataException {
        throw new BIResultSetDataException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1001");
    }

    public void updateObject(Object obj, int column) throws BIResultSetDataException {
        throw new BIResultSetDataException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1001");
    }

    public void insertObject(Object obj, int column) throws BIResultSetDataException {
        throw new BIResultSetDataException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1001");
    }

    public void insertRow() throws BIResultSetDataException {
        throw new BIResultSetDataException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1001");
    }

    public void updateRow() throws BIResultSetDataException {
        throw new BIResultSetDataException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1001");
    }

    public void beforeFirst() throws BIResultSetDataException {
        if (!this.supports(IBIResultSetData.Supports.ACCESS_RESTART)) {
            throw new BIResultSetDataException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1002");
        }
        this.currentRow = -1;
    }

    public boolean first() throws BIResultSetDataException {
        if (this.supports(IBIResultSetData.Supports.ACCESS_RESTART)) {
            if (this.data.size() > 0) {
                this.currentRow = 0;
                return true;
            }
            this.currentRow = -1;
            return false;
        }
        throw new BIResultSetDataException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1002");
    }

    public boolean last() throws BIResultSetDataException {
        if (this.supports(IBIResultSetData.Supports.ACCESS_RANDOM)) {
            if (this.data.size() > 0) {
                this.currentRow = this.data.size() - 1;
                return true;
            }
            this.currentRow = -1;
            return false;
        }
        throw new BIResultSetDataException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1000");
    }

    public void afterLast() throws BIResultSetDataException {
        if (!this.supports(IBIResultSetData.Supports.ACCESS_RANDOM)) {
            throw new BIResultSetDataException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1000");
        }
        this.currentRow = -2;
    }

    public boolean isBeforeFirst() throws BIResultSetDataException {
        return this.currentRow == -1;
    }

    public boolean isFirst() throws BIResultSetDataException {
        return this.currentRow == 0;
    }

    public boolean isLast() throws BIResultSetDataException {
        return this.currentRow == this.data.size() - 1;
    }

    public boolean isAfterLast() throws BIResultSetDataException {
        return this.currentRow == -2;
    }

    public boolean next() throws BIResultSetDataException {
        return this.relative(1);
    }

    public boolean previous() throws BIResultSetDataException {
        return this.relative(-1);
    }

    public boolean absolute(int row) throws BIResultSetDataException {
        if (this.supports(IBIResultSetData.Supports.ACCESS_RANDOM) || this.currentRow == row - 1 || this.currentRow == row - 2) {
            if (row >= 0) {
                if (row == 0) {
                    this.currentRow = -1;
                    return false;
                }
                if (row <= this.data.size()) {
                    this.currentRow = row - 1;
                    return true;
                }
                this.currentRow = -2;
                return false;
            }
            if (row + this.data.size() >= 0) {
                this.currentRow = this.data.size() + row;
                return true;
            }
            this.currentRow = -1;
            return false;
        }
        throw new BIResultSetDataException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1000");
    }

    public boolean relative(int row) throws BIResultSetDataException {
        if (this.supports(IBIResultSetData.Supports.ACCESS_RANDOM) || row == 1 || row == 0) {
            if (row == 0) {
                return this.currentRow >= 0;
            }
            if (row > 0) {
                switch (this.currentRow) {
                    case -1: {
                        this.currentRow = row - 1;
                        break;
                    }
                    case -2: {
                        return false;
                    }
                    default: {
                        this.currentRow += row;
                    }
                }
                if (this.currentRow >= this.data.size()) {
                    this.currentRow = -2;
                    return false;
                }
                return true;
            }
            switch (this.currentRow) {
                case -1: {
                    return false;
                }
                case -2: {
                    this.currentRow = this.data.size() + row;
                    break;
                }
                default: {
                    this.currentRow += row;
                }
            }
            if (this.currentRow < 0) {
                this.currentRow = -1;
                return false;
            }
            return true;
        }
        throw new BIResultSetDataException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1000");
    }

    public void close() throws BIResultSetDataException {
        this.currentRow = -1;
    }

    public int getRow() throws BIResultSetDataException {
        if (this.currentRow >= 0) {
            return this.currentRow + 1;
        }
        return this.currentRow;
    }

    public int getRowCount() throws BIResultSetDataException {
        if (this.supports(IBIResultSetData.Supports.ACCESS_RANDOM)) {
            return this.data.size();
        }
        throw new BIResultSetDataException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1000");
    }

    public void setFetchSize(int rows) throws BIResultSetDataException {
        throw new BIResultSetDataException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1003");
    }

    public int getFetchSize() throws BIResultSetDataException {
        throw new BIResultSetDataException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1003");
    }

    private Object retrieveObject(int row, int column) throws BIResultSetDataException {
        if (!this.supports(IBIResultSetData.Supports.ACCESS_RANDOM) || row <= 0) {
            throw new BIResultSetDataException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1004");
        }
        try {
            return ((Object[])this.data.get(row - 1))[column - 1];
        }
        catch (ClassCastException ex) {
            throw new BIResultSetDataException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1005", new Object[]{new Integer(row), new Integer(column)});
        }
        catch (IndexOutOfBoundsException ex) {
            throw new BIResultSetDataException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1005", new Object[]{new Integer(row), new Integer(column)});
        }
    }

    private void assertConnectionInfo() {
        if (this.connectionInfo == null) {
            throw new BIRuntimeException(Locale.getDefault(), "sdk_0000");
        }
    }
}

