/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.result.impl;

import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.result.impl.BIResultSetDataException;
import com.sap.ip.bi.sdk.dac.result.impl.IBIColumnMetaData;
import com.sap.ip.bi.sdk.dac.result.impl.IBIResultSet;
import com.sap.ip.bi.sdk.dac.result.impl.IBIResultSetData;
import com.sap.ip.bi.sdk.dac.result.impl.IBISynchronizeCursor;
import com.sap.ip.bi.sdk.exception.BIRuntimeException;
import com.sap.ip.bi.sdk.exception.BISQLException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class BIResultSet
implements IBIResultSet,
IBISynchronizeCursor {
    private final IBIResultSet.Type resultSetType;
    private final boolean resultSetUpdateable;
    private IBIResultSetData row = null;
    private IBIColumnMetaData[] metaData = null;
    private BIResultSetMetaData resultMeta = null;
    private Map colNameIndex = null;
    private int fetchDirection = 1002;
    private int fetchSize = 0;
    private boolean wasNull = false;
    private boolean isSynchronized = false;
    protected IBIConnectionInfo connectionInfo = IBIConnectionInfo.DEFAULT;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;

    protected BIResultSet() {
        this.resultSetType = IBIResultSet.Type.UNRESTRICTED;
        this.resultSetUpdateable = false;
    }

    public BIResultSet(IBIResultSetData row, IBIColumnMetaData[] metaData, IBIResultSet.Type resultSetType, boolean resultSetUpdateable) throws SQLException {
        this.assertResultSetType(resultSetType);
        this.resultSetType = resultSetType;
        if (resultSetUpdateable && row != null && (row.supports(IBIResultSetData.Supports.UPDATE_LOCAL) || row.supports(IBIResultSetData.Supports.UPDATE_WRITETHROUGH))) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1001");
        }
        this.resultSetUpdateable = false;
        this.row = row;
        this.metaData = metaData;
        this.colNameIndex = new HashMap();
        if (metaData != null) {
            int i = 0;
            while (i < metaData.length) {
                String colName = metaData[i].getColumnName();
                if (this.colNameIndex.put(colName, new Integer(i + 1)) != null) {
                    throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2001", new Object[]{colName});
                }
                ++i;
            }
        } else {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2002");
        }
        this.resultMeta = new BIResultSetMetaData();
    }

    public BIResultSet(IBIConnectionInfo connectionInfo, IBIResultSetData row, IBIColumnMetaData[] metaData, IBIResultSet.Type resultSetType, boolean resultSetUpdateable) throws SQLException {
        this.connectionInfo = connectionInfo;
        this.assertConnectionInfo();
        this.assertResultSetType(resultSetType);
        this.resultSetType = resultSetType;
        if (resultSetUpdateable && row != null && (row.supports(IBIResultSetData.Supports.UPDATE_LOCAL) || row.supports(IBIResultSetData.Supports.UPDATE_WRITETHROUGH))) {
            throw new BISQLException(connectionInfo.getLocale(), "sdk.dac.rel.result_1001");
        }
        this.resultSetUpdateable = false;
        this.row = row;
        this.metaData = metaData;
        this.colNameIndex = new HashMap();
        if (metaData != null) {
            int i = 0;
            while (i < metaData.length) {
                String colName = metaData[i].getColumnName();
                if (this.colNameIndex.put(colName, new Integer(i + 1)) != null) {
                    throw new BISQLException(connectionInfo.getLocale(), "sdk.dac.rel.result_2001", new Object[]{colName});
                }
                ++i;
            }
        } else {
            throw new BISQLException(connectionInfo.getLocale(), "sdk.dac.rel.result_2002");
        }
        this.resultMeta = new BIResultSetMetaData();
    }

    public BIResultSet(IBIResultSetData row, IBIColumnMetaData[] metaData) throws SQLException {
        this(row, metaData, IBIResultSet.Type.UNRESTRICTED, false);
    }

    public BIResultSet(IBIConnectionInfo connectionInfo, IBIResultSetData row, IBIColumnMetaData[] metaData) throws SQLException {
        this(connectionInfo, row, metaData, IBIResultSet.Type.UNRESTRICTED, false);
    }

    protected IBIResultSet.Type getResultSetType() {
        return this.resultSetType;
    }

    public void setSynchronized(boolean synchronize) throws SQLException {
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public boolean isSynchronized() throws SQLException {
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public void synchronize() throws SQLException {
        if (this.isSynchronized) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
        }
    }

    public boolean synchAbsolute(int arg0) throws SQLException {
        try {
            return this.row.absolute(arg0);
        }
        catch (BIResultSetDataException ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_6001", (Throwable)((Object)ex));
        }
    }

    public boolean synchRelative(int arg0) throws SQLException {
        try {
            return this.row.relative(arg0);
        }
        catch (BIResultSetDataException ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_6001", (Throwable)((Object)ex));
        }
    }

    public void synchBeforeFirst() throws SQLException {
        try {
            this.row.beforeFirst();
        }
        catch (BIResultSetDataException ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_6001", (Throwable)((Object)ex));
        }
    }

    public void synchAfterLast() throws SQLException {
        try {
            this.row.afterLast();
        }
        catch (BIResultSetDataException ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_6001", (Throwable)((Object)ex));
        }
    }

    public int synchGetRow() throws SQLException {
        try {
            return this.row.getRow();
        }
        catch (BIResultSetDataException ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_6001", (Throwable)((Object)ex));
        }
    }

    public int synchGetColumnCount() throws SQLException {
        return this.resultMeta.getColumnCount();
    }

    public int synchGetRowCount() throws SQLException {
        try {
            return this.row.getRowCount();
        }
        catch (BIResultSetDataException ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_6001", (Throwable)((Object)ex));
        }
    }

    public boolean next() throws SQLException {
        this.assertNavigation();
        return this.relative(1);
    }

    public void close() throws SQLException {
        this.assertNavigation();
        try {
            this.row.close();
            this.synchronize();
        }
        catch (BIResultSetDataException ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_6001", (Throwable)((Object)ex));
        }
    }

    public boolean wasNull() throws SQLException {
        this.assertAccess();
        return this.wasNull;
    }

    public String getString(int arg0) throws SQLException {
        this.assertAccess();
        try {
            Object col = this.row.getObject(arg0);
            if (col == null) {
                this.wasNull = true;
                return null;
            }
            this.wasNull = false;
            return col.toString();
        }
        catch (BIResultSetDataException ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), (Throwable)((Object)ex));
        }
        catch (Exception ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2004", (Throwable)ex);
        }
    }

    public boolean getBoolean(int arg0) throws SQLException {
        this.assertAccess();
        try {
            Object col = this.row.getObject(arg0);
            if (col == null) {
                this.wasNull = true;
                return false;
            }
            this.wasNull = false;
            if (col instanceof Boolean) {
                return (Boolean)col;
            }
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2005", new Object[]{col.getClass(), class$java$lang$Boolean == null ? (class$java$lang$Boolean = BIResultSet.class$("java.lang.Boolean")) : class$java$lang$Boolean});
        }
        catch (BIResultSetDataException ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), (Throwable)((Object)ex));
        }
        catch (Exception ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2004", (Throwable)ex);
        }
    }

    public byte getByte(int arg0) throws SQLException {
        this.assertAccess();
        try {
            Object col = this.row.getObject(arg0);
            if (col == null) {
                this.wasNull = true;
                return 0;
            }
            this.wasNull = false;
            if (col instanceof Byte) {
                return (Byte)col;
            }
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2005", new Object[]{col.getClass(), class$java$lang$Byte == null ? (class$java$lang$Byte = BIResultSet.class$("java.lang.Byte")) : class$java$lang$Byte});
        }
        catch (BIResultSetDataException ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), (Throwable)((Object)ex));
        }
        catch (Exception ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2004", (Throwable)ex);
        }
    }

    public short getShort(int arg0) throws SQLException {
        this.assertAccess();
        try {
            Object col = this.row.getObject(arg0);
            if (col == null) {
                this.wasNull = true;
                return 0;
            }
            this.wasNull = false;
            if (col instanceof Short) {
                return (Short)col;
            }
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2005", new Object[]{col.getClass(), class$java$lang$Short == null ? (class$java$lang$Short = BIResultSet.class$("java.lang.Short")) : class$java$lang$Short});
        }
        catch (BIResultSetDataException ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), (Throwable)((Object)ex));
        }
        catch (Exception ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2004", (Throwable)ex);
        }
    }

    public int getInt(int arg0) throws SQLException {
        this.assertAccess();
        try {
            Object col = this.row.getObject(arg0);
            if (col == null) {
                this.wasNull = true;
                return 0;
            }
            this.wasNull = false;
            if (col instanceof Integer) {
                return (Integer)col;
            }
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2005", new Object[]{col.getClass(), class$java$lang$Integer == null ? (class$java$lang$Integer = BIResultSet.class$("java.lang.Integer")) : class$java$lang$Integer});
        }
        catch (BIResultSetDataException ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), (Throwable)((Object)ex));
        }
        catch (Exception ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2004", (Throwable)ex);
        }
    }

    public long getLong(int arg0) throws SQLException {
        this.assertAccess();
        try {
            Object col = this.row.getObject(arg0);
            if (col == null) {
                this.wasNull = true;
                return 0L;
            }
            this.wasNull = false;
            if (col instanceof Long) {
                return (Long)col;
            }
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2005", new Object[]{col.getClass(), class$java$lang$Long == null ? (class$java$lang$Long = BIResultSet.class$("java.lang.Long")) : class$java$lang$Long});
        }
        catch (BIResultSetDataException ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), (Throwable)((Object)ex));
        }
        catch (Exception ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2004", (Throwable)ex);
        }
    }

    public float getFloat(int arg0) throws SQLException {
        this.assertAccess();
        try {
            Object col = this.row.getObject(arg0);
            if (col == null) {
                this.wasNull = true;
                return 0.0f;
            }
            this.wasNull = false;
            if (col instanceof Float) {
                return ((Float)col).floatValue();
            }
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2005", new Object[]{col.getClass(), class$java$lang$Float == null ? (class$java$lang$Float = BIResultSet.class$("java.lang.Float")) : class$java$lang$Float});
        }
        catch (BIResultSetDataException ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), (Throwable)((Object)ex));
        }
        catch (Exception ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2004", (Throwable)ex);
        }
    }

    public double getDouble(int arg0) throws SQLException {
        this.assertAccess();
        try {
            Object col = this.row.getObject(arg0);
            if (col == null) {
                this.wasNull = true;
                return 0.0;
            }
            this.wasNull = false;
            if (col instanceof Double) {
                return (Double)col;
            }
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2005", new Object[]{col.getClass(), class$java$lang$Double == null ? (class$java$lang$Double = BIResultSet.class$("java.lang.Double")) : class$java$lang$Double});
        }
        catch (BIResultSetDataException ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), (Throwable)((Object)ex));
        }
        catch (Exception ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2004", (Throwable)ex);
        }
    }

    public BigDecimal getBigDecimal(int arg0, int arg1) throws SQLException {
        this.assertAccess();
        try {
            Object col = this.row.getObject(arg0);
            if (col == null) {
                this.wasNull = true;
                return null;
            }
            this.wasNull = false;
            if (col instanceof BigDecimal) {
                try {
                    ((BigDecimal)col).setScale(arg1);
                }
                catch (ArithmeticException ex) {
                    throw new BISQLException(this.connectionInfo.getLocale(), (Throwable)ex);
                }
                return (BigDecimal)col;
            }
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2005", new Object[]{col.getClass(), class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = BIResultSet.class$("java.math.BigDecimal")) : class$java$math$BigDecimal});
        }
        catch (BIResultSetDataException ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), (Throwable)((Object)ex));
        }
        catch (Exception ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2004", (Throwable)ex);
        }
    }

    public byte[] getBytes(int arg0) throws SQLException {
        this.assertAccess();
        try {
            Object col = this.row.getObject(arg0);
            if (col == null) {
                this.wasNull = true;
                return null;
            }
            this.wasNull = false;
            if (col instanceof Byte[]) {
                byte[] res = new byte[((Byte[])col).length];
                int i = 0;
                while (i < res.length) {
                    res[i] = ((Byte[])col)[i];
                    ++i;
                }
                return res;
            }
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2005", new Object[]{col.getClass(), "[" + (class$java$lang$Byte == null ? (class$java$lang$Byte = BIResultSet.class$("java.lang.Byte")) : class$java$lang$Byte) + ";"});
        }
        catch (BIResultSetDataException ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), (Throwable)((Object)ex));
        }
        catch (Exception ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2004", (Throwable)ex);
        }
    }

    public Date getDate(int arg0) throws SQLException {
        this.assertAccess();
        try {
            Object col = this.row.getObject(arg0);
            if (col == null) {
                this.wasNull = true;
                return null;
            }
            this.wasNull = false;
            if (col instanceof Date) {
                return (Date)col;
            }
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2005", new Object[]{col.getClass(), class$java$sql$Date == null ? (class$java$sql$Date = BIResultSet.class$("java.sql.Date")) : class$java$sql$Date});
        }
        catch (BIResultSetDataException ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), (Throwable)((Object)ex));
        }
        catch (Exception ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2004", (Throwable)ex);
        }
    }

    public Time getTime(int arg0) throws SQLException {
        this.assertAccess();
        try {
            Object col = this.row.getObject(arg0);
            if (col == null) {
                this.wasNull = true;
                return null;
            }
            this.wasNull = false;
            if (col instanceof Time) {
                return (Time)col;
            }
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2005", new Object[]{col.getClass(), class$java$sql$Time == null ? (class$java$sql$Time = BIResultSet.class$("java.sql.Time")) : class$java$sql$Time});
        }
        catch (BIResultSetDataException ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), (Throwable)((Object)ex));
        }
        catch (Exception ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2004", (Throwable)ex);
        }
    }

    public Timestamp getTimestamp(int arg0) throws SQLException {
        this.assertAccess();
        try {
            Object col = this.row.getObject(arg0);
            if (col == null) {
                this.wasNull = true;
                return null;
            }
            this.wasNull = false;
            if (col instanceof Timestamp) {
                return (Timestamp)col;
            }
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2005", new Object[]{col.getClass(), class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = BIResultSet.class$("java.sql.Timestamp")) : class$java$sql$Timestamp});
        }
        catch (BIResultSetDataException ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), (Throwable)((Object)ex));
        }
        catch (Exception ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2004", (Throwable)ex);
        }
    }

    public InputStream getAsciiStream(int arg0) throws SQLException {
        this.assertAccess();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2006");
    }

    public InputStream getUnicodeStream(int arg0) throws SQLException {
        this.assertAccess();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2006");
    }

    public InputStream getBinaryStream(int arg0) throws SQLException {
        this.assertAccess();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2006");
    }

    public String getString(String arg0) throws SQLException {
        this.assertAccess();
        return this.getString(this.findColumn(arg0));
    }

    public boolean getBoolean(String arg0) throws SQLException {
        this.assertAccess();
        return this.getBoolean(this.findColumn(arg0));
    }

    public byte getByte(String arg0) throws SQLException {
        this.assertAccess();
        return this.getByte(this.findColumn(arg0));
    }

    public short getShort(String arg0) throws SQLException {
        this.assertAccess();
        return this.getShort(this.findColumn(arg0));
    }

    public int getInt(String arg0) throws SQLException {
        this.assertAccess();
        return this.getInt(this.findColumn(arg0));
    }

    public long getLong(String arg0) throws SQLException {
        this.assertAccess();
        return this.getLong(this.findColumn(arg0));
    }

    public float getFloat(String arg0) throws SQLException {
        this.assertAccess();
        return this.getFloat(this.findColumn(arg0));
    }

    public double getDouble(String arg0) throws SQLException {
        this.assertAccess();
        return this.getDouble(this.findColumn(arg0));
    }

    public BigDecimal getBigDecimal(String arg0, int arg1) throws SQLException {
        this.assertAccess();
        return this.getBigDecimal(this.findColumn(arg0), arg1);
    }

    public byte[] getBytes(String arg0) throws SQLException {
        this.assertAccess();
        return this.getBytes(this.findColumn(arg0));
    }

    public Date getDate(String arg0) throws SQLException {
        this.assertAccess();
        return this.getDate(this.findColumn(arg0));
    }

    public Time getTime(String arg0) throws SQLException {
        this.assertAccess();
        return this.getTime(this.findColumn(arg0));
    }

    public Timestamp getTimestamp(String arg0) throws SQLException {
        this.assertAccess();
        return this.getTimestamp(this.findColumn(arg0));
    }

    public InputStream getAsciiStream(String arg0) throws SQLException {
        this.assertAccess();
        return this.getAsciiStream(this.findColumn(arg0));
    }

    public InputStream getUnicodeStream(String arg0) throws SQLException {
        this.assertAccess();
        return this.getUnicodeStream(this.findColumn(arg0));
    }

    public InputStream getBinaryStream(String arg0) throws SQLException {
        this.assertAccess();
        return this.getBinaryStream(this.findColumn(arg0));
    }

    public SQLWarning getWarnings() throws SQLException {
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public void clearWarnings() throws SQLException {
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public String getCursorName() throws SQLException {
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.resultMeta;
    }

    public Object getObject(int arg0) throws SQLException {
        this.assertAccess();
        try {
            Object col = this.row.getObject(arg0);
            this.wasNull = col == null;
            return col;
        }
        catch (BIResultSetDataException ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), (Throwable)((Object)ex));
        }
        catch (Exception ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2004", (Throwable)ex);
        }
    }

    public Object getObject(String arg0) throws SQLException {
        this.assertAccess();
        return this.getObject(this.findColumn(arg0));
    }

    public int findColumn(String arg0) throws SQLException {
        if (this.colNameIndex.containsKey(arg0)) {
            return (Integer)this.colNameIndex.get(arg0);
        }
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2008", new Object[]{arg0});
    }

    public Reader getCharacterStream(int arg0) throws SQLException {
        this.assertAccess();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public Reader getCharacterStream(String arg0) throws SQLException {
        this.assertAccess();
        return this.getCharacterStream(this.findColumn(arg0));
    }

    public BigDecimal getBigDecimal(int arg0) throws SQLException {
        this.assertAccess();
        try {
            Object col = this.row.getObject(arg0);
            this.wasNull = col == null;
            if (col instanceof BigDecimal) {
                return (BigDecimal)col;
            }
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2005", new Object[]{col.getClass(), class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = BIResultSet.class$("java.math.BigDecimal")) : class$java$math$BigDecimal});
        }
        catch (BIResultSetDataException ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), (Throwable)((Object)ex));
        }
        catch (Exception ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2004", (Throwable)ex);
        }
    }

    public BigDecimal getBigDecimal(String arg0) throws SQLException {
        this.assertAccess();
        return this.getBigDecimal(this.findColumn(arg0));
    }

    public boolean isBeforeFirst() throws SQLException {
        this.assertNavigation();
        try {
            return this.row.isBeforeFirst();
        }
        catch (BIResultSetDataException ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), (Throwable)((Object)ex));
        }
    }

    public boolean isAfterLast() throws SQLException {
        this.assertNavigation();
        try {
            return this.row.isAfterLast();
        }
        catch (BIResultSetDataException ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), (Throwable)((Object)ex));
        }
    }

    public boolean isFirst() throws SQLException {
        this.assertNavigation();
        try {
            return this.row.isFirst();
        }
        catch (BIResultSetDataException ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), (Throwable)((Object)ex));
        }
    }

    public boolean isLast() throws SQLException {
        this.assertNavigation();
        try {
            return this.row.isLast();
        }
        catch (BIResultSetDataException ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), (Throwable)((Object)ex));
        }
    }

    public void beforeFirst() throws SQLException {
        this.assertNavigation();
        try {
            this.row.beforeFirst();
            this.synchronize();
        }
        catch (BIResultSetDataException ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), (Throwable)((Object)ex));
        }
    }

    public void afterLast() throws SQLException {
        this.assertNavigation();
        try {
            this.row.afterLast();
            this.synchronize();
        }
        catch (BIResultSetDataException ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), (Throwable)((Object)ex));
        }
    }

    public boolean first() throws SQLException {
        this.assertNavigation();
        try {
            boolean ret = this.row.first();
            this.synchronize();
            return ret;
        }
        catch (BIResultSetDataException ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), (Throwable)((Object)ex));
        }
    }

    public boolean last() throws SQLException {
        this.assertNavigation();
        try {
            boolean ret = this.row.last();
            this.synchronize();
            return ret;
        }
        catch (BIResultSetDataException ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), (Throwable)((Object)ex));
        }
    }

    public int getRow() throws SQLException {
        this.assertNavigation();
        try {
            return this.row.getRow();
        }
        catch (BIResultSetDataException ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), (Throwable)((Object)ex));
        }
    }

    public boolean absolute(int arg0) throws SQLException {
        this.assertNavigation();
        try {
            boolean ret = this.row.absolute(arg0);
            this.synchronize();
            return ret;
        }
        catch (BIResultSetDataException ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), (Throwable)((Object)ex));
        }
    }

    public boolean relative(int arg0) throws SQLException {
        this.assertNavigation();
        try {
            boolean ret = this.row.relative(arg0);
            this.synchronize();
            return ret;
        }
        catch (BIResultSetDataException ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), (Throwable)((Object)ex));
        }
    }

    public boolean previous() throws SQLException {
        this.assertNavigation();
        return this.relative(-1);
    }

    public void setFetchDirection(int arg0) throws SQLException {
        if (arg0 != 1000 && arg0 != 1001 && arg0 != 1002) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2007", new Object[]{new Integer(arg0)});
        }
        this.fetchDirection = arg0;
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    public void setFetchSize(int arg0) throws SQLException {
        try {
            this.row.setFetchSize(arg0);
        }
        catch (BIResultSetDataException ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), (Throwable)((Object)ex));
        }
    }

    public int getFetchSize() throws SQLException {
        try {
            return this.row.getFetchSize();
        }
        catch (BIResultSetDataException ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), (Throwable)((Object)ex));
        }
    }

    public int getType() throws SQLException {
        return 1004;
    }

    public int getConcurrency() throws SQLException {
        return 1007;
    }

    public boolean rowUpdated() throws SQLException {
        this.assertUpdate();
        return false;
    }

    public boolean rowInserted() throws SQLException {
        this.assertUpdate();
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        this.assertUpdate();
        return false;
    }

    public void updateNull(int arg0) throws SQLException {
        this.assertUpdate();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1001");
    }

    public void updateBoolean(int arg0, boolean arg1) throws SQLException {
        this.assertUpdate();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1001");
    }

    public void updateByte(int arg0, byte arg1) throws SQLException {
        this.assertUpdate();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1001");
    }

    public void updateShort(int arg0, short arg1) throws SQLException {
        this.assertUpdate();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1001");
    }

    public void updateInt(int arg0, int arg1) throws SQLException {
        this.assertUpdate();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1001");
    }

    public void updateLong(int arg0, long arg1) throws SQLException {
        this.assertUpdate();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1001");
    }

    public void updateFloat(int arg0, float arg1) throws SQLException {
        this.assertUpdate();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1001");
    }

    public void updateDouble(int arg0, double arg1) throws SQLException {
        this.assertUpdate();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1001");
    }

    public void updateBigDecimal(int arg0, BigDecimal arg1) throws SQLException {
        this.assertUpdate();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1001");
    }

    public void updateString(int arg0, String arg1) throws SQLException {
        this.assertUpdate();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1001");
    }

    public void updateBytes(int arg0, byte[] arg1) throws SQLException {
        this.assertUpdate();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1001");
    }

    public void updateDate(int arg0, Date arg1) throws SQLException {
        this.assertUpdate();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1001");
    }

    public void updateTime(int arg0, Time arg1) throws SQLException {
        this.assertUpdate();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1001");
    }

    public void updateTimestamp(int arg0, Timestamp arg1) throws SQLException {
        this.assertUpdate();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1001");
    }

    public void updateAsciiStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        this.assertUpdate();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1001");
    }

    public void updateBinaryStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        this.assertUpdate();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1001");
    }

    public void updateCharacterStream(int arg0, Reader arg1, int arg2) throws SQLException {
        this.assertUpdate();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1001");
    }

    public void updateObject(int arg0, Object arg1, int arg2) throws SQLException {
        this.assertUpdate();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1001");
    }

    public void updateObject(int arg0, Object arg1) throws SQLException {
        this.assertUpdate();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1001");
    }

    public void updateNull(String arg0) throws SQLException {
        this.assertUpdate();
        this.updateNull(this.findColumn(arg0));
    }

    public void updateBoolean(String arg0, boolean arg1) throws SQLException {
        this.assertUpdate();
        this.updateBoolean(this.findColumn(arg0), arg1);
    }

    public void updateByte(String arg0, byte arg1) throws SQLException {
        this.assertUpdate();
        this.updateByte(this.findColumn(arg0), arg1);
    }

    public void updateShort(String arg0, short arg1) throws SQLException {
        this.assertUpdate();
        this.updateShort(this.findColumn(arg0), arg1);
    }

    public void updateInt(String arg0, int arg1) throws SQLException {
        this.assertUpdate();
        this.updateInt(this.findColumn(arg0), arg1);
    }

    public void updateLong(String arg0, long arg1) throws SQLException {
        this.assertUpdate();
        this.updateLong(this.findColumn(arg0), arg1);
    }

    public void updateFloat(String arg0, float arg1) throws SQLException {
        this.assertUpdate();
        this.updateFloat(this.findColumn(arg0), arg1);
    }

    public void updateDouble(String arg0, double arg1) throws SQLException {
        this.assertUpdate();
        this.updateDouble(this.findColumn(arg0), arg1);
    }

    public void updateBigDecimal(String arg0, BigDecimal arg1) throws SQLException {
        this.assertUpdate();
        this.updateBigDecimal(this.findColumn(arg0), arg1);
    }

    public void updateString(String arg0, String arg1) throws SQLException {
        this.assertUpdate();
        this.updateString(this.findColumn(arg0), arg1);
    }

    public void updateBytes(String arg0, byte[] arg1) throws SQLException {
        this.assertUpdate();
        this.updateBytes(this.findColumn(arg0), arg1);
    }

    public void updateDate(String arg0, Date arg1) throws SQLException {
        this.assertUpdate();
        this.updateDate(this.findColumn(arg0), arg1);
    }

    public void updateTime(String arg0, Time arg1) throws SQLException {
        this.assertUpdate();
        this.updateTime(this.findColumn(arg0), arg1);
    }

    public void updateTimestamp(String arg0, Timestamp arg1) throws SQLException {
        this.assertUpdate();
        this.updateTimestamp(this.findColumn(arg0), arg1);
    }

    public void updateAsciiStream(String arg0, InputStream arg1, int arg2) throws SQLException {
        this.assertUpdate();
        this.updateAsciiStream(this.findColumn(arg0), arg1, arg2);
    }

    public void updateBinaryStream(String arg0, InputStream arg1, int arg2) throws SQLException {
        this.assertUpdate();
        this.updateBinaryStream(this.findColumn(arg0), arg1, arg2);
    }

    public void updateCharacterStream(String arg0, Reader arg1, int arg2) throws SQLException {
        this.assertUpdate();
        this.updateCharacterStream(this.findColumn(arg0), arg1, arg2);
    }

    public void updateObject(String arg0, Object arg1, int arg2) throws SQLException {
        this.assertUpdate();
        this.updateObject(this.findColumn(arg0), arg1, arg2);
    }

    public void updateObject(String arg0, Object arg1) throws SQLException {
        this.assertUpdate();
        this.updateObject(this.findColumn(arg0), arg1);
    }

    public void insertRow() throws SQLException {
        this.assertUpdate();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1001");
    }

    public void updateRow() throws SQLException {
        this.assertUpdate();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1001");
    }

    public void deleteRow() throws SQLException {
        this.assertUpdate();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1001");
    }

    public void refreshRow() throws SQLException {
        this.assertUpdate();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2009");
    }

    public void cancelRowUpdates() throws SQLException {
        this.assertUpdate();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1001");
    }

    public void moveToInsertRow() throws SQLException {
        this.assertUpdate();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1001");
    }

    public void moveToCurrentRow() throws SQLException {
        this.assertUpdate();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1001");
    }

    public Statement getStatement() throws SQLException {
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public Object getObject(int arg0, Map arg1) throws SQLException {
        this.assertAccess();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public Ref getRef(int arg0) throws SQLException {
        this.assertAccess();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public Blob getBlob(int arg0) throws SQLException {
        this.assertAccess();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public Clob getClob(int arg0) throws SQLException {
        this.assertAccess();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public Array getArray(int arg0) throws SQLException {
        this.assertAccess();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public Object getObject(String arg0, Map arg1) throws SQLException {
        this.assertAccess();
        return this.getObject(this.findColumn(arg0), arg1);
    }

    public Ref getRef(String arg0) throws SQLException {
        this.assertAccess();
        return this.getRef(this.findColumn(arg0));
    }

    public Blob getBlob(String arg0) throws SQLException {
        this.assertAccess();
        return this.getBlob(this.findColumn(arg0));
    }

    public Clob getClob(String arg0) throws SQLException {
        this.assertAccess();
        return this.getClob(this.findColumn(arg0));
    }

    public Array getArray(String arg0) throws SQLException {
        this.assertAccess();
        return this.getArray(this.findColumn(arg0));
    }

    public Date getDate(int arg0, Calendar arg1) throws SQLException {
        this.assertAccess();
        return this.getDate(arg0, arg1);
    }

    public Date getDate(String arg0, Calendar arg1) throws SQLException {
        this.assertAccess();
        return this.getDate(this.findColumn(arg0), arg1);
    }

    public Time getTime(int arg0, Calendar arg1) throws SQLException {
        this.assertAccess();
        return this.getTime(arg0, arg1);
    }

    public Time getTime(String arg0, Calendar arg1) throws SQLException {
        this.assertAccess();
        return this.getTime(this.findColumn(arg0), arg1);
    }

    public Timestamp getTimestamp(int arg0, Calendar arg1) throws SQLException {
        this.assertAccess();
        return this.getTimestamp(arg0, arg1);
    }

    public Timestamp getTimestamp(String arg0, Calendar arg1) throws SQLException {
        this.assertAccess();
        return this.getTimestamp(this.findColumn(arg0), arg1);
    }

    public URL getURL(int arg0) throws SQLException {
        this.assertAccess();
        try {
            return new URL(this.getString(arg0));
        }
        catch (MalformedURLException ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), (Throwable)ex);
        }
    }

    public URL getURL(String arg0) throws SQLException {
        this.assertAccess();
        return this.getURL(this.findColumn(arg0));
    }

    public void updateRef(int arg0, Ref arg1) throws SQLException {
        this.assertUpdate();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1001");
    }

    public void updateRef(String arg0, Ref arg1) throws SQLException {
        this.assertUpdate();
        this.updateRef(this.findColumn(arg0), arg1);
    }

    public void updateBlob(int arg0, Blob arg1) throws SQLException {
        this.assertUpdate();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1001");
    }

    public void updateBlob(String arg0, Blob arg1) throws SQLException {
        this.assertUpdate();
        this.updateBlob(this.findColumn(arg0), arg1);
    }

    public void updateClob(int arg0, Clob arg1) throws SQLException {
        this.assertUpdate();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1001");
    }

    public void updateClob(String arg0, Clob arg1) throws SQLException {
        this.assertUpdate();
        this.updateClob(this.findColumn(arg0), arg1);
    }

    public void updateArray(int arg0, Array arg1) throws SQLException {
        this.assertUpdate();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1001");
    }

    public void updateArray(String arg0, Array arg1) throws SQLException {
        this.assertUpdate();
        this.updateArray(this.findColumn(arg0), arg1);
    }

    private void assertResultSetType(IBIResultSet.Type resultSetType) throws SQLException {
        if (resultSetType == null || resultSetType != IBIResultSet.Type.ACCESS && resultSetType != IBIResultSet.Type.NAVIGATION && resultSetType != IBIResultSet.Type.UNRESTRICTED) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2012", new Object[]{resultSetType.toString()});
        }
    }

    private void assertUpdate() throws SQLException {
        if (!this.resultSetUpdateable) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1001");
        }
        this.assertAccess();
    }

    private void assertAccess() throws SQLException {
        if (this.getResultSetType() != IBIResultSet.Type.ACCESS && this.getResultSetType() != IBIResultSet.Type.UNRESTRICTED) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2013");
        }
    }

    private void assertNavigation() throws SQLException {
        if (this.getResultSetType() != IBIResultSet.Type.NAVIGATION && this.getResultSetType() != IBIResultSet.Type.UNRESTRICTED) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2014");
        }
    }

    private void assertAccessNavigation() throws SQLException {
        this.assertAccess();
        this.assertNavigation();
    }

    private void assertConnectionInfo() {
        if (this.connectionInfo == null) {
            throw new BIRuntimeException(Locale.getDefault(), "sdk_0000");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class BIResultSetMetaData
    implements ResultSetMetaData {
        public int getColumnCount() throws SQLException {
            try {
                return BIResultSet.this.metaData.length;
            }
            catch (Exception ex) {
                this.handleException(-1);
                throw new BISQLException(BIResultSet.this.connectionInfo.getLocale(), "sdk.dac.rel.result_2002", (Throwable)ex);
            }
        }

        public boolean isAutoIncrement(int arg0) throws SQLException {
            try {
                return BIResultSet.this.metaData[arg0 - 1].isAutoIncrement();
            }
            catch (Exception ex) {
                this.handleException(arg0);
                throw new BISQLException(BIResultSet.this.connectionInfo.getLocale(), "sdk.dac.rel.result_2002", (Throwable)ex);
            }
        }

        public boolean isCaseSensitive(int arg0) throws SQLException {
            try {
                return BIResultSet.this.metaData[arg0 - 1].isCaseSensitive();
            }
            catch (Exception ex) {
                this.handleException(arg0);
                throw new BISQLException(BIResultSet.this.connectionInfo.getLocale(), "sdk.dac.rel.result_2002", (Throwable)ex);
            }
        }

        public boolean isSearchable(int arg0) throws SQLException {
            try {
                return BIResultSet.this.metaData[arg0 - 1].isSearchable();
            }
            catch (Exception ex) {
                this.handleException(arg0);
                throw new BISQLException(BIResultSet.this.connectionInfo.getLocale(), "sdk.dac.rel.result_2002", (Throwable)ex);
            }
        }

        public boolean isCurrency(int arg0) throws SQLException {
            try {
                return BIResultSet.this.metaData[arg0 - 1].isCurrency();
            }
            catch (Exception ex) {
                this.handleException(arg0);
                throw new BISQLException(BIResultSet.this.connectionInfo.getLocale(), "sdk.dac.rel.result_2002", (Throwable)ex);
            }
        }

        public int isNullable(int arg0) throws SQLException {
            try {
                return BIResultSet.this.metaData[arg0 - 1].isNullable();
            }
            catch (Exception ex) {
                this.handleException(arg0);
                throw new BISQLException(BIResultSet.this.connectionInfo.getLocale(), "sdk.dac.rel.result_2002", (Throwable)ex);
            }
        }

        public boolean isSigned(int arg0) throws SQLException {
            try {
                return BIResultSet.this.metaData[arg0 - 1].isSigned();
            }
            catch (Exception ex) {
                this.handleException(arg0);
                throw new BISQLException(BIResultSet.this.connectionInfo.getLocale(), "sdk.dac.rel.result_2002", (Throwable)ex);
            }
        }

        public int getColumnDisplaySize(int arg0) throws SQLException {
            try {
                return BIResultSet.this.metaData[arg0 - 1].getColumnDisplaySize();
            }
            catch (Exception ex) {
                this.handleException(arg0);
                throw new BISQLException(BIResultSet.this.connectionInfo.getLocale(), "sdk.dac.rel.result_2002", (Throwable)ex);
            }
        }

        public String getColumnLabel(int arg0) throws SQLException {
            try {
                String label = BIResultSet.this.metaData[arg0 - 1].getColumnLabel();
                if (label == null) {
                    label = BIResultSet.this.metaData[arg0 - 1].getColumnName();
                }
                return label;
            }
            catch (Exception ex) {
                this.handleException(arg0);
                throw new BISQLException(BIResultSet.this.connectionInfo.getLocale(), "sdk.dac.rel.result_2002", (Throwable)ex);
            }
        }

        public String getColumnName(int arg0) throws SQLException {
            try {
                return BIResultSet.this.metaData[arg0 - 1].getColumnName();
            }
            catch (Exception ex) {
                this.handleException(arg0);
                throw new BISQLException(BIResultSet.this.connectionInfo.getLocale(), "sdk.dac.rel.result_2002", (Throwable)ex);
            }
        }

        public String getSchemaName(int arg0) throws SQLException {
            try {
                return BIResultSet.this.metaData[arg0 - 1].getSchemaName();
            }
            catch (Exception ex) {
                this.handleException(arg0);
                throw new BISQLException(BIResultSet.this.connectionInfo.getLocale(), "sdk.dac.rel.result_2002", (Throwable)ex);
            }
        }

        public int getPrecision(int arg0) throws SQLException {
            try {
                return BIResultSet.this.metaData[arg0 - 1].getPrecision();
            }
            catch (Exception ex) {
                this.handleException(arg0);
                throw new BISQLException(BIResultSet.this.connectionInfo.getLocale(), "sdk.dac.rel.result_2002", (Throwable)ex);
            }
        }

        public int getScale(int arg0) throws SQLException {
            try {
                return BIResultSet.this.metaData[arg0 - 1].getScale();
            }
            catch (Exception ex) {
                this.handleException(arg0);
                throw new BISQLException(BIResultSet.this.connectionInfo.getLocale(), "sdk.dac.rel.result_2002", (Throwable)ex);
            }
        }

        public String getTableName(int arg0) throws SQLException {
            try {
                return BIResultSet.this.metaData[arg0 - 1].getTableName();
            }
            catch (Exception ex) {
                this.handleException(arg0);
                throw new BISQLException(BIResultSet.this.connectionInfo.getLocale(), "sdk.dac.rel.result_2002", (Throwable)ex);
            }
        }

        public String getCatalogName(int arg0) throws SQLException {
            try {
                return BIResultSet.this.metaData[arg0 - 1].getCatalogName();
            }
            catch (Exception ex) {
                this.handleException(arg0);
                throw new BISQLException(BIResultSet.this.connectionInfo.getLocale(), "sdk.dac.rel.result_2002", (Throwable)ex);
            }
        }

        public int getColumnType(int arg0) throws SQLException {
            try {
                return BIResultSet.this.metaData[arg0 - 1].getColumnType();
            }
            catch (Exception ex) {
                this.handleException(arg0);
                throw new BISQLException(BIResultSet.this.connectionInfo.getLocale(), "sdk.dac.rel.result_2002", (Throwable)ex);
            }
        }

        public String getColumnTypeName(int arg0) throws SQLException {
            try {
                return BIResultSet.this.metaData[arg0 - 1].getColumnTypeName();
            }
            catch (Exception ex) {
                this.handleException(arg0);
                throw new BISQLException(BIResultSet.this.connectionInfo.getLocale(), "sdk.dac.rel.result_2002", (Throwable)ex);
            }
        }

        public boolean isReadOnly(int arg0) throws SQLException {
            try {
                return BIResultSet.this.metaData[arg0 - 1].isReadOnly();
            }
            catch (Exception ex) {
                this.handleException(arg0);
                throw new BISQLException(BIResultSet.this.connectionInfo.getLocale(), "sdk.dac.rel.result_2002", (Throwable)ex);
            }
        }

        public boolean isWritable(int arg0) throws SQLException {
            try {
                return BIResultSet.this.metaData[arg0 - 1].isWritable();
            }
            catch (Exception ex) {
                this.handleException(arg0);
                throw new BISQLException(BIResultSet.this.connectionInfo.getLocale(), "sdk.dac.rel.result_2002", (Throwable)ex);
            }
        }

        public boolean isDefinitelyWritable(int arg0) throws SQLException {
            try {
                return BIResultSet.this.metaData[arg0 - 1].isDefinitelyWritable();
            }
            catch (Exception ex) {
                this.handleException(arg0);
                throw new BISQLException(BIResultSet.this.connectionInfo.getLocale(), "sdk.dac.rel.result_2002", (Throwable)ex);
            }
        }

        public String getColumnClassName(int arg0) throws SQLException {
            try {
                return BIResultSet.this.metaData[arg0 - 1].getColumnClassName();
            }
            catch (Exception ex) {
                this.handleException(arg0);
                throw new BISQLException(BIResultSet.this.connectionInfo.getLocale(), "sdk.dac.rel.result_2002", (Throwable)ex);
            }
        }

        private void handleException(int arg0) throws SQLException {
            if (BIResultSet.this.metaData == null) {
                throw new BISQLException(BIResultSet.this.connectionInfo.getLocale(), "sdk.dac.rel.result_2010");
            }
            if (arg0 >= BIResultSet.this.metaData.length) {
                throw new BISQLException(BIResultSet.this.connectionInfo.getLocale(), "sdk.dac.rel.result_2011", new Object[]{new Integer(arg0)});
            }
        }
    }
}

