/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.result.impl;

import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.result.IBIAxisCursor;
import com.sap.ip.bi.sdk.dac.result.impl.BIAxisCursor;
import com.sap.ip.bi.sdk.dac.result.impl.BIResultSet;
import com.sap.ip.bi.sdk.dac.result.impl.IBIColumnMetaData;
import com.sap.ip.bi.sdk.dac.result.impl.IBIDataSet;
import com.sap.ip.bi.sdk.dac.result.impl.IBIResultSet;
import com.sap.ip.bi.sdk.dac.result.impl.IBIResultSetData;
import com.sap.ip.bi.sdk.dac.result.impl.IBISynchronizeCursor;
import com.sap.ip.bi.sdk.exception.BISQLException;
import com.sap.ip.bi.sdk.util.BILoggingSetup;
import com.sap.ip.bi.sdk.util.impl.IBIMonitor;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class BIDataSet
extends BIResultSet
implements IBIDataSet,
IBISynchronizeCursor {
    private static final String COLUMN_CURSOR = "COLUMNS";
    private static final String ROW_CURSOR = "ROWS";
    private static final String PAGES_CURSOR = "PAGES";
    private static final String SLICER_CURSOR = "SLICER";
    private static final HashMap axisMap = new HashMap();
    private static final boolean tracePrivateMethods = false;
    private static final Location loggingLoc;
    private static final Category loggingCat;
    private IBIMonitor monitor = null;
    private ArrayList axis = null;
    private int[] dimensionCount;
    private int[] rowDelta;
    private int ordinal = -1;
    private boolean isInitialized = false;
    private static final boolean rowMajorNavigation = true;
    private final boolean revertAxisOrder;
    private int currentAxisCursor = 0;
    private AxisList axisList = new AxisList();
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$result$impl$BIDataSet;

    public BIDataSet(IBIResultSetData cell, IBIColumnMetaData[] cellMeta, IBIResultSet.Type resultSetType, boolean revertAxisOrder, boolean resultSetUpdateable) throws SQLException {
        super(cell, cellMeta, resultSetType, resultSetUpdateable);
        this.revertAxisOrder = revertAxisOrder;
        this.axis = new ArrayList();
    }

    public BIDataSet(IBIResultSetData cell, IBIColumnMetaData[] cellMeta, boolean revertAxisOrder) throws SQLException {
        super(cell, cellMeta);
        this.axis = new ArrayList();
        this.revertAxisOrder = revertAxisOrder;
    }

    public BIDataSet(IBIConnectionInfo connectionInfo, IBIResultSetData cell, IBIColumnMetaData[] cellMeta, IBIResultSet.Type resultSetType, boolean revertAxisOrder, boolean resultSetUpdateable) throws SQLException {
        super(connectionInfo, cell, cellMeta, resultSetType, resultSetUpdateable);
        this.revertAxisOrder = revertAxisOrder;
        this.axis = new ArrayList();
    }

    public BIDataSet(IBIConnectionInfo connectionInfo, IBIResultSetData cell, IBIColumnMetaData[] cellMeta, boolean revertAxisOrder) throws SQLException {
        super(connectionInfo, cell, cellMeta);
        this.axis = new ArrayList();
        this.revertAxisOrder = revertAxisOrder;
    }

    private IBIAxisCursor getAxisCursor(String axisName) throws SQLException {
        com.sap.ip.bi.sdk.dac.result.impl.IBIAxisCursor iBIAxisCursor;
        String method = "getAxisCursor(String)";
        loggingLoc.entering("getAxisCursor(String)", new Object[]{axisName});
        try {
            Integer ordinal;
            if (!this.isInitialized) {
                this.initialize();
            }
            if ((ordinal = (Integer)axisMap.get(axisName)) == null || ordinal < 0 || ordinal > this.axis.size() || this.axis.get(ordinal) == null) {
                BISQLException sqx = new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_5001", new Object[]{axisName});
                loggingLoc.throwing("getAxisCursor(String)", (Throwable)sqx);
                throw sqx;
            }
            iBIAxisCursor = (com.sap.ip.bi.sdk.dac.result.impl.IBIAxisCursor)this.axis.get(ordinal);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return iBIAxisCursor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IBIAxisCursor getAxisCursor(int axisOrdinal) throws SQLException {
        com.sap.ip.bi.sdk.dac.result.impl.IBIAxisCursor iBIAxisCursor;
        block6: {
            com.sap.ip.bi.sdk.dac.result.impl.IBIAxisCursor iBIAxisCursor2;
            block5: {
                String method = "getAxisCursor(int)";
                loggingLoc.entering("getAxisCursor(int)", new Object[]{new Integer(axisOrdinal)});
                try {
                    if (!this.isInitialized) {
                        this.initialize();
                    }
                    if (axisOrdinal < 0 || axisOrdinal > this.axis.size()) {
                        BISQLException sqx = new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_5001", new Object[]{new Integer(axisOrdinal)});
                        loggingLoc.throwing("getAxisCursor(int)", (Throwable)sqx);
                        throw sqx;
                    }
                    if (this.revertAxisOrder) {
                        iBIAxisCursor2 = (com.sap.ip.bi.sdk.dac.result.impl.IBIAxisCursor)this.axis.get(this.axis.size() - axisOrdinal - 1);
                        Object var5_6 = null;
                        break block5;
                    }
                    iBIAxisCursor = (com.sap.ip.bi.sdk.dac.result.impl.IBIAxisCursor)this.axis.get(axisOrdinal);
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    loggingLoc.exiting();
                    throw throwable;
                }
            }
            loggingLoc.exiting();
            return iBIAxisCursor2;
        }
        Object var5_7 = null;
        loggingLoc.exiting();
        return iBIAxisCursor;
    }

    public List getAxisCursor() throws SQLException {
        AxisList axisList;
        String method = "getAxisCursor()";
        loggingLoc.entering("getAxisCursor()");
        try {
            if (!this.isInitialized) {
                this.initialize();
            }
            axisList = this.axisList;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return axisList;
    }

    public com.sap.ip.bi.sdk.dac.result.impl.IBIAxisCursor createAxisCursor(IBIResultSetData row, IBIColumnMetaData[] metaData) throws SQLException {
        return this.createAxisCursor(row, metaData, false);
    }

    public com.sap.ip.bi.sdk.dac.result.impl.IBIAxisCursor createAxisCursor(IBIResultSetData row, IBIColumnMetaData[] metaData, boolean resultSetUpdateable) throws SQLException {
        BIAxisCursor bIAxisCursor;
        String method = "createAxisCursor(IBIResultSetData, IBIColumnMetaData[], boolean)";
        loggingLoc.entering("createAxisCursor(IBIResultSetData, IBIColumnMetaData[], boolean)", new Object[]{row, metaData, new Boolean(resultSetUpdateable)});
        try {
            BIResultSet result = new BIResultSet(this.connectionInfo, row, metaData, IBIResultSet.Type.UNRESTRICTED, resultSetUpdateable);
            BIAxisCursor ac = new BIAxisCursor(this.connectionInfo, this.currentAxisCursor, this, result);
            this.axis.add(ac);
            if (this.revertAxisOrder) {
                int ordinal = this.currentAxisCursor;
                Iterator i = ((AbstractList)this.axis).iterator();
                while (i.hasNext()) {
                    BIAxisCursor a = (BIAxisCursor)i.next();
                    a.setOrdinal(ordinal--);
                }
            }
            ++this.currentAxisCursor;
            bIAxisCursor = ac;
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return bIAxisCursor;
    }

    public Object getSource() throws SQLException {
        String method = "getSource()";
        loggingLoc.entering("getSource()");
        try {
            BISQLException sqx = new BISQLException(this.connectionInfo.getLocale(), "sdk_1003", new Object[]{"getSource()"});
            loggingLoc.throwing("getSource()", (Throwable)sqx);
            throw sqx;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void synchronize() throws SQLException {
        block11: {
            block10: {
                String method = "synchronize()";
                loggingLoc.entering("synchronize()");
                try {
                    block12: {
                        int cellRow;
                        if (!this.isInitialized) {
                            this.initialize();
                        }
                        int[] currentRow = new int[this.axis.size()];
                        int i = 0;
                        while (true) {
                            if (i >= this.axis.size()) break;
                            currentRow[i] = ((com.sap.ip.bi.sdk.dac.result.impl.IBIAxisCursor)this.axis.get(i)).synchGetRow();
                            switch (currentRow[i]) {
                                case -1: {
                                    this.synchBeforeFirst();
                                    Object var9_4 = null;
                                    break block10;
                                }
                                case -2: {
                                    this.synchAfterLast();
                                    break block11;
                                }
                                default: {
                                    ++i;
                                    break;
                                }
                            }
                        }
                        int absolute = 1;
                        int i2 = 0;
                        while (true) {
                            if (i2 >= this.axis.size()) {
                                cellRow = this.synchGetRow();
                                if (cellRow >= 0) break;
                                cellRow = absolute;
                                this.synchAbsolute(absolute);
                                break block12;
                            }
                            absolute += this.rowDelta[i2] * (currentRow[i2] - 1);
                            ++i2;
                        }
                        int relative = absolute - cellRow;
                        cellRow = absolute;
                        this.synchRelative(relative);
                    }
                    Object var9_6 = null;
                    loggingLoc.exiting();
                    return;
                }
                catch (Throwable throwable) {
                    Object var9_7 = null;
                    loggingLoc.exiting();
                    throw throwable;
                }
            }
            loggingLoc.exiting();
            return;
        }
        Object var9_5 = null;
        loggingLoc.exiting();
    }

    private void initialize() throws SQLException {
        String method = "initialize()";
        try {
            this.dimensionCount = new int[this.axis.size()];
            int[] rowCount = new int[this.axis.size()];
            this.rowDelta = new int[this.axis.size()];
            Iterator iter = ((AbstractList)this.axis).iterator();
            int i = 0;
            while (iter.hasNext()) {
                com.sap.ip.bi.sdk.dac.result.impl.IBIAxisCursor ac = (com.sap.ip.bi.sdk.dac.result.impl.IBIAxisCursor)iter.next();
                if (ac == null) {
                    BISQLException sqx = new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_5001", new Object[]{null});
                    loggingLoc.throwing("initialize()", (Throwable)sqx);
                    throw sqx;
                }
                this.dimensionCount[i] = ac.getDimensionCursor().size();
                rowCount[i] = ac.synchGetRowCount();
                ++i;
            }
            int x = 0;
            while (x < this.axis.size()) {
                int p = 1;
                int y = x + 1;
                while (y < this.axis.size()) {
                    p *= rowCount[y];
                    ++y;
                }
                this.rowDelta[x] = p;
                ++x;
            }
            this.isInitialized = true;
            this.synchAbsolute(1);
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        axisMap.put(COLUMN_CURSOR, new Integer(0));
        axisMap.put(ROW_CURSOR, new Integer(1));
        axisMap.put(PAGES_CURSOR, new Integer(2));
        loggingLoc = Location.getLocation((String)(class$com$sap$ip$bi$sdk$dac$result$impl$BIDataSet == null ? (class$com$sap$ip$bi$sdk$dac$result$impl$BIDataSet = BIDataSet.class$("com.sap.ip.bi.sdk.dac.result.impl.BIDataSet")) : class$com$sap$ip$bi$sdk$dac$result$impl$BIDataSet).getName());
        loggingCat = BILoggingSetup.QUERY.getCategory();
    }

    private class AxisList
    extends AbstractList {
        private AxisList() {
        }

        public int size() {
            return BIDataSet.this.axis != null ? BIDataSet.this.axis.size() : 0;
        }

        public Object get(int index) throws IndexOutOfBoundsException {
            if (BIDataSet.this.axis == null) {
                throw new IndexOutOfBoundsException();
            }
            if (BIDataSet.this.revertAxisOrder) {
                return BIDataSet.this.axis.get(BIDataSet.this.axis.size() - index - 1);
            }
            return BIDataSet.this.axis.get(index);
        }
    }
}

