/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.result.impl;

import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.result.IBICursorColumn;
import com.sap.ip.bi.sdk.dac.result.IBICursorColumnType;
import com.sap.ip.bi.sdk.exception.BIRuntimeException;
import java.util.HashMap;
import java.util.Map;

public class BICursorColumn
implements IBICursorColumn {
    private static final char SEPARATOR = '.';
    private static Map names = new HashMap();
    private static int globalIndex = 0;
    private final String name;
    private final int index;
    private final IBICursorColumnType type;
    private final boolean isMandatory;
    private static final boolean MANDATORY = true;
    private static final boolean OPTIONAL = false;
    private static final boolean FIRST_COLUMN = true;
    private static final IBIConnectionInfo connInfo = IBIConnectionInfo.DEFAULT;
    public static final BICursorColumn VALUE = new BICursorColumn("VALUE", IBICursorColumnType.OBJECT, true, true);
    public static final BICursorColumn DATATYPE = new BICursorColumn("DATATYPE", IBICursorColumnType.OBJECT, true);
    public static final BICursorColumn STATUS = new BICursorColumn("STATUS", IBICursorColumnType.STATUS, true);
    public static final BICursorColumn FORMATTED_VALUE = new BICursorColumn("FORMATTED_VALUE", IBICursorColumnType.STRING, true);
    public static final BICursorColumn MEMBER_NAME = new BICursorColumn("MEMBER_NAME", IBICursorColumnType.STRING, true, true);
    public static final BICursorColumn MEMBER_CAPTION = new BICursorColumn("MEMBER_CAPTION", IBICursorColumnType.STRING, true);
    public static final BICursorColumn MEMBER_TYPE = new BICursorColumn("MEMBER_TYPE", IBICursorColumnType.STRING, true);
    public static final BICursorColumn MEMBER_UNIQUE_NAME = new BICursorColumn("MEMBER_UNIQUE_NAME", IBICursorColumnType.STRING, true);
    public static final BICursorColumn MEMBER_GUID = new BICursorColumn("MEMBER_GUID", IBICursorColumnType.STRING, true);
    public static final BICursorColumn CATALOG_NAME = new BICursorColumn("CATALOG_NAME", IBICursorColumnType.STRING, true);
    public static final BICursorColumn SCHEMA_NAME = new BICursorColumn("SCHEMA_NAME", IBICursorColumnType.STRING, true);
    public static final BICursorColumn CUBE_NAME = new BICursorColumn("CUBE_NAME", IBICursorColumnType.STRING, true);
    public static final BICursorColumn DIMENSION_UNIQUE_NAME = new BICursorColumn("DIMENSION_UNIQUE_NAME", IBICursorColumnType.STRING, true);
    public static final BICursorColumn HIERARCHY_UNIQUE_NAME = new BICursorColumn("HIERARCHY_UNIQUE_NAME", IBICursorColumnType.STRING, true);
    public static final BICursorColumn LEVEL_UNIQUE_NAME = new BICursorColumn("LEVEL_UNIQUE_NAME", IBICursorColumnType.STRING, true);
    public static final BICursorColumn LEVEL_NUMBER = new BICursorColumn("LEVEL_NUMBER", IBICursorColumnType.INTEGER, true);
    public static final BICursorColumn CHILDREN_CARDINALITY = new BICursorColumn("CHILDREN_CARDINALITY", IBICursorColumnType.INTEGER, true);
    public static final BICursorColumn PARENT_UNIQUE_NAME = new BICursorColumn("PARENT_UNIQUE_NAME", IBICursorColumnType.STRING, true);
    public static final BICursorColumn PARENT_LEVEL = new BICursorColumn("PARENT_LEVEL", IBICursorColumnType.INTEGER, true);
    public static final BICursorColumn PARENT_COUNT = new BICursorColumn("PARENT_COUNT", IBICursorColumnType.INTEGER, true);
    public static final BICursorColumn DESCRIPTION = new BICursorColumn("DESCRIPTION", IBICursorColumnType.STRING, true);
    public static final BICursorColumn DISPLAY_INFO = new BICursorColumn("DISPLAY_INFO", IBICursorColumnType.INTEGER, true);
    public static final BICursorColumn MEMBER_DRILLED_DOWN = new BICursorColumn("MEMBER_DRILLED_DOWN", IBICursorColumnType.BOOLEAN, true);
    public static final BICursorColumn PARENT_SAME_AS_PROV = new BICursorColumn("PARENT_SAME_AS_PROV", IBICursorColumnType.BOOLEAN, true);
    public static final BICursorColumn NAME = new BICursorColumn("NAME", IBICursorColumnType.STRING, true, true);
    public static final BICursorColumn CAPTION = new BICursorColumn("CAPTION", IBICursorColumnType.STRING, true);

    private BICursorColumn(String name, IBICursorColumnType type) {
        BICursorColumn.checkColumnName(name);
        this.name = name;
        this.type = type;
        this.index = 0;
        this.isMandatory = false;
    }

    private BICursorColumn(String name, IBICursorColumnType type, boolean isMandatory) {
        BICursorColumn.checkColumnName(name);
        this.name = name;
        this.type = type;
        this.isMandatory = isMandatory;
        this.index = isMandatory ? ++globalIndex : 0;
    }

    private BICursorColumn(String name, IBICursorColumnType type, boolean isMandatory, boolean isFirstColumn) {
        BICursorColumn.checkColumnName(name);
        this.name = name;
        this.type = type;
        this.isMandatory = isMandatory;
        if (isFirstColumn) {
            globalIndex = 0;
        }
        this.index = isMandatory ? ++globalIndex : 0;
    }

    public static IBICursorColumn createCursorColumn(String name, IBICursorColumnType type) {
        BICursorColumn.checkColumnName(name);
        return new BICursorColumn(name, type == null ? IBICursorColumnType.NONE : type);
    }

    public String toString() {
        return this.name;
    }

    public IBICursorColumnType getType() {
        return this.type;
    }

    public boolean isMandatory() {
        return this.isMandatory;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean equals(IBICursorColumn other) {
        return this == other;
    }

    public boolean equals(String other) {
        return this.name.equals(other);
    }

    private static void checkColumnName(String name) {
        if (names.containsKey(name)) {
            throw new BIRuntimeException(connInfo.getLocale(), "sdk.dac.rel.result_3000", new Object[]{name});
        }
    }

    public static String uniqueName(String dimension, String columnName) {
        return dimension + '.' + columnName;
    }

    public static String uniqueName(String dimension, String attribute, String columnName) {
        return dimension + '.' + "Attribute" + '.' + attribute + '.' + columnName;
    }

    public static String uniqueName(String dimension, IBICursorColumn column) {
        return BICursorColumn.uniqueName(dimension, column.toString());
    }

    public static String uniqueName(String dimension, String attribute, IBICursorColumn column) {
        return BICursorColumn.uniqueName(dimension, attribute, column.toString());
    }
}

