/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.result.impl;

import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.result.IBICursorColumn;
import com.sap.ip.bi.sdk.dac.result.impl.BISQLTypes;
import com.sap.ip.bi.sdk.dac.result.impl.IBIColumnMetaData;
import com.sap.ip.bi.sdk.exception.BISQLException;
import com.sap.ip.bi.sdk.util.BILoggingSetup;
import com.sap.ip.bi.sdk.util.impl.IBIMonitor;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class BIColumnMetaData
implements IBIColumnMetaData {
    private static final boolean tracePrivateMethods = false;
    private static final Location loggingLoc = Location.getLocation((String)(class$com$sap$ip$bi$sdk$dac$result$impl$BIColumnMetaData == null ? (class$com$sap$ip$bi$sdk$dac$result$impl$BIColumnMetaData = BIColumnMetaData.class$("com.sap.ip.bi.sdk.dac.result.impl.BIColumnMetaData")) : class$com$sap$ip$bi$sdk$dac$result$impl$BIColumnMetaData).getName());
    private static final Category loggingCat = BILoggingSetup.QUERY.getCategory();
    private IBIMonitor monitor = null;
    private IBIConnectionInfo connectionInfo = IBIConnectionInfo.DEFAULT;
    private boolean isAutoIncrement = false;
    private boolean isCaseSensitive = false;
    private boolean isSearchable = false;
    private boolean isCurrency = false;
    private int isNullable = 2;
    private boolean isSigned = false;
    private int columnDisplaySize = -1;
    private String columnLabel = null;
    private String columnName = null;
    private String schemaName = null;
    private int precision = -1;
    private int scale = -1;
    private String tableName = null;
    private String catalogName = null;
    private boolean isReadOnly = true;
    private boolean isWritable = false;
    private boolean isDefinitelyWritable = false;
    private String columnTypeName = null;
    private String columnClassName = null;
    private int columnType = 0;
    private boolean isModifiable = false;
    private static String SEPARATOR = ".";
    private static final BIColumnMetaData[] _CELL = new BIColumnMetaData[]{new BIColumnMetaData(IBICursorColumn.VALUE), new BIColumnMetaData(IBICursorColumn.DATATYPE), new BIColumnMetaData(IBICursorColumn.STATUS), new BIColumnMetaData(IBICursorColumn.FORMATTED_VALUE)};
    private static final BIColumnMetaData[] _AXIS = new BIColumnMetaData[]{new BIColumnMetaData(IBICursorColumn.MEMBER_UNIQUE_NAME), new BIColumnMetaData(IBICursorColumn.MEMBER_CAPTION), new BIColumnMetaData(IBICursorColumn.LEVEL_UNIQUE_NAME), new BIColumnMetaData(IBICursorColumn.LEVEL_NUMBER), new BIColumnMetaData(IBICursorColumn.DISPLAY_INFO)};
    private static final BIColumnMetaData[] _DIMENSION = new BIColumnMetaData[]{new BIColumnMetaData(IBICursorColumn.CATALOG_NAME), new BIColumnMetaData(IBICursorColumn.SCHEMA_NAME), new BIColumnMetaData(IBICursorColumn.CUBE_NAME), new BIColumnMetaData(IBICursorColumn.DIMENSION_UNIQUE_NAME), new BIColumnMetaData(IBICursorColumn.HIERARCHY_UNIQUE_NAME), new BIColumnMetaData(IBICursorColumn.LEVEL_UNIQUE_NAME), new BIColumnMetaData(IBICursorColumn.LEVEL_NUMBER), new BIColumnMetaData(IBICursorColumn.MEMBER_NAME), new BIColumnMetaData(IBICursorColumn.MEMBER_UNIQUE_NAME), new BIColumnMetaData(IBICursorColumn.MEMBER_CAPTION), new BIColumnMetaData(IBICursorColumn.MEMBER_TYPE), new BIColumnMetaData(IBICursorColumn.MEMBER_GUID), new BIColumnMetaData(IBICursorColumn.CHILDREN_CARDINALITY), new BIColumnMetaData(IBICursorColumn.PARENT_LEVEL), new BIColumnMetaData(IBICursorColumn.PARENT_UNIQUE_NAME), new BIColumnMetaData(IBICursorColumn.PARENT_COUNT), new BIColumnMetaData(IBICursorColumn.DESCRIPTION)};
    private static final BIColumnMetaData[] _DIMENSION_ATTRIBUTE = new BIColumnMetaData[]{new BIColumnMetaData(IBICursorColumn.NAME), new BIColumnMetaData(IBICursorColumn.CAPTION)};
    public static final List DIMENSION = Collections.unmodifiableList(Arrays.asList(_DIMENSION));
    public static final List DIMENSION_ATTRIBUTE = Collections.unmodifiableList(Arrays.asList(_DIMENSION_ATTRIBUTE));
    public static final List AXIS = Collections.unmodifiableList(Arrays.asList(_AXIS));
    public static final List CELL = Collections.unmodifiableList(Arrays.asList(_CELL));
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$result$impl$BIColumnMetaData;

    private BIColumnMetaData() {
        String method = "BIColumnMetaData()";
        try {
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            throw throwable;
        }
    }

    public BIColumnMetaData(int columnType, String columnName) {
        String method = "BIColumnMetaData(int, String)";
        try {
            this.columnType = columnType;
            this.columnName = columnName;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            throw throwable;
        }
    }

    public BIColumnMetaData(IBIConnectionInfo connectionInfo, int columnType, String columnName) {
        String method = "BIColumnMetaData(int, String)";
        try {
            this.connectionInfo = connectionInfo;
            this.columnType = columnType;
            this.columnName = columnName;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            throw throwable;
        }
    }

    public BIColumnMetaData(IBICursorColumn column) {
        String method = "BIColumnMetaData(IBICursorColumn)";
        try {
            this.columnType = column.getType().getSQLType();
            this.columnName = column.toString();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            throw throwable;
        }
    }

    public boolean isAutoIncrement() throws SQLException {
        boolean bl;
        String method = "isAutoIncrement()";
        loggingLoc.entering("isAutoIncrement()");
        try {
            bl = this.isAutoIncrement;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return bl;
    }

    public void setAutoIncrement(boolean autoIncrement) throws SQLException {
        String method = "setAutoIncrement(boolean)";
        loggingLoc.entering("setAutoIncrement(boolean)", new Object[]{new Boolean(autoIncrement)});
        try {
            if (!this.isModifiable) {
                BISQLException sqx = new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2015");
                loggingLoc.throwing("setAutoIncrement(boolean)", (Throwable)sqx);
                throw sqx;
            }
            this.isAutoIncrement = autoIncrement;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public boolean isCaseSensitive() throws SQLException {
        boolean bl;
        String method = "isCaseSensitive()";
        loggingLoc.entering("isCaseSensitive()");
        try {
            bl = this.isCaseSensitive;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return bl;
    }

    public void setCaseSensitive(boolean caseSensitive) throws SQLException {
        String method = "setCaseSensitive(boolean)";
        loggingLoc.entering("setCaseSensitive(boolean)", new Object[]{new Boolean(caseSensitive)});
        try {
            if (!this.isModifiable) {
                BISQLException sqx = new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2015");
                loggingLoc.throwing("setCaseSensitive(boolean)", (Throwable)sqx);
                throw sqx;
            }
            this.isCaseSensitive = caseSensitive;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public boolean isSearchable() throws SQLException {
        boolean bl;
        String method = "isSearchable()";
        loggingLoc.entering("isSearchable()");
        try {
            bl = this.isSearchable;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return bl;
    }

    public void setSearchable(boolean searchable) throws SQLException {
        String method = "setSearchable(boolean)";
        loggingLoc.entering("setSearchable(boolean)", new Object[]{new Boolean(searchable)});
        try {
            if (!this.isModifiable) {
                BISQLException sqx = new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2015");
                loggingLoc.throwing("setSearchable(boolean)", (Throwable)sqx);
                throw sqx;
            }
            this.isSearchable = searchable;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public boolean isCurrency() throws SQLException {
        boolean bl;
        String method = "isCurrency()";
        loggingLoc.entering("isCurrency()");
        try {
            bl = this.isCurrency;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return bl;
    }

    public void setCurrency(boolean currency) throws SQLException {
        String method = "setCurrency(boolean)";
        loggingLoc.entering("setCurrency(boolean)", new Object[]{new Boolean(currency)});
        try {
            if (!this.isModifiable) {
                BISQLException sqx = new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2015");
                loggingLoc.throwing("setCurrency(boolean)", (Throwable)sqx);
                throw sqx;
            }
            this.isCurrency = currency;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public int isNullable() throws SQLException {
        int n;
        String method = "isNullable()";
        loggingLoc.entering("isNullable()");
        try {
            n = this.isNullable;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return n;
    }

    public void setNullable(int nullable) throws SQLException {
        String method = "setNullable(int)";
        loggingLoc.entering("setNullable(int)", new Object[]{new Integer(nullable)});
        try {
            if (this.isModifiable) {
                if (nullable != 0 && nullable != 1 && nullable != 2) {
                    BISQLException sqx = new BISQLException(this.connectionInfo.getLocale(), nullable + " is not a valid entry");
                    loggingLoc.throwing("setNullable(int)", (Throwable)sqx);
                    throw sqx;
                }
            } else {
                BISQLException sqx = new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2015");
                loggingLoc.throwing("setNullable(int)", (Throwable)sqx);
                throw sqx;
            }
            this.isNullable = nullable;
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public boolean isSigned() throws SQLException {
        boolean bl;
        String method = "isSigned()";
        loggingLoc.entering("isSigned()");
        try {
            bl = this.isSigned;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return bl;
    }

    public void setSigned(boolean signed) throws SQLException {
        String method = "setSigned(boolean)";
        loggingLoc.entering("setSigned(boolean)", new Object[]{new Boolean(signed)});
        try {
            if (!this.isModifiable) {
                BISQLException sqx = new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2015");
                loggingLoc.throwing("setSigned(boolean)", (Throwable)sqx);
                throw sqx;
            }
            this.isSigned = signed;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public int getColumnDisplaySize() throws SQLException {
        int n;
        String method = "getColumnDisplaySize()";
        loggingLoc.entering("getColumnDisplaySize()");
        try {
            n = this.columnDisplaySize;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return n;
    }

    public void setColumnDisplaySize(int columnDisplaySize) throws SQLException {
        String method = "setColumnDisplaySize(int)";
        loggingLoc.entering("setColumnDisplaySize(int)", new Object[]{new Integer(columnDisplaySize)});
        try {
            if (!this.isModifiable) {
                BISQLException sqx = new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2015");
                loggingLoc.throwing("setColumnDisplaySize(int)", (Throwable)sqx);
                throw sqx;
            }
            this.columnDisplaySize = columnDisplaySize;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public String getColumnLabel() throws SQLException {
        String string;
        String method = "getColumnLabel()";
        loggingLoc.entering("getColumnLabel()");
        try {
            string = this.columnLabel;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return string;
    }

    public void setColumnLabel(String columnLabel) throws SQLException {
        String method = "setColumnLabel(String)";
        loggingLoc.entering("setColumnLabel(String)", new Object[]{columnLabel});
        try {
            if (!this.isModifiable) {
                BISQLException sqx = new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2015");
                loggingLoc.throwing("setColumnLabel(String)", (Throwable)sqx);
                throw sqx;
            }
            this.columnLabel = columnLabel;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public String getColumnName() throws SQLException {
        String string;
        String method = "getColumnName()";
        loggingLoc.entering("getColumnName()");
        try {
            string = this.columnName;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return string;
    }

    public void setColumnName(String columnName) throws SQLException {
        String method = "setColumnName(String)";
        loggingLoc.entering("setColumnName(String)", new Object[]{columnName});
        try {
            if (!this.isModifiable) {
                BISQLException sqx = new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2015");
                loggingLoc.throwing("setColumnName(String)", (Throwable)sqx);
                throw sqx;
            }
            this.columnName = columnName;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public String getSchemaName() throws SQLException {
        String string;
        String method = "getSchemaName()";
        loggingLoc.entering("getSchemaName()");
        try {
            string = this.schemaName;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return string;
    }

    public void setSchemaName(String schemaName) throws SQLException {
        String method = "setSchemaName(String)";
        loggingLoc.entering("setSchemaName(String)", new Object[]{schemaName});
        try {
            if (!this.isModifiable) {
                BISQLException sqx = new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2015");
                loggingLoc.throwing("setSchemaName(String)", (Throwable)sqx);
                throw sqx;
            }
            this.schemaName = schemaName;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public int getPrecision() throws SQLException {
        int n;
        String method = "getPrecision()";
        loggingLoc.entering("getPrecision()");
        try {
            n = this.precision;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return n;
    }

    public void setPrecision(int precision) throws SQLException {
        String method = "setPrecision(int)";
        loggingLoc.entering("setPrecision(int)", new Object[]{new Integer(precision)});
        try {
            if (!this.isModifiable) {
                BISQLException sqx = new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2015");
                loggingLoc.throwing("setPrecision(int)", (Throwable)sqx);
                throw sqx;
            }
            this.precision = precision;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public int getScale() throws SQLException {
        int n;
        String method = "getScale()";
        loggingLoc.entering("getScale()");
        try {
            n = this.scale;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return n;
    }

    public void setScale(int scale) throws SQLException {
        String method = "setScale(int)";
        loggingLoc.entering("setScale(int)", new Object[]{new Integer(scale)});
        try {
            if (!this.isModifiable) {
                BISQLException sqx = new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2015");
                loggingLoc.throwing("setScale(int)", (Throwable)sqx);
                throw sqx;
            }
            this.scale = scale;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public String getTableName() throws SQLException {
        String string;
        String method = "getTableName()";
        loggingLoc.entering("getTableName()");
        try {
            string = this.tableName;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return string;
    }

    public void setTableName(String tableName) throws SQLException {
        String method = "setTableName(String)";
        loggingLoc.entering("setTableName(String)", new Object[]{tableName});
        try {
            if (!this.isModifiable) {
                BISQLException sqx = new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2015");
                loggingLoc.throwing("setTableName(String)", (Throwable)sqx);
                throw sqx;
            }
            this.tableName = tableName;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public String getCatalogName() throws SQLException {
        String string;
        String method = "getCatalogName()";
        loggingLoc.entering("getCatalogName()");
        try {
            string = this.catalogName;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return string;
    }

    public void setCatalogName(String catalogName) throws SQLException {
        String method = "setCatalogName(String)";
        loggingLoc.entering("setCatalogName(String)", new Object[]{catalogName});
        try {
            if (!this.isModifiable) {
                BISQLException sqx = new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2015");
                loggingLoc.throwing("setCatalogName(String)", (Throwable)sqx);
                throw sqx;
            }
            this.catalogName = catalogName;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public int getColumnType() throws SQLException {
        int n;
        String method = "getColumnType()";
        loggingLoc.entering("getColumnType()");
        try {
            n = this.columnType;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return n;
    }

    public void setColumnType(int columnType) throws SQLException {
        String method = "setColumnType(int)";
        loggingLoc.entering("setColumnType(int)", new Object[]{new Integer(columnType)});
        try {
            if (!this.isModifiable) {
                BISQLException sqx = new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2015");
                loggingLoc.throwing("setColumnType(int)", (Throwable)sqx);
                throw sqx;
            }
            this.columnType = columnType;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getColumnTypeName() throws SQLException {
        String string;
        block6: {
            String string2;
            block5: {
                String method = "getColumnTypeName()";
                loggingLoc.entering("getColumnTypeName()");
                try {
                    if (this.columnTypeName == null) {
                        try {
                            string2 = BISQLTypes.typeName(this.connectionInfo, this.columnType);
                            Object var5_5 = null;
                            break block5;
                        }
                        catch (SQLException ex) {
                            String string3 = null;
                            Object var5_6 = null;
                            loggingLoc.exiting();
                            return string3;
                        }
                    }
                    string = this.columnTypeName;
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    loggingLoc.exiting();
                    throw throwable;
                }
            }
            loggingLoc.exiting();
            return string2;
        }
        Object var5_7 = null;
        loggingLoc.exiting();
        return string;
    }

    public void setColumnTypeName(String columnTypeName) throws SQLException {
        String method = "setColumnTypeName(String)";
        loggingLoc.entering("setColumnTypeName(String)", new Object[]{columnTypeName});
        try {
            if (!this.isModifiable) {
                BISQLException sqx = new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2015");
                loggingLoc.throwing("setColumnTypeName(String)", (Throwable)sqx);
                throw sqx;
            }
            this.columnTypeName = columnTypeName;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public boolean isReadOnly() throws SQLException {
        boolean bl;
        String method = "isReadOnly()";
        loggingLoc.entering("isReadOnly()");
        try {
            bl = this.isReadOnly;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return bl;
    }

    public void setReadOnly(boolean readonly) throws SQLException {
        String method = "setReadOnly(boolean)";
        loggingLoc.entering("setReadOnly(boolean)", new Object[]{new Boolean(readonly)});
        try {
            if (!this.isModifiable) {
                BISQLException sqx = new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2015");
                loggingLoc.throwing("setReadOnly(boolean)", (Throwable)sqx);
                throw sqx;
            }
            this.isReadOnly = readonly;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public boolean isWritable() throws SQLException {
        boolean bl;
        String method = "isWritable()";
        loggingLoc.entering("isWritable()");
        try {
            bl = this.isWritable;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return bl;
    }

    public void setWritable(boolean writable) throws SQLException {
        String method = "setWritable(boolean)";
        loggingLoc.entering("setWritable(boolean)", new Object[]{new Boolean(writable)});
        try {
            if (!this.isModifiable) {
                BISQLException sqx = new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2015");
                loggingLoc.throwing("setWritable(boolean)", (Throwable)sqx);
                throw sqx;
            }
            this.isWritable = writable;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public boolean isDefinitelyWritable() throws SQLException {
        boolean bl;
        String method = "isDefinitelyWritable()";
        loggingLoc.entering("isDefinitelyWritable()");
        try {
            bl = this.isDefinitelyWritable;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return bl;
    }

    public void setDefinitelyWritable(boolean definitelyWritable) throws SQLException {
        String method = "setDefinitelyWritable(boolean)";
        loggingLoc.entering("setDefinitelyWritable(boolean)", new Object[]{new Boolean(definitelyWritable)});
        try {
            if (!this.isModifiable) {
                BISQLException sqx = new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2015");
                loggingLoc.throwing("setDefinitelyWritable(boolean)", (Throwable)sqx);
                throw sqx;
            }
            this.isDefinitelyWritable = definitelyWritable;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public String getColumnClassName() throws SQLException {
        String string;
        String method = "getColumnClassName()";
        loggingLoc.entering("getColumnClassName()");
        try {
            string = this.columnClassName;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return string;
    }

    public void setColumnClassName(String columnClassName) throws SQLException {
        String method = "setColumnClassName(String)";
        loggingLoc.entering("setColumnClassName(String)", new Object[]{columnClassName});
        try {
            if (!this.isModifiable) {
                BISQLException sqx = new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2015");
                loggingLoc.throwing("setColumnClassName(String)", (Throwable)sqx);
                throw sqx;
            }
            this.columnClassName = columnClassName;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public void setModifiable(boolean isModifiable) throws SQLException {
        String method = "setModifiable(boolean)";
        loggingLoc.entering("setModifiable(boolean)", new Object[]{new Boolean(isModifiable)});
        try {
            this.isModifiable = isModifiable;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

