/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.xmla.impl;

import com.sap.ip.bi.sdk.dac.connector.impl.BIRestriction;
import com.sap.ip.bi.sdk.dac.connector.olap.BIOlapDataSourceType;
import com.sap.ip.bi.sdk.dac.connector.olap.BIVariant;
import com.sap.ip.bi.sdk.dac.connector.olap.CommonMDRConnection;
import com.sap.ip.bi.sdk.dac.connector.olap.MetadataNameConverter;
import com.sap.ip.bi.sdk.dac.connector.olap.schema.AttributeObject;
import com.sap.ip.bi.sdk.dac.connector.olap.schema.BISAPVariableObject;
import com.sap.ip.bi.sdk.dac.connector.olap.schema.CubeObject;
import com.sap.ip.bi.sdk.dac.connector.olap.schema.DimensionObject;
import com.sap.ip.bi.sdk.dac.connector.olap.schema.LevelBasedHierarchyObject;
import com.sap.ip.bi.sdk.dac.connector.olap.schema.LevelObject;
import com.sap.ip.bi.sdk.dac.connector.olap.schema.MeasureObject;
import com.sap.ip.bi.sdk.dac.connector.olap.schema.OlapSchemaObject;
import com.sap.ip.bi.sdk.dac.connector.olap.schema.SchemaObject;
import com.sap.ip.bi.sdk.dac.connector.xmla.impl.Connection;
import com.sap.ip.bi.sdk.dac.olap.query.member.IBIMember;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import com.sap.ip.bi.sdk.exception.BIRuntimeException;
import com.sap.ip.bi.sdk.util.BILoggingSetup;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.omg.cwm.analysis.olap.Dimension;
import org.omg.cwm.analysis.olap.LevelBasedHierarchy;

public class XmlaMDRConnection
extends CommonMDRConnection {
    private Connection connection = null;
    private static final Location loc = Location.getLocation((String)(class$com$sap$ip$bi$sdk$dac$connector$xmla$impl$XmlaMDRConnection == null ? (class$com$sap$ip$bi$sdk$dac$connector$xmla$impl$XmlaMDRConnection = XmlaMDRConnection.class$("com.sap.ip.bi.sdk.dac.connector.xmla.impl.XmlaMDRConnection")) : class$com$sap$ip$bi$sdk$dac$connector$xmla$impl$XmlaMDRConnection).getName());
    private static final Category cat = BILoggingSetup.CONNECTION.getCategory();
    private Locale locale;
    private static String[][] MANDATORY_PROPERTY = new String[][]{{"MEMBER_CAPTION", "1", "0", "0", "DATA_TYPE", "A label or caption associated with the member", null, null, "Member caption"}, {"MEMBER_NAME", "1", "0", "0", "DATA_TYPE", "Name of the member", null, null, "Member name"}, {"MEMBER_UNIQUE_NAME", "1", "0", "0", "DATA_TYPE", "Unique name of the member", null, null, "Member unique name"}};
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$connector$xmla$impl$XmlaMDRConnection;

    public XmlaMDRConnection(Connection connection, BIOlapDataSourceType dataSourceType) throws BIResourceException {
        super(connection.getConnectionInfo(), dataSourceType);
        this.connection = connection;
        this.locale = connection != null ? connection.getLocale() : Locale.getDefault();
    }

    public void assertLoadSchemas() throws BIResourceException {
        loc.entering("assertSchemasLoaded()");
        if (this.metaStore.getSchema().isEmpty()) {
            this.assertFindSchema(null);
        }
        loc.exiting();
    }

    public void assertLoadCubeDimensionAssoc(OlapSchemaObject obj) throws BIResourceException {
        loc.entering("assertCubeDimensionAssocLoaded(" + obj + ")");
        String catalogName = null;
        String schemaName = null;
        String cubeName = null;
        Object dimensionUName = null;
        if (obj != null) {
            if (obj instanceof CubeObject) {
                if (!this.metaStore.getDimension((CubeObject)obj).isEmpty()) {
                    return;
                }
                catalogName = ((CubeObject)obj).getCatalogName();
                schemaName = ((CubeObject)obj).getSchemaName();
                cubeName = ((CubeObject)obj).getCubeName();
            } else if (obj instanceof DimensionObject) {
                if (!this.metaStore.getDimensionofCube((DimensionObject)obj).isEmpty()) {
                    return;
                }
                catalogName = ((DimensionObject)obj).getCatalogName();
                schemaName = ((DimensionObject)obj).getSchemaName();
                cubeName = ((DimensionObject)obj).getCubeName();
            } else {
                cat.errorT(loc, "assertLoadCubeDimensionAssoc: Unsupported Metadata schema object: " + obj.getClass().getName());
                throw new BIRuntimeException(this.locale, cat, 500, loc, "sdk.dac.connector_1021", null);
            }
        }
        ArrayList cdas = new ArrayList();
        ArrayList<BIRestriction> res = new ArrayList<BIRestriction>();
        res.add(new BIRestriction("CATALOG_NAME", catalogName));
        res.add(new BIRestriction("SCHEMA_NAME", schemaName));
        res.add(new BIRestriction("CUBE_NAME", cubeName));
        List dim_hm = this.connection.discoverSchemaRowsetasList("MDSCHEMA_DIMENSIONS", res);
        int i = 0;
        while (i < dim_hm.size()) {
            HashMap hm = (HashMap)dim_hm.get(i);
            loc.debugT(cat, "dimensions from XMLA:" + hm.toString());
            DimensionObject dimObj = this.newDimensionObject(hm);
            ++i;
        }
        loc.exiting();
    }

    public void assertLoadLevelBasedHierarchies(DimensionObject dimension) throws BIResourceException {
        loc.entering("assertLevelBasedHierarchiesLoaded(" + dimension + ")");
        if (!this.metaStore.getHierarchy(dimension).isEmpty()) {
            return;
        }
        this.assertFindHierarchy(MetadataNameConverter.schemaNameFromSchemaAndCatalogName((String)dimension.getCatalogName(), (String)dimension.getSchemaName()), dimension.getCubeName(), dimension.getDimensionName(), null);
        loc.exiting();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void assertLoadHierarchyLevelAssoc(OlapSchemaObject obj) throws BIResourceException {
        loc.entering("assertHierarchyLevelAssocLoaded(" + obj + ")");
        String catalogName = null;
        String schemaName = null;
        String cubeName = null;
        String dimensionUName = null;
        Object hierarchyUName = null;
        if (obj != null) {
            if (obj instanceof LevelBasedHierarchyObject) {
                if (!this.metaStore.getLevel((LevelBasedHierarchyObject)obj).isEmpty()) {
                    return;
                }
                catalogName = ((LevelBasedHierarchyObject)obj).getCatalogName();
                schemaName = ((LevelBasedHierarchyObject)obj).getSchemaName();
                cubeName = ((LevelBasedHierarchyObject)obj).getCubeName();
                dimensionUName = ((LevelBasedHierarchyObject)obj).getDimensionUniqueName();
            } else {
                if (!(obj instanceof LevelObject)) {
                    cat.errorT(loc, "assertLoadHierarchyLevelAssoc: Unsupported Metadata schema object: " + obj.getClass().getName());
                    throw new BIRuntimeException(this.locale, cat, 400, loc, "sdk.dac.connector_1021", null);
                }
                if (!this.metaStore.getLevelofHierarchy((LevelObject)obj).isEmpty()) {
                    return;
                }
                catalogName = ((LevelObject)obj).getCatalogName();
                schemaName = ((LevelObject)obj).getSchemaName();
                cubeName = ((LevelObject)obj).getCubeName();
                dimensionUName = ((LevelObject)obj).getDimensionUniqueName();
            }
        } else if (!this.metaStore.getDimension().isEmpty()) {
            return;
        }
        ArrayList hlas = new ArrayList();
        ArrayList<BIRestriction> res = new ArrayList<BIRestriction>();
        res.add(new BIRestriction("CATALOG_NAME", catalogName));
        res.add(new BIRestriction("SCHEMA_NAME", schemaName));
        res.add(new BIRestriction("CUBE_NAME", cubeName));
        res.add(new BIRestriction("DIMENSION_UNIQUE_NAME", dimensionUName));
        List lev_hm = this.connection.discoverSchemaRowsetasList("MDSCHEMA_LEVELS", res);
        int i = 0;
        while (i < lev_hm.size()) {
            HashMap hm = (HashMap)lev_hm.get(i);
            loc.debugT(cat, "Level from XMLA:" + hm.toString());
            LevelObject levelObj = this.newLevelObject(hm);
            ++i;
        }
        loc.exiting();
    }

    public void assertLoadMeasures(CubeObject cube) throws BIResourceException {
        loc.entering("assertMeasuresLoaded(" + cube + ")");
        if (!this.metaStore.getMeasure(cube).isEmpty()) {
            return;
        }
        this.assertFindMeasure(MetadataNameConverter.schemaNameFromSchemaAndCatalogName((String)cube.getCatalogName(), (String)cube.getSchemaName()), cube.getCubeName(), null);
        loc.exiting();
    }

    public List assertFindSchema(String schemaName) throws BIResourceException {
        loc.entering("assertFindSchema(" + schemaName + ")");
        ArrayList<SchemaObject> schemas = new ArrayList<SchemaObject>();
        ArrayList<BIRestriction> res = new ArrayList<BIRestriction>();
        String lCatalogName = MetadataNameConverter.schemaNameToCatalogName((Locale)this.locale, (String)schemaName);
        String lSchemaName = MetadataNameConverter.schemaNameToSchemaName((Locale)this.locale, (String)schemaName);
        if (lCatalogName != null) {
            res.add(new BIRestriction("CATALOG_NAME", lCatalogName));
        }
        if (lSchemaName != null) {
            res.add(new BIRestriction("SCHEMA_NAME", lSchemaName));
        }
        List catalog_hm = this.connection.discoverSchemaRowsetasList("DBSCHEMA_CATALOGS", res);
        int i = 0;
        while (i < catalog_hm.size()) {
            HashMap hm = (HashMap)catalog_hm.get(i);
            loc.debugT(cat, "Catalog from XMLA:" + hm.toString());
            SchemaObject schema = this.newSchemaObject(hm);
            schemas.add(schema);
            ++i;
        }
        loc.exiting();
        return schemas;
    }

    public void assertLoadCubes() throws BIResourceException {
        loc.entering("assertLoadCubes()");
        Iterator i = this.metaStore.getSchema().values().iterator();
        while (i.hasNext()) {
            SchemaObject schema = (SchemaObject)i.next();
            if (!this.metaStore.getCube(schema).isEmpty()) continue;
            String schemaName = MetadataNameConverter.schemaNameFromSchemaAndCatalogName((String)schema.getCatalogName(), (String)schema.getSchemaName());
            this.assertFindCube(schemaName, null);
        }
        loc.exiting();
    }

    public void assertLoadCubes(SchemaObject schema) throws BIResourceException {
        loc.entering("assertLoadCubes(SchemaObject schema)");
        if (!this.metaStore.getCube(schema).isEmpty()) {
            loc.exiting();
            return;
        }
        this.assertFindCube(MetadataNameConverter.schemaNameFromSchemaAndCatalogName((String)schema.getCatalogName(), (String)schema.getSchemaName()), null);
        loc.exiting();
    }

    public List assertFindCube(String schemaName, String cubeName) throws BIResourceException {
        loc.entering("assertFindCube(" + schemaName + "," + cubeName + ")");
        ArrayList<CubeObject> cubes = new ArrayList<CubeObject>();
        ArrayList<BIRestriction> res = new ArrayList<BIRestriction>();
        String lCatalogName = null;
        String lSchemaName = null;
        if (schemaName != null && schemaName.length() > 0) {
            lCatalogName = MetadataNameConverter.schemaNameToCatalogName((Locale)this.locale, (String)schemaName);
            lSchemaName = MetadataNameConverter.schemaNameToSchemaName((Locale)this.locale, (String)schemaName);
        }
        if (lCatalogName != null && lCatalogName.length() > 0) {
            res.add(new BIRestriction("CATALOG_NAME", lCatalogName));
        }
        if (lSchemaName != null && lSchemaName.length() > 0) {
            res.add(new BIRestriction("SCHEMA_NAME", lSchemaName));
        }
        res.add(new BIRestriction("CUBE_NAME", cubeName));
        List cube_hm = this.connection.discoverSchemaRowsetasList("MDSCHEMA_CUBES", res);
        int i = 0;
        while (i < cube_hm.size()) {
            HashMap hm = (HashMap)cube_hm.get(i);
            loc.debugT(cat, "Cube from XMLA:" + hm.toString());
            CubeObject cube = this.newCubeObject(hm);
            cubes.add(cube);
            ++i;
        }
        loc.exiting();
        return cubes;
    }

    public List assertFindDimension(String schemaName, String cubeName, String dimensionName) throws BIResourceException {
        loc.entering("assertFindDimension(" + schemaName + "," + cubeName + ")");
        ArrayList<DimensionObject> dimensions = new ArrayList<DimensionObject>();
        ArrayList<BIRestriction> res = new ArrayList<BIRestriction>();
        String lCatalogName = null;
        String lSchemaName = null;
        if (schemaName != null && schemaName.length() > 0) {
            lCatalogName = MetadataNameConverter.schemaNameToCatalogName((Locale)this.locale, (String)schemaName);
            lSchemaName = MetadataNameConverter.schemaNameToSchemaName((Locale)this.locale, (String)schemaName);
        }
        if (lCatalogName != null && lCatalogName.length() > 0) {
            res.add(new BIRestriction("CATALOG_NAME", lCatalogName));
        }
        if (lSchemaName != null && lSchemaName.length() > 0) {
            res.add(new BIRestriction("SCHEMA_NAME", lSchemaName));
        }
        if (cubeName != null && cubeName.length() > 0) {
            res.add(new BIRestriction("CUBE_NAME", cubeName));
        }
        boolean checkDimensionNam = false;
        if (dimensionName != null && dimensionName != "") {
            checkDimensionNam = true;
        }
        List dim_hm = this.connection.discoverSchemaRowsetasList("MDSCHEMA_DIMENSIONS", res);
        int i = 0;
        while (i < dim_hm.size()) {
            HashMap hm = (HashMap)dim_hm.get(i);
            loc.debugT(cat, "Dimension from XMLA:" + hm.toString());
            DimensionObject dimension = this.newDimensionObject(hm);
            if (!checkDimensionNam || dimensionName.equalsIgnoreCase(dimension.getDimensionName())) {
                dimensions.add(dimension);
            }
            ++i;
        }
        loc.exiting();
        return dimensions;
    }

    public List assertFindHierarchy(String schemaName, String cubeName, String dimensionName, String hierarchyName) throws BIResourceException {
        loc.entering("assertFindHierarchy(" + schemaName + "," + cubeName + "," + dimensionName + ")");
        ArrayList<LevelBasedHierarchyObject> hierarchies = new ArrayList<LevelBasedHierarchyObject>();
        ArrayList<BIRestriction> res = new ArrayList<BIRestriction>();
        String lCatalogName = null;
        String lSchemaName = null;
        if (schemaName != null && schemaName.length() > 0) {
            lCatalogName = MetadataNameConverter.schemaNameToCatalogName((Locale)this.locale, (String)schemaName);
            lSchemaName = MetadataNameConverter.schemaNameToSchemaName((Locale)this.locale, (String)schemaName);
        }
        if (lCatalogName != null && lCatalogName.length() > 0) {
            res.add(new BIRestriction("CATALOG_NAME", lCatalogName));
        }
        if (lSchemaName != null && lSchemaName.length() > 0) {
            res.add(new BIRestriction("SCHEMA_NAME", lSchemaName));
        }
        String dimensionUName = "[" + dimensionName + "]";
        if (cubeName != null && cubeName.length() > 0) {
            res.add(new BIRestriction("CUBE_NAME", cubeName));
        }
        if (dimensionName != null && dimensionName.length() > 0) {
            res.add(new BIRestriction("DIMENSION_UNIQUE_NAME", dimensionUName));
        }
        boolean checkHryNam = false;
        if (hierarchyName != null && hierarchyName != "") {
            checkHryNam = true;
        }
        List hie_hm = this.connection.discoverSchemaRowsetasList("MDSCHEMA_HIERARCHIES", res);
        int i = 0;
        while (i < hie_hm.size()) {
            HashMap hm = (HashMap)hie_hm.get(i);
            loc.debugT(cat, "Hierarchy from XMLA:" + hm.toString());
            LevelBasedHierarchyObject hierarchy = this.newHierarchyObject(hm);
            if (!checkHryNam || hierarchyName.equalsIgnoreCase((String)hm.get("HIERARCHY_NAME"))) {
                hierarchies.add(hierarchy);
            }
            ++i;
        }
        loc.exiting();
        return hierarchies;
    }

    public List assertFindLevel(String schemaName, String cubeName, String dimensionName, String hierarchyName, String levelName) throws BIResourceException {
        loc.entering("assertFindLevel(" + schemaName + "," + cubeName + "," + dimensionName + "," + hierarchyName + "," + levelName + ")");
        ArrayList<LevelObject> levels = new ArrayList<LevelObject>();
        ArrayList<BIRestriction> res = new ArrayList<BIRestriction>();
        String lCatalogName = null;
        String lSchemaName = null;
        if (schemaName != null && schemaName.length() > 0) {
            lCatalogName = MetadataNameConverter.schemaNameToCatalogName((Locale)this.locale, (String)schemaName);
            lSchemaName = MetadataNameConverter.schemaNameToSchemaName((Locale)this.locale, (String)schemaName);
        }
        if (lCatalogName != null && lCatalogName.length() > 0) {
            res.add(new BIRestriction("CATALOG_NAME", lCatalogName));
        }
        if (lSchemaName != null && lSchemaName.length() > 0) {
            res.add(new BIRestriction("SCHEMA_NAME", lSchemaName));
        }
        String dimensionUName = "[" + dimensionName + "]";
        if (cubeName != null && cubeName.length() > 0) {
            res.add(new BIRestriction("CUBE_NAME", cubeName));
        }
        if (dimensionName != null && dimensionName.length() > 0) {
            res.add(new BIRestriction("DIMENSION_UNIQUE_NAME", dimensionUName));
        }
        boolean checkHryNam = false;
        if (hierarchyName != null && hierarchyName != "") {
            checkHryNam = true;
        }
        String hierarchyUName = null;
        if (checkHryNam) {
            List hie_hm = this.connection.discoverSchemaRowsetasList("MDSCHEMA_HIERARCHIES", res);
            int i = 0;
            while (i < hie_hm.size()) {
                HashMap hm = (HashMap)hie_hm.get(i);
                loc.debugT(cat, "Hierarchy from XMLA:" + hm.toString());
                if (hierarchyName.equalsIgnoreCase((String)hm.get("HIERARCHY_NAME"))) {
                    hierarchyUName = (String)hm.get("HIERARCHY_UNIQUE_NAME");
                }
                ++i;
            }
        }
        if (hierarchyUName != null) {
            res.add(new BIRestriction("HIERARCHY_UNIQUE_NAME", hierarchyUName));
        }
        boolean checkLvlNam = false;
        if (levelName != null && levelName != "") {
            checkLvlNam = true;
        }
        List lev_hm = this.connection.discoverSchemaRowsetasList("MDSCHEMA_LEVELS", res);
        int i = 0;
        while (i < lev_hm.size()) {
            HashMap hm = (HashMap)lev_hm.get(i);
            loc.debugT(cat, "Level from XMLA:" + hm.toString());
            LevelObject level = this.newLevelObject(hm);
            if (!checkLvlNam || levelName.equalsIgnoreCase((String)hm.get("LEVEL_NAME"))) {
                levels.add(level);
            }
            ++i;
        }
        loc.exiting();
        return levels;
    }

    public List assertFindMeasure(String schemaName, String cubeName, String measureName) throws BIResourceException {
        loc.entering(cat, "assertFindMeasure(" + schemaName + ", " + cubeName + ", " + measureName + ")");
        ArrayList<MeasureObject> measures = new ArrayList<MeasureObject>();
        ArrayList<BIRestriction> res = new ArrayList<BIRestriction>();
        String lCatalogName = null;
        String lSchemaName = null;
        if (schemaName != null && schemaName.length() > 0) {
            lCatalogName = MetadataNameConverter.schemaNameToCatalogName((Locale)this.locale, (String)schemaName);
            lSchemaName = MetadataNameConverter.schemaNameToSchemaName((Locale)this.locale, (String)schemaName);
        }
        if (lCatalogName != null && lCatalogName.length() > 0) {
            res.add(new BIRestriction("CATALOG_NAME", lCatalogName));
        }
        if (lSchemaName != null && lSchemaName.length() > 0) {
            res.add(new BIRestriction("SCHEMA_NAME", lSchemaName));
        }
        if (cubeName != null && cubeName.length() > 0) {
            res.add(new BIRestriction("CUBE_NAME", cubeName));
        }
        boolean checkMeasureNam = false;
        if (measureName != null && measureName != "") {
            checkMeasureNam = true;
        }
        List measure_hm = this.connection.discoverSchemaRowsetasList("MDSCHEMA_MEASURES", res);
        int i = 0;
        while (i < measure_hm.size()) {
            HashMap hm = (HashMap)measure_hm.get(i);
            loc.debugT(cat, "measures from XMLA:" + hm.toString());
            MeasureObject measure = this.newMeasureObject(hm);
            if (!checkMeasureNam || measureName.equalsIgnoreCase((String)hm.get("MEASURE_NAME"))) {
                measures.add(measure);
            }
            ++i;
        }
        loc.exiting();
        return measures;
    }

    public void assertLoadAttributes(DimensionObject dimension) throws BIResourceException {
        loc.entering(cat, "assertAttributeLoaded(" + dimension + ")");
        if (this.metaStore.getAttribute(dimension).isEmpty()) {
            ArrayList hierarchies = new ArrayList();
            ArrayList<BIRestriction> res = new ArrayList<BIRestriction>();
            res.add(new BIRestriction("CATALOG_NAME", dimension.getCatalogName()));
            res.add(new BIRestriction("SCHEMA_NAME", dimension.getSchemaName()));
            res.add(new BIRestriction("CUBE_NAME", dimension.getCubeName()));
            res.add(new BIRestriction("DIMENSION_UNIQUE_NAME", dimension.getDimensionUniqueName()));
            List property_hm = this.connection.discoverSchemaRowsetasList("MDSCHEMA_PROPERTIES", res);
            int i = 0;
            while (i < property_hm.size()) {
                HashMap hm = (HashMap)property_hm.get(i);
                loc.debugT(cat, "Propertiesl from XMLA:" + hm.toString());
                this.newAttributeObject(hm, dimension);
                ++i;
            }
            int i2 = 0;
            while (i2 < MANDATORY_PROPERTY.length) {
                AttributeObject attrObj = new AttributeObject(dimension.getCatalogName(), dimension.getSchemaName(), dimension.getCubeName(), dimension.getDimensionUniqueName(), null, null, null, MANDATORY_PROPERTY[i2][0], MANDATORY_PROPERTY[i2][1]);
                attrObj.setCharacterMaximumLength(MANDATORY_PROPERTY[i2][2]);
                attrObj.setCharacterOctetLength(MANDATORY_PROPERTY[i2][3]);
                attrObj.setDataType(MANDATORY_PROPERTY[i2][4]);
                attrObj.setDescription(MANDATORY_PROPERTY[i2][5]);
                attrObj.setNumericPrecision(MANDATORY_PROPERTY[i2][6]);
                attrObj.setNumericScale(MANDATORY_PROPERTY[i2][7]);
                attrObj.setPropertyCaption(MANDATORY_PROPERTY[i2][8]);
                if (!this.metaStore.containsAttribute(attrObj)) {
                    this.metaStore.addAttribute(attrObj, (OlapSchemaObject)dimension);
                }
                ++i2;
            }
        }
        loc.exiting();
    }

    private SchemaObject newSchemaObject(HashMap hm) {
        SchemaObject schema = new SchemaObject((String)hm.get("CATALOG_NAME"), "");
        if (!this.metaStore.containsSchema(schema)) {
            this.metaStore.addSchema(schema);
            return schema;
        }
        return (SchemaObject)this.metaStore.getSchema().get(schema.toString());
    }

    private CubeObject newCubeObject(HashMap hm) {
        CubeObject cube = new CubeObject((String)hm.get("CATALOG_NAME"), (String)hm.get("SCHEMA_NAME"), (String)hm.get("CUBE_NAME"));
        if (!this.metaStore.containsCube(cube)) {
            cube.setCreatedOn((String)hm.get("CREATED_ON"));
            cube.setCubeGuid((String)hm.get("CUBE_GUID"));
            cube.setCubeType((String)hm.get("CUBE_TYPE"));
            cube.setDataUpdatedBy((String)hm.get("DATA_UPDATED_BY"));
            cube.setDescription((String)hm.get("DESCRIPTION"));
            cube.setLastDataUpdate((String)hm.get("LAST_DATA_UPDATE"));
            cube.setLastSchemaUpdate((String)hm.get("LAST_SCHEMA_UPDATE"));
            cube.setSchemaUpdatedBy((String)hm.get("SCHEMA_UPDATED_BY"));
            this.metaStore.addCube(cube);
            return cube;
        }
        return (CubeObject)this.metaStore.getCube().get(cube.toString());
    }

    private DimensionObject newDimensionObject(HashMap hm) {
        DimensionObject dimension = new DimensionObject((String)hm.get("CATALOG_NAME"), (String)hm.get("SCHEMA_NAME"), (String)hm.get("CUBE_NAME"), (String)hm.get("DIMENSION_UNIQUE_NAME"));
        if (!this.metaStore.containsDimension(dimension)) {
            dimension.setDimensionName((String)hm.get("DIMENSION_NAME"));
            dimension.setDefaultHierarchy((String)hm.get("DEFAULT_HIERARCHY"));
            dimension.setDimensionCaption((String)hm.get("DIMENSION_CAPTION"));
            dimension.setDimensionCardinality((String)hm.get("DIMENSION_CARDINALITY"));
            dimension.setDimensionGuid((String)hm.get("DIMENSION_GUID"));
            dimension.setDimensionOrdinal((String)hm.get("DIMENSION_ORDINAL"));
            dimension.setDimensionType((String)hm.get("DIMENSION_TYPE"));
            this.metaStore.addDimension(dimension);
            return dimension;
        }
        return (DimensionObject)this.metaStore.getDimension().get(dimension.toString());
    }

    private LevelBasedHierarchyObject newHierarchyObject(HashMap hm) {
        LevelBasedHierarchyObject hierarchy = new LevelBasedHierarchyObject((String)hm.get("CATALOG_NAME"), (String)hm.get("SCHEMA_NAME"), (String)hm.get("CUBE_NAME"), (String)hm.get("DIMENSION_UNIQUE_NAME"), (String)hm.get("HIERARCHY_UNIQUE_NAME"));
        if (!this.metaStore.containsHierarchy(hierarchy)) {
            hierarchy.setAllMember((String)hm.get("ALL_MEMBER"));
            hierarchy.setDefaultMember((String)hm.get("DEFAULT_MEMBER"));
            hierarchy.setDimensionType((String)hm.get("DIMENSION_TYPE"));
            hierarchy.setHierarchyCaption((String)hm.get("HIERARCHY_CAPTION"));
            hierarchy.setHierarchyCardinality((String)hm.get("HIERARCHY_CARDINALITY"));
            hierarchy.setHierarchyGuid((String)hm.get("HIERARCHY_GUID"));
            hierarchy.setHierarchyName((String)hm.get("HIERARCHY_NAME"));
            this.metaStore.addHierarchy(hierarchy);
            return hierarchy;
        }
        return (LevelBasedHierarchyObject)this.metaStore.getHierarchy().get(hierarchy.toString());
    }

    private LevelObject newLevelObject(HashMap hm) {
        LevelObject level = new LevelObject((String)hm.get("CATALOG_NAME"), (String)hm.get("SCHEMA_NAME"), (String)hm.get("CUBE_NAME"), (String)hm.get("DIMENSION_UNIQUE_NAME"), (String)hm.get("HIERARCHY_UNIQUE_NAME"), (String)hm.get("LEVEL_UNIQUE_NAME"), Integer.parseInt((String)hm.get("LEVEL_NUMBER")));
        if (!this.metaStore.containsLevel(level)) {
            level.setLevelCadinality((String)hm.get("LEVEL_CARDINALITY"));
            level.setLevelCaption((String)hm.get("LEVEL_CAPTION"));
            level.setLevelGuid((String)hm.get("LEVEL_GUID"));
            level.setLevelName((String)hm.get("LEVEL_NAME"));
            level.setLevelNumber(Integer.parseInt((String)hm.get("LEVEL_NUMBER")));
            level.setLevelType((String)hm.get("LEVEL_TYPE"));
            this.metaStore.addLevel(level);
            return level;
        }
        return (LevelObject)this.metaStore.getLevel().get(level.toString());
    }

    private MeasureObject newMeasureObject(HashMap hm) {
        MeasureObject measure = new MeasureObject((String)hm.get("CATALOG_NAME"), (String)hm.get("SCHEMA_NAME"), (String)hm.get("CUBE_NAME"), (String)hm.get("MEASURE_UNIQUE_NAME"));
        if (!this.metaStore.containsMeasure(measure)) {
            measure.setMeasureName((String)hm.get("MEASURE_NAME"));
            measure.setMeasureCaption((String)hm.get("MEASURE_CAPTION"));
            measure.setMeasureGuid((String)hm.get("MEASURE_GUID"));
            measure.setMeasureAggregator((String)hm.get("MEASURE_AGGREGATOR"));
            measure.setDataType((String)hm.get("DATA_TYPE"));
            measure.setNumericPrecision((String)hm.get("NUMERIC_PRECISION"));
            measure.setNumericScale((String)hm.get("NUMERIC_SCALE"));
            measure.setMeasureUnits((String)hm.get("MEASURE_UNITS"));
            measure.setDescription((String)hm.get("DESCRIPTION"));
            this.metaStore.addMeasure(measure);
            return measure;
        }
        return (MeasureObject)this.metaStore.getMeasure().get(measure.toString());
    }

    private AttributeObject newAttributeObject(HashMap hm, DimensionObject dimension) {
        AttributeObject attribute = new AttributeObject((String)hm.get("CATALOG_NAME"), (String)hm.get("SCHEMA_NAME"), (String)hm.get("CUBE_NAME"), (String)hm.get("DIMENSION_UNIQUE_NAME"), (String)hm.get("HIERARCHY_UNIQUE_NAME"), (String)hm.get("LEVEL_UNIQUE_NAME"), (String)hm.get("MEMBER_UNIQUE_NAME"), (String)hm.get("PROPERTY_NAME"), (String)hm.get("PROPERTY_TYPE"));
        if (!this.metaStore.containsAttribute(attribute)) {
            attribute.setCharacterMaximumLength((String)hm.get("CHARACTER_MAXIMUM_LENGTH"));
            attribute.setCharacterOctetLength((String)hm.get("CHARACTER_OCTET_LENGTH"));
            attribute.setDataType((String)hm.get("DATA_TYPE"));
            attribute.setDescription((String)hm.get("DESCRIPTION"));
            attribute.setPropertyCaption((String)hm.get("PROPERTY_CAPTION"));
            this.metaStore.addAttribute(attribute, (OlapSchemaObject)dimension);
            return attribute;
        }
        return (AttributeObject)this.metaStore.getAttribute().get(attribute.toString());
    }

    public void assertLoadSAPVariables(CubeObject cube) throws BIResourceException {
        loc.entering(cat, "assertLoadSAPVariables(" + cube + ")");
        if (!this.metaStore.getSAPVariable(cube).isEmpty()) {
            return;
        }
        this.assertFindSAPVariable(MetadataNameConverter.schemaNameFromSchemaAndCatalogName((String)cube.getCatalogName(), (String)cube.getSchemaName()), cube.getCubeName(), null);
        loc.exiting();
    }

    private BISAPVariableObject newSAPVariableObject(HashMap hm) {
        BISAPVariableObject variableObj = new BISAPVariableObject((String)hm.get("CATALOG_NAME"), (String)hm.get("SCHEMA_NAME"), (String)hm.get("CUBE_NAME"), (String)hm.get("VARIABLE_NAME"));
        if (!this.metaStore.containsSAPVariable(variableObj)) {
            variableObj.setVariableGUID((String)hm.get("VARIABLE_UID"));
            variableObj.setVariableCaption((String)hm.get("VARIABLE_CAPTION"));
            variableObj.setVariableOrdinal(Integer.parseInt((String)hm.get("VARIABLE_ORDINAL")));
            variableObj.setVariableType(Short.parseShort((String)hm.get("VARIABLE_TYPE")));
            variableObj.setDataType((String)hm.get("DATA_TYPE"));
            variableObj.setCharacterMaximumLength(Long.parseLong((String)hm.get("MAX_LENGTH")));
            variableObj.setVariableProcessingType(Integer.parseInt("1"));
            variableObj.setVariableSelectionType(Integer.parseInt((String)hm.get("VARIABLE_SELECTION_TYPE")));
            variableObj.setVariableEntryType(Integer.parseInt((String)hm.get("VARIABLE_ENTRY_TYPE")));
            variableObj.setReferenceDimension((String)hm.get("REFERENCE_DIMENSION"));
            variableObj.setReferenceHierarchy((String)hm.get("REFERENCE_HIERARCHY"));
            variableObj.setDefaultLow(new BIVariant((String)hm.get("DEFAULT_LOW")));
            variableObj.setDefaultHigh(new BIVariant((String)hm.get("DEFAULT_HIGH")));
            variableObj.setDefaultLowCap((String)hm.get("DEFAULT_LOW_CAPTION"));
            variableObj.setDefaultHighCap((String)hm.get("DEFAULT_HIGH_CAPTION"));
            variableObj.setDescription((String)hm.get("DESCRIPTION"));
            this.metaStore.addSAPVariable(variableObj);
            return variableObj;
        }
        return (BISAPVariableObject)this.metaStore.getSAPVariable().get(variableObj.toString());
    }

    public List assertFindSAPVariable(String schemaName, String cubeName, String variableName) throws BIResourceException {
        loc.entering(cat, "assertFindSAPVariables(" + schemaName + ", " + cubeName + ")");
        boolean checkVariableNam = false;
        if (variableName != null && variableName.length() != 0) {
            checkVariableNam = true;
        }
        ArrayList<BISAPVariableObject> variables = new ArrayList<BISAPVariableObject>();
        ArrayList<BIRestriction> res = new ArrayList<BIRestriction>();
        String lCatalogName = MetadataNameConverter.schemaNameToCatalogName((Locale)this.locale, (String)schemaName);
        String lSchemaName = MetadataNameConverter.schemaNameToSchemaName((Locale)this.locale, (String)schemaName);
        if (lCatalogName != null) {
            res.add(new BIRestriction("CATALOG_NAME", lCatalogName));
        }
        if (lSchemaName != null) {
            res.add(new BIRestriction("SCHEMA_NAME", lSchemaName));
        }
        res.add(new BIRestriction("CUBE_NAME", cubeName));
        List variable_hm = this.connection.discoverSchemaRowsetasList("SAP_VARIABLES", res);
        int i = 0;
        while (i < variable_hm.size()) {
            HashMap hm = (HashMap)variable_hm.get(i);
            loc.debugT(cat, "variables from XMLA:" + hm.toString());
            if (!checkVariableNam || variableName.equalsIgnoreCase((String)hm.get("VARIABLE_NAME"))) {
                BISAPVariableObject variable = this.newSAPVariableObject(hm);
                variables.add(variable);
            }
            ++i;
        }
        loc.exiting();
        return variables;
    }

    protected LevelBasedHierarchy findHierarchyFirst(String catalogName, String schemaName, String cubeName, String dimensionUName, String hierarchyUName) throws BIResourceException {
        return this.connection.getObjectFinder().findHierarchyFirst(MetadataNameConverter.schemaNameFromSchemaAndCatalogName((String)catalogName, (String)schemaName), cubeName, MetadataNameConverter.dimensionUniqueNametoDimensionName((String)dimensionUName), MetadataNameConverter.hierarchyUniqueNametoHierarchyName((String)hierarchyUName));
    }

    protected IBIMember findMember(String catalogName, String schemaName, String cubeName, String dimensionUName, String hierarchyUName, String memberCaption, BIVariant defaultValue) throws BIResourceException {
        return this.connection.getObjectFinder().findMemberFirst(MetadataNameConverter.schemaNameFromSchemaAndCatalogName((String)catalogName, (String)schemaName), cubeName, MetadataNameConverter.dimensionUniqueNametoDimensionName((String)dimensionUName), MetadataNameConverter.hierarchyUniqueNametoHierarchyName((String)hierarchyUName), null, null, null);
    }

    protected Dimension findDimensionFirst(String catalogName, String schemaName, String cubeName, String dimensionUName) throws BIResourceException {
        return this.connection.getObjectFinder().findDimensionFirst(MetadataNameConverter.schemaNameFromSchemaAndCatalogName((String)catalogName, (String)schemaName), cubeName, MetadataNameConverter.dimensionUniqueNametoDimensionName((String)dimensionUName));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

