/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.xmla.impl;

import com.sap.ip.bi.sdk.dac.connector.IBIConnection;
import com.sap.ip.bi.sdk.dac.connector.IBIOlap;
import com.sap.ip.bi.sdk.dac.connector.IBIOlapObjectFinder;
import com.sap.ip.bi.sdk.dac.connector.impl.BIConnectionConstants;
import com.sap.ip.bi.sdk.dac.connector.impl.BIRestriction;
import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionDetails;
import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.connector.impl.IBINativeXmla;
import com.sap.ip.bi.sdk.dac.connector.olap.BIOlapDataSourceType;
import com.sap.ip.bi.sdk.dac.connector.olap.BITreeOperator;
import com.sap.ip.bi.sdk.dac.connector.olap.CommonConnection;
import com.sap.ip.bi.sdk.dac.connector.olap.CommonRelationalConnection;
import com.sap.ip.bi.sdk.dac.connector.olap.MetadataNameConverter;
import com.sap.ip.bi.sdk.dac.connector.olap.odbo.BIOdboMetadataConstants;
import com.sap.ip.bi.sdk.dac.connector.xmla.XmlaConnectionConstants;
import com.sap.ip.bi.sdk.dac.connector.xmla.impl.IBIXmlaProxy;
import com.sap.ip.bi.sdk.dac.connector.xmla.impl.ServerProxy;
import com.sap.ip.bi.sdk.dac.connector.xmla.impl.StandaloneProxy;
import com.sap.ip.bi.sdk.dac.connector.xmla.impl.XmlaMDRConnection;
import com.sap.ip.bi.sdk.dac.connector.xmla.impl.XmlaMDRConnectionRelational;
import com.sap.ip.bi.sdk.dac.olap.query.IBIMemberFactory;
import com.sap.ip.bi.sdk.dac.olap.query.IBIQueryFactory;
import com.sap.ip.bi.sdk.dac.olap.query.member.IBIMember;
import com.sap.ip.bi.sdk.dac.relational.query.IBIQueryExecute;
import com.sap.ip.bi.sdk.dac.result.IBIDataSet;
import com.sap.ip.bi.sdk.dac.result.IBIResultSet;
import com.sap.ip.bi.sdk.dac.result.impl.BIColumnMetaData;
import com.sap.ip.bi.sdk.dac.result.impl.BIDataSet;
import com.sap.ip.bi.sdk.dac.result.impl.BIResultSet;
import com.sap.ip.bi.sdk.dac.result.impl.BIResultSetData;
import com.sap.ip.bi.sdk.dac.result.impl.IBIColumnMetaData;
import com.sap.ip.bi.sdk.dac.result.impl.IBIResultSetData;
import com.sap.ip.bi.sdk.exception.BIOlapQueryException;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import com.sap.ip.bi.sdk.exception.BIRuntimeException;
import com.sap.ip.bi.sdk.util.BILoggingSetup;
import com.sap.ip.bi.sdk.util.impl.BILogonLanguage;
import com.sap.ip.bi.sdk.util.impl.BIMonitor;
import com.sap.ip.bi.sdk.util.impl.IBIMonitor;
import com.sap.ip.bi.sdk.util.impl.ServerRTCounter;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.resource.ResourceException;
import javax.resource.cci.LocalTransaction;
import javax.xml.rpc.soap.SOAPFaultException;
import org.omg.cwm.analysis.olap.Cube;
import org.omg.cwm.analysis.olap.Dimension;
import org.omg.cwm.analysis.olap.Hierarchy;
import org.omg.cwm.analysis.olap.Level;
import org.omg.cwm.objectmodel.core.CorePackage;
import org.omg.cwm.objectmodel.core.ModelElement;

public class Connection
extends CommonRelationalConnection
implements IBINativeXmla,
IBIQueryExecute,
IBIConnectionDetails {
    private static Attributes attributes = null;
    private Properties properties;
    private String providerName;
    private static final Location loc = Location.getLocation((String)(class$com$sap$ip$bi$sdk$dac$connector$xmla$impl$Connection == null ? (class$com$sap$ip$bi$sdk$dac$connector$xmla$impl$Connection = Connection.class$("com.sap.ip.bi.sdk.dac.connector.xmla.impl.Connection")) : class$com$sap$ip$bi$sdk$dac$connector$xmla$impl$Connection).getName());
    private static final Category cat = BILoggingSetup.CONNECTION.getCategory();
    private IBIMonitor monitor;
    private CorePackage corePackage = null;
    private LocalTransaction trans = null;
    private Locale locale = Locale.getDefault();
    private IBIConnection connection;
    private ServerRTCounter counter;
    private IBIQueryFactory queryFactory = null;
    private IBIOlap olap = null;
    private ProxyWrapper proxyWrapper = null;
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$connector$xmla$impl$Connection;

    private Connection() {
    }

    private Connection(Properties prop) throws BIResourceException {
        if (prop != null) {
            loc.entering("Constructor(" + ((Hashtable)prop).toString() + ")");
        } else {
            loc.entering("Constructor(null)");
        }
        this.properties = new Properties();
        Enumeration<?> e = prop.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            ((Hashtable)this.properties).put(key, prop.getProperty(key));
        }
        String language = this.getProperty(BIConnectionConstants.LANGUAGE.toString());
        this.locale = BILogonLanguage.getLocale((String)language);
        this.counter = ServerRTCounter.getInstance();
        this.monitor = BIMonitor.createMonitor();
        ((CommonConnection)this).connectionInfo = new ConnectionInfo();
        this.proxyWrapper = new ProxyWrapper(this.properties);
        loc.exiting();
    }

    public static Connection connect(Properties props) throws ResourceException {
        Connection c = new Connection(props);
        return c;
    }

    public IBIConnectionInfo getConnectionInfo() throws BIResourceException {
        if (((CommonConnection)this).connectionInfo == null) {
            throw new BIResourceException(Locale.getDefault(), "sdk.dac.connector_1101");
        }
        return ((CommonConnection)this).connectionInfo;
    }

    public void connectMdr() throws BIResourceException {
        loc.entering("connectMdr");
        try {
            try {
                BIOlapDataSourceType providerType = this.getDataSourceType();
                ((CommonConnection)this).mdr = new XmlaMDRConnection(this, providerType);
                this.trans = ((CommonConnection)this).mdr.getLocalTransaction();
                this.trans.begin();
            }
            catch (ResourceException ex) {
                throw new BIResourceException(this.locale, cat, 500, loc, "sdk.dac.connector.mmr_1000", null, (Throwable)ex);
            }
            Object var3_3 = null;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            loc.exiting();
            throw throwable;
        }
        loc.exiting();
    }

    public BIOlapDataSourceType getDataSourceType() {
        String provider = this.getProviderName().toLowerCase();
        if (provider.indexOf("sap business information warehouse") >= 0) {
            return BIOlapDataSourceType.SAP_BW;
        }
        if (provider.indexOf("microsoft xml for analysis provider") >= 0) {
            return BIOlapDataSourceType.MS_OLAP;
        }
        return BIOlapDataSourceType.OTHER;
    }

    public void close() throws BIResourceException {
        loc.entering("close");
        this.proxyWrapper.closeSession();
        try {
            block5: {
                try {
                    if (((CommonConnection)this).mdr == null) break block5;
                    if (this.trans != null) {
                        this.trans.rollback();
                    }
                    ((CommonConnection)this).mdr.close();
                    ((CommonConnection)this).mdr = null;
                }
                catch (Exception ex) {
                    loc.errorT(cat, "can not close mdr connection:", ex.getMessage());
                    throw new BIRuntimeException(this.locale, "sdk.dac.connector_2003", (Throwable)ex);
                }
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            loc.exiting();
            throw throwable;
        }
        loc.exiting();
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public boolean isAlive() throws BIResourceException {
        loc.entering("isAlive()");
        try {
            List rowset = this.proxyWrapper.isAlive();
            this.providerName = this.getProviderName(rowset);
        }
        catch (Exception e) {
            throw new BIResourceException(this.locale, cat, 500, loc, "sdk.dac.connector.xmla_1010", null, (Throwable)e);
        }
        loc.exiting();
        return true;
    }

    private String getProviderName(List rowset) {
        String providerName = null;
        int i = 0;
        while (i < rowset.size()) {
            HashMap hm = (HashMap)rowset.get(i);
            if (hm.get("PropertyName").equals("ProviderName")) {
                providerName = (String)hm.get("Value");
                break;
            }
            ++i;
        }
        return providerName;
    }

    public Attributes getAttributes() {
        if (attributes == null) {
            attributes = new Attributes();
        }
        return attributes;
    }

    public List discoverSchemaRowsetasList(String requestType, List restrictions) throws BIResourceException {
        loc.entering("discoverSchemaRowsetasList(" + requestType + "," + restrictions + ")");
        List list_hm = null;
        this.monitor.startRequest(IBIMonitor.Request.CONNECTION);
        list_hm = this.proxyWrapper.discover(requestType, restrictions);
        this.monitor.endRequest(IBIMonitor.Request.CONNECTION);
        loc.exiting();
        return list_hm;
    }

    public List discoverSchemaRowsetasList(String requestType) throws BIResourceException {
        return this.discoverSchemaRowsetasList(requestType, null);
    }

    public IBIDataSet getDataSet(String mdx) throws BIResourceException {
        loc.entering("getDataset(" + mdx + ")");
        BIDataSet dataset = null;
        this.monitor.startRequest(IBIMonitor.Request.CONNECTION);
        dataset = this.proxyWrapper.execute(mdx);
        this.monitor.endRequest(IBIMonitor.Request.CONNECTION);
        loc.exiting();
        return dataset;
    }

    Locale getLocale() {
        return this.locale;
    }

    private Collection getTaggedValue(ModelElement element) throws BIResourceException {
        if (this.corePackage == null) {
            this.corePackage = (CorePackage)this.getTopLevelPackage().refPackage("org.omg.cwm.objectmodel.Core");
        }
        return this.corePackage.getTaggedElement().getTaggedValue(element);
    }

    public IBIOlapObjectFinder getObjectFinder() throws BIResourceException {
        if (((CommonConnection)this).objectFinder == null) {
            if (this.queryFactory == null) {
                this.queryFactory = this.olap.getQueryFactory();
            }
            ((CommonConnection)this).objectFinder = new ObjectFinder(this.queryFactory);
        }
        return ((CommonConnection)this).objectFinder;
    }

    protected void connectMDRRelational() throws BIResourceException {
        try {
            this.mdrRelational = new XmlaMDRConnectionRelational((CommonConnection)this, ((CommonConnection)this).connectionInfo);
            this.outerMostRelational = this.mdrRelational.connect();
        }
        catch (ResourceException ex) {
            throw new BIResourceException(this.locale, "sdk.dac.connector.mmr_1000", (Throwable)ex);
        }
    }

    public void setOlap(IBIOlap olap) {
        this.olap = olap;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ProxyWrapper {
        private IBIXmlaProxy wsProxy;
        private String logonMethod;
        private String user;
        private String password;
        private String url;
        private String dataSource;
        private String statefulness;
        private String language;
        private String timeout;
        private String sessionId;
        private Locale locale;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public ProxyWrapper(Properties properties) throws BIResourceException {
            boolean standalone;
            Object proxy;
            block18: {
                block19: {
                    this.timeout = null;
                    this.sessionId = null;
                    this.locale = Locale.getDefault();
                    proxy = null;
                    standalone = true;
                    try {
                        try {
                            InitialContext ctx = new InitialContext();
                            proxy = ctx.lookup("/wsclients/proxies/sap.com/com.sap.ip.bi.sdk.dac.connector.xmla.proxy.ws/com.sap.ip.bi.sdk.dac.connector.xmla.wsclient.XmlaWSClient");
                        }
                        catch (Throwable e) {
                            proxy = null;
                            Object var7_10 = null;
                            if (proxy != null) {
                                standalone = false;
                                loc.debugT(cat, "XMLA Connector is in server mode");
                                break block18;
                            }
                            standalone = true;
                            loc.debugT(cat, "XMLA Connector is in standalone mode");
                            try {
                                Class.forName("com.sap.ip.bi.sdk.dac.connector.xmla.standalone.MsXmlAnalysis");
                            }
                            catch (ClassNotFoundException e2) {
                                throw new BIRuntimeException(this.locale, cat, 500, loc, "sdk.dac.connector.xmla_1015", null, (Throwable)e2);
                            }
                        }
                        Object var7_9 = null;
                        if (proxy == null) break block19;
                        standalone = false;
                    }
                    catch (Throwable throwable) {
                        Object var7_11 = null;
                        if (proxy != null) {
                            standalone = false;
                            loc.debugT(cat, "XMLA Connector is in server mode");
                            throw throwable;
                        }
                        standalone = true;
                        loc.debugT(cat, "XMLA Connector is in standalone mode");
                        try {}
                        catch (ClassNotFoundException e2) {
                            throw new BIRuntimeException(this.locale, cat, 500, loc, "sdk.dac.connector.xmla_1015", null, (Throwable)e2);
                        }
                        Class.forName("com.sap.ip.bi.sdk.dac.connector.xmla.standalone.MsXmlAnalysis");
                        throw throwable;
                    }
                    loc.debugT(cat, "XMLA Connector is in server mode");
                    break block18;
                }
                standalone = true;
                loc.debugT(cat, "XMLA Connector is in standalone mode");
                try {}
                catch (ClassNotFoundException e2) {
                    throw new BIRuntimeException(this.locale, cat, 500, loc, "sdk.dac.connector.xmla_1015", null, (Throwable)e2);
                }
                Class.forName("com.sap.ip.bi.sdk.dac.connector.xmla.standalone.MsXmlAnalysis");
            }
            this.user = properties.getProperty(BIConnectionConstants.USERNAME.toString());
            this.password = properties.getProperty(BIConnectionConstants.PASSWORD.toString());
            this.logonMethod = properties.getProperty(XmlaConnectionConstants.LOGONMETHOD.toString());
            this.url = properties.getProperty(XmlaConnectionConstants.URL.toString());
            this.dataSource = properties.getProperty(XmlaConnectionConstants.DATA_SOURCE.toString());
            this.statefulness = properties.getProperty(XmlaConnectionConstants.STATEFULNESS.toString());
            this.language = properties.getProperty(BIConnectionConstants.LANGUAGE.toString());
            try {
                this.timeout = properties.getProperty(XmlaConnectionConstants.TIMEOUT.toString());
                if (this.timeout != null) {
                    Integer.parseInt(this.timeout);
                }
            }
            catch (NumberFormatException e) {
                this.timeout = null;
                loc.debugT(cat, "NumberFormatException: timeout");
            }
            this.locale = BILogonLanguage.getLocale((String)this.language);
            loc.debugT(cat, " user:" + this.user + " passwd:" + "*****" + " language:" + this.language + " url:" + this.url + " dataSource:" + this.dataSource + " logonmethod:" + this.logonMethod + " timeout:" + this.timeout);
            if (this.url == null) {
                throw new BIRuntimeException(this.locale, cat, 500, loc, "sdk_4000", new Object[]{"Connection Property: url"}, null);
            }
            if (this.url.endsWith("/sap/bw/xml/soap/xmla") && this.language != null && this.language.length() != 0) {
                this.url = this.url + "?sap-language=" + this.language;
                loc.debugT(cat, "BW URL with language: " + this.url + ";");
            }
            try {
                if (standalone) {
                    this.wsProxy = new StandaloneProxy(((CommonConnection)Connection.this).connectionInfo, this.user, this.password, this.url);
                    return;
                }
                this.wsProxy = new ServerProxy(((CommonConnection)Connection.this).connectionInfo, proxy, this.user, this.password, this.url, this.logonMethod, this.timeout);
                return;
            }
            catch (Exception e) {
                throw new BIResourceException(this.locale, cat, 500, loc, "sdk.dac.connector.xmla_1008", null, (Throwable)e);
            }
        }

        public List isAlive() throws RemoteException {
            return this.wsProxy.isAlive();
        }

        public List discover(String requestType, List restrictions) throws BIResourceException {
            try {
                this.setStatefulness();
                List ret = this.wsProxy.discover(requestType, restrictions, this.dataSource);
                this.getSessionId();
                return ret;
            }
            catch (SOAPFaultException ex) {
                throw new BIResourceException(this.locale, cat, 600, loc, "sdk.dac.connector.xmla_1002", new Object[]{ex.getFaultCode().getLocalPart(), ex.getFaultString()}, (Throwable)ex);
            }
            catch (Exception e) {
                throw new BIResourceException(this.locale, cat, 600, loc, "sdk.dac.connector.xmla_1001", new Object[]{requestType}, (Throwable)e);
            }
        }

        public BIDataSet execute(String mdx) throws BIResourceException {
            try {
                this.setStatefulness();
                BIDataSet dataset = this.wsProxy.execute(mdx, this.dataSource);
                this.getSessionId();
                return dataset;
            }
            catch (SOAPFaultException ex) {
                cat.errorT(loc, ex.getLocalizedMessage());
                throw new BIResourceException(((CommonConnection)Connection.this).connectionInfo.getLocale(), cat, 600, loc, "sdk.dac.connector.xmla_1002", new Object[]{ex.getFaultCode().getLocalPart(), ex.getFaultString()}, (Throwable)ex);
            }
            catch (Exception e) {
                cat.errorT(loc, e.getLocalizedMessage());
                throw new BIResourceException(this.locale, cat, 500, loc, "sdk.dac.connector.xmla_1003", new Object[]{mdx}, (Throwable)e);
            }
        }

        public void closeSession() throws BIResourceException {
            loc.entering("closeSession()");
            if (this.statefulness != null && this.statefulness.equalsIgnoreCase("true") && this.sessionId != null) {
                try {
                    this.wsProxy.closeSession(this.sessionId);
                    List ret = this.wsProxy.discover("DISCOVER_PROPERTIES", null, this.dataSource);
                    this.sessionId = null;
                }
                catch (SOAPFaultException ex) {
                    throw new BIResourceException(this.locale, cat, 600, loc, "sdk.dac.connector.xmla_1002", new Object[]{ex.getFaultCode().getLocalPart(), ex.getFaultString()}, (Throwable)ex);
                }
                catch (Exception e) {
                    throw new BIResourceException(this.locale, cat, 600, loc, "sdk.dac.connector.xmla_1001", new Object[]{"DISCOVER_PROPERTIES"}, (Throwable)e);
                }
            }
            loc.exiting();
        }

        private void setStatefulness() throws Exception {
            if (this.statefulness != null && this.statefulness.equalsIgnoreCase("true")) {
                if (this.sessionId == null) {
                    this.wsProxy.beginSession();
                } else {
                    this.wsProxy.processSession(this.sessionId);
                }
            }
        }

        private void getSessionId() throws Exception {
            if (this.statefulness != null && this.statefulness.equalsIgnoreCase("true") && this.sessionId == null) {
                this.sessionId = this.wsProxy.getSessionId();
            }
        }
    }

    public class Attributes {
        private String EISProductName = "";
        private String EISProductVersion = "";
        private String userName = "";

        protected Attributes() {
        }

        public String getEISProductName() {
            return this.EISProductName;
        }

        public String getEISProductVersion() {
            return this.EISProductVersion;
        }

        public String getUserName() {
            return this.userName;
        }
    }

    private class ObjectFinder
    extends CommonConnection.AbstractObjectFinder {
        IBIQueryFactory queryFactory = null;

        private ObjectFinder(IBIQueryFactory queryFac) {
            super((CommonConnection)Connection.this);
            this.queryFactory = queryFac;
        }

        public List findMember(String schemaName, String cubeName, String dimensionName, String hierarchyName, String levelName, String memberName, BITreeOperator treeOperator) throws BIResourceException {
            return this.findMember(schemaName, cubeName, dimensionName, hierarchyName, levelName, memberName, treeOperator, false);
        }

        private List findMember(String schemaName, String cubeName, String dimensionName, String hierarchyName, String levelName, String memberName, BITreeOperator treeOperator, boolean findFirst) throws BIResourceException {
            loc.entering("findMember(" + schemaName + "," + cubeName + "," + dimensionName + "," + hierarchyName + "," + levelName + "," + "memberName:" + memberName);
            Connection.super.assertConnectedToMDR();
            if (dimensionName == null || dimensionName.length() == 0) {
                throw new BIResourceException(Connection.this.locale, cat, 500, loc, "sdk.dac.connector.xmla_1011", null);
            }
            ArrayList<BIRestriction> res = new ArrayList<BIRestriction>();
            String lCatalogName = MetadataNameConverter.schemaNameToCatalogName((Locale)Connection.this.locale, (String)schemaName);
            String lSchemaName = MetadataNameConverter.schemaNameToSchemaName((Locale)Connection.this.locale, (String)schemaName);
            String dimensionUName = MetadataNameConverter.dimensionNameToDimensionUniqueName((String)dimensionName);
            String levelUName = null;
            if (levelName != null) {
                levelUName = MetadataNameConverter.dimensionLevelNametoLevelUniqueName((String)dimensionName, (String)levelName);
            }
            if (lCatalogName != null) {
                res.add(new BIRestriction("CATALOG_NAME", lCatalogName));
            }
            if (lSchemaName != null) {
                res.add(new BIRestriction("SCHEMA_NAME", lSchemaName));
            }
            if (cubeName != null) {
                res.add(new BIRestriction("CUBE_NAME", cubeName));
            }
            res.add(new BIRestriction("DIMENSION_UNIQUE_NAME", dimensionUName));
            boolean checkHryNam = false;
            if (hierarchyName != null && hierarchyName != "") {
                checkHryNam = true;
            }
            String hierarchyUName = null;
            if (checkHryNam) {
                List hie_hm = Connection.this.discoverSchemaRowsetasList("MDSCHEMA_HIERARCHIES", res);
                int i = 0;
                while (i < hie_hm.size()) {
                    HashMap hm = (HashMap)hie_hm.get(i);
                    loc.debugT(cat, "Hierarchy from XMLA:" + hm.toString());
                    String hname = (String)hm.get("HIERARCHY_NAME");
                    if (hname == null) {
                        hname = (String)hm.get("HIERARCHY_CAPTION");
                    }
                    if (hierarchyName.equalsIgnoreCase(hname)) {
                        hierarchyUName = (String)hm.get("HIERARCHY_UNIQUE_NAME");
                        break;
                    }
                    ++i;
                }
            }
            String operator = null;
            if (treeOperator != null) {
                operator = treeOperator.toString();
            }
            if (hierarchyUName != null) {
                res.add(new BIRestriction("HIERARCHY_UNIQUE_NAME", hierarchyUName));
            }
            if (levelUName != null) {
                res.add(new BIRestriction("LEVEL_UNIQUE_NAME", levelUName));
            }
            Object memberUName = null;
            if (memberName != null) {
                res.add(new BIRestriction("MEMBER_NAME", memberName));
            }
            if (treeOperator != null) {
                res.add(new BIRestriction("TREE_OP", operator));
            }
            List member_hm = Connection.this.discoverSchemaRowsetasList("MDSCHEMA_MEMBERS", res);
            ArrayList<IBIMember> members = new ArrayList<IBIMember>();
            List dimensions = this.findDimension(schemaName, cubeName, dimensionName);
            Dimension dim = (Dimension)dimensions.get(0);
            int k = 0;
            while (k < member_hm.size()) {
                HashMap properties = (HashMap)member_hm.get(k);
                loc.debugT(cat, "Members from XMLA:" + properties.toString());
                String memName = (String)properties.get("MEMBER_NAME");
                IBIMember member = null;
                member = this.createMember(dim, memName, properties);
                members.add(member);
                if (findFirst) break;
                ++k;
            }
            loc.exiting();
            return members;
        }

        public List findMember(Level level, String memberName, BITreeOperator treeOperator) throws BIResourceException {
            return this.findMember(level, memberName, treeOperator, false);
        }

        private List findMember(Level level, String memberName, BITreeOperator treeOperator, boolean findFirst) throws BIResourceException {
            loc.entering("findMember(" + level + "," + "memberName:" + memberName);
            Connection.super.assertConnectedToMDR();
            Collection tvs = ((CommonConnection)Connection.this).mdr.getTaggedValue((ModelElement)level);
            String operator = null;
            if (treeOperator != null) {
                operator = treeOperator.toString();
            }
            ArrayList<BIRestriction> res = new ArrayList<BIRestriction>();
            res.add(new BIRestriction("CATALOG_NAME", Connection.super.getSchemaAttribute("CATALOG_NAME", tvs)));
            res.add(new BIRestriction("SCHEMA_NAME", Connection.super.getSchemaAttribute("SCHEMA_NAME", tvs)));
            res.add(new BIRestriction("CUBE_NAME", Connection.super.getSchemaAttribute("CUBE_NAME", tvs)));
            res.add(new BIRestriction("DIMENSION_UNIQUE_NAME", Connection.super.getSchemaAttribute("DIMENSION_UNIQUE_NAME", tvs)));
            res.add(new BIRestriction("HIERARCHY_UNIQUE_NAME", Connection.super.getSchemaAttribute("HIERARCHY_UNIQUE_NAME", tvs)));
            res.add(new BIRestriction("LEVEL_UNIQUE_NAME", Connection.super.getSchemaAttribute("LEVEL_UNIQUE_NAME", tvs)));
            Object memberUName = null;
            if (memberName != null) {
                res.add(new BIRestriction("MEMBER_NAME", memberName));
            }
            if (treeOperator != null) {
                res.add(new BIRestriction("TREE_OP", operator));
            }
            List member_hm = Connection.this.discoverSchemaRowsetasList("MDSCHEMA_MEMBERS", res);
            ArrayList<IBIMember> members = new ArrayList<IBIMember>();
            Dimension dimension = level.getDimension();
            IBIMember member = null;
            int k = 0;
            while (k < member_hm.size()) {
                HashMap properties = (HashMap)member_hm.get(k);
                loc.debugT(cat, "Members from XMLA:" + properties.toString());
                member = this.createMember(dimension, memberName, properties);
                members.add(member);
                if (findFirst) break;
                ++k;
            }
            loc.exiting();
            return members;
        }

        private IBIMember createMember(Dimension dimension, String memberName, Map properties) throws BIResourceException {
            IBIMemberFactory memberFactory = this.queryFactory.getMemberFactory();
            IBIMember member = null;
            try {
                member = memberFactory.createMember(dimension, memberName, null, properties);
            }
            catch (BIOlapQueryException e) {
                throw new BIResourceException(Connection.this.locale, cat, 500, loc, "sdk.dac.connector.olap_1005", (Throwable)e);
            }
            return member;
        }

        public IBIResultSet findMemberData(List restrictions, List selectedAttributes) throws BIResourceException {
            int i;
            loc.entering("getMemberData(" + restrictions + selectedAttributes + ")");
            Cube cube = null;
            Dimension dimension = null;
            Hierarchy hierarchy = null;
            Level level = null;
            String catName = null;
            String schName = null;
            String cubeName = null;
            String dimensionUName = null;
            String hierarchyUName = null;
            String levelUName = null;
            String levelNumber = null;
            String memberName = null;
            String memberUName = null;
            String memberCaption = null;
            String memberType = null;
            String treeOperator = null;
            Object item = null;
            BIResultSet resultSet = null;
            Object cP = null;
            Collection tags = null;
            ArrayList<BIRestriction> res = new ArrayList<BIRestriction>();
            if (restrictions != null) {
                Iterator i2 = restrictions.iterator();
                while (i2.hasNext()) {
                    item = i2.next();
                    loc.debugT(cat, "restrictions:" + item);
                    if (item instanceof Cube) {
                        cube = item;
                        tags = Connection.this.getTaggedValue((ModelElement)cube);
                        if (catName == null) {
                            catName = Connection.super.getSchemaAttribute("CATALOG_NAME", tags);
                        }
                        if (schName == null) {
                            schName = Connection.super.getSchemaAttribute("SCHEMA_NAME", tags);
                        }
                        if (cubeName != null) continue;
                        cubeName = Connection.super.getSchemaAttribute("CUBE_NAME", tags);
                        continue;
                    }
                    if (item instanceof Dimension) {
                        dimension = item;
                        tags = Connection.this.getTaggedValue((ModelElement)dimension);
                        if (catName == null) {
                            catName = Connection.super.getSchemaAttribute("CATALOG_NAME", tags);
                        }
                        if (schName == null) {
                            schName = Connection.super.getSchemaAttribute("SCHEMA_NAME", tags);
                        }
                        if (cubeName == null) {
                            cubeName = Connection.super.getSchemaAttribute("CUBE_NAME", tags);
                        }
                        if (dimensionUName != null) continue;
                        dimensionUName = Connection.super.getSchemaAttribute("DIMENSION_UNIQUE_NAME", tags);
                        continue;
                    }
                    if (item instanceof Hierarchy) {
                        hierarchy = item;
                        tags = Connection.this.getTaggedValue((ModelElement)hierarchy);
                        if (catName == null) {
                            catName = Connection.super.getSchemaAttribute("CATALOG_NAME", tags);
                        }
                        if (schName == null) {
                            schName = Connection.super.getSchemaAttribute("SCHEMA_NAME", tags);
                        }
                        if (cubeName == null) {
                            cubeName = Connection.super.getSchemaAttribute("CUBE_NAME", tags);
                        }
                        if (dimensionUName == null) {
                            dimensionUName = Connection.super.getSchemaAttribute("DIMENSION_UNIQUE_NAME", tags);
                        }
                        if (hierarchyUName != null) continue;
                        hierarchyUName = Connection.super.getSchemaAttribute("HIERARCHY_UNIQUE_NAME", tags);
                        continue;
                    }
                    if (item instanceof Level) {
                        level = item;
                        tags = Connection.this.getTaggedValue((ModelElement)level);
                        if (catName == null) {
                            catName = Connection.super.getSchemaAttribute("CATALOG_NAME", tags);
                        }
                        if (schName == null) {
                            schName = Connection.super.getSchemaAttribute("SCHEMA_NAME", tags);
                        }
                        if (cubeName == null) {
                            cubeName = Connection.super.getSchemaAttribute("CUBE_NAME", tags);
                        }
                        if (dimensionUName == null) {
                            dimensionUName = Connection.super.getSchemaAttribute("DIMENSION_UNIQUE_NAME", tags);
                        }
                        if (hierarchyUName == null) {
                            hierarchyUName = Connection.super.getSchemaAttribute("HIERARCHY_UNIQUE_NAME", tags);
                        }
                        if (levelUName == null) {
                            levelUName = Connection.super.getSchemaAttribute("LEVEL_UNIQUE_NAME", tags);
                        }
                        if (levelNumber != null) continue;
                        levelNumber = Connection.super.getSchemaAttribute("LEVEL_NUMBER", tags);
                        continue;
                    }
                    if (item instanceof IBIMember) {
                        IBIMember member = item;
                        tags = Connection.this.getTaggedValue((ModelElement)member);
                        if (memberName == null) {
                            memberName = Connection.super.getSchemaAttribute("MEMBER_NAME", tags);
                        }
                        if (memberUName == null) {
                            memberUName = Connection.super.getSchemaAttribute("MEMBER_UNIQUE_NAME", tags);
                        }
                        if (memberCaption == null) {
                            memberCaption = Connection.super.getSchemaAttribute("MEMBER_CAPTION", tags);
                        }
                        if (memberType == null) {
                            memberType = Connection.super.getSchemaAttribute("MEMBER_TYPE", tags);
                        }
                        if (catName == null) {
                            catName = Connection.super.getSchemaAttribute("CATALOG_NAME", tags);
                        }
                        if (schName == null) {
                            schName = Connection.super.getSchemaAttribute("SCHEMA_NAME", tags);
                        }
                        if (cubeName == null) {
                            cubeName = Connection.super.getSchemaAttribute("CUBE_NAME", tags);
                        }
                        if (dimensionUName == null) {
                            dimensionUName = Connection.super.getSchemaAttribute("DIMENSION_UNIQUE_NAME", tags);
                        }
                        if (hierarchyUName == null) {
                            hierarchyUName = Connection.super.getSchemaAttribute("HIERARCHY_UNIQUE_NAME", tags);
                        }
                        if (levelUName == null) {
                            levelUName = Connection.super.getSchemaAttribute("LEVEL_UNIQUE_NAME", tags);
                        }
                        if (levelNumber != null) continue;
                        levelNumber = Connection.super.getSchemaAttribute("LEVEL_NUMBER", tags);
                        continue;
                    }
                    if (item instanceof BIOdboMetadataConstants.BITreeOperator) {
                        if (treeOperator != null) continue;
                        treeOperator = ((BIOdboMetadataConstants.BITreeOperator)item).toString();
                        continue;
                    }
                    if (!(item instanceof BIRestriction)) continue;
                    String name = ((BIRestriction)item).name;
                    String value = ((BIRestriction)item).value;
                    if (name == null) {
                        name = "";
                    }
                    if (name.equals("CATALOG_NAME") && catName == null) {
                        catName = value;
                    }
                    if (name.equals("SCHEMA_NAME") && schName == null) {
                        schName = value;
                    }
                    if (name.equals("CUBE_NAME") && cubeName == null) {
                        cubeName = value;
                    }
                    if (name.equals("DIMENSION_UNIQUE_NAME") && dimensionUName == null) {
                        dimensionUName = value;
                    }
                    if (name.equals("HIERARCHY_UNIQUE_NAME") && hierarchyUName == null) {
                        hierarchyUName = value;
                    }
                    if (name.equals("LEVEL_UNIQUE_NAME") && levelUName == null) {
                        levelUName = value;
                    }
                    if (name.equals("LEVEL_NUMBER") && levelNumber == null) {
                        levelNumber = value;
                    }
                    if (name.equals("MEMBER_NAME") && memberName == null) {
                        memberName = value;
                    }
                    if (name.equals("MEMBER_CAPTION") && memberCaption == null) {
                        memberCaption = value;
                    }
                    if (name.equals("MEMBER_TYPE") && memberType == null) {
                        memberType = value;
                    }
                    if (name.equals("MEMBER_UNIQUE_NAME") && memberUName == null) {
                        memberUName = value;
                    }
                    if (!name.equals("TREE_OP") || treeOperator != null) continue;
                    treeOperator = value;
                }
                if (catName != null) {
                    res.add(new BIRestriction("CATALOG_NAME", catName));
                }
                if (schName != null) {
                    res.add(new BIRestriction("SCHEMA_NAME", schName));
                }
                if (cubeName != null) {
                    res.add(new BIRestriction("CUBE_NAME", cubeName));
                }
                if (dimensionUName != null) {
                    res.add(new BIRestriction("DIMENSION_UNIQUE_NAME", dimensionUName));
                }
                if (hierarchyUName != null) {
                    res.add(new BIRestriction("HIERARCHY_UNIQUE_NAME", hierarchyUName));
                }
                if (levelUName != null) {
                    res.add(new BIRestriction("LEVEL_UNIQUE_NAME", levelUName));
                }
                if (levelNumber != null) {
                    res.add(new BIRestriction("LEVEL_NUMBER", levelNumber));
                }
                if (memberName != null) {
                    res.add(new BIRestriction("MEMBER_NAME", memberName));
                }
                if (memberCaption != null) {
                    res.add(new BIRestriction("MEMBER_CAPTION", memberCaption));
                }
                if (memberType != null) {
                    res.add(new BIRestriction("MEMBER_TYPE", memberType));
                }
                if (memberUName != null) {
                    res.add(new BIRestriction("MEMBER_UNIQUE_NAME", memberUName));
                }
                if (treeOperator != null) {
                    res.add(new BIRestriction("TREE_OP", treeOperator));
                }
            }
            loc.debugT(cat, "Restrictions for getMemberData:catName" + catName + ";" + "schName" + schName + ";" + "cubeName" + cubeName + ";" + "dimensionUName" + dimensionUName + ";" + "hierarchyUName" + hierarchyUName + ";" + "levelUName" + levelUName + ";" + "levelNumber" + levelNumber + ";" + "memberName" + memberName + ";" + "memberCaption" + memberCaption + ";" + "memberType" + memberType + ";" + "memberUName" + memberUName + ";" + "treeOperator" + treeOperator + ";");
            if (dimensionUName == null && hierarchyUName == null && levelUName == null && levelNumber == null && memberName == null && memberCaption == null && memberType == null && memberUName == null) {
                throw new BIResourceException(Connection.this.locale, cat, 500, loc, "sdk.dac.connector.xmla_1011", null);
            }
            BIResultSetData resultSetData = null;
            BIColumnMetaData[] columnMetadata = null;
            ArrayList<Object[]> data = new ArrayList<Object[]>();
            Object[] object = null;
            List member_hm = Connection.this.discoverSchemaRowsetasList("MDSCHEMA_MEMBERS", res);
            int k = 0;
            while (k < member_hm.size()) {
                HashMap hm = (HashMap)member_hm.get(k);
                loc.debugT(cat, hm.toString());
                if (selectedAttributes == null) {
                    object = new Object[]{hm.get("CATALOG_NAME"), hm.get("SCHEMA_NAME"), hm.get("CUBE_NAME"), hm.get("DIMENSION_UNIQUE_NAME"), hm.get("HIERARCHY_UNIQUE_NAME"), hm.get("LEVEL_UNIQUE_NAME"), hm.get("LEVEL_NUMBER"), hm.get("MEMBER_NAME"), hm.get("MEMBER_UNIQUE_NAME"), hm.get("MEMBER_ORDINAL"), hm.get("MEMBER_TYPE"), hm.get("MEMBER_GUID"), hm.get("MEMBER_CAPTION"), hm.get("CHILDREN_CARDINALITY"), hm.get("PARENT_LEVEL"), hm.get("PARENT_UNIQUE_NAME"), hm.get("PARENT_COUNT"), hm.get("DESCRIPTION")};
                } else {
                    object = new Object[selectedAttributes.size()];
                    i = 0;
                    if (selectedAttributes.contains("CATALOG_NAME")) {
                        object[i] = hm.get("CATALOG_NAME");
                        ++i;
                    }
                    if (selectedAttributes.contains("SCHEMA_NAME")) {
                        object[i] = hm.get("SCHEMA_NAME");
                        ++i;
                    }
                    if (selectedAttributes.contains("CUBE_NAME")) {
                        object[i] = hm.get("CUBE_NAME");
                        ++i;
                    }
                    if (selectedAttributes.contains("DIMENSION_UNIQUE_NAME")) {
                        object[i] = hm.get("DIMENSION_UNIQUE_NAME");
                        ++i;
                    }
                    if (selectedAttributes.contains("HIERARCHY_UNIQUE_NAME")) {
                        object[i] = hm.get("HIERARCHY_UNIQUE_NAME");
                        ++i;
                    }
                    if (selectedAttributes.contains("LEVEL_UNIQUE_NAME")) {
                        object[i] = hm.get("LEVEL_UNIQUE_NAME");
                        ++i;
                    }
                    if (selectedAttributes.contains("LEVEL_NUMBER")) {
                        object[i] = hm.get("LEVEL_NUMBER");
                        ++i;
                    }
                    if (selectedAttributes.contains("LEVEL_NUMBER")) {
                        object[i] = hm.get("MEMBER_NAME");
                        ++i;
                    }
                    if (selectedAttributes.contains("MEMBER_UNIQUE_NAME")) {
                        object[i] = hm.get("MEMBER_UNIQUE_NAME");
                        ++i;
                    }
                    if (selectedAttributes.contains("MEMBER_ORDINAL")) {
                        object[i] = hm.get("MEMBER_ORDINAL");
                        ++i;
                    }
                    if (selectedAttributes.contains("MEMBER_TYPE")) {
                        object[i] = hm.get("MEMBER_TYPE");
                        ++i;
                    }
                    if (selectedAttributes.contains("MEMBER_GUID")) {
                        object[i] = hm.get("MEMBER_GUID");
                        ++i;
                    }
                    if (selectedAttributes.contains("MEMBER_CAPTION")) {
                        object[i] = hm.get("MEMBER_CAPTION");
                        ++i;
                    }
                    if (selectedAttributes.contains("CHILDREN_CARDINALITY")) {
                        object[i] = hm.get("CHILDREN_CARDINALITY");
                        ++i;
                    }
                    if (selectedAttributes.contains("PARENT_LEVEL")) {
                        object[i] = hm.get("PARENT_LEVEL");
                        ++i;
                    }
                    if (selectedAttributes.contains("PARENT_UNIQUE_NAME")) {
                        object[i] = hm.get("PARENT_UNIQUE_NAME");
                        ++i;
                    }
                    if (selectedAttributes.contains("PARENT_COUNT")) {
                        object[i] = hm.get("PARENT_COUNT");
                        ++i;
                    }
                    if (selectedAttributes.contains("DESCRIPTION")) {
                        object[i] = hm.get("DESCRIPTION");
                    }
                }
                data.add(object);
                ++k;
            }
            if (selectedAttributes == null) {
                columnMetadata = new BIColumnMetaData[]{new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "CATALOG_NAME"), new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "SCHEMA_NAME"), new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "CUBE_NAME"), new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "DIMENSION_UNIQUE_NAME"), new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "HIERARCHY_UNIQUE_NAME"), new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "LEVEL_UNIQUE_NAME"), new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 4, "LEVEL_NUMBER"), new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "MEMBER_NAME"), new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "MEMBER_UNIQUE_NAME"), new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 4, "MEMBER_ORDINAL"), new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 4, "MEMBER_TYPE"), new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "MEMBER_GUID"), new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "MEMBER_CAPTION"), new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 4, "CHILDREN_CARDINALITY"), new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 4, "PARENT_LEVEL"), new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "PARENT_UNIQUE_NAME"), new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 4, "PARENT_COUNT"), new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "DESCRIPTION")};
            } else {
                columnMetadata = new BIColumnMetaData[selectedAttributes.size()];
                i = 0;
                if (selectedAttributes.contains("CATALOG_NAME")) {
                    columnMetadata[i] = new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "CATALOG_NAME");
                    ++i;
                }
                if (selectedAttributes.contains("SCHEMA_NAME")) {
                    columnMetadata[i] = new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "SCHEMA_NAME");
                    ++i;
                }
                if (selectedAttributes.contains("CUBE_NAME")) {
                    columnMetadata[i] = new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "CUBE_NAME");
                    ++i;
                }
                if (selectedAttributes.contains("DIMENSION_UNIQUE_NAME")) {
                    columnMetadata[i] = new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "DIMENSION_UNIQUE_NAME");
                    ++i;
                }
                if (selectedAttributes.contains("HIERARCHY_UNIQUE_NAME")) {
                    columnMetadata[i] = new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "HIERARCHY_UNIQUE_NAME");
                    ++i;
                }
                if (selectedAttributes.contains("LEVEL_UNIQUE_NAME")) {
                    columnMetadata[i] = new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "LEVEL_UNIQUE_NAME");
                    ++i;
                }
                if (selectedAttributes.contains("LEVEL_NUMBER")) {
                    columnMetadata[i] = new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 4, "LEVEL_NUMBER");
                    ++i;
                }
                if (selectedAttributes.contains("MEMBER_NAME")) {
                    columnMetadata[i] = new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "MEMBER_NAME");
                }
                if (selectedAttributes.contains("MEMBER_UNIQUE_NAME")) {
                    columnMetadata[i] = new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "MEMBER_UNIQUE_NAME");
                    ++i;
                }
                if (selectedAttributes.contains("MEMBER_ORDINAL")) {
                    columnMetadata[i] = new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 4, "MEMBER_ORDINAL");
                    ++i;
                }
                if (selectedAttributes.contains("MEMBER_TYPE")) {
                    columnMetadata[i] = new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 4, "MEMBER_TYPE");
                    ++i;
                }
                if (selectedAttributes.contains("MEMBER_GUID")) {
                    columnMetadata[i] = new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "MEMBER_GUID");
                    ++i;
                }
                if (selectedAttributes.contains("MEMBER_CAPTION")) {
                    columnMetadata[i] = new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "MEMBER_CAPTION");
                    ++i;
                }
                if (selectedAttributes.contains("CHILDREN_CARDINALITY")) {
                    columnMetadata[i] = new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 4, "CHILDREN_CARDINALITY");
                    ++i;
                }
                if (selectedAttributes.contains("PARENT_LEVEL")) {
                    columnMetadata[i] = new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 4, "PARENT_LEVEL");
                    ++i;
                }
                if (selectedAttributes.contains("PARENT_UNIQUE_NAME")) {
                    columnMetadata[i] = new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "PARENT_UNIQUE_NAME");
                    ++i;
                }
                if (selectedAttributes.contains("PARENT_COUNT")) {
                    columnMetadata[i] = new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 4, "PARENT_COUNT");
                    ++i;
                }
                if (selectedAttributes.contains("DESCRIPTION")) {
                    columnMetadata[i] = new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "DESCRIPTION");
                    ++i;
                }
            }
            try {
                resultSetData = new BIResultSetData(((CommonConnection)Connection.this).connectionInfo, data);
                resultSet = new BIResultSet(((CommonConnection)Connection.this).connectionInfo, (IBIResultSetData)resultSetData, (IBIColumnMetaData[])columnMetadata);
            }
            catch (SQLException e) {
                cat.errorT(loc, e.getLocalizedMessage());
                throw new BIResourceException(Connection.this.locale, cat, 500, loc, "sdk.dac.connector_1053", (Throwable)e);
            }
            loc.exiting();
            return resultSet;
        }

        public IBIMember findMemberFirst(String schemaName, String cubeName, String dimensionName, String hierarchyName, String levelName, String memberName, BITreeOperator treeOperator) throws BIResourceException {
            List memberList = this.findMember(schemaName, cubeName, dimensionName, hierarchyName, levelName, memberName, treeOperator, true);
            if (memberList != null & memberList.size() > 0) {
                return (IBIMember)memberList.get(0);
            }
            return null;
        }

        public IBIMember findMemberFirst(Level level, String memberName, BITreeOperator treeOperator) throws BIResourceException {
            List memberList = this.findMember(level, memberName, treeOperator, true);
            if (memberList != null & memberList.size() > 0) {
                return (IBIMember)memberList.get(0);
            }
            return null;
        }
    }

    private class ConnectionInfo
    implements IBIConnectionInfo {
        Locale locale = null;
        String user = null;

        private ConnectionInfo() {
            this.user = Connection.this.properties.getProperty(BIConnectionConstants.USERNAME.toString());
            this.locale = BILogonLanguage.getLocale((String)Connection.this.properties.getProperty(BIConnectionConstants.LANGUAGE.toString()));
        }

        public String getUser() {
            return this.user;
        }

        public Locale getLocale() {
            return this.locale;
        }
    }
}

