/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.xmla;

import com.sap.ip.bi.sdk.dac.connector.impl.AbstractManagedConnection;
import com.sap.ip.bi.sdk.dac.connector.impl.ConnectorConnection;
import com.sap.ip.bi.sdk.dac.connector.xmla.XmlaConnection;
import com.sap.ip.bi.sdk.dac.connector.xmla.XmlaConnectionConstants;
import com.sap.ip.bi.sdk.dac.connector.xmla.XmlaConnectionProperties;
import com.sap.ip.bi.sdk.dac.connector.xmla.XmlaManagedConnectionFactory;
import com.sap.ip.bi.sdk.dac.connector.xmla.XmlaManagedConnectionMetaData;
import com.sap.ip.bi.sdk.dac.connector.xmla.impl.Connection;
import com.sap.ip.bi.sdk.exception.BICapabilityNotSupportedException;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import com.sap.ip.bi.sdk.util.BILoggingSetup;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.security.GenericCredential;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;

public class XmlaManagedConnection
extends AbstractManagedConnection {
    protected XmlaManagedConnectionFactory m_managedConnectionFactory;
    private XmlaConnectionProperties m_request_info;
    private String user;
    private String passwd;
    private static final Location loc = Location.getLocation((String)(class$com$sap$ip$bi$sdk$dac$connector$xmla$XmlaManagedConnection == null ? (class$com$sap$ip$bi$sdk$dac$connector$xmla$XmlaManagedConnection = XmlaManagedConnection.class$("com.sap.ip.bi.sdk.dac.connector.xmla.XmlaManagedConnection")) : class$com$sap$ip$bi$sdk$dac$connector$xmla$XmlaManagedConnection).getName());
    private static final Category cat = BILoggingSetup.CONNECTION.getCategory();
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$connector$xmla$XmlaManagedConnection;
    static /* synthetic */ Class class$javax$resource$spi$security$PasswordCredential;
    static /* synthetic */ Class class$javax$resource$spi$security$GenericCredential;

    protected XmlaManagedConnection(XmlaManagedConnectionFactory managed_connection_factory, Subject subject, XmlaConnectionProperties request_info) throws ResourceException {
        loc.entering();
        loc.infoT(cat, "XmlaManagedConnection.Constructor(" + managed_connection_factory + "," + subject + "," + request_info + ")");
        this.m_managedConnectionFactory = managed_connection_factory;
        this.m_logWriter = managed_connection_factory.m_logWriter;
        this.m_subject = subject;
        this.m_request_info = request_info;
        try {
            Properties connProps = new Properties(managed_connection_factory.m_properties);
            if (request_info != null && request_info.m_properties != null) {
                Enumeration e = ((Hashtable)request_info.m_properties).keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    connProps.setProperty(key, request_info.getProperty(key));
                }
            }
            loc.infoT(cat, "subject: " + subject);
            if (subject != null) {
                Iterator credsIter = subject.getPrivateCredentials(class$javax$resource$spi$security$PasswordCredential == null ? (class$javax$resource$spi$security$PasswordCredential = XmlaManagedConnection.class$("javax.resource.spi.security.PasswordCredential")) : class$javax$resource$spi$security$PasswordCredential).iterator();
                while (credsIter.hasNext()) {
                    PasswordCredential pc = (PasswordCredential)credsIter.next();
                    if (pc == null) continue;
                    connProps.setProperty(XmlaConnectionConstants.LOGONMETHOD.toString(), XmlaConnectionConstants.LOGONMETHOD_UID.toString());
                    connProps.setProperty(XmlaConnectionProperties.Parameter.USER.name, pc.getUserName());
                    connProps.setProperty(XmlaConnectionProperties.Parameter.PASSWD.name, new String(pc.getPassword()));
                    loc.infoT(cat, "Found PasswordCredential");
                    break;
                }
                credsIter = subject.getPrivateCredentials(class$javax$resource$spi$security$GenericCredential == null ? (class$javax$resource$spi$security$GenericCredential = XmlaManagedConnection.class$("javax.resource.spi.security.GenericCredential")) : class$javax$resource$spi$security$GenericCredential).iterator();
                while (credsIter.hasNext()) {
                    String authMechType;
                    GenericCredential gc = (GenericCredential)credsIter.next();
                    if (gc == null || !(authMechType = gc.getMechType()).equals("1.3.6.1.4.1.694.2.1.3.1")) continue;
                    connProps.setProperty(XmlaConnectionConstants.LOGONMETHOD.toString(), XmlaConnectionConstants.LOGONMETHOD_SSO.toString());
                    loc.infoT(cat, "Found SAPAssertionTicket");
                    break;
                }
            }
            this.connection = Connection.connect(connProps);
        }
        catch (Exception ex) {
            if (ex instanceof BIResourceException) {
                ((BIResourceException)ex).log();
            } else {
                cat.errorT(loc, ex.toString());
            }
            throw new BIResourceException(this.connection == null ? Locale.getDefault() : this.connection.getConnectionInfo().getLocale(), cat, 500, loc, "sdk.dac.connector_1100", null, (Throwable)ex);
        }
        loc.exiting();
    }

    protected boolean equals(XmlaManagedConnectionFactory managed_connection_factory, Subject subject, XmlaConnectionProperties request_info) throws ResourceException {
        String method = "equals( XmlaManagedConnectionFactory, Subject, XmlaConnectionProperties)";
        loc.entering("equals( XmlaManagedConnectionFactory, Subject, XmlaConnectionProperties)");
        if (this.m_subject != null && subject == null || this.m_subject == null && subject != null) {
            return false;
        }
        if (this.m_subject != null && !this.m_subject.equals(subject)) {
            return false;
        }
        if (managed_connection_factory != null && !this.m_managedConnectionFactory.equals(managed_connection_factory)) {
            return false;
        }
        return subject != null || this.compareProperties(request_info);
    }

    protected boolean compareProperties(XmlaConnectionProperties other) throws ResourceException {
        loc.entering("compareProperties(" + other + ")");
        XmlaConnectionProperties request_info = null;
        request_info = other == null ? new XmlaConnectionProperties(this.m_managedConnectionFactory.m_properties) : other;
        if (request_info.m_properties == null) {
            request_info.m_properties = this.m_managedConnectionFactory.m_properties;
        }
        if (((Hashtable)this.connection.getProperties()).size() < ((Hashtable)request_info.m_properties).size()) {
            loc.debugT(cat, "connection.getProperties().size() < request_info.m_properties.size()" + ((Hashtable)this.connection.getProperties()).size() + "  " + ((Hashtable)request_info.m_properties).size());
            loc.exiting((Object)new Boolean(false));
            return false;
        }
        boolean is_equal = true;
        Enumeration keys = ((Hashtable)this.connection.getProperties()).keys();
        while (keys.hasMoreElements() && is_equal) {
            String key = (String)keys.nextElement();
            String valueMC = this.connection.getProperty(key);
            String valueNew = request_info.m_properties.getProperty(key);
            loc.debugT(cat, "key:" + key + "valueMC:" + valueMC + "valueNew:" + valueNew);
            if (valueMC != null && valueMC.length() > 0 && (valueNew == null || valueNew.length() == 0)) {
                is_equal = false;
                continue;
            }
            if ((valueMC == null || valueMC.length() == 0) && valueNew != null && valueNew.length() > 0) {
                is_equal = false;
                continue;
            }
            if (valueMC == null || valueNew == null || valueMC.equals(valueNew)) continue;
            is_equal = false;
        }
        loc.debugT(cat, "compareProperties  is_equal " + is_equal);
        loc.exiting((Object)new Boolean(is_equal));
        return is_equal;
    }

    /*
     * Loose catch block
     */
    public void destroy() throws ResourceException {
        Object v0;
        block11: {
            if (this.connection == null) {
                return;
            }
            this.cleanup();
            Object var3_1 = null;
            try {
                this.connection.close();
                v0 = null;
                break block11;
            }
            catch (Throwable throwable) {
                v0 = null;
            }
            {
                break block11;
                catch (ResourceException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                Object v1;
                Object var3_2 = null;
                try {
                    this.connection.close();
                    v1 = null;
                }
                catch (Throwable throwable2) {
                    v1 = null;
                }
                Object var6_8 = v1;
                this.connection = null;
                throw throwable;
            }
        }
        Object var6_7 = v0;
        this.connection = null;
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo info) throws ResourceException {
        loc.entering("getConnection(Subject, ConnectionRequestInfo)");
        this.assertConnection();
        return new XmlaConnection(this);
    }

    public void cleanup() throws ResourceException {
        Vector vector = this.m_associated_connections;
        synchronized (vector) {
            Vector list = (Vector)this.m_associated_connections.clone();
            int num_connections = list.size();
            int i = 0;
            while (i < num_connections) {
                ((XmlaConnection)((Object)list.elementAt(i))).dissociateManagedConnection();
                ++i;
            }
            this.m_associated_connections.removeAllElements();
        }
    }

    public void associateConnection(Object connection) throws ResourceException {
        if (connection == null) {
            throw new BIResourceException(Locale.getDefault(), cat, 500, loc, "sdk.dac.connector_1101", null);
        }
        if (!(connection instanceof XmlaConnection)) {
            throw new BIResourceException(Locale.getDefault(), cat, 500, loc, "sdk.dac.connector_1007", new Object[]{connection.getClass()}, null);
        }
        this.assertConnection();
        ((XmlaConnection)((Object)connection)).associateConnection((ManagedConnection)this);
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        if (this.m_connection_listeners == null) {
            this.m_connection_listeners = new Vector();
        }
        this.m_connection_listeners.addElement(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        if (this.m_connection_listeners != null) {
            this.m_connection_listeners.removeElement(listener);
        }
    }

    public XAResource getXAResource() throws ResourceException {
        throw new BICapabilityNotSupportedException(this.connection == null ? Locale.getDefault() : this.connection.getConnectionInfo().getLocale(), "sdk_1000");
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        throw new BICapabilityNotSupportedException(this.connection == null ? Locale.getDefault() : this.connection.getConnectionInfo().getLocale(), "sdk_1000");
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        this.assertConnection();
        return new XmlaManagedConnectionMetaData(this);
    }

    public void setLogWriter(PrintWriter logWriter) throws ResourceException {
        this.m_logWriter = logWriter;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.m_logWriter;
    }

    public XmlaManagedConnectionFactory getManagedConnectionFactory() {
        return this.m_managedConnectionFactory;
    }

    protected void unregisterConnection(XmlaConnection connection) {
        this.m_associated_connections.removeElement((Object)connection);
    }

    protected void assertConnection() throws BIResourceException {
        if (this.connection == null) {
            cat.errorT(loc, "assertConnection(): Connection is null");
            throw new BIResourceException(Locale.getDefault(), cat, 500, loc, "sdk.dac.connector_1101", null);
        }
        try {
            this.connection.isAlive();
        }
        catch (BIResourceException e) {
            Locale locale;
            this.fireConnectErrorOccurredEvent(null);
            e.log();
            try {
                locale = this.connection.getConnectionInfo().getLocale();
            }
            catch (BIResourceException ex) {
                locale = Locale.getDefault();
            }
            throw new BIResourceException(locale, cat, 500, loc, "sdk.dac.connector_1101", new Object[0], (Throwable)e);
        }
    }

    protected ConnectorConnection getConnection() throws BIResourceException {
        return super.getConnection();
    }

    protected void fireConnectionClosedEvent(javax.resource.cci.Connection connection) throws BIResourceException {
        super.fireConnectionClosedEvent(connection);
    }

    protected void fireConnectErrorOccurredEvent(javax.resource.cci.Connection connection) throws BIResourceException {
        super.fireConnectErrorOccurredEvent(connection);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

