/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.sapq.impl;

import com.sap.aii.util.misc.api.BaseException;
import com.sap.ip.bi.sdk.dac.connector.impl.BIConnectionInfo;
import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.connector.sapq.SapqConnectionConstants;
import com.sap.ip.bi.sdk.dac.connector.sapq.impl.SapqQueryInfo;
import com.sap.ip.bi.sdk.dac.connector.sapq.impl.proxy.Rsaq_Remote_Query_Call_Input;
import com.sap.ip.bi.sdk.dac.connector.sapq.impl.proxy.Rsaq_Remote_Query_Call_Output;
import com.sap.ip.bi.sdk.dac.connector.sapq.impl.proxy.Rsaq_Remote_Query_Delete_Input;
import com.sap.ip.bi.sdk.dac.connector.sapq.impl.proxy.Rsaq_Remote_Query_Delete_Output;
import com.sap.ip.bi.sdk.dac.connector.sapq.impl.proxy.Rsaq_Remote_Query_Generation_Input;
import com.sap.ip.bi.sdk.dac.connector.sapq.impl.proxy.Rsaq_Remote_Query_Generation_Output;
import com.sap.ip.bi.sdk.dac.connector.sapq.impl.proxy.RsaqfnameType;
import com.sap.ip.bi.sdk.dac.connector.sapq.impl.proxy.RsaqfnameTypeList;
import com.sap.ip.bi.sdk.dac.connector.sapq.impl.proxy.RsaqfsnameType;
import com.sap.ip.bi.sdk.dac.connector.sapq.impl.proxy.RsaqfsnameTypeList;
import com.sap.ip.bi.sdk.dac.connector.sapq.impl.proxy.RsaqldataType;
import com.sap.ip.bi.sdk.dac.connector.sapq.impl.proxy.RsaqldataTypeList;
import com.sap.ip.bi.sdk.dac.connector.sapq.impl.proxy.RsaqldescType;
import com.sap.ip.bi.sdk.dac.connector.sapq.impl.proxy.RsaqldescTypeList;
import com.sap.ip.bi.sdk.dac.connector.sapq.impl.proxy.RsparamsType;
import com.sap.ip.bi.sdk.dac.connector.sapq.impl.proxy.RsparamsTypeList;
import com.sap.ip.bi.sdk.dac.connector.sapq.impl.proxy.SAPQ_PortType;
import com.sap.ip.bi.sdk.dac.relational.query.sapq.IBISapqQueryCall;
import com.sap.ip.bi.sdk.dac.relational.query.sapq.IBISapqSelectOption;
import com.sap.ip.bi.sdk.dac.relational.query.sapq.IBISapqSortField;
import com.sap.ip.bi.sdk.dac.result.impl.BIColumnMetaData;
import com.sap.ip.bi.sdk.dac.result.impl.BIEmptyResultSet;
import com.sap.ip.bi.sdk.dac.result.impl.BIResultSet;
import com.sap.ip.bi.sdk.dac.result.impl.BIResultSetData;
import com.sap.ip.bi.sdk.dac.result.impl.BIResultSetMetaData;
import com.sap.ip.bi.sdk.dac.result.impl.IBIColumnMetaData;
import com.sap.ip.bi.sdk.dac.result.impl.IBIResultSet;
import com.sap.ip.bi.sdk.dac.result.impl.IBIResultSetData;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import com.sap.ip.bi.sdk.exception.BISQLException;
import com.sap.ip.bi.sdk.util.BILoggingSetup;
import com.sap.ip.bi.sdk.util.impl.BISqlAbapDate;
import com.sap.ip.bi.sdk.util.impl.BISqlAbapNumber;
import com.sap.ip.bi.sdk.util.impl.BISqlAbapType;
import com.sap.ip.bi.sdk.util.impl.IBIMonitor;
import com.sap.ip.bi.sdk.util.impl.ServerRTCounter;
import com.sap.mw.jco.JCO;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SapqQueryExecution {
    private static final boolean tracePrivateMethods = false;
    private static final Location loggingLoc = Location.getLocation((String)(class$com$sap$ip$bi$sdk$dac$connector$sapq$impl$SapqQueryExecution == null ? (class$com$sap$ip$bi$sdk$dac$connector$sapq$impl$SapqQueryExecution = SapqQueryExecution.class$("com.sap.ip.bi.sdk.dac.connector.sapq.impl.SapqQueryExecution")) : class$com$sap$ip$bi$sdk$dac$connector$sapq$impl$SapqQueryExecution).getName());
    private ServerRTCounter serverRTCounter = ServerRTCounter.getInstance();
    private static final Category loggingCat = BILoggingSetup.QUERY.getCategory();
    private IBIMonitor monitor = null;
    private final boolean useGlobalqueryArea;
    static final String QUERY_AREA_GLOBAL = "X";
    static final String QUERY_AREA_LOCAL = " ";
    private JCO.Client client = null;
    private SAPQ_PortType sapq = null;
    private IBIConnectionInfo connectionInfo = IBIConnectionInfo.DEFAULT;
    private static final String EXTERNAL_REPRESENTATION = "Z";
    private static final String TRUE = "X";
    private static final String FALSE = " ";
    private static final String INT_SELNAME = "SP$00000";
    private int offset = 0;
    private int index = 0;
    private List column = new ArrayList();
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$connector$sapq$impl$SapqQueryExecution;

    public SapqQueryExecution(JCO.Client client, IBIConnectionInfo connectionInfo) throws BIResourceException {
        String method = "SapqQueryExecution(JCO.Client)";
        try {
            this.connectionInfo = connectionInfo;
            BIConnectionInfo.assertConnectionInfo((IBIConnectionInfo)connectionInfo);
            this.sapq = new SAPQ_PortType();
            try {
                this.sapq.messageSpecifier.setJcoClient(client);
                this.serverRTCounter.incrementCounter();
            }
            catch (JCO.Exception ex) {
                BIResourceException rex = new BIResourceException(connectionInfo.getLocale(), "sdk.dac.connector.sapq_1001", new Object[]{client}, (Throwable)ex);
                loggingLoc.throwing("SapqQueryExecution(JCO.Client)", (Throwable)rex);
                throw rex;
            }
            this.useGlobalqueryArea = client != null && "X".equals(client.getProperty(SapqConnectionConstants.QUERYAREA.toString()));
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SapqQueryInfo generateQuery(IBISapqQueryCall call) throws BIResourceException {
        String method = "generateQuery(IBISapqQueryCall)";
        loggingLoc.entering("generateQuery(IBISapqQueryCall)");
        try {
            Rsaq_Remote_Query_Generation_Input input = new Rsaq_Remote_Query_Generation_Input();
            input.setWorkspace(this.useGlobalqueryArea ? "X" : " ");
            RsaqfnameTypeList fields = new RsaqfnameTypeList();
            Iterator i = call.getFields().iterator();
            while (i.hasNext()) {
                String selName = (String)i.next();
                RsaqfnameType s = new RsaqfnameType();
                s.setName(selName);
                fields.add((Object)s);
            }
            input.setFields(fields);
            RsaqfnameTypeList selectFields = new RsaqfnameTypeList();
            HashMap<String, String> selectMap = new HashMap<String, String>();
            int count = 0;
            Iterator i2 = call.getSelectFields().iterator();
            while (i2.hasNext()) {
                String selName = (String)i2.next();
                RsaqfnameType s = new RsaqfnameType();
                s.setName(selName);
                selectFields.add((Object)s);
                StringBuffer internal = new StringBuffer().append(++count);
                int len = internal.length();
                internal.insert(0, INT_SELNAME.substring(0, INT_SELNAME.length() - len));
                selectMap.put(selName, internal.toString());
            }
            input.setSelect_Fields(selectFields);
            RsaqfsnameTypeList sortFields = new RsaqfsnameTypeList();
            Iterator i3 = call.getSortFields().iterator();
            while (i3.hasNext()) {
                IBISapqSortField sortField = (IBISapqSortField)i3.next();
                RsaqfsnameType s = new RsaqfsnameType();
                s.setName(sortField.getSortField());
                if (sortField.isAscending()) {
                    s.setDescending(" ");
                } else {
                    s.setDescending("X");
                }
                sortFields.add((Object)s);
            }
            input.setSort_Fields(sortFields);
            input.setFuncarea(call.getFuncArea());
            try {
                _SapqQueryInfo q;
                Rsaq_Remote_Query_Generation_Output output = this.sapq.rsaq_Remote_Query_Generation(input);
                this.serverRTCounter.incrementCounter();
                _SapqQueryInfo _SapqQueryInfo2 = q = new _SapqQueryInfo(output.getQuery(), output.getUsergroup(), selectMap);
                Object var16_19 = null;
                loggingLoc.exiting();
                return _SapqQueryInfo2;
            }
            catch (Exception ex) {
                BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.connector_1200", (Throwable)ex);
                loggingLoc.throwing("generateQuery(IBISapqQueryCall)", (Throwable)rex);
                throw rex;
            }
        }
        catch (Throwable throwable) {
            Object var16_20 = null;
            loggingLoc.exiting();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResultSet executeQuery(IBISapqQueryCall call, SapqQueryInfo query) throws BIResourceException {
        ResultSet resultSet;
        block8: {
            String method = "executeQuery(IBISapqQueryCall, SapqQueryInfo)";
            loggingLoc.entering("executeQuery(IBISapqQueryCall, SapqQueryInfo)");
            try {
                Throwable cause;
                BaseException ex2;
                Rsaq_Remote_Query_Call_Input input = new Rsaq_Remote_Query_Call_Input();
                input.setWorkspace(this.useGlobalqueryArea ? "X" : " ");
                input.setUsergroup(query.getUserGroup());
                input.setQuery(query.getQuery());
                input.setSkip_Selscreen("X");
                input.setData_To_Memory("X");
                input.setExternal_Presentation(EXTERNAL_REPRESENTATION);
                RsparamsTypeList selectionTable = new RsparamsTypeList();
                IBISapqSelectOption[] s = call.getSelectTable();
                int i = 0;
                while (true) {
                    if (s == null || i >= s.length) {
                        input.setSelection_Table(selectionTable);
                        try {
                            Rsaq_Remote_Query_Call_Output output = this.sapq.rsaq_Remote_Query_Call(input);
                            this.serverRTCounter.incrementCounter();
                            resultSet = this.processQueryCallOutput(output);
                            Object var12_12 = null;
                            break block8;
                        }
                        catch (BaseException ex2) {
                            cause = ex2.getRootCause();
                            break;
                        }
                    }
                    RsparamsType rsp = new RsparamsType();
                    rsp.setKind(s[i].getKind().toString());
                    rsp.setSelname((String)query.getSelectMap().get(s[i].getColumn().getName()));
                    rsp.setSign(s[i].getSign().toString());
                    rsp.setOption(s[i].getOption().toString());
                    rsp.setLow(s[i].getLow());
                    rsp.setHigh(s[i].getHigh());
                    selectionTable.add((Object)rsp);
                    ++i;
                }
                while (cause != null) {
                    if (cause instanceof JCO.AbapException) {
                        if (!((JCO.AbapException)cause).getKey().equals("NO_DATA_SELECTED")) break;
                        ResultSet resultSet2 = this.emptyResultSet(call);
                        Object var12_13 = null;
                        loggingLoc.exiting();
                        return resultSet2;
                    }
                    if (!(cause instanceof BaseException)) break;
                    cause = ((BaseException)cause).getRootCause();
                }
                BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.connector_1200", (Throwable)ex2);
                loggingLoc.throwing("executeQuery(IBISapqQueryCall, SapqQueryInfo)", (Throwable)rex);
                throw rex;
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                loggingLoc.exiting();
                throw throwable;
            }
        }
        loggingLoc.exiting();
        return resultSet;
    }

    public void deleteQuery(SapqQueryInfo query) throws BIResourceException {
        String method = "deleteQuery(SapqQueryInfo)";
        loggingLoc.entering("deleteQuery(SapqQueryInfo)");
        try {
            Rsaq_Remote_Query_Delete_Input input = new Rsaq_Remote_Query_Delete_Input();
            input.setWorkspace(this.useGlobalqueryArea ? "X" : " ");
            input.setQuery(query.getQuery());
            input.setUsergroup(query.getUserGroup());
            input.setQuestion(" ");
            try {
                Rsaq_Remote_Query_Delete_Output output = this.sapq.rsaq_Remote_Query_Delete(input);
                this.serverRTCounter.incrementCounter();
            }
            catch (Exception ex) {
                BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.connector_1200", (Throwable)ex);
                loggingLoc.throwing("deleteQuery(SapqQueryInfo)", (Throwable)rex);
                throw rex;
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    private ResultSet processQueryCallOutput(Rsaq_Remote_Query_Call_Output output) throws BIResourceException {
        String method = "processQueryCallOutput(Rsaq_Remote_Query_Call_Output)";
        try {
            try {
                BIResultSet res;
                RsaqldescTypeList ldesc = output.getListdesc();
                RsaqldataTypeList ldata = output.getLdata();
                ArrayList<BIColumnMetaData> md = new ArrayList<BIColumnMetaData>();
                Iterator i = ldesc.iterator();
                while (i.hasNext()) {
                    RsaqldescType l = (RsaqldescType)((Object)i.next());
                    String columnName = l.getFnameint();
                    int columnType = BISqlAbapType.getSqlTypeFromAbap((String)l.getFtyp());
                    BIColumnMetaData m = new BIColumnMetaData(this.connectionInfo, columnType, columnName);
                    m.setModifiable(true);
                    m.setCatalogName("SAPQUERY");
                    m.setSchemaName("SAPQUERY");
                    m.setColumnName(columnName);
                    m.setColumnType(columnType);
                    m.setColumnTypeName(BISqlAbapType.getSQLTypeNameFromAbap((String)l.getFtyp()));
                    m.setPrecision(Integer.parseInt(l.getFolen()));
                    m.setScale(Integer.parseInt(l.getFolen()));
                    m.setModifiable(false);
                    md.add(m);
                }
                IBIColumnMetaData[] meta = md.toArray(new IBIColumnMetaData[0]);
                ArrayList data = this.processQueryCallOutputData(new SapqQueryDataInputStream(ldata), meta);
                BIResultSet bIResultSet = res = new BIResultSet(this.connectionInfo, (IBIResultSetData)new BIResultSetData(this.connectionInfo, (List)data), meta, IBIResultSet.Type.UNRESTRICTED, false);
                Object var12_13 = null;
                return bIResultSet;
            }
            catch (SQLException ex) {
                ((BISQLException)ex).log();
                throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_4001", (Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            throw throwable;
        }
    }

    private ArrayList processQueryCallOutputData(InputStream stream, IBIColumnMetaData[] meta) throws BIResourceException {
        String method = "processQueryCallOutputData(InputStream, IBIColumnMetaData[])";
        try {
            ArrayList<Object[]> rows = new ArrayList<Object[]>();
            String value = null;
            ArrayList<Object> columns = new ArrayList<Object>();
            int index = 0;
            while ((value = this.processQueryCallOutputValue(stream)) != null) {
                block7: {
                    this.serverRTCounter.addToCounter(1, value != null ? (long)value.length() : 0L);
                    try {
                        columns.add(this.getQueryCallOutputValue(value, meta[index]));
                    }
                    catch (NumberFormatException ex) {
                        if (rows.size() != 0) break block7;
                        BIColumnMetaData m = (BIColumnMetaData)meta[index];
                        try {
                            m.setModifiable(true);
                            m.setColumnType(12);
                            m.setModifiable(false);
                        }
                        catch (SQLException sx) {
                            // empty catch block
                        }
                        columns.add(value);
                    }
                }
                if (++index < meta.length) continue;
                index = 0;
                rows.add(columns.toArray());
                columns.clear();
            }
            ArrayList<Object[]> arrayList = rows;
            Object var12_12 = null;
            return arrayList;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String processQueryCallOutputValue(InputStream stream) throws BIResourceException {
        String method = "processQueryCallOutputValue(InputStream)";
        try {
            try {
                int bytes = 0;
                byte[] number = new byte[3];
                bytes = stream.read(number);
                if (bytes < 3) {
                    if (bytes != 1 || number[0] != 47) throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.connector.sapq_3001", new Object[]{new Character('/'), bytes > 0 ? new Byte(number[0]) : null});
                    return null;
                }
                int size = 100 * (number[0] - 48) + 10 * (number[1] - 48) + (number[2] - 48);
                if (stream.read() == -1) {
                    return null;
                }
                byte[] data = new byte[size + 1];
                bytes = stream.read(data);
                if (bytes == size + 1) return new String(data, 0, size);
                throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.connector.sapq_3002", new Object[]{new Integer(size + 1), new Integer(bytes)});
            }
            catch (IOException ex) {
                loggingLoc.errorT("processQueryCallOutputValue(InputStream)", ex.getLocalizedMessage());
                throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.connector.sapq_3000", (Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object getQueryCallOutputValue(String value, IBIColumnMetaData meta) throws BIResourceException {
        String method = "getQueryCallOutputValue(String, IBIColumnMetaData)";
        try {
            try {
                switch (meta.getColumnType()) {
                    case -5: {
                        return new BigInteger(BISqlAbapNumber.getNumberFromAbapNumber((String)value));
                    }
                    case 4: 
                    case 5: {
                        return new Integer(BISqlAbapNumber.getNumberFromAbapNumber((String)value));
                    }
                    case 3: {
                        return new BigDecimal(BISqlAbapNumber.getNumberFromAbapNumber((String)value));
                    }
                    case 2: 
                    case 6: 
                    case 7: 
                    case 8: {
                        return new Double(BISqlAbapNumber.getNumberFromAbapNumber((String)value));
                    }
                    case 1: {
                        return new Character(value.charAt(0));
                    }
                    case -3: 
                    case -1: 
                    case 12: {
                        return value;
                    }
                    case 91: {
                        return Date.valueOf(BISqlAbapDate.convertDate((String)value));
                    }
                    case 92: {
                        return Time.valueOf(BISqlAbapDate.convertTime((String)value));
                    }
                    case 1111: 
                    case 2000: {
                        return value;
                    }
                }
                throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.connector_1002", new Object[]{"(" + value + ")", new Integer(meta.getColumnType())});
            }
            catch (SQLException ex) {
                ((BISQLException)ex).log();
                throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.connector.sapq_3000", (Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            throw throwable;
        }
    }

    private ResultSet emptyResultSet(IBISapqQueryCall call) {
        List fields = call.getFields();
        if (fields == null) {
            return new BIEmptyResultSet(this.connectionInfo, null);
        }
        IBIColumnMetaData[] colMeta = new IBIColumnMetaData[fields.size()];
        Iterator f = fields.iterator();
        int i = 0;
        while (i < colMeta.length) {
            String name = (String)f.next();
            BIColumnMetaData c = new BIColumnMetaData(this.connectionInfo, 12, name);
            try {
                c.setModifiable(true);
                c.setColumnLabel(name);
                c.setModifiable(false);
            }
            catch (SQLException ex) {
                // empty catch block
            }
            colMeta[i] = c;
            ++i;
        }
        BIResultSetMetaData meta = new BIResultSetMetaData(this.connectionInfo, colMeta);
        BIEmptyResultSet res = new BIEmptyResultSet(this.connectionInfo, (ResultSetMetaData)meta);
        return res;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SapqQueryDataInputStream
    extends InputStream {
        private final RsaqldataTypeList ldata;
        private Iterator lineIterator = null;
        private String line = null;
        private int offset = 0;
        private int length = 0;

        public SapqQueryDataInputStream(RsaqldataTypeList ldata) {
            this.ldata = ldata;
            this.lineIterator = ldata.iterator();
            if (this.hasNextLine()) {
                this.line = this.getNextLine();
                this.length = this.line.length();
                this.offset = 0;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int read() throws IOException {
            char c;
            block6: {
                int current2;
                block5: {
                    char c2;
                    block4: {
                        String method = "read()";
                        loggingLoc.entering("read()");
                        try {
                            if (this.offset >= this.length) {
                                if (this.hasNextLine()) {
                                    this.line = this.getNextLine();
                                    this.length = this.line.length();
                                    this.offset = 0;
                                    int current2 = this.offset++;
                                    c2 = this.line.charAt(current2);
                                    Object var5_7 = null;
                                    break block4;
                                }
                                current2 = -1;
                                break block5;
                            }
                            int current3 = this.offset++;
                            c = this.line.charAt(current3);
                            break block6;
                        }
                        catch (Throwable throwable) {
                            Object var5_10 = null;
                            loggingLoc.exiting();
                            throw throwable;
                        }
                    }
                    loggingLoc.exiting();
                    return c2;
                }
                Object var5_8 = null;
                loggingLoc.exiting();
                return current2;
            }
            Object var5_9 = null;
            loggingLoc.exiting();
            return c;
        }

        private boolean hasNextLine() {
            String method = "hasNextLine()";
            try {
                boolean bl = this.lineIterator.hasNext();
                Object var4_3 = null;
                return bl;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw throwable;
            }
        }

        private String getNextLine() {
            String method = "getNextLine()";
            try {
                String string = ((RsaqldataType)((Object)this.lineIterator.next())).getLine();
                Object var4_3 = null;
                return string;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw throwable;
            }
        }
    }

    private class _SapqQueryInfo
    implements SapqQueryInfo {
        private final String query;
        private final String userGroup;
        private final Map selectMap;

        public _SapqQueryInfo(String query, String userGroup, Map selectMap) {
            this.query = query;
            this.userGroup = userGroup;
            this.selectMap = selectMap;
        }

        public String getQuery() {
            return this.query;
        }

        public String getUserGroup() {
            return this.userGroup;
        }

        public Map getSelectMap() {
            return this.selectMap;
        }
    }
}

