/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.sapq;

import com.sap.ip.bi.sdk.dac.connector.impl.AbstractManagedConnection;
import com.sap.ip.bi.sdk.dac.connector.impl.ConnectorConnection;
import com.sap.ip.bi.sdk.dac.connector.sapq.SapqConnection;
import com.sap.ip.bi.sdk.dac.connector.sapq.SapqConnectionProperties;
import com.sap.ip.bi.sdk.dac.connector.sapq.SapqManagedConnectionFactory;
import com.sap.ip.bi.sdk.dac.connector.sapq.SapqManagedConnectionMetaData;
import com.sap.ip.bi.sdk.dac.connector.sapq.impl.Connection;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import com.sap.ip.bi.sdk.util.BILoggingSetup;
import com.sap.ip.bi.sdk.util.impl.IBIMonitor;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;

public class SapqManagedConnection
extends AbstractManagedConnection
implements ManagedConnection {
    private static final boolean tracePrivateMethods = true;
    private static final Location loggingLoc = Location.getLocation((String)(class$com$sap$ip$bi$sdk$dac$connector$sapq$SapqManagedConnection == null ? (class$com$sap$ip$bi$sdk$dac$connector$sapq$SapqManagedConnection = SapqManagedConnection.class$("com.sap.ip.bi.sdk.dac.connector.sapq.SapqManagedConnection")) : class$com$sap$ip$bi$sdk$dac$connector$sapq$SapqManagedConnection).getName());
    private static final Category loggingCat = BILoggingSetup.CONNECTION.getCategory();
    private IBIMonitor monitor = null;
    protected SapqManagedConnectionFactory m_managedConnectionFactory;
    private SapqConnectionProperties m_request_info;
    private String user;
    private String passwd;
    protected Vector m_associated_connections = new Vector();
    protected Vector m_connection_listeners = null;
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$connector$sapq$SapqManagedConnection;

    protected SapqManagedConnection(SapqManagedConnectionFactory managed_connection_factory, Subject subject, SapqConnectionProperties request_info) throws ResourceException {
        String method = "SapqManagedConnection(SapqManagedConnectionFactory, Subject, SapqConnectionProperties)";
        loggingLoc.entering("SapqManagedConnection(SapqManagedConnectionFactory, Subject, SapqConnectionProperties)");
        try {
            this.m_managedConnectionFactory = managed_connection_factory;
            this.m_logWriter = managed_connection_factory.m_logWriter;
            this.m_subject = subject;
            this.m_request_info = request_info;
            try {
                Properties connProps = new Properties(managed_connection_factory.m_properties);
                if (subject != null) {
                    connProps.setProperty(SapqConnectionProperties.Parameter.USER.name, "");
                    connProps.setProperty(SapqConnectionProperties.Parameter.PASSWD.name, "");
                } else if (request_info != null && request_info.m_properties != null) {
                    Enumeration e = ((Hashtable)request_info.m_properties).keys();
                    while (e.hasMoreElements()) {
                        String key = (String)e.nextElement();
                        connProps.setProperty(key, request_info.getProperty(key));
                    }
                }
                this.connection = Connection.connect(connProps, this);
                this.connectionInfo = this.connection.getConnectionInfo();
            }
            catch (Exception ex) {
                throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.connector_1100", (Throwable)ex);
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean equals(SapqManagedConnectionFactory managed_connection_factory, Subject subject, SapqConnectionProperties request_info) throws ResourceException {
        boolean bl;
        block10: {
            boolean bl2;
            block9: {
                boolean bl3;
                block8: {
                    boolean bl4;
                    block7: {
                        boolean bl5;
                        block6: {
                            String method = "equals(SapqManagedConnectionFactory, Subject, SapqConnectionProperties)";
                            loggingLoc.entering("equals(SapqManagedConnectionFactory, Subject, SapqConnectionProperties)");
                            try {
                                if (this.m_subject != null && subject == null || this.m_subject == null && subject != null) {
                                    bl5 = false;
                                    Object var9_6 = null;
                                    break block6;
                                }
                                if (this.m_subject != null && !this.m_subject.equals(subject)) {
                                    bl4 = false;
                                    break block7;
                                }
                                if (managed_connection_factory != null && !this.m_managedConnectionFactory.equals(managed_connection_factory)) {
                                    bl3 = false;
                                    break block8;
                                }
                                if (subject == null && !this.compareProperties(request_info)) {
                                    bl2 = false;
                                    break block9;
                                }
                                bl = true;
                                break block10;
                            }
                            catch (Throwable throwable) {
                                Object var9_11 = null;
                                loggingLoc.exiting();
                                throw throwable;
                            }
                        }
                        loggingLoc.exiting();
                        return bl5;
                    }
                    Object var9_7 = null;
                    loggingLoc.exiting();
                    return bl4;
                }
                Object var9_8 = null;
                loggingLoc.exiting();
                return bl3;
            }
            Object var9_9 = null;
            loggingLoc.exiting();
            return bl2;
        }
        Object var9_10 = null;
        loggingLoc.exiting();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean compareProperties(SapqConnectionProperties other) throws ResourceException {
        boolean bl;
        block9: {
            boolean bl2;
            block8: {
                String method = "compareProperties(SapqConnectionProperties)";
                loggingLoc.entering("compareProperties(SapqConnectionProperties)");
                try {
                    SapqConnectionProperties request_info = null;
                    request_info = other == null ? new SapqConnectionProperties(this.m_managedConnectionFactory.m_properties) : other;
                    if (request_info.m_properties == null) {
                        request_info.m_properties = this.m_managedConnectionFactory.m_properties;
                    }
                    if (((Hashtable)this.connection.getProperties()).size() < ((Hashtable)request_info.m_properties).size()) {
                        bl2 = false;
                        Object var12_5 = null;
                        break block8;
                    }
                    boolean is_equal = true;
                    Enumeration keys = ((Hashtable)this.connection.getProperties()).keys();
                    while (true) {
                        if (!keys.hasMoreElements() || !is_equal) {
                            bl = is_equal;
                            break block9;
                        }
                        String key = (String)keys.nextElement();
                        String valueMC = this.connection.getProperty(key);
                        String valueNew = request_info.m_properties.getProperty(key);
                        loggingLoc.debugT(loggingCat, "key:" + key + "valueMC:" + valueMC + "valueNew:" + valueNew);
                        if (valueMC != null && valueMC.length() > 0 && (valueNew == null || valueNew.length() == 0)) {
                            is_equal = false;
                            continue;
                        }
                        if ((valueMC == null || valueMC.length() == 0) && valueNew != null && valueNew.length() > 0) {
                            is_equal = false;
                            continue;
                        }
                        if (valueMC == null || valueNew == null || valueMC.equals(valueNew)) continue;
                        is_equal = false;
                    }
                }
                catch (Throwable throwable) {
                    Object var12_7 = null;
                    loggingLoc.exiting();
                    throw throwable;
                }
            }
            loggingLoc.exiting();
            return bl2;
        }
        Object var12_6 = null;
        loggingLoc.exiting();
        return bl;
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo info) throws ResourceException {
        SapqConnection sapqConnection;
        String method = "getConnection(Subject, ConnectionRequestInfo)";
        loggingLoc.entering("getConnection(Subject, ConnectionRequestInfo)");
        try {
            this.assertConnection();
            sapqConnection = new SapqConnection(this);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return sapqConnection;
    }

    public void cleanup() throws ResourceException {
        String method = "cleanup()";
        loggingLoc.entering("cleanup()");
        try {
            Vector vector = this.m_associated_connections;
            synchronized (vector) {
                Vector list = (Vector)this.m_associated_connections.clone();
                int num_connections = list.size();
                int i = 0;
                while (i < num_connections) {
                    ((SapqConnection)((Object)list.elementAt(i))).dissociateManagedConnection();
                    ++i;
                }
                this.m_associated_connections.removeAllElements();
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public void associateConnection(Object connection) throws ResourceException {
        String method = "associateConnection(Object)";
        loggingLoc.entering("associateConnection(Object)");
        try {
            if (connection == null) {
                throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.connector_1101");
            }
            if (!(connection instanceof SapqConnection)) {
                throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.connector_1007", new Object[]{connection.getClass().toString()});
            }
            this.assertConnection();
            ((SapqConnection)((Object)connection)).associateConnection(this);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        SapqManagedConnectionMetaData sapqManagedConnectionMetaData;
        String method = "getMetaData()";
        loggingLoc.entering("getMetaData()");
        try {
            this.assertConnection();
            sapqManagedConnectionMetaData = new SapqManagedConnectionMetaData(this);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return sapqManagedConnectionMetaData;
    }

    public SapqManagedConnectionFactory getManagedConnectionFactory() {
        SapqManagedConnectionFactory sapqManagedConnectionFactory;
        String method = "getManagedConnectionFactory()";
        loggingLoc.entering("getManagedConnectionFactory()");
        try {
            sapqManagedConnectionFactory = this.m_managedConnectionFactory;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return sapqManagedConnectionFactory;
    }

    protected void unregisterConnection(SapqConnection connection) {
        String method = "unregisterConnection(SapqConnection)";
        loggingLoc.entering("unregisterConnection(SapqConnection)");
        try {
            this.m_associated_connections.removeElement((Object)connection);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    protected ConnectorConnection getConnection() throws BIResourceException {
        return super.getConnection();
    }

    protected void fireConnectionClosedEvent(javax.resource.cci.Connection connection) throws BIResourceException {
        super.fireConnectionClosedEvent(connection);
    }

    protected void fireConnectErrorOccurredEvent(javax.resource.cci.Connection connection) throws BIResourceException {
        super.fireConnectErrorOccurredEvent(connection);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

