/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.sapq;

import com.sap.ip.bi.sdk.dac.connector.impl.BIConnectionConstants;
import com.sap.ip.bi.sdk.dac.connector.sapq.SapqConnectionConstants;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.resource.cci.ConnectionSpec;
import javax.resource.spi.ConnectionRequestInfo;

public class SapqConnectionProperties
implements ConnectionSpec,
ConnectionRequestInfo,
Serializable,
Cloneable {
    protected Properties m_properties = new Properties();

    public SapqConnectionProperties() {
    }

    public SapqConnectionProperties(Properties properties) {
        Enumeration keys = ((Hashtable)properties).keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            this.setProperty(key, properties.getProperty(key));
        }
    }

    public SapqConnectionProperties(String username, String password, String language) {
        this.setProperty(Parameter.USER.name, username);
        this.setProperty(Parameter.PASSWD.name, password);
        this.setProperty(Parameter.LANG.name, language);
    }

    protected final void setProperty(String key, String value) {
        if (((Hashtable)this.m_properties).get(key) != null) {
            ((Hashtable)this.m_properties).remove(key);
        }
        if (value != null) {
            this.m_properties.setProperty(key, value);
        }
    }

    protected final String getProperty(String key) {
        return this.m_properties.getProperty(key);
    }

    public Object clone() {
        return new SapqConnectionProperties(this.m_properties);
    }

    public String getUserName() {
        return this.getProperty(Parameter.USER.name);
    }

    public void setUserName(String user) {
        this.setProperty(Parameter.USER.name, user);
    }

    public String getPassword() {
        return this.getProperty(Parameter.PASSWD.name);
    }

    public void setPassword(String password) {
        this.setProperty(Parameter.PASSWD.name, password);
    }

    public final String getLanguage() {
        return this.getProperty(Parameter.LANG.name);
    }

    public final void setLanguage(String language) {
        this.setProperty(Parameter.LANG.name, language);
    }

    public final String getQueryArea() {
        return this.getProperty(Parameter.QUERYAREA.name);
    }

    public final void setQueryArea(String queryArea) {
        this.setProperty(Parameter.QUERYAREA.name, queryArea);
    }

    public final String getClient() {
        return this.getProperty(Parameter.CLIENT.name);
    }

    public final void setClient(String client) {
        this.setProperty(Parameter.CLIENT.name, client);
    }

    public final String getMessageServer() {
        return this.getProperty(Parameter.MESSAGESERVER.name);
    }

    public final void setMessageServer(String msgServer) {
        this.setProperty(Parameter.MESSAGESERVER.name, msgServer);
    }

    public final String getApplicationServer() {
        return this.getProperty(Parameter.APPLICATIONSERVER.name);
    }

    public final void setApplicationServer(String appServer) {
        this.setProperty(Parameter.APPLICATIONSERVER.name, appServer);
    }

    public final String getSystemNumber() {
        return this.getProperty(Parameter.SYSTEMNUMBER.name);
    }

    public final void setSystemNumber(String sysNumber) {
        this.setProperty(Parameter.SYSTEMNUMBER.name, sysNumber);
    }

    public final String getServerGroup() {
        return this.getProperty(Parameter.SERVERGROUP.name);
    }

    public final void setServerGroup(String serverGroup) {
        this.setProperty(Parameter.SERVERGROUP.name, serverGroup);
    }

    public final String getR3Name() {
        return this.getProperty(Parameter.R3NAME.name);
    }

    public final void setR3Name(String r3Name) {
        this.setProperty(Parameter.R3NAME.name, r3Name);
    }

    public final String getRFCTrace() {
        return this.getProperty(Parameter.RFCTRACE.name);
    }

    public final void setRFCTrace(String rfcTrace) {
        this.setProperty(Parameter.RFCTRACE.name, rfcTrace);
    }

    public final String getSNCMode() {
        return this.getProperty(Parameter.SNCMODE.name);
    }

    public final void setSNCMode(String sncMode) {
        this.setProperty(Parameter.SNCMODE.name, sncMode);
    }

    public final String getSNCPartner() {
        return this.getProperty(Parameter.SNCPARTNER.name);
    }

    public final void setSNCPartner(String sncPartner) {
        this.setProperty(Parameter.SNCPARTNER.name, sncPartner);
    }

    public final String getSNCLevel() {
        return this.getProperty(Parameter.SNCLEVEL.name);
    }

    public final void setSNCLevel(String sncLevel) {
        this.setProperty(Parameter.SNCLEVEL.name, sncLevel);
    }

    public int hashCode() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < Parameter.m_num_parameters) {
            String value;
            Parameter p = Parameter.m_parameters[i];
            if (p != null && (value = this.m_properties.getProperty(p.name)) != null) {
                sb.append(value);
            }
            ++i;
        }
        return sb.toString().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof SapqConnectionProperties)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        SapqConnectionProperties obj = (SapqConnectionProperties)other;
        if (((Hashtable)this.m_properties).size() != ((Hashtable)obj.m_properties).size()) {
            return false;
        }
        boolean is_equal = true;
        Enumeration keys = ((Hashtable)this.m_properties).keys();
        while (keys.hasMoreElements() && is_equal) {
            String key = (String)keys.nextElement();
            String value1 = this.m_properties.getProperty(key);
            String value2 = obj.m_properties.getProperty(key);
            if (value1 == null && value2 != null) {
                is_equal = false;
                continue;
            }
            if (value1 != null && value2 == null) {
                is_equal = false;
                continue;
            }
            if (value1.equals(value2)) continue;
            is_equal = false;
        }
        return is_equal;
    }

    public static class Parameter
    implements Serializable {
        protected static Parameter[] m_parameters = new Parameter[15];
        public static final Parameter USER = new Parameter(BIConnectionConstants.USERNAME);
        public static final Parameter PASSWD = new Parameter(BIConnectionConstants.PASSWORD);
        public static final Parameter LANG = new Parameter(BIConnectionConstants.LANGUAGE);
        public static final Parameter QUERYAREA = new Parameter(SapqConnectionConstants.QUERYAREA);
        public static final Parameter CLIENT = new Parameter(SapqConnectionConstants.CLIENT);
        public static final Parameter MESSAGESERVER = new Parameter(SapqConnectionConstants.MESSAGESERVER);
        public static final Parameter APPLICATIONSERVER = new Parameter(SapqConnectionConstants.APPLICATIONSERVER);
        public static final Parameter SYSTEMNUMBER = new Parameter(SapqConnectionConstants.SYSTEMNUMBER);
        public static final Parameter SERVERGROUP = new Parameter(SapqConnectionConstants.SERVERGROUP);
        public static final Parameter R3NAME = new Parameter(SapqConnectionConstants.R3NAME);
        public static final Parameter RFCTRACE = new Parameter(SapqConnectionConstants.RFCTRACE);
        public static final Parameter SNCMODE = new Parameter(SapqConnectionConstants.SNCMODE);
        public static final Parameter SNCPARTNER = new Parameter(SapqConnectionConstants.SNCPARTNER);
        public static final Parameter SNCLEVEL = new Parameter(SapqConnectionConstants.SNCLEVEL);
        private static int m_num_parameters = 0;
        public final String name;

        protected Parameter(BIConnectionConstants name) {
            this(name.toString());
        }

        protected Parameter(String name) {
            Parameter parameter = this;
            synchronized (parameter) {
                this.name = name;
                if (m_parameters.length < ++m_num_parameters) {
                    Parameter[] old = m_parameters;
                    m_parameters = new Parameter[m_num_parameters];
                    System.arraycopy(old, 0, m_parameters, 0, old.length);
                }
                Parameter.m_parameters[Parameter.m_num_parameters - 1] = this;
            }
        }

        public String toString() {
            return this.name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof Parameter)) {
                return false;
            }
            return this.name.equals(((Parameter)other).name);
        }
    }
}

