#!/bin/perl

use Archive::Zip qw( :ERROR_CODES :CONSTANTS );
use File::Find;
use Cwd;

#################################################
# DELETE THE NOT NEEDED DUMMY FILES 
#################################################
# get the currend working directory
my $dir = getcwd;

# first find all dummy files that are in the wrong directory (copied by WinRunner)
find(\&delete, $dir);

# delete the not needed files
sub delete 
{
	if (/^dummy\.txt$/)
	{
		if ($File::Find::name =~ /\/QTR\/T[0-9]+\/exp\/dummy_for_wrunzip\.pl\.txt/)
		{
			unlink $File::Find::name;
		}
	}
}

#################################################
# CREATE THE ZIP FILE
#################################################
# create a new zip-file
my $zip = Archive::Zip->new();

# add all winrunner scripts
my $pred1 = sub { /script$/ };
$zip->addTree( '.', '', $pred1 );

# add crvx.asc for every test
my $pred2 = sub { /crvx\.asc$/ };
$zip->addTree( '.', '', $pred2 );

# add tm.asc for every test
my $pred3 = sub { /tm\.asc$/ };
$zip->addTree( '.', '', $pred3 );

# add the dummy_for_wrunzip.pl.txt to archive (used to include the exp directory)
 my $pred4 = sub { /dummy\.txt$/ };
$zip->addTree( '.', '', $pred4 );

# add all .gui file located in the GUIFiles directory
my $pred5 = sub { /\.gui$/ };
$zip->addTree( 'GUIFiles', 'GUIFiles', $pred5 );

# add this script to the zip file
$zip->addFile( ".\\wrunzip.pl" );

# add webdbmtests.cfg to the zip file
$zip->addFile( ".\\dbmguitests.cfg" );

# add pskill.exe to the zip file
$zip->addFile( ".\\pskill.exe" );

# add filldata.exe to the zip file
$zip->addFile( ".\\Fill\\filldata.exe" );

# add filllog.exe to the zip file
$zip->addFile( ".\\Fill\\filllog.exe" );

# write out the zip file
die 'write error' unless $zip->writeToFileNamed( 'DBMGUI.zip' ) == AZ_OK;
