/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.util;

import com.sap.sdb.syncMan.SyncManThread;
import java.util.LinkedList;

public abstract class SyncManQueue {
    private LinkedList m_lList = new LinkedList();
    private String m_ID;

    protected SyncManQueue() {
        this.m_ID = Integer.toString(this.hashCode());
    }

    protected SyncManQueue(String id) {
        this.m_ID = id;
    }

    public String getID() {
        return this.m_ID;
    }

    protected synchronized Object popInternal() throws InterruptedException {
        while (this.getQueueSize() == 0) {
            Thread thr = Thread.currentThread();
            if (thr instanceof SyncManThread) {
                ((SyncManThread)thr).waitSemaphore(this, 0L, this.m_ID);
                continue;
            }
            this.wait();
        }
        return this.removeFirstObject();
    }

    protected synchronized Object popInternal(long timeout) throws Exception {
        long start;
        if (timeout == 0L) {
            return this.popInternal();
        }
        long current = start = System.currentTimeMillis();
        while (this.getQueueSize() == 0 && current - start < timeout) {
            Thread thr = Thread.currentThread();
            if (thr instanceof SyncManThread) {
                ((SyncManThread)thr).waitSemaphore(this, timeout - (current - start), this.m_ID);
            } else {
                this.wait(timeout - (current - start));
            }
            current = System.currentTimeMillis();
        }
        if (this.getQueueSize() == 0) {
            throw new Exception("Timeout expired in Queue <" + this.m_ID + ">.");
        }
        return this.removeFirstObject();
    }

    protected synchronized void pushInternal(Object obj) {
        this.appendObject(obj);
        this.notify();
    }

    public synchronized boolean isEmpty() {
        return this.getQueueSize() == 0;
    }

    public int getQueueSize() {
        return this.m_lList.size();
    }

    public void clear() {
        this.m_lList.clear();
    }

    private void appendObject(Object obj) {
        this.m_lList.addLast(obj);
    }

    private Object removeFirstObject() {
        return this.m_lList.removeFirst();
    }
}

