/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.util;

import com.sap.sdb.syncMan.SyncService;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class CreateSyncManTables {
    private int m_database = 0;
    private String m_jdbcDriver;
    private String m_schema;
    private boolean m_noecho;
    private String m_numericType;
    private String m_columnCodeTypeChar;
    private String m_columnCodeTypeByte;
    private String m_columnNotNull;
    private Connection m_connection = null;
    private static final int MAXDB = 1;
    private static final int MINDB = 2;
    private static final int MYSQL = 3;
    private static final String lineSep = System.getProperty("line.separator", "\r\n");

    public CreateSyncManTables(Connection con, String jdbcDriver, String schema, boolean noecho, boolean createDesignTables, boolean createRunTimeTables) throws ClassNotFoundException, SQLException {
        this.m_connection = con;
        this.m_noecho = noecho;
        this.m_schema = schema;
        this.m_jdbcDriver = jdbcDriver;
        this.install(createDesignTables, createRunTimeTables);
    }

    public void dropSchema() throws SQLException {
        try {
            Statement stmt = this.m_connection.createStatement();
            if (!this.m_noecho) {
                System.out.println();
            }
            System.out.println("drop tables ...");
            this.dropTable(stmt, "REPLICATION_CLIENT_CONSTRAINT");
            this.dropTable(stmt, "REPLICATION_TABLE_COLUMNS");
            this.dropTable(stmt, "REPLICATION_TABLES");
            this.dropTable(stmt, "REPLICATION_TRANSACTION_LIST");
            this.dropTable(stmt, "REPLICATION_UNITS");
            this.dropTable(stmt, "REPLICATION_IGNORE_LIST");
            this.dropTable(stmt, "REPLICATION_DROPPED_TRIGGERS");
            this.dropTable(stmt, "REPLICATION_TABLE_VERSIONS");
            if (this.m_database == 1) {
                this.dropTable(stmt, "RD_REP_TABLE");
                this.dropTable(stmt, "RD_PARTICIPANT");
                this.dropTable(stmt, "RD_PARTICIPANT_CONFIG");
                this.dropTable(stmt, "RD_PARTICIPANT_TABLE");
                this.dropTable(stmt, "RD_TABLE_COLUMN");
                this.dropTable(stmt, "RD_TABLE_COLUMN_GROUP");
                this.dropTable(stmt, "RD_PARTICIPANT_AUTH");
                this.dropTable(stmt, "RD_TABLE_VERSIONS");
            }
            if (this.m_database == 1) {
                String sql = "DROP dbproc \"" + this.m_schema + "\"." + "DROPPED_SYSTEM_TRIGGERS";
                if (!this.m_noecho) {
                    System.out.println("   " + sql);
                }
                this.executeIgnoreError(stmt, sql);
                sql = "DROP SEQUENCE + \"" + this.m_schema + "\"." + "REPLICATION_ID";
                if (!this.m_noecho) {
                    System.out.println("   " + sql);
                }
                this.executeIgnoreError(stmt, sql);
            }
            this.m_connection.commit();
            System.out.println("... tables dropped.");
        }
        catch (SQLException ex) {
            this.m_connection.rollback();
            throw new SQLException(ex.toString());
        }
        finally {
            this.m_connection.close();
        }
    }

    private void createMetaTables(boolean createDesignTables, boolean createRunTimeTables) throws SQLException {
        try {
            Statement stmt;
            block17: {
                stmt = this.m_connection.createStatement();
                this.m_connection.setAutoCommit(false);
                if (!this.m_noecho) {
                    System.out.println();
                    System.out.println("creating database objects ...");
                }
                this.createSchema(stmt);
                if (createRunTimeTables) {
                    String sql;
                    block16: {
                        this.createTable(stmt, "REPLICATION_UNITS", "UNIT_ID " + this.m_numericType + " (20) " + this.m_columnNotNull + ", " + "UNIT_NAME" + " CHAR (100) " + this.m_columnNotNull + ", " + "UNIT_TYPE" + " " + this.m_numericType + "  (1) " + this.m_columnNotNull + ", " + "IS_MASTER" + " " + this.m_numericType + "  (1) " + this.m_columnNotNull + ", " + "INBOUND_DEST_ID" + " CHAR (100) " + this.m_columnCodeTypeChar + ", " + "UNIT_INBOUND_DEST_PASS" + " CHAR (100) " + this.m_columnCodeTypeChar + ", " + "OUTBOUND_DEST_ID" + " CHAR (100) " + this.m_columnCodeTypeChar + ", " + "UNIT_OUTBOUND_DEST_PASS" + " CHAR (100) " + this.m_columnCodeTypeChar + ", " + "INSTALLED_CLIENTS" + " " + this.m_numericType + " (10) , " + "UNIT_PROT" + " INTEGER " + this.m_columnNotNull + ", " + "PRIMARY KEY (" + "UNIT_ID" + ")");
                        this.createIndex(stmt, "REPLICATION_UNITS", "UNIT_NAME, IS_MASTER");
                        this.createTable(stmt, "REPLICATION_TABLES", "UNIT_ID " + this.m_numericType + " (20) " + this.m_columnNotNull + ", " + "TABLE_ID" + " " + this.m_numericType + " (20) " + this.m_columnNotNull + ", " + "TABLE_SCHEMA" + " CHAR (100) " + this.m_columnNotNull + ", " + "TABLE_NAME" + " CHAR (100) " + this.m_columnNotNull + ", " + "SHADOW_TABLE_NAME" + " CHAR (100) , " + "VERSION_TABLE_NAME" + " CHAR (100) , " + "AUDIT_TABLE_NAME" + " CHAR (100) , " + "PRIMARY KEY (" + "UNIT_ID" + ", " + "TABLE_ID" + ")");
                        this.createIndex(stmt, "REPLICATION_TABLES", "UNIT_ID, TABLE_SCHEMA, TABLE_NAME");
                        this.createTable(stmt, "REPLICATION_TABLE_COLUMNS", "UNIT_ID " + this.m_numericType + " (20) " + this.m_columnNotNull + ", " + "TABLE_ID" + " " + this.m_numericType + " (20) " + this.m_columnNotNull + ", " + "COLUMN_ID" + " " + this.m_numericType + " (20) " + this.m_columnNotNull + ", " + "COLUMN_NAME" + " CHAR (100) " + this.m_columnNotNull + ", " + "SQL_TYPE" + " " + this.m_numericType + "  (5) " + this.m_columnNotNull + ", " + "COL_PRECISION" + " " + this.m_numericType + "  (5) " + this.m_columnNotNull + ", " + "SCALE" + " " + this.m_numericType + "  (5) " + this.m_columnNotNull + ", " + "key_pos" + " " + this.m_numericType + "  (3) " + this.m_columnNotNull + ", " + "column_group_id" + " " + this.m_numericType + " (20) " + this.m_columnNotNull + ", " + "column_group_versioned" + " " + this.m_numericType + "  (1) " + this.m_columnNotNull + ", " + "PRIMARY KEY (" + "UNIT_ID" + ", " + "TABLE_ID" + ", " + "COLUMN_ID" + ")");
                        this.createIndex(stmt, "REPLICATION_TABLE_COLUMNS", "UNIT_ID, TABLE_ID, COLUMN_NAME");
                        this.createTable(stmt, "REPLICATION_CLIENT_CONSTRAINT", "CLIENT_ID " + this.m_numericType + " (20) " + this.m_columnNotNull + ", " + "TABLE_ID" + " " + this.m_numericType + " (20) " + this.m_columnNotNull + ", " + "COLUMN_ID" + " " + this.m_numericType + " (20) " + this.m_columnNotNull + ", " + "CONSTRAINT_TYPE" + " " + this.m_numericType + "  (3) " + this.m_columnNotNull + ", " + "CONSTRAINT_VALUE1" + " CHAR (255) " + this.m_columnNotNull + ", " + "CONSTRAINT_VALUE2" + " CHAR (255), " + "PRIMARY KEY (" + "CLIENT_ID" + ", " + "TABLE_ID" + ", " + "COLUMN_ID" + ")");
                        this.createTable(stmt, "REPLICATION_TRANSACTION_LIST", "REP_TRANSID CHAR   (6) " + this.m_columnCodeTypeByte + " " + this.m_columnNotNull + ", " + "TABLE_SCHEMA" + " CHAR (100) " + this.m_columnNotNull + ", " + "TABLE_NAME" + " CHAR (100) " + this.m_columnNotNull + ", " + "REP_SEQ" + " " + this.m_numericType + " (20) " + this.m_columnNotNull + ", " + "PRIMARY KEY (" + "REP_TRANSID" + ", " + "TABLE_SCHEMA" + ", " + "TABLE_NAME" + ")");
                        this.createTable(stmt, "REPLICATION_IGNORE_LIST", "UNIT_ID " + this.m_numericType + " (20) " + this.m_columnNotNull + ", " + "LAST_UPDATER" + " " + this.m_numericType + " (20) " + this.m_columnNotNull + ", " + "ROW_CREATOR" + " " + this.m_numericType + " (20) " + this.m_columnNotNull + ", " + "ROW_VERSION" + " " + this.m_numericType + " (20) " + this.m_columnNotNull + ", " + "REF_COUNT" + " " + this.m_numericType + " (10) " + this.m_columnNotNull + ", " + "PRIMARY KEY (" + "UNIT_ID" + ", " + "LAST_UPDATER" + ", " + "ROW_CREATOR" + ", " + "ROW_VERSION" + ")");
                        this.createTable(stmt, "REPLICATION_DROPPED_TRIGGERS", "DROP_TIME Timestamp " + this.m_columnNotNull + ", " + "TABLE_NAME" + " CHAR (100) " + this.m_columnNotNull + ", " + "TABLE_SCHEMA" + " CHAR (100) " + this.m_columnNotNull);
                        this.createTable(stmt, "REPLICATION_TABLE_VERSIONS", "TABLE_NAME CHAR (128) , VERSION CHAR (16) , PRIMARY KEY (TABLE_NAME)");
                        String version = SyncService.getVersion();
                        this.executeIgnoreError(stmt, "INSERT INTO \"" + this.m_schema + "\"." + "REPLICATION_TABLE_VERSIONS" + " VALUES ('" + "REPLICATION_CLIENT_CONSTRAINT" + "', '" + version + "')");
                        this.executeIgnoreError(stmt, "INSERT INTO \"" + this.m_schema + "\"." + "REPLICATION_TABLE_VERSIONS" + " VALUES ('" + "REPLICATION_TABLE_COLUMNS" + "', '" + version + "')");
                        this.executeIgnoreError(stmt, "INSERT INTO \"" + this.m_schema + "\"." + "REPLICATION_TABLE_VERSIONS" + " VALUES ('" + "REPLICATION_TABLES" + "', '" + version + "')");
                        this.executeIgnoreError(stmt, "INSERT INTO \"" + this.m_schema + "\"." + "REPLICATION_TABLE_VERSIONS" + " VALUES ('" + "REPLICATION_TRANSACTION_LIST" + "', '" + version + "')");
                        this.executeIgnoreError(stmt, "INSERT INTO \"" + this.m_schema + "\"." + "REPLICATION_TABLE_VERSIONS" + " VALUES ('" + "REPLICATION_UNITS" + "', '" + version + "')");
                        this.executeIgnoreError(stmt, "INSERT INTO \"" + this.m_schema + "\"." + "REPLICATION_TABLE_VERSIONS" + " VALUES ('" + "REPLICATION_IGNORE_LIST" + "', '" + version + "')");
                        this.executeIgnoreError(stmt, "INSERT INTO \"" + this.m_schema + "\"." + "REPLICATION_TABLE_VERSIONS" + " VALUES ('" + "REPLICATION_DROPPED_TRIGGERS" + "', '" + version + "')");
                        this.executeIgnoreError(stmt, "INSERT INTO \"" + this.m_schema + "\"." + "REPLICATION_TABLE_VERSIONS" + " VALUES ('" + "REPLICATION_TABLE_VERSIONS" + "', '" + version + "')");
                        if (this.m_database == 1) {
                            sql = "create dbproc \"" + this.m_schema + "\"." + "DROPPED_SYSTEM_TRIGGERS" + lineSep + " ( in schema    char(32), " + lineSep + " in tablename char(32)) " + lineSep + " as var " + lineSep + " stmt     CHAR(256); " + lineSep + " stmt = 'INSERT INTO \"" + this.m_schema + "\"." + "REPLICATION_DROPPED_TRIGGERS" + lineSep + "    VALUES (TIMESTAMP, ''' || " + lineSep + "    SCHEMA || ''',''' || TABLENAME || ''')';  " + lineSep + " EXECUTE stmt; " + lineSep + " IF $RC <> 0 " + lineSep + " THEN " + lineSep + "     STOP ($RC); ";
                            if (!this.m_noecho) {
                                System.out.println("   " + sql);
                            }
                            try {
                                stmt.execute(sql);
                                System.out.println("created dbproc DROPPED_SYSTEM_TRIGGERS");
                            }
                            catch (SQLException ex) {
                                if (ex.getErrorCode() == -6006) break block16;
                                throw ex;
                            }
                        }
                    }
                    if (this.m_database == 1 || this.m_database == 2) {
                        sql = "";
                        if (this.m_database == 1) {
                            sql = "create sequence \"" + this.m_schema + "\"." + "REPLICATION_ID" + " increment by 1 nominvalue maxvalue 9223372036854775807 nocycle cache 1000";
                        }
                        if (this.m_database == 2) {
                            sql = "create sequence \"" + this.m_schema + "\"." + "REPLICATION_ID";
                        }
                        if (!this.m_noecho) {
                            System.out.println("   " + sql);
                        }
                        try {
                            stmt.execute(sql);
                            System.out.println("created sequence REPLICATION_ID");
                        }
                        catch (SQLException ex) {
                            if (ex.getErrorCode() == -6006 || ex.getErrorCode() == -6000) break block17;
                            throw ex;
                        }
                    }
                }
            }
            if (this.m_database == 1 && createDesignTables) {
                this.createDesignTables(stmt);
            }
            this.m_connection.commit();
            if (!this.m_noecho) {
                System.out.println("... all created.");
            }
        }
        catch (SQLException ex) {
            this.m_connection.rollback();
            throw new SQLException(ex.toString());
        }
    }

    private void createDesignTables(Statement stmt) throws SQLException {
        this.createTable(stmt, "RD_PARTICIPANT", "design_id        " + this.m_numericType + " (20) " + this.m_columnNotNull + ", " + "participant_id   " + this.m_numericType + " (20) " + this.m_columnNotNull + ", " + "participant_name CHAR (128) " + this.m_columnNotNull + ", " + "participant_type " + this.m_numericType + "  (1) " + this.m_columnNotNull + ", " + "server_node      CHAR (128) " + this.m_columnNotNull + ", " + "data_base        CHAR (128) " + this.m_columnNotNull + ", " + "rep_user         CHAR (128) " + this.m_columnNotNull + ", " + "rep_password     CHAR (128) " + this.m_columnNotNull + ", " + "is_master        " + this.m_numericType + "  (1) " + this.m_columnNotNull + ", " + "is_installed     " + this.m_numericType + "  (1) " + this.m_columnNotNull + ", " + "PARTICPANT_PROT" + " INTEGER " + this.m_columnNotNull + ", " + "PRIMARY KEY (participant_id)");
        this.createIndexEx(stmt, "INDEX_RD_PARTICIPANT_1", "RD_PARTICIPANT", "participant_name, design_id");
        this.createIndexEx(stmt, "INDEX_RD_PARTICIPANT_2", "RD_PARTICIPANT", "participant_name, server_node, data_base");
        this.createTable(stmt, "RD_PARTICIPANT_TABLE", "DESIGN_ID " + this.m_numericType + " (20) " + this.m_columnNotNull + ", " + "participant_id  " + this.m_numericType + " (20) " + this.m_columnNotNull + ", " + "rep_table_id   " + this.m_numericType + " (20) " + this.m_columnNotNull + ", " + "table_id        " + this.m_numericType + " (20) " + this.m_columnNotNull + ", " + "table_server\t   CHAR (128) " + this.m_columnNotNull + ", " + "table_database  CHAR (128) " + this.m_columnNotNull + ", " + "table_schema    CHAR (64) " + this.m_columnNotNull + ", " + "table_name      CHAR (64) " + this.m_columnNotNull + ", " + "is_master_table " + this.m_numericType + "  (1) " + this.m_columnNotNull + ", " + "PRIMARY KEY (design_id, participant_id, table_id)");
        this.createIndex(stmt, "RD_PARTICIPANT_TABLE", "table_server,table_database,table_schema, table_name, participant_id");
        this.createTable(stmt, "RD_PARTICIPANT_CONFIG", "server_node CHAR (128) " + this.m_columnNotNull + ", " + "data_base   CHAR (128) " + this.m_columnNotNull + ", " + "use_ssl " + this.m_numericType + "  (1) " + this.m_columnNotNull + ", " + "jdbc_driver CHAR (255) " + this.m_columnNotNull + ", " + "PRIMARY KEY (server_node, data_base)");
        this.createTable(stmt, "RD_PARTICIPANT_AUTH", "DESIGN_ID " + this.m_numericType + " (20) " + this.m_columnNotNull + ", " + "RD_DEST_IS_QUEUE" + " " + this.m_numericType + "  (1) " + this.m_columnNotNull + ", " + "RD_DEST_READ_PASS" + " CHAR (100) , " + "RD_DEST_WRITE_PASS" + " CHAR (100) , " + "PRIMARY KEY (" + "DESIGN_ID" + "," + "RD_DEST_IS_QUEUE" + ")");
        this.createTable(stmt, "RD_TABLE_VERSIONS", "TABLE_NAME CHAR (128) , VERSION CHAR (16) , PRIMARY KEY (TABLE_NAME)");
        this.createTable(stmt, "RD_REP_TABLE", "rep_table_server CHAR (128) " + this.m_columnNotNull + ", " + "rep_table_database CHAR (128) " + this.m_columnNotNull + ", " + "rep_table_schema CHAR (64) " + this.m_columnNotNull + ", " + "rep_table_name  CHAR (64) " + this.m_columnNotNull + ", " + "rep_table_id    " + this.m_numericType + " (20) " + this.m_columnNotNull + ", " + "PRIMARY KEY (rep_table_id)");
        this.createIndex(stmt, "RD_REP_TABLE", "rep_table_server,rep_table_database,rep_table_schema, rep_table_name");
        this.createTable(stmt, "RD_TABLE_COLUMN_GROUP", "participant_id    " + this.m_numericType + " (20) " + this.m_columnNotNull + ", " + "table_id          " + this.m_numericType + " (20) " + this.m_columnNotNull + ", " + "column_group_id   " + this.m_numericType + " (20) " + this.m_columnNotNull + ", " + "column_group_name CHAR (128) " + this.m_columnNotNull + ", " + "has_keycols       " + this.m_numericType + "  (1) " + this.m_columnNotNull + ", " + "is_versioned      " + this.m_numericType + "  (1) " + this.m_columnNotNull + ", " + "for_replication   " + this.m_numericType + "  (1) " + this.m_columnNotNull + ", " + "contains_blob     " + this.m_numericType + "  (1) " + this.m_columnNotNull + ", " + "PRIMARY KEY (participant_id,table_id,column_group_id)");
        this.createIndex(stmt, "RD_TABLE_COLUMN_GROUP", "participant_id, table_id, column_group_name");
        this.createTable(stmt, "RD_TABLE_COLUMN", "PARTICIPANT_ID  " + this.m_numericType + "(20) " + this.m_columnNotNull + ", " + "TABLE_ID" + "  " + this.m_numericType + "(20) " + this.m_columnNotNull + ", " + "COLUMN_GROUP_ID" + "  " + this.m_numericType + "(20) " + this.m_columnNotNull + ", " + "COLUMN_ID" + "  " + this.m_numericType + "(20) " + this.m_columnNotNull + ", " + "COLUMN_NAME" + "  CHAR(128) " + this.m_columnNotNull + ", " + "SQL_TYPE" + "  " + this.m_numericType + " (5) " + this.m_columnNotNull + ", " + "TYPE_NAME" + "  CHAR (20) " + this.m_columnNotNull + ", " + "COL_PRECISION" + "  " + this.m_numericType + " (5) " + this.m_columnNotNull + ", " + "SCALE" + "  " + this.m_numericType + " (5) " + this.m_columnNotNull + ", " + "POS" + "  " + this.m_numericType + " (3) " + this.m_columnNotNull + ", " + "KEY_POS" + "  " + this.m_numericType + " (3) " + this.m_columnNotNull + ", " + "CONSTRAINT_TYPE" + "  " + this.m_numericType + " (3) " + this.m_columnNotNull + ", " + "CONSTRAINT_VALUE1" + "  CHAR(255) " + this.m_columnNotNull + ", " + "CONSTRAINT_VALUE2" + "  CHAR(255), " + "PRIMARY KEY (participant_id, " + "table_id," + "column_group_id, " + "column_id)");
        this.createIndex(stmt, "RD_TABLE_COLUMN", "participant_id, table_id, column_name");
        if (!this.m_noecho) {
            System.out.println("insert version values ...");
        }
        String version = SyncService.getVersion();
        this.executeIgnoreError(stmt, "INSERT INTO \"" + this.m_schema + "\"." + "RD_TABLE_VERSIONS" + " VALUES ('" + "RD_REP_TABLE" + "', '" + version + "')");
        this.executeIgnoreError(stmt, "INSERT INTO \"" + this.m_schema + "\"." + "RD_TABLE_VERSIONS" + " VALUES ('" + "RD_PARTICIPANT" + "', '" + version + "')");
        this.executeIgnoreError(stmt, "INSERT INTO \"" + this.m_schema + "\"." + "RD_TABLE_VERSIONS" + " VALUES ('" + "RD_PARTICIPANT_CONFIG" + "', '" + version + "')");
        this.executeIgnoreError(stmt, "INSERT INTO \"" + this.m_schema + "\"." + "RD_TABLE_VERSIONS" + " VALUES ('" + "RD_PARTICIPANT_TABLE" + "', '" + version + "')");
        this.executeIgnoreError(stmt, "INSERT INTO \"" + this.m_schema + "\"." + "RD_TABLE_VERSIONS" + " VALUES ('" + "RD_TABLE_COLUMN" + "', '" + version + "')");
        this.executeIgnoreError(stmt, "INSERT INTO \"" + this.m_schema + "\"." + "RD_TABLE_VERSIONS" + " VALUES ('" + "RD_TABLE_COLUMN_GROUP" + "', '" + version + "')");
        this.executeIgnoreError(stmt, "INSERT INTO \"" + this.m_schema + "\"." + "RD_TABLE_VERSIONS" + " VALUES ('" + "RD_PARTICIPANT_AUTH" + "', '" + version + "')");
        this.executeIgnoreError(stmt, "INSERT INTO \"" + this.m_schema + "\"." + "RD_TABLE_VERSIONS" + " VALUES ('" + "RD_TABLE_VERSIONS" + "', '" + version + "')");
    }

    private void createSchema(Statement stmt) throws SQLException {
        if (this.m_database == 3) {
            return;
        }
        String sql = "CREATE SCHEMA \"" + this.m_schema + "\"";
        if (!this.m_noecho) {
            System.out.println("   " + sql);
        }
        try {
            stmt.execute(sql);
        }
        catch (SQLException ex) {
            if (this.m_database == 1 || this.m_database == 2) {
                if (ex.getErrorCode() != -6006) {
                    throw ex;
                }
            }
            throw ex;
        }
    }

    private void createTable(Statement stmt, String tabname, String colSpec) throws SQLException {
        String sql = "CREATE TABLE ";
        if (this.m_database != 3) {
            sql = sql + "\"" + this.m_schema + "\".";
        }
        sql = sql + tabname + "(" + colSpec + ")";
        if (!this.m_noecho) {
            System.out.println("   " + sql);
        }
        try {
            stmt.execute(sql);
            System.out.println("created table " + tabname);
        }
        catch (SQLException ex) {
            if (this.m_database == 1 || this.m_database == 2) {
                if (ex.getErrorCode() != -6000) {
                    throw ex;
                }
            }
            if (this.m_database == 3) {
                if (ex.getErrorCode() != 1050) {
                    throw ex;
                }
            }
            throw ex;
        }
    }

    private void createIndex(Statement stmt, String tabname, String colSpec) throws SQLException {
        this.createIndexEx(stmt, "INDEX_" + tabname, tabname, colSpec);
    }

    private void createIndexEx(Statement stmt, String indexName, String tabname, String colSpec) throws SQLException {
        String sql = "CREATE UNIQUE INDEX " + indexName + " ON ";
        if (this.m_database != 3) {
            sql = sql + "\"" + this.m_schema + "\".";
        }
        sql = sql + tabname + "(" + colSpec + ")";
        if (!this.m_noecho) {
            System.out.println("   " + sql);
        }
        try {
            stmt.execute(sql);
            System.out.println("created index INDEX_" + tabname);
        }
        catch (SQLException ex) {
            if (this.m_database == 1 || this.m_database == 2) {
                if (ex.getErrorCode() != -6008 && ex.getErrorCode() != -7055) {
                    throw ex;
                }
            }
            if (this.m_database == 3) {
                if (ex.getErrorCode() != 1061) {
                    throw ex;
                }
            }
            throw ex;
        }
    }

    private void dropTable(Statement stmt, String tabname) {
        String sql = "DROP TABLE \"" + this.m_schema + "\"." + tabname;
        if (!this.m_noecho) {
            System.out.println("   " + sql);
        }
        this.executeIgnoreError(stmt, sql);
    }

    private void executeIgnoreError(Statement stmt, String cmd) {
        block2: {
            try {
                stmt.execute(cmd);
            }
            catch (SQLException e) {
                if (this.m_noecho) break block2;
                System.out.println(e.toString());
                System.out.println();
            }
        }
    }

    private void install(boolean createDesignTables, boolean createRunTimeTables) throws ClassNotFoundException, SQLException {
        if (!this.m_noecho) {
            System.out.println();
        }
        if (this.m_jdbcDriver.startsWith("com.sap.dbtech")) {
            this.m_database = 1;
        } else if (this.m_jdbcDriver.startsWith("com.sap.sdb.minDB")) {
            this.m_database = 2;
        } else if (this.m_jdbcDriver.startsWith("com.mysql.jdbc.Driver")) {
            this.m_database = 3;
        }
        switch (this.m_database) {
            case 1: {
                System.out.println("connecting to MaxDB ...");
                this.m_numericType = "FIXED";
                this.m_columnCodeTypeChar = "ASCII";
                this.m_columnCodeTypeByte = "BYTE";
                this.m_columnNotNull = "NOT NULL";
                break;
            }
            case 2: {
                System.out.println("connecting to MinDB ...");
                this.m_numericType = "FIXED";
                this.m_columnCodeTypeChar = "ASCII";
                this.m_columnCodeTypeByte = "BYTE";
                this.m_columnNotNull = "";
                break;
            }
            case 3: {
                System.out.println("connecting to MySQL ...");
                this.m_numericType = "DECIMAL";
                this.m_columnCodeTypeChar = "";
                this.m_columnCodeTypeByte = "BINARY";
                this.m_columnNotNull = "NOT NULL";
            }
        }
        Class.forName(this.m_jdbcDriver);
        this.createMetaTables(createDesignTables, createRunTimeTables);
    }
}

