/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.triggerMinDB;

import com.sap.sdb.minDB.triggerInterface.Trigger;
import com.sap.sdb.minDB.triggerInterface.TriggerConnection;
import com.sap.sdb.minDB.triggerInterface.TriggerImageSet;
import com.sap.sdb.minDB.triggerInterface.TriggerParamSet;
import com.sap.sdb.syncMan.triggerMinDB.ClientTrigger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

public class ClientUpdateTrigger
extends ClientTrigger
implements Trigger {
    private static final String STMT_INSERT_SHADOW_TAB_BEFORE = "insertShadowTabBefore";
    private static final String STMT_INSERT_SHADOW_TAB_AFTER = "insertShadowTabAfter";
    private static final String STMT_SELECT_VERSION_TAB = "selectVersionTab";
    private static final String STMT_UPDATE_VERSION_TAB_VERSIONED = "updateVersionTabVersioned";
    private static final String STMT_UPDATE_VERSION_TAB = "updateVersionTab";

    public void executeTrigger(TriggerConnection connection, HashMap prepStmtMap, TriggerParamSet param, TriggerImageSet image) throws SQLException {
        try {
            String keyCondition;
            String syncUser = param.getString("SYNCMAN_USER");
            String syncSchema = param.getString("SYNCMAN_SCHEMA");
            if (connection.getUsername().equals(syncUser)) {
                return;
            }
            int colCount = param.getInt("COLUMN_COUNT");
            int keyCount = param.getInt("KEY_COUNT");
            int beforeImage = param.getInt("BEFORE_IMAGE");
            int verCount = param.getInt("VER_COUNT");
            boolean verColChanged = false;
            long newColGoupVersion = -1L;
            String transID = Long.toString(connection.getTransactionID());
            String sequenceNo = super.getNextSequenceNo(connection, param, syncSchema);
            String updaterID = param.getString("UPDATER_ID");
            HashMap<String, String> keyCols = new HashMap<String, String>(keyCount);
            for (int i = 1; i <= keyCount; ++i) {
                int colIndex = image.findColumn(param.getString("KEY" + i));
                if (image.isUpdated(colIndex)) {
                    throw new SQLException("Replicated table not allowed: Primary Key Update", "", -7083);
                }
                String colName = image.getColumnName(colIndex);
                keyCols.put(colName, colName);
            }
            if (beforeImage == 0) {
                verColChanged = true;
            }
            byte[] change = new byte[colCount];
            block3: for (int i = 1; i <= colCount; ++i) {
                int colIndex = image.findColumn(param.getString("COL" + i));
                String colName = image.getColumnName(colIndex);
                if (keyCols.get(colName) == null) {
                    if (image.isUpdated(colIndex)) {
                        change[i - 1] = 1;
                        if (beforeImage != 1 || verColChanged) continue;
                        for (int j = 1; j <= verCount; ++j) {
                            int verColIndex = image.findColumn(param.getString("VER" + j));
                            if (verColIndex != colIndex) continue;
                            verColChanged = true;
                            continue block3;
                        }
                        continue;
                    }
                    change[i - 1] = -1;
                    continue;
                }
                change[i - 1] = image.isUpdated(colIndex) ? 1 : -1;
            }
            PreparedStatement insertShadowStmtBefore = (PreparedStatement)prepStmtMap.get(STMT_INSERT_SHADOW_TAB_BEFORE);
            PreparedStatement insertShadowStmtAfter = (PreparedStatement)prepStmtMap.get(STMT_INSERT_SHADOW_TAB_AFTER);
            PreparedStatement selectVersionStmt = (PreparedStatement)prepStmtMap.get(STMT_SELECT_VERSION_TAB);
            PreparedStatement updateVersionStmt = null;
            PreparedStatement updateVersionStmtVersioned = null;
            if (verColChanged) {
                updateVersionStmtVersioned = (PreparedStatement)prepStmtMap.get(STMT_UPDATE_VERSION_TAB_VERSIONED);
            } else {
                updateVersionStmt = (PreparedStatement)prepStmtMap.get(STMT_UPDATE_VERSION_TAB);
            }
            String string = keyCondition = selectVersionStmt == null || updateVersionStmt == null || updateVersionStmtVersioned == null ? super.buildKeyCondition(param, keyCount) : null;
            if (insertShadowStmtAfter == null) {
                insertShadowStmtAfter = this.prepareShadowTableInsertAfter(connection, param, syncSchema, colCount);
                prepStmtMap.put(STMT_INSERT_SHADOW_TAB_AFTER, insertShadowStmtAfter);
            }
            if (beforeImage == 1 && insertShadowStmtBefore == null) {
                insertShadowStmtBefore = this.prepareShadowTableInsertBefore(connection, param, syncSchema, colCount);
                prepStmtMap.put(STMT_INSERT_SHADOW_TAB_BEFORE, insertShadowStmtBefore);
            }
            if (selectVersionStmt == null) {
                selectVersionStmt = this.prepareVersionTableSelect(connection, param, syncSchema, keyCondition);
                prepStmtMap.put(STMT_SELECT_VERSION_TAB, selectVersionStmt);
            }
            if (updateVersionStmt == null && !verColChanged) {
                updateVersionStmt = this.prepareVersionTableUpdate(connection, param, syncSchema, keyCondition);
                prepStmtMap.put(STMT_UPDATE_VERSION_TAB, updateVersionStmt);
            }
            if (updateVersionStmtVersioned == null && verColChanged) {
                updateVersionStmtVersioned = this.prepareVersionTableUpdateVersioned(connection, param, syncSchema, keyCondition);
                prepStmtMap.put(STMT_UPDATE_VERSION_TAB_VERSIONED, updateVersionStmtVersioned);
            }
            this.setShadowTableColumnValues(insertShadowStmtAfter, param, image, colCount, false, keyCols);
            if (beforeImage == 1) {
                this.setShadowTableColumnValues(insertShadowStmtBefore, param, image, colCount, true, keyCols);
            }
            for (int i = 1; i <= keyCount; ++i) {
                int colIndex = image.findColumn(param.getString("KEY" + i));
                String currKeyValue = image.getOldString(colIndex);
                if (verColChanged) {
                    updateVersionStmtVersioned.setString(2 + i, currKeyValue);
                } else {
                    updateVersionStmt.setString(1 + i, currKeyValue);
                }
                selectVersionStmt.setString(i, currKeyValue);
            }
            ResultSet result = selectVersionStmt.executeQuery();
            result.next();
            String rowCreator = result.getString(1);
            String rowVersion = result.getString(2);
            long colGoupVersion = result.getLong(3);
            result.close();
            if (verColChanged) {
                newColGoupVersion = colGoupVersion + 1L;
                updateVersionStmtVersioned.setLong(1, newColGoupVersion);
                updateVersionStmtVersioned.setString(2, updaterID);
            } else {
                updateVersionStmt.setString(1, updaterID);
            }
            insertShadowStmtAfter.setString(colCount + 1, transID);
            insertShadowStmtAfter.setString(colCount + 2, sequenceNo);
            insertShadowStmtAfter.setBytes(colCount + 3, change);
            insertShadowStmtAfter.setString(colCount + 4, rowCreator);
            insertShadowStmtAfter.setString(colCount + 5, rowVersion);
            insertShadowStmtAfter.setString(colCount + 6, updaterID);
            insertShadowStmtAfter.setLong(colCount + 7, newColGoupVersion);
            insertShadowStmtAfter.executeUpdate();
            if (beforeImage == 1) {
                insertShadowStmtBefore.setString(colCount + 1, transID);
                insertShadowStmtBefore.setString(colCount + 2, sequenceNo);
                insertShadowStmtBefore.setLong(colCount + 3, colGoupVersion);
                insertShadowStmtBefore.executeUpdate();
            }
            if (verColChanged) {
                updateVersionStmtVersioned.executeUpdate();
            } else {
                updateVersionStmt.executeUpdate();
            }
            this.insertIntoTransList(connection, prepStmtMap, image, syncSchema, transID, sequenceNo);
        }
        catch (SQLException ex) {
            if (connection.isVerboseTrigger()) {
                connection.printStackTrace((Exception)ex);
            }
            throw ex;
        }
    }

    private PreparedStatement prepareShadowTableInsertAfter(TriggerConnection connection, TriggerParamSet param, String syncSchema, int colCount) throws SQLException {
        String colNames = "";
        String colParameters = "";
        for (int i = 1; i <= colCount; ++i) {
            colNames = colNames + "\"_" + param.getString("COL" + i) + "\", ";
            colParameters = colParameters + " ?,";
        }
        String sql = "INSERT INTO " + syncSchema + "." + param.getString("SHADOW_TABLE") + "(" + colNames + "REP_TRANSID, REP_COUNTER, REP_TYPE, " + "REP_CHANGE, ROW_CREATOR, ROW_VERSION, UPDATER_ID, " + "COL_GROUP_VERSION) VALUES (" + colParameters + " ?, ?, 1, ? ," + " ?, ?, ?," + " ?)";
        if (connection.isVerboseTrigger()) {
            connection.println(sql);
        }
        return connection.prepareStatement(sql);
    }

    private PreparedStatement prepareShadowTableInsertBefore(TriggerConnection connection, TriggerParamSet param, String syncSchema, int colCount) throws SQLException {
        String colNames = "";
        String colParameters = "";
        for (int i = 1; i <= colCount; ++i) {
            colNames = colNames + "\"_" + param.getString("COL" + i) + "\", ";
            colParameters = colParameters + " ?,";
        }
        String sql = "INSERT INTO " + syncSchema + "." + param.getString("SHADOW_TABLE") + "(" + colNames + "REP_TRANSID, REP_COUNTER, REP_TYPE, " + "REP_CHANGE, ROW_CREATOR, ROW_VERSION, UPDATER_ID, " + "COL_GROUP_VERSION) VALUES (" + colParameters + " ?, ?, 3, null, " + " null, null, null," + "?)";
        if (connection.isVerboseTrigger()) {
            connection.println(sql);
        }
        return connection.prepareStatement(sql);
    }

    private PreparedStatement prepareVersionTableSelect(TriggerConnection connection, TriggerParamSet param, String syncSchema, String keyCondition) throws SQLException {
        String sql = "SELECT ROW_CREATOR, ROW_VERSION,COL_GROUP_VERSION FROM " + syncSchema + "." + param.getString("VERSION_TABLE") + " WHERE " + keyCondition;
        if (connection.isVerboseTrigger()) {
            connection.println(sql);
        }
        return connection.prepareStatement(sql);
    }

    private PreparedStatement prepareVersionTableUpdate(TriggerConnection connection, TriggerParamSet param, String syncSchema, String keyCondition) throws SQLException {
        String sql = "UPDATE " + syncSchema + "." + param.getString("VERSION_TABLE") + " SET LAST_UPDATER=?" + " WHERE " + keyCondition;
        if (connection.isVerboseTrigger()) {
            connection.println(sql);
        }
        return connection.prepareStatement(sql);
    }

    private PreparedStatement prepareVersionTableUpdateVersioned(TriggerConnection connection, TriggerParamSet param, String syncSchema, String keyCondition) throws SQLException {
        String sql = "UPDATE " + syncSchema + "." + param.getString("VERSION_TABLE") + " SET COL_GROUP_VERSION=?" + ",LAST_UPDATER=?" + " WHERE " + keyCondition;
        if (connection.isVerboseTrigger()) {
            connection.println(sql);
        }
        return connection.prepareStatement(sql);
    }

    private void setShadowTableColumnValues(PreparedStatement prepStmt, TriggerParamSet param, TriggerImageSet image, int colCount, boolean before, HashMap keyCols) throws SQLException {
        block7: for (int i = 1; i <= colCount; ++i) {
            boolean colNull = false;
            int colIndex = image.findColumn(param.getString("COL" + i));
            int colType = image.getColumnType(colIndex);
            if (before) {
                if (image.isOldNull(colIndex)) {
                    prepStmt.setNull(i, colType);
                    colNull = true;
                }
            } else {
                boolean colChanged = false;
                String colName = image.getColumnName(colIndex);
                colChanged = keyCols.get(colName) != null ? true : image.isUpdated(colIndex);
                if (image.isNewNull(colIndex) || !colChanged) {
                    prepStmt.setNull(i, colType);
                    colNull = true;
                }
            }
            if (colNull) continue;
            switch (colType) {
                case -2: 
                case 2004: {
                    prepStmt.setBytes(i, before ? image.getOldBytes(colIndex) : image.getNewBytes(colIndex));
                    continue block7;
                }
                case 1: 
                case 2005: {
                    prepStmt.setString(i, before ? image.getOldString(colIndex) : image.getNewString(colIndex));
                    continue block7;
                }
                case 8: {
                    prepStmt.setDouble(i, before ? image.getOldDouble(colIndex) : image.getNewDouble(colIndex));
                    continue block7;
                }
                case 2: {
                    prepStmt.setLong(i, before ? image.getOldLong(colIndex) : image.getNewLong(colIndex));
                    continue block7;
                }
                case 2000: {
                    prepStmt.setObject(i, before ? image.getOldObject(colIndex) : image.getNewObject(colIndex));
                }
            }
        }
    }
}

