/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.definition;

import com.sap.sdb.syncMan.definition.DefinitionSQLHandler;
import com.sap.sdb.syncMan.definition.ReplicationUnit;
import com.sap.sdb.syncMan.util.ConnectionPool;
import com.sap.sdb.syncMan.util.SQLNames;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class ReplicationSchema
implements SQLNames {
    private Hashtable m_unitsByName = new Hashtable();
    private Hashtable m_inUnitsByName;
    private Hashtable m_outUnitsByName = new Hashtable();
    private boolean m_haveMaster;
    private Properties m_jndiProps;

    public ReplicationSchema(String[] unitRestriction, boolean noConsumption, Properties jndiProps) throws Exception {
        this.m_inUnitsByName = new Hashtable();
        this.m_jndiProps = jndiProps;
        DefinitionSQLHandler sqlhandler = DefinitionSQLHandler.createHandler();
        sqlhandler.loadSchema(this.m_unitsByName, unitRestriction, this, noConsumption);
        sqlhandler = null;
        this.m_haveMaster = false;
        Enumeration en = this.m_unitsByName.elements();
        while (en.hasMoreElements()) {
            ReplicationUnit unit = (ReplicationUnit)en.nextElement();
            boolean bl = this.m_haveMaster = this.m_haveMaster || unit.isMaster();
            if (unit.isOutbound()) {
                this.m_outUnitsByName.put(unit.getUnitName(), unit);
            }
            if (unit.isInbound()) {
                this.m_inUnitsByName.put(unit.getUnitName(), unit);
            }
            if (!unit.isInbound() || noConsumption) continue;
            unit.init();
        }
    }

    Properties getJndiProps() {
        return this.m_jndiProps;
    }

    public ReplicationUnit getInUnit(String unitName) {
        return (ReplicationUnit)this.m_inUnitsByName.get(unitName);
    }

    public int getInUnitCount() {
        return this.m_inUnitsByName.size();
    }

    public Enumeration getInUnitEnum() {
        return this.m_inUnitsByName.elements();
    }

    public int getOutUnitCount() {
        return this.m_outUnitsByName.size();
    }

    public Enumeration getOutUnitEnum() {
        return this.m_outUnitsByName.elements();
    }

    public String getSchemaName() {
        return ConnectionPool.getSchema();
    }

    public boolean hasMaster() {
        return this.m_haveMaster;
    }
}

