/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.definition;

import com.sap.sdb.syncMan.definition.DefinitionSQLHandler;
import com.sap.sdb.syncMan.definition.ReplicationSchema;
import com.sap.sdb.syncMan.definition.ReplicationTable;
import com.sap.sdb.syncMan.definition.ReplicationUnit;
import com.sap.sdb.syncMan.util.ConnectionPool;
import com.sap.sdb.syncMan.util.SQLNames;
import com.sap.sdb.syncMan.util.TableName;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Vector;

public class MaxDBDefinitionSQLHandler
extends DefinitionSQLHandler
implements SQLNames {
    private static final String LSEP = System.getProperty("line.separator");

    public void loadSchema(Hashtable unitHash, String[] unitRestriction, ReplicationSchema schema, boolean noConsumption) throws Exception {
        Connection jdbcConnection = ConnectionPool.getConnection();
        boolean haveSel = false;
        Vector<String> gnamevec = null;
        if (unitRestriction != null && unitRestriction.length > 0) {
            haveSel = true;
            gnamevec = new Vector<String>(unitRestriction.length);
            for (int i = 0; i < unitRestriction.length; ++i) {
                gnamevec.add(unitRestriction[i]);
            }
        }
        String repSchema = ConnectionPool.getSchema();
        TableName unitTab = new TableName(repSchema, "REPLICATION_UNITS");
        TableName repTab = new TableName(repSchema, "REPLICATION_TABLES");
        TableName repColTab = new TableName(repSchema, "REPLICATION_TABLE_COLUMNS");
        String selectSchema = "SELECT U.UNIT_ID, " + LSEP + "U." + "UNIT_NAME" + ", " + LSEP + "U." + "UNIT_TYPE" + ", " + LSEP + "U." + "IS_MASTER" + ", " + LSEP + "U." + "INBOUND_DEST_ID" + ", " + LSEP + "U." + "UNIT_INBOUND_DEST_PASS" + ", " + LSEP + "T." + "TABLE_ID" + ", " + LSEP + "T." + "TABLE_SCHEMA" + ", " + LSEP + "T." + "TABLE_NAME" + ", " + LSEP + "T." + "VERSION_TABLE_NAME" + ", " + LSEP + "T." + "SHADOW_TABLE_NAME" + ", " + LSEP + "T." + "AUDIT_TABLE_NAME" + ", " + LSEP + "C." + "COLUMN_NAME" + ", " + LSEP + "C." + "COLUMN_ID" + ", " + LSEP + "C." + "KEY_POS" + ", " + LSEP + "C." + "SQL_TYPE" + LSEP + "FROM " + unitTab.getSQLTableName() + " U, " + repTab.getSQLTableName() + " T, " + repColTab.getSQLTableName() + " C" + LSEP + "WHERE " + "U." + "UNIT_ID" + " = " + "T." + "UNIT_ID" + LSEP + "AND " + "U." + "UNIT_ID" + " = " + "C." + "UNIT_ID" + LSEP + "AND " + "T." + "TABLE_ID" + " = " + "C." + "TABLE_ID";
        Statement stmt = jdbcConnection.createStatement();
        ResultSet result = stmt.executeQuery(selectSchema);
        while (result.next()) {
            long unitID = result.getLong(1);
            String unitName = result.getString(2);
            int unitType = result.getInt(3);
            boolean isMaster = result.getBoolean(4);
            String inDestId = result.getString(5);
            String inDestPass = result.getString(6);
            long tableID = result.getLong(7);
            String tableOwner = result.getString(8);
            String tableName = result.getString(9);
            String versionTableName = result.getString(10);
            String shadowTableName = result.getString(11);
            String auditTableName = result.getString(12);
            String colName = result.getString(13);
            Long colId = new Long(result.getLong(14));
            boolean isInKey = result.getInt(15) != -1;
            Integer colType = new Integer(result.getInt(16));
            if (haveSel && !gnamevec.contains(unitName)) continue;
            ReplicationUnit unit = (ReplicationUnit)unitHash.get(unitName);
            if (unit == null) {
                unit = new ReplicationUnit(schema, unitID, unitName, unitType, isMaster, inDestId, inDestPass);
                unitHash.put(unitName, unit);
            }
            if (noConsumption || !unit.isInbound()) continue;
            ReplicationTable table = unit.getTableById(tableID);
            if (table == null) {
                table = new ReplicationTable(unit, tableOwner, tableName, versionTableName, shadowTableName, auditTableName);
                unit.addTable(table, tableName, tableID);
            }
            table.addColumn(colId, colName, colType, isInKey);
        }
        result.close();
        jdbcConnection.commit();
        ConnectionPool.freeConnection(jdbcConnection);
    }
}

