/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.consumption;

import com.sap.sdb.syncMan.consumption.MaxDBTableConsumptionSQLHandler;
import com.sap.sdb.syncMan.consumption.MinDBTableConsumptionSQLHandler;
import com.sap.sdb.syncMan.consumption.MySQLTableConsumptionSQLHandler;
import com.sap.sdb.syncMan.definition.ReplicationSchema;
import com.sap.sdb.syncMan.definition.ReplicationTable;
import com.sap.sdb.syncMan.definition.ReplicationUnit;
import com.sap.sdb.syncMan.message.RowReceiveMessage;
import com.sap.sdb.syncMan.util.ConnectionPool;
import com.sap.sdb.syncMan.util.SQLNames;
import com.sap.sdb.syncMan.util.TableName;
import java.sql.Connection;

public abstract class TableConsumptionSQLHandler
implements SQLNames {
    protected ReplicationTable m_table;
    protected final Long[] m_keyIDs;
    protected final int[] m_keyTypes;
    protected final String[] m_keyNames;
    protected final Long[] m_nonKeyIDs;
    protected final int[] m_nonKeyTypes;
    protected final String[] m_nonKeyNames;
    protected final int m_col_count;
    protected final int m_key_count;
    protected final int m_non_key_count;
    protected final String m_sequenceSQLName;

    protected TableConsumptionSQLHandler(ReplicationTable table) {
        this.m_table = table;
        this.m_col_count = table.getColumnCount();
        this.m_key_count = table.getKeyColumnCount();
        this.m_non_key_count = this.m_col_count - this.m_key_count;
        this.m_keyIDs = table.getKeyIDs();
        this.m_keyTypes = table.getKeyTypes();
        this.m_keyNames = table.getKeyNames();
        this.m_nonKeyIDs = table.getNonKeyIDs();
        this.m_nonKeyTypes = table.getNonKeyTypes();
        this.m_nonKeyNames = table.getNonKeyNames();
        TableName sname = new TableName(ConnectionPool.getSchema(), "REPLICATION_ID");
        this.m_sequenceSQLName = sname.getSQLTableName();
    }

    public static TableConsumptionSQLHandler createHandler(ReplicationSchema schema, ReplicationUnit unit, ReplicationTable table) throws Exception {
        TableConsumptionSQLHandler retval = null;
        if (schema != null && unit != null && table != null) {
            if (ConnectionPool.isMaxDB()) {
                retval = new MaxDBTableConsumptionSQLHandler(table);
            } else if (ConnectionPool.isMySQL()) {
                retval = new MySQLTableConsumptionSQLHandler(table);
            } else if (ConnectionPool.isMinDB()) {
                retval = new MinDBTableConsumptionSQLHandler(table);
            }
        }
        return retval;
    }

    public abstract boolean executeInsertMessage(Connection var1, RowReceiveMessage var2) throws Exception;

    public abstract boolean executeUpdateMessage(Connection var1, RowReceiveMessage var2) throws Exception;

    public abstract boolean executeDeleteMessage(Connection var1, RowReceiveMessage var2) throws Exception;

    public abstract boolean rowVersionMatches(Connection var1, RowReceiveMessage var2) throws Exception;

    public abstract void deleteVersion(Connection var1, RowReceiveMessage var2) throws Exception;

    public abstract void insertVersion(Connection var1, RowReceiveMessage var2) throws Exception;

    public abstract void lockDataRow(Connection var1, RowReceiveMessage var2) throws Exception;

    public abstract void unlockDataRow(Connection var1, RowReceiveMessage var2) throws Exception;

    public abstract void insertShadowTableEntryForRefresh(Connection var1, RowReceiveMessage var2, boolean var3) throws Exception;

    public abstract void insertTransactionTableEntryForRefresh(Connection var1) throws Exception;

    public abstract void insertShadowTableEntryForRefreshEcho(Connection var1, RowReceiveMessage var2) throws Exception;

    public abstract void insertTransactionTableEntryForRefreshEcho(Connection var1) throws Exception;

    public abstract void setSourceClientIDInShadowTable(Connection var1, RowReceiveMessage var2) throws Exception;

    public abstract void setReceivedVersions(Connection var1, RowReceiveMessage var2) throws Exception;

    public abstract void setReceivedVersionsInShadowTable(Connection var1, RowReceiveMessage var2) throws Exception;

    public abstract void updateColumnGroupVersionInVersionTable(Connection var1, RowReceiveMessage var2) throws Exception;

    public abstract void updateColumnGroupVersionInShadowTable(Connection var1, RowReceiveMessage var2) throws Exception;

    public abstract boolean columnGroupVersionMatches(Connection var1, RowReceiveMessage var2) throws Exception;

    public abstract void auditMsg(Connection var1, RowReceiveMessage var2, int var3) throws Exception;
}

