/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.capture;

import com.sap.sdb.syncMan.capture.CaptureColConstraint;
import com.sap.sdb.syncMan.capture.CaptureColDesc;
import com.sap.sdb.syncMan.capture.CapturePrepStmtCache;
import com.sap.sdb.syncMan.capture.CaptureResult;
import com.sap.sdb.syncMan.capture.CaptureResultRow;
import com.sap.sdb.syncMan.capture.CaptureTable;
import com.sap.sdb.syncMan.capture.CaptureUnit;
import com.sap.sdb.syncMan.message.MessageFreeList;
import com.sap.sdb.syncMan.message.RowSendMessage;
import com.sap.sdb.syncMan.util.SQLNames;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

class CaptureUnitTableEntry
implements SQLNames {
    private boolean m_accumulatedUpdates;
    private int m_maxReceiverClients;
    private long m_tableID;
    private long m_singleReceiverID;
    private CaptureUnit m_unit;
    private CaptureTable m_table;
    private CaptureColDesc[] m_colList;
    private LinkedList m_keyColList;

    CaptureUnitTableEntry(CaptureUnit unit, CaptureTable table, long tableID, int installedClients, long singleReceiverID, boolean accumulatedUpdates) {
        this.m_unit = unit;
        this.m_table = table;
        this.m_tableID = tableID;
        this.m_singleReceiverID = singleReceiverID;
        this.m_accumulatedUpdates = accumulatedUpdates;
        this.m_colList = null;
        this.m_keyColList = new LinkedList();
        this.m_maxReceiverClients = this.m_singleReceiverID == -1L ? installedClients : 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    RowSendMessage createMessage(Connection con, CaptureResult result, String transID) throws SQLException {
        if (this.m_accumulatedUpdates && result.isUpdateAction()) {
            throw new SQLException("createAccumulatedMsg not yet implemented");
        }
        RowSendMessage msg = MessageFreeList.getRowSendMessage();
        msg.initSendMessage(this.m_unit.getUnitID(), result.getActionType(), transID, this.m_tableID);
        if (result.isRefreshDoneAction()) {
            this.setVersionsAndReceiver(result, msg);
            return msg;
        }
        boolean anyColumnFound = false;
        HashMap<Long, Long> usedColGroupMap = null;
        CaptureResultRow beforeImageRow = result.getUpdBeforeImageRow();
        boolean[] beforeImageWritten = new boolean[this.m_colList.length];
        for (int colIndex = 0; colIndex < this.m_colList.length; ++colIndex) {
            int unqualifiedClientsCount;
            CaptureColDesc colDesc = this.m_colList[colIndex];
            if (result.isUpdateAction()) {
                beforeImageWritten[colIndex] = false;
                if (!colDesc.isKeyCol()) {
                    if (colDesc.isUpdatedCol(result.getColUpdateFlags())) {
                        anyColumnFound = true;
                    } else {
                        Long groupID;
                        if (usedColGroupMap == null || (groupID = colDesc.getColGroupID()) == null || !usedColGroupMap.containsKey(groupID)) continue;
                        beforeImageWritten[colIndex] = true;
                        colDesc.addGroupBeforeImageToMsg(beforeImageRow, msg);
                        continue;
                    }
                }
            } else {
                if (result.isDeleteAction() && !colDesc.isKeyCol()) continue;
                anyColumnFound = true;
            }
            if ((unqualifiedClientsCount = colDesc.addDataToMsg(con, result.getCurrRow(), msg, (byte)1)) >= this.m_maxReceiverClients) break;
            if (beforeImageRow == null || colDesc.isKeyCol() || colDesc.isVersionedCol()) continue;
            beforeImageWritten[colIndex] = true;
            Long groupID = colDesc.getColGroupID();
            if (groupID != null) {
                if (usedColGroupMap == null) {
                    usedColGroupMap = new HashMap<Long, Long>();
                } else if (usedColGroupMap.containsKey(groupID)) {
                    groupID = null;
                }
                if (groupID != null) {
                    usedColGroupMap.put(groupID, groupID);
                    for (int k = 0; k < colIndex; ++k) {
                        if (beforeImageWritten[k] || !groupID.equals(this.m_colList[k].getColGroupID())) continue;
                        beforeImageWritten[k] = true;
                        this.m_colList[k].addGroupBeforeImageToMsg(beforeImageRow, msg);
                    }
                }
            }
            colDesc.addDataToMsg(con, beforeImageRow, msg, (byte)0);
        }
        if (anyColumnFound && msg.getUnqualifiedClientsCount() < this.m_maxReceiverClients) {
            this.setVersionsAndReceiver(result, msg);
            return msg;
        }
        MessageFreeList.freeRowSendMessage(msg);
        return null;
    }

    CaptureUnit getUnit() {
        return this.m_unit;
    }

    LinkedList selectColumnIDs(Connection con, CapturePrepStmtCache prepStmtCache, HashMap colNameIndex) throws SQLException {
        PreparedStatement prepStmt = prepStmtCache.getPrepStmt(con, 3);
        prepStmt.setLong(1, this.m_unit.getUnitID());
        prepStmt.setLong(2, this.m_tableID);
        ResultSet result = prepStmt.executeQuery();
        LinkedList<CaptureColDesc> allColumns = new LinkedList<CaptureColDesc>();
        while (result.next()) {
            CaptureColDesc colDesc = new CaptureColDesc(this.m_table.getColName(result.getString("COLUMN_NAME")), result, colNameIndex, this.m_keyColList);
            this.selectConstraints(con, prepStmtCache, colDesc);
            allColumns.addLast(colDesc);
        }
        result.close();
        this.m_colList = new CaptureColDesc[allColumns.size()];
        Iterator iter = allColumns.iterator();
        for (int i = 0; i < this.m_colList.length; ++i) {
            this.m_colList[i] = (CaptureColDesc)iter.next();
        }
        return this.m_keyColList;
    }

    void selectConstraints(Connection con, CapturePrepStmtCache prepStmtCache, CaptureColDesc colDesc) throws SQLException {
        LinkedList<CaptureColConstraint> constraintList = new LinkedList<CaptureColConstraint>();
        int stmtIndex = this.m_singleReceiverID != -1L ? 5 : 4;
        PreparedStatement prepStmt = prepStmtCache.getPrepStmt(con, stmtIndex);
        prepStmt.setLong(1, this.m_tableID);
        prepStmt.setLong(2, colDesc.getID());
        if (this.m_singleReceiverID != -1L) {
            prepStmt.setLong(3, this.m_singleReceiverID);
        }
        ResultSet result = prepStmt.executeQuery();
        while (result.next()) {
            if (result.getInt("CONSTRAINT_TYPE") <= 0) continue;
            CaptureColConstraint currConstraint = new CaptureColConstraint(result);
            constraintList.add(currConstraint);
        }
        result.close();
        if (constraintList.size() > 0) {
            colDesc.addConstraintList(constraintList);
        }
    }

    private void setVersionsAndReceiver(CaptureResult result, RowSendMessage msg) {
        if (this.m_unit.isMaster()) {
            long updaterID = result.getUpdaterID();
            msg.setVersionEntries(result.getRowCreatorID(), result.getRowVersion(), updaterID, result.getColGroupVersion());
            if (this.m_singleReceiverID != -1L) {
                msg.setSingleReceiver(this.m_singleReceiverID);
            } else if (result.isRefreshAction()) {
                msg.setSingleReceiver(result.getSingleReceiverID());
            }
            return;
        }
        msg.setVersionEntries(result.getRowCreatorID(), result.getRowVersion(), this.m_unit.getUnitID(), result.getColGroupVersion());
    }
}

