/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.capture;

import com.sap.sdb.syncMan.SyncManThread;
import com.sap.sdb.syncMan.capture.CaptureColDesc;
import com.sap.sdb.syncMan.capture.CaptureHandler;
import com.sap.sdb.syncMan.capture.CapturePrepStmtCache;
import com.sap.sdb.syncMan.capture.CaptureResult;
import com.sap.sdb.syncMan.capture.CaptureSourceTable;
import com.sap.sdb.syncMan.capture.CaptureTransHandler;
import com.sap.sdb.syncMan.capture.CaptureUnit;
import com.sap.sdb.syncMan.capture.CaptureUnitTableEntry;
import com.sap.sdb.syncMan.message.RowSendMessage;
import com.sap.sdb.syncMan.util.ConnectionPool;
import com.sap.sdb.syncMan.util.DebugOutput;
import com.sap.sdb.syncMan.util.SQLNames;
import com.sap.sdb.syncMan.util.TableName;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.jms.JMSException;

abstract class CaptureTable
implements SQLNames {
    private TableName m_baseTabName;
    private TableName m_shadowTabName;
    private TableName m_versionTabName;
    private LinkedList m_sendTableList;
    private LinkedList m_keyColList;
    private String[] m_keyColNames;
    private CaptureHandler m_captureHandler;
    private static final int PROGRESS_INTERVAL = 100;
    private static final int MAX_ROWS_PER_COPY_TRANS = 200;

    CaptureTable(CaptureHandler captureHandler, Connection con, TableName tabname) throws SQLException {
        if (Thread.currentThread() != captureHandler) {
            throw new SQLException("constructor CaptureTable has to be invoked by a CaptureHandler thread");
        }
        this.m_baseTabName = tabname;
        this.m_shadowTabName = null;
        this.m_versionTabName = null;
        this.m_sendTableList = null;
        this.m_keyColList = null;
        this.m_keyColNames = null;
        this.m_captureHandler = captureHandler;
        this.loadAuxTablenames(con, captureHandler.getPrepStmtCache());
    }

    void addCreatedVersionCount(long versionCount) {
        this.m_captureHandler.addCreatedVersionCount(versionCount);
    }

    private void buildDestinations(Connection con, CapturePrepStmtCache prepStmtCache, ResultSetMetaData metaDataSelectedEntries) throws SQLException {
        this.m_sendTableList = new LinkedList();
        try {
            HashMap colNameIndex = this.getColNameIndex(metaDataSelectedEntries);
            PreparedStatement prepStmt = prepStmtCache.getPrepStmt(con, 10);
            prepStmt.setString(1, this.m_baseTabName.getOwner());
            prepStmt.setString(2, this.m_baseTabName.getIdentifier());
            ResultSet result = prepStmt.executeQuery();
            long singleReceiverID = this.m_captureHandler.getSingleRecieverID();
            while (result.next()) {
                long unitID = result.getLong("UNIT_ID");
                long tableID = result.getLong("TABLE_ID");
                boolean isMaster = result.getBoolean("IS_MASTER");
                String destination = result.getString("OUTBOUND_DEST_ID");
                int installedClients = isMaster ? result.getInt("INSTALLED_CLIENTS") : 1;
                CaptureUnit unit = new CaptureUnit(unitID, isMaster, destination);
                CaptureUnitTableEntry unitTable = new CaptureUnitTableEntry(unit, this, tableID, installedClients, singleReceiverID, this.m_captureHandler.accumulatedUpdWanted());
                LinkedList keyColList = unitTable.selectColumnIDs(con, prepStmtCache, colNameIndex);
                if (this.m_keyColList == null) {
                    this.m_keyColList = keyColList;
                }
                this.m_sendTableList.add(unitTable);
            }
            result.close();
        }
        catch (SQLException ex) {
            this.m_sendTableList = null;
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void captureEntries(Connection con, CapturePrepStmtCache prepStmtCache) throws Exception {
        CaptureResult result = null;
        try {
            result = this.selectEntries(con);
            if (this.m_sendTableList == null) {
                this.buildDestinations(con, prepStmtCache, result.getMetaData());
            }
            if (this.m_sendTableList.size() > 0) {
                this.sendMessagesToDestinations(con, result);
            } else if (DebugOutput.isVerboseCaptureMsg()) {
                DebugOutput.println("CaptureTable: unit entries for " + this.m_baseTabName.getSQLTableName() + " not found");
            }
            this.addCreatedVersionCount(result.getCreatedVersionCount());
        }
        finally {
            if (result != null) {
                result.close();
            }
        }
    }

    TableName getBaseTableName() {
        return this.m_baseTabName;
    }

    CaptureHandler getCaptureHandler() {
        return this.m_captureHandler;
    }

    abstract String getColName(String var1);

    abstract HashMap getColNameIndex(ResultSetMetaData var1) throws SQLException;

    String[] getKeyColNames(Connection con) throws SQLException {
        if (this.m_keyColNames != null) {
            return this.m_keyColNames;
        }
        if (this.m_keyColList == null) {
            LinkedList<String> keyList = new LinkedList<String>();
            DatabaseMetaData metaData = con.getMetaData();
            ResultSet result = metaData.getPrimaryKeys(null, this.m_baseTabName.getOwner(), this.m_baseTabName.getIdentifier());
            while (result.next()) {
                String keyCol = result.getString("COLUMN_NAME");
                keyList.add(keyCol);
            }
            result.close();
            this.m_keyColNames = new String[keyList.size()];
            Iterator iter = keyList.iterator();
            for (int i = 0; i < this.m_keyColNames.length; ++i) {
                this.m_keyColNames[i] = (String)iter.next();
            }
            return this.m_keyColNames;
        }
        String[] m_keyColNames = new String[this.m_keyColList.size()];
        Iterator keyColIter = this.m_keyColList.iterator();
        for (int i = 0; i < m_keyColNames.length; ++i) {
            CaptureColDesc colDesc = (CaptureColDesc)keyColIter.next();
            m_keyColNames[i] = colDesc.getName();
        }
        return m_keyColNames;
    }

    TableName getShadowTableName() {
        return this.m_shadowTabName;
    }

    TableName getVersionTableName() {
        return this.m_versionTabName;
    }

    private void loadAuxTablenames(Connection con, CapturePrepStmtCache prepStmtCache) throws SQLException {
        PreparedStatement prepStmt = prepStmtCache.getPrepStmt(con, 2);
        prepStmt.setString(1, this.m_baseTabName.getOwner());
        prepStmt.setString(2, this.m_baseTabName.getIdentifier());
        ResultSet result = prepStmt.executeQuery();
        if (result.next()) {
            this.m_shadowTabName = new TableName(ConnectionPool.getSchema(), result.getString("SHADOW_TABLE_NAME"));
            this.m_versionTabName = new TableName(ConnectionPool.getSchema(), result.getString("VERSION_TABLE_NAME"));
        }
        result.close();
    }

    private void sendMessagesToDestinations(Connection con, CaptureResult result) throws JMSException, SQLException {
        int rowCount = 0;
        while (result.next(con)) {
            boolean setLastOfTrans = false;
            String transID = this.m_captureHandler.getCurrentTransID();
            if (++rowCount % 100 == 0) {
                this.setProgress(rowCount);
            }
            if (this instanceof CaptureSourceTable && rowCount % 200 == 0) {
                setLastOfTrans = true;
            }
            Iterator iter = this.m_sendTableList.iterator();
            while (iter.hasNext()) {
                CaptureUnitTableEntry unitTable = (CaptureUnitTableEntry)iter.next();
                CaptureUnit unit = unitTable.getUnit();
                RowSendMessage msg = unitTable.createMessage(con, result, transID);
                if (msg != null) {
                    if (setLastOfTrans) {
                        msg.setIsLastInTransaction();
                    }
                    this.m_captureHandler.addReplicationMessage(unit, msg);
                    continue;
                }
                if (!DebugOutput.isVerboseCaptureMsg()) continue;
                if (this.m_captureHandler instanceof CaptureTransHandler) {
                    DebugOutput.println("CaptureTable: " + this.m_baseTabName.getSQLTableName() + " / trans " + ((CaptureTransHandler)this.m_captureHandler).getCurrentTransID() + ": entry " + rowCount + " not sent");
                    continue;
                }
                DebugOutput.println("CaptureTable: " + this.m_baseTabName.getSQLTableName() + ": entry " + rowCount + " not sent");
            }
        }
    }

    abstract CaptureResult selectEntries(Connection var1) throws SQLException;

    private void setProgress(int rowCount) {
        SyncManThread ownThread = (SyncManThread)Thread.currentThread();
        ownThread.setCustomMsg("capture table " + this.m_baseTabName.getSQLTableName() + ": " + rowCount + " rows");
    }
}

