/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.capture;

import com.sap.sdb.syncMan.capture.CaptureCopyHandler;
import com.sap.sdb.syncMan.capture.CaptureHandler;
import com.sap.sdb.syncMan.capture.CapturePrepStmtCache;
import com.sap.sdb.syncMan.capture.CaptureResult;
import com.sap.sdb.syncMan.capture.CaptureSourceInitVersResult;
import com.sap.sdb.syncMan.capture.CaptureSourceResult;
import com.sap.sdb.syncMan.capture.CaptureTable;
import com.sap.sdb.syncMan.util.TableName;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;

class CaptureSourceTable
extends CaptureTable {
    private boolean m_initRowVersOnly;

    CaptureSourceTable(CaptureHandler captureHandler, Connection con, TableName tabname) throws SQLException {
        super(captureHandler, con, tabname);
        this.m_initRowVersOnly = ((CaptureCopyHandler)captureHandler).isInitRowVersOnly();
    }

    private String buildVersionJoinWhereClause(Connection con) throws SQLException {
        StringBuffer joinWhereClause = new StringBuffer(100);
        DatabaseMetaData dbMetaData = con.getMetaData();
        ResultSet keyList = dbMetaData.getPrimaryKeys(null, super.getBaseTableName().getOwner(), super.getBaseTableName().getIdentifier());
        boolean isFirst = true;
        while (keyList.next()) {
            if (isFirst) {
                isFirst = false;
            } else {
                joinWhereClause.append(" AND ");
            }
            String columnName = keyList.getString("COLUMN_NAME");
            joinWhereClause.append("\"");
            joinWhereClause.append(columnName);
            joinWhereClause.append("\" = \"");
            joinWhereClause.append("_");
            joinWhereClause.append(columnName);
            joinWhereClause.append("\"");
        }
        keyList.close();
        return joinWhereClause.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void captureEntries(Connection con, CapturePrepStmtCache prepStmtCache) throws Exception {
        if (!this.m_initRowVersOnly) {
            super.captureEntries(con, prepStmtCache);
            return;
        }
        CaptureResult result = null;
        try {
            result = this.selectEntries(con);
            if (result != null) {
                while (result.next(con)) {
                }
                super.addCreatedVersionCount(result.getCreatedVersionCount());
            }
        }
        finally {
            if (result != null) {
                result.close();
            }
        }
    }

    String getColName(String replicationColumnName) {
        return replicationColumnName;
    }

    HashMap getColNameIndex(ResultSetMetaData metaDataSelectedEntries) throws SQLException {
        HashMap<String, Integer> colNameIndex = new HashMap<String, Integer>();
        int colCount = metaDataSelectedEntries.getColumnCount();
        for (int i = 1; i <= colCount; ++i) {
            String colName = metaDataSelectedEntries.getColumnName(i);
            colNameIndex.put(colName, new Integer(i));
        }
        return colNameIndex;
    }

    private CaptureResult joinSelect(Connection con, String sourceTab, String versionTab) throws SQLException {
        Statement stmt = con.createStatement();
        String joinWhereClause = this.buildVersionJoinWhereClause(con);
        String joinSelectStmt = "SELECT " + super.getBaseTableName().getSQLIdentifier() + ".*, " + CaptureSourceResult.getSelectListVersionPart(super.getVersionTableName()) + " FROM " + sourceTab + ", " + versionTab + " WHERE " + joinWhereClause;
        ResultSet result = stmt.executeQuery(joinSelectStmt);
        return new CaptureSourceResult(result);
    }

    CaptureResult selectEntries(Connection con) throws SQLException {
        Statement stmt = con.createStatement();
        String sourceTab = super.getBaseTableName().getSQLTableName();
        String versionTab = super.getVersionTableName().getSQLTableName();
        stmt.execute("LOCK TABLE " + sourceTab + " IN SHARE MODE");
        stmt.execute("LOCK TABLE " + versionTab + " IN SHARE MODE");
        ResultSet resultSourceCount = stmt.executeQuery("SELECT COUNT(*) FROM " + sourceTab);
        int sourceCount = resultSourceCount.next() ? resultSourceCount.getInt(1) : 0;
        resultSourceCount.close();
        ResultSet resultVersionCount = stmt.executeQuery("SELECT COUNT(*) FROM " + versionTab);
        int versionCount = resultVersionCount.next() ? resultVersionCount.getInt(1) : 0;
        resultVersionCount.close();
        if (sourceCount == versionCount) {
            return this.m_initRowVersOnly ? null : this.joinSelect(con, sourceTab, versionTab);
        }
        return this.selectInitVersions(con, sourceTab);
    }

    private CaptureResult selectInitVersions(Connection con, String sourceTab) throws SQLException {
        StringBuffer sql = new StringBuffer(200);
        sql.append("SELECT ");
        if (this.m_initRowVersOnly) {
            String[] keyColNames = super.getKeyColNames(con);
            for (int i = 0; i < keyColNames.length; ++i) {
                if (i > 0) {
                    sql.append(", ");
                }
                sql.append('\"');
                sql.append(keyColNames[i]);
                sql.append('\"');
            }
        } else {
            sql.append("*");
        }
        sql.append(" FROM ");
        sql.append(sourceTab);
        ResultSet result = con.createStatement().executeQuery(sql.toString());
        return new CaptureSourceInitVersResult(this, result);
    }
}

