/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.capture;

import com.sap.sdb.syncMan.capture.CaptureResult;
import com.sap.sdb.syncMan.capture.CaptureResultRow;
import com.sap.sdb.syncMan.capture.CaptureTable;
import com.sap.sdb.syncMan.util.ConnectionPool;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

class CaptureSourceInitVersResult
extends CaptureResult {
    private CaptureTable m_captureTab;
    private ResultSet m_result;
    private CaptureResultRow m_currRow;
    private long m_rowCreatorID;
    private long m_rowVersion;
    private long m_updaterID;
    private long m_colGroupVersion;
    private PreparedStatement m_prepStmtInsertVersion;
    private PreparedStatement m_prepStmtNextSequence;
    private PreparedStatement m_prepStmtSelectVersion;
    private long m_createdVersionCount;

    CaptureSourceInitVersResult(CaptureTable captureTab, ResultSet result) {
        this.m_captureTab = captureTab;
        this.m_result = result;
        this.m_currRow = new CaptureResultRow(result);
        this.m_rowCreatorID = -1L;
        this.m_rowVersion = -1L;
        this.m_updaterID = -1L;
        this.m_colGroupVersion = -1L;
        this.m_prepStmtInsertVersion = null;
        this.m_prepStmtNextSequence = null;
        this.m_prepStmtSelectVersion = null;
        this.m_createdVersionCount = 0L;
    }

    void close() throws SQLException {
        if (this.m_result == null) {
            return;
        }
        this.m_result.close();
        if (this.m_prepStmtInsertVersion != null) {
            this.m_prepStmtInsertVersion.close();
            this.m_prepStmtInsertVersion = null;
        }
        if (this.m_prepStmtNextSequence != null) {
            this.m_prepStmtNextSequence.close();
            this.m_prepStmtNextSequence = null;
        }
        if (this.m_prepStmtSelectVersion != null) {
            this.m_prepStmtSelectVersion.close();
            this.m_prepStmtSelectVersion = null;
        }
        this.m_result = null;
        this.m_currRow = null;
        this.m_rowCreatorID = -1L;
        this.m_rowVersion = -1L;
        this.m_updaterID = -1L;
        this.m_colGroupVersion = -1L;
    }

    int getActionType() {
        return 0;
    }

    long getColGroupVersion() {
        return this.m_colGroupVersion;
    }

    long getCreatedVersionCount() {
        return this.m_createdVersionCount;
    }

    CaptureResultRow getCurrRow() {
        return this.m_currRow;
    }

    ResultSetMetaData getMetaData() throws SQLException {
        return this.m_result.getMetaData();
    }

    private long getNewSequence(Connection con) throws SQLException {
        if (this.m_prepStmtNextSequence == null) {
            String sql = "SELECT \"" + ConnectionPool.getSchema() + "\"." + "REPLICATION_ID" + ".NEXTVAL FROM dual";
            this.m_prepStmtNextSequence = con.prepareStatement(sql);
        }
        ResultSet result = this.m_prepStmtNextSequence.executeQuery();
        result.next();
        long newSequence = result.getLong(1);
        result.close();
        return newSequence;
    }

    long getRowCreatorID() {
        return this.m_rowCreatorID;
    }

    long getRowVersion() {
        return this.m_rowVersion;
    }

    long getUpdaterID() {
        return 0L;
    }

    private void insertNewVersion(Connection con) throws SQLException {
        String[] keyColNames = this.m_captureTab.getKeyColNames(con);
        if (this.m_prepStmtInsertVersion == null) {
            StringBuffer sql = new StringBuffer(200);
            sql.append("INSERT ");
            sql.append(this.m_captureTab.getVersionTableName().getSQLTableName());
            sql.append(" SET ");
            for (int i = 0; i < keyColNames.length; ++i) {
                sql.append("\"_");
                sql.append(keyColNames[i]);
                sql.append("\" = ?, ");
            }
            sql.append("ROW_CREATOR = ?, ROW_VERSION = ?, LAST_UPDATER = ?, COL_GROUP_VERSION = ?");
            this.m_prepStmtInsertVersion = con.prepareStatement(sql.toString());
        }
        for (int i = 0; i < keyColNames.length; ++i) {
            this.m_prepStmtInsertVersion.setString(i + 1, this.m_currRow.getString(keyColNames[i]));
        }
        this.m_rowCreatorID = 0L;
        this.m_rowVersion = this.getNewSequence(con);
        this.m_updaterID = 0L;
        this.m_colGroupVersion = 0L;
        this.m_prepStmtInsertVersion.setLong(keyColNames.length + 1, this.m_rowCreatorID);
        this.m_prepStmtInsertVersion.setLong(keyColNames.length + 2, this.m_rowVersion);
        this.m_prepStmtInsertVersion.setLong(keyColNames.length + 3, this.m_updaterID);
        this.m_prepStmtInsertVersion.setLong(keyColNames.length + 4, this.m_colGroupVersion);
        try {
            this.m_prepStmtInsertVersion.executeUpdate();
            ++this.m_createdVersionCount;
            return;
        }
        catch (SQLException ex) {
            if (!ConnectionPool.isDuplicateKey(ex)) {
                throw ex;
            }
            this.selectExistingVersion(con, keyColNames);
            return;
        }
    }

    boolean isInsDelUpdAction() {
        return true;
    }

    boolean next(Connection con) throws SQLException {
        if (!this.m_result.next()) {
            return false;
        }
        this.insertNewVersion(con);
        return true;
    }

    private void selectExistingVersion(Connection con, String[] keyColNames) throws SQLException {
        if (this.m_prepStmtSelectVersion == null) {
            StringBuffer sql = new StringBuffer(200);
            sql.append("SELECT ROW_CREATOR, ROW_VERSION, LAST_UPDATER, COL_GROUP_VERSION FROM ");
            sql.append(this.m_captureTab.getVersionTableName().getSQLTableName());
            sql.append(" WHERE \"_");
            for (int i = 0; i < keyColNames.length; ++i) {
                if (i > 0) {
                    sql.append(" AND \"_");
                }
                sql.append(keyColNames[i]);
                sql.append("\" = ?");
            }
            this.m_prepStmtSelectVersion = con.prepareStatement(sql.toString());
        }
        for (int i = 0; i < keyColNames.length; ++i) {
            this.m_prepStmtSelectVersion.setString(i + 1, this.m_currRow.getString(keyColNames[i]));
        }
        ResultSet result = this.m_prepStmtSelectVersion.executeQuery();
        if (!result.next()) {
            String key = "";
            for (int i = 0; i < keyColNames.length; ++i) {
                if (i > 0) {
                    key = key + ", ";
                }
                key = key + this.m_currRow.getString(keyColNames[i]);
            }
            throw new SQLException("synchronization version not found; key: " + key);
        }
        this.m_rowCreatorID = result.getLong(1);
        this.m_rowVersion = result.getLong(2);
        this.m_updaterID = result.getLong(3);
        this.m_colGroupVersion = result.getLong(4);
        result.close();
    }
}

