/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.capture;

import com.sap.sdb.syncMan.capture.CaptureHandler;
import com.sap.sdb.syncMan.capture.CaptureManager;
import com.sap.sdb.syncMan.capture.CaptureResult;
import com.sap.sdb.syncMan.capture.CaptureShadowClientResult;
import com.sap.sdb.syncMan.capture.CaptureShadowResult;
import com.sap.sdb.syncMan.capture.CaptureTable;
import com.sap.sdb.syncMan.capture.CaptureTransHandler;
import com.sap.sdb.syncMan.util.SQLNames;
import com.sap.sdb.syncMan.util.TableName;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;

class CaptureShadowTable
extends CaptureTable
implements SQLNames {
    private boolean m_isMaster = CaptureManager.isMaster();
    private Connection m_connectionLastDelete = null;
    private Connection m_connectionLastSelect = null;
    private PreparedStatement m_prepStmtDeleteEntries = null;
    private PreparedStatement m_prepStmtSelectEntries = null;
    private PreparedStatement m_prepStmtSelectBeforeImage = null;

    CaptureShadowTable(CaptureHandler captureHandler, Connection con, TableName tabname) throws SQLException {
        super(captureHandler, con, tabname);
    }

    void deleteTransEntries(Connection con, byte[] transIDBytes) throws SQLException {
        if (this.m_connectionLastDelete != con) {
            this.m_connectionLastDelete = null;
            TableName shadowTabname = super.getShadowTableName();
            this.m_prepStmtDeleteEntries = con.prepareStatement("DELETE " + shadowTabname.getSQLTableName() + " WHERE " + "REP_TRANSID" + " = ?");
            this.m_connectionLastDelete = con;
        }
        this.m_prepStmtDeleteEntries.setBytes(1, transIDBytes);
        this.m_prepStmtDeleteEntries.executeUpdate();
    }

    String getColName(String replicationColumnName) {
        return "_" + replicationColumnName;
    }

    HashMap getColNameIndex(ResultSetMetaData metaDataSelectedEntries) throws SQLException {
        HashMap<String, Integer> colNameIndex = new HashMap<String, Integer>();
        for (int i = 1; i <= metaDataSelectedEntries.getColumnCount(); ++i) {
            String currColName = metaDataSelectedEntries.getColumnName(i);
            if (!currColName.startsWith("_")) continue;
            colNameIndex.put(currColName, new Integer(i));
        }
        return colNameIndex;
    }

    private String getSelectString(boolean beforeImage) {
        String condition = beforeImage ? "=" : "<>";
        return "SELECT * FROM " + super.getShadowTableName().getSQLTableName() + " WHERE " + "REP_TRANSID" + " = ?" + " AND " + "REP_TYPE" + condition + 3 + " ORDER BY " + "REP_COUNTER";
    }

    CaptureResult selectEntries(Connection con) throws SQLException {
        if (this.m_connectionLastSelect != con) {
            this.m_connectionLastSelect = null;
            this.m_prepStmtSelectEntries = con.prepareStatement(this.getSelectString(false));
            if (!this.m_isMaster) {
                this.m_prepStmtSelectBeforeImage = con.prepareStatement(this.getSelectString(true));
            }
            this.m_connectionLastSelect = con;
        }
        CaptureTransHandler transHandler = (CaptureTransHandler)super.getCaptureHandler();
        byte[] transIDBytes = transHandler.getCurrentTransIDBytes();
        this.m_prepStmtSelectEntries.setBytes(1, transIDBytes);
        ResultSet result = this.m_prepStmtSelectEntries.executeQuery();
        if (this.m_isMaster) {
            return new CaptureShadowResult(result);
        }
        this.m_prepStmtSelectBeforeImage.setBytes(1, transIDBytes);
        ResultSet resultBeforeImage = this.m_prepStmtSelectBeforeImage.executeQuery();
        return new CaptureShadowClientResult(result, resultBeforeImage);
    }
}

