/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.capture;

import com.sap.sdb.syncMan.capture.CaptureResultRow;
import com.sap.sdb.syncMan.capture.CaptureShadowResult;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

class CaptureShadowClientResult
extends CaptureShadowResult {
    private ResultSet m_beforeImageResult = null;
    private CaptureResultRow m_currBeforeImageRow;
    private long m_sequenceBeforeEntry;
    boolean m_isEndOfBeforeImage;
    boolean m_isValidBeforeImage;
    boolean m_readNext;

    CaptureShadowClientResult(ResultSet afterImage, ResultSet beforeImage) {
        super(afterImage);
        this.m_beforeImageResult = beforeImage;
        this.m_currBeforeImageRow = new CaptureResultRow(beforeImage);
        this.m_sequenceBeforeEntry = -1L;
        this.m_isEndOfBeforeImage = false;
        this.m_isValidBeforeImage = false;
        this.m_readNext = true;
    }

    void close() throws SQLException {
        super.close();
        this.m_isValidBeforeImage = false;
        if (this.m_beforeImageResult != null) {
            this.m_beforeImageResult.close();
            this.m_beforeImageResult = null;
        }
    }

    CaptureResultRow getUpdBeforeImageRow() {
        return this.m_isValidBeforeImage ? this.m_currBeforeImageRow : null;
    }

    boolean next(Connection con) throws SQLException {
        this.m_isValidBeforeImage = false;
        if (!super.next(con)) {
            return false;
        }
        if (this.m_isEndOfBeforeImage || !super.isUpdateAction()) {
            return true;
        }
        if (this.m_readNext) {
            this.m_readNext = false;
            if (!this.m_beforeImageResult.next()) {
                this.m_isEndOfBeforeImage = true;
                return true;
            }
            this.m_sequenceBeforeEntry = this.m_currBeforeImageRow.getLong("REP_COUNTER");
        }
        if (this.m_sequenceBeforeEntry == super.getEntrySequence()) {
            this.m_isValidBeforeImage = true;
            this.m_readNext = true;
        }
        return true;
    }
}

