/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.capture;

import com.sap.sdb.syncMan.util.SQLNames;
import com.sap.sdb.syncMan.util.TableName;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;

class CapturePrepStmtCache
implements SQLNames {
    static final int DELETE_TRANS = 0;
    static final int SELECT_ALL_TABLES = 1;
    static final int SELECT_AUX_TABLE_NAMES = 2;
    static final int SELECT_COLUMNS = 3;
    static final int SELECT_CONSTRAINTS = 4;
    static final int SELECT_CONSTRAINTS_BY_ID = 5;
    static final int SELECT_MAX_SEQ = 6;
    static final int SELECT_PASSWORD = 7;
    static final int SELECT_TABLES = 8;
    static final int SELECT_TRANS_IDS = 9;
    static final int SELECT_UNITS = 10;
    private static final int MAX_STATEMENTS = 11;
    private Connection m_connectionLastPrepare = null;
    private PreparedStatement[] m_prepStmt = new PreparedStatement[11];
    private String m_schema;
    private String m_unitConstraint;
    private String[] m_unitnames;
    static final String LOCK_IGNORE_OPTION = " WITH LOCK (IGNORE)";
    private static final String IS_ANY_OUT_UNIT = "(REPLICATION_UNITS.UNIT_TYPE = 0 OR REPLICATION_UNITS.UNIT_TYPE = 2)";
    private static final String UNIT_ID_JOIN = "REPLICATION_TABLES.UNIT_ID = REPLICATION_UNITS.UNIT_ID";
    private static final int PARAM_CNT_SELECT_ALL_TABLES = 0;
    private static final int PARAM_CNT_SELECT_PASSWORD = 1;
    private static final int PARAM_CNT_SELECT_UNITS = 2;

    CapturePrepStmtCache(String schemaName, String[] unitnames) {
        this.m_schema = schemaName;
        this.m_unitConstraint = null;
        this.m_unitnames = null;
        if (unitnames != null && unitnames.length > 0) {
            this.m_unitnames = unitnames;
            this.m_unitConstraint = this.getUnitConstraint();
        }
    }

    synchronized PreparedStatement getPrepStmt(Connection con, int stmtIndex) throws SQLException {
        if (this.m_connectionLastPrepare != con) {
            Arrays.fill(this.m_prepStmt, null);
            this.m_connectionLastPrepare = null;
        }
        if (this.m_prepStmt[stmtIndex] != null) {
            return this.m_prepStmt[stmtIndex];
        }
        String sql = null;
        int paramOffset = -1;
        switch (stmtIndex) {
            case 0: {
                sql = this.getStmtDeleteTrans();
                break;
            }
            case 1: {
                if (this.m_unitConstraint == null) {
                    sql = this.getStmtSelectAllTables();
                    break;
                }
                sql = this.getStmtSelectAllTables() + this.m_unitConstraint;
                paramOffset = 1;
                break;
            }
            case 2: {
                sql = this.getStmtSelectAuxTableNames();
                break;
            }
            case 3: {
                sql = this.getStmtSelectColumns();
                break;
            }
            case 4: {
                sql = this.getStmtSelectConstraints();
                break;
            }
            case 5: {
                sql = this.getStmtSelectConstraintsByID();
                break;
            }
            case 7: {
                if (this.m_unitConstraint == null) {
                    sql = this.getStmtSelectPassword();
                    break;
                }
                sql = this.getStmtSelectPassword() + this.m_unitConstraint;
                paramOffset = 2;
                break;
            }
            case 6: {
                sql = this.getStmtSelectMaxSeq();
                break;
            }
            case 8: {
                sql = this.getStmtSelectTables();
                break;
            }
            case 9: {
                sql = this.getStmtSelectTransIDs();
                break;
            }
            case 10: {
                if (this.m_unitConstraint == null) {
                    sql = this.getStmtSelectUnits();
                    break;
                }
                sql = this.getStmtSelectUnits() + this.m_unitConstraint;
                paramOffset = 3;
                break;
            }
            default: {
                throw new SQLException("illegal prepared statement index " + stmtIndex);
            }
        }
        this.m_prepStmt[stmtIndex] = con.prepareStatement(sql);
        if (paramOffset > 0) {
            for (int i = 0; i < this.m_unitnames.length; ++i) {
                this.m_prepStmt[stmtIndex].setString(paramOffset + i, this.m_unitnames[i]);
            }
        }
        this.m_connectionLastPrepare = con;
        return this.m_prepStmt[stmtIndex];
    }

    private String getStmtDeleteTrans() {
        TableName transTab = new TableName(this.m_schema, "REPLICATION_TRANSACTION_LIST");
        return "DELETE FROM " + transTab.getSQLTableName() + " WHERE " + "REP_TRANSID" + " = ?";
    }

    private String getStmtSelectAllTables() {
        TableName repTab = new TableName(this.m_schema, "REPLICATION_TABLES");
        TableName unitTab = new TableName(this.m_schema, "REPLICATION_UNITS");
        return "SELECT DISTINCT TABLE_SCHEMA, TABLE_NAME FROM " + repTab.getSQLTableName() + ", " + unitTab.getSQLTableName() + " WHERE " + IS_ANY_OUT_UNIT + " AND " + UNIT_ID_JOIN;
    }

    private String getStmtSelectAuxTableNames() {
        TableName repTab = new TableName(this.m_schema, "REPLICATION_TABLES");
        return "SELECT SHADOW_TABLE_NAME, VERSION_TABLE_NAME FROM " + repTab.getSQLTableName() + " WHERE " + "TABLE_SCHEMA" + " = ?" + " AND " + "TABLE_NAME" + " = ?";
    }

    private String getStmtSelectColumns() {
        TableName repColTab = new TableName(this.m_schema, "REPLICATION_TABLE_COLUMNS");
        return "SELECT COLUMN_NAME, COLUMN_ID, COLUMN_GROUP_ID, SQL_TYPE, COLUMN_GROUP_VERSIONED, KEY_POS FROM " + repColTab.getSQLTableName() + " WHERE " + "UNIT_ID" + " = ?" + " AND " + "TABLE_ID" + " = ?";
    }

    private String getStmtSelectConstraints() {
        TableName constrTab = new TableName(this.m_schema, "REPLICATION_CLIENT_CONSTRAINT");
        return "SELECT CLIENT_ID, CONSTRAINT_TYPE, CONSTRAINT_VALUE1, CONSTRAINT_VALUE2 FROM " + constrTab.getSQLTableName() + " WHERE " + "TABLE_ID" + " = ?" + " AND " + "COLUMN_ID" + " = ?";
    }

    private String getStmtSelectConstraintsByID() {
        TableName constrTab = new TableName(this.m_schema, "REPLICATION_CLIENT_CONSTRAINT");
        return "SELECT CLIENT_ID, CONSTRAINT_TYPE, CONSTRAINT_VALUE1, CONSTRAINT_VALUE2 FROM " + constrTab.getSQLTableName() + " WHERE " + "TABLE_ID" + " = ?" + " AND " + "COLUMN_ID" + " = ?" + " AND " + "CLIENT_ID" + " = ?";
    }

    private String getStmtSelectMaxSeq() {
        TableName transTab = new TableName(this.m_schema, "REPLICATION_TRANSACTION_LIST");
        return "SELECT MAX(REP_SEQ) FROM " + transTab.getSQLTableName() + LOCK_IGNORE_OPTION;
    }

    private String getStmtSelectPassword() {
        TableName unitTab = new TableName(this.m_schema, "REPLICATION_UNITS");
        return "SELECT UNIT_OUTBOUND_DEST_PASS FROM " + unitTab.getSQLTableName() + " WHERE " + "IS_MASTER" + " = ? AND " + IS_ANY_OUT_UNIT;
    }

    private String getStmtSelectTables() {
        TableName transTab = new TableName(this.m_schema, "REPLICATION_TRANSACTION_LIST");
        return "SELECT TABLE_SCHEMA, TABLE_NAME, REP_SEQ FROM " + transTab.getSQLTableName() + " WHERE " + "REP_TRANSID" + " = ?";
    }

    private String getStmtSelectTransIDs() {
        TableName transTab = new TableName(this.m_schema, "REPLICATION_TRANSACTION_LIST");
        return "SELECT DISTINCT REP_TRANSID FROM " + transTab.getSQLTableName() + " WHERE " + "REP_SEQ" + " <= ?" + " AND " + "REP_TRANSID" + " NOT IN" + " (SELECT " + "REP_TRANSID" + " FROM " + transTab.getSQLTableName() + " WHERE " + "REP_SEQ" + " > ?)" + LOCK_IGNORE_OPTION;
    }

    private String getStmtSelectUnits() {
        TableName repTab = new TableName(this.m_schema, "REPLICATION_TABLES");
        TableName unitTab = new TableName(this.m_schema, "REPLICATION_UNITS");
        return "SELECT REPLICATION_TABLES.UNIT_ID, REPLICATION_TABLES.TABLE_ID, REPLICATION_UNITS.IS_MASTER, REPLICATION_UNITS.OUTBOUND_DEST_ID, REPLICATION_UNITS.INSTALLED_CLIENTS FROM " + repTab.getSQLTableName() + ", " + unitTab.getSQLTableName() + " WHERE " + "REPLICATION_TABLES" + "." + "TABLE_SCHEMA" + " = ?" + " AND " + "REPLICATION_TABLES" + "." + "TABLE_NAME" + " = ?" + " AND " + UNIT_ID_JOIN + " AND " + IS_ANY_OUT_UNIT;
    }

    private String getUnitConstraint() {
        StringBuffer condition = new StringBuffer(100);
        condition.append(" AND REPLICATION_UNITS.UNIT_NAME ");
        if (this.m_unitnames.length == 1) {
            condition.append("= ?");
        } else {
            condition.append("IN (?");
            for (int i = 1; i < this.m_unitnames.length; ++i) {
                condition.append(", ?");
            }
            condition.append(')');
        }
        return condition.toString();
    }
}

