/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.gui.jface_viewer;

import com.sap.sdb.syncMan.design.DesignSQLLayer;
import com.sap.sdb.syncMan.design.Participant;
import com.sap.sdb.syncMan.design.TablesNode;
import com.sap.sdb.syncMan.design.UnitsNode;
import com.sap.sdb.syncMan.gui.jface_controls.UnitControl;
import com.sap.sdb.syncMan.tool.Resources;
import java.sql.SQLException;
import java.util.Vector;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class UnitTreeContentProvider
implements ITreeContentProvider {
    UnitControl mUnitsControl;

    public UnitTreeContentProvider(UnitControl UnitsControl) {
        this.mUnitsControl = UnitsControl;
    }

    public Object[] getChildren(Object parentElement) {
        Object[] children = null;
        try {
            if (parentElement instanceof Participant) {
                Participant item = (Participant)parentElement;
                if ((item.getParticipantName() == null || item.getParticipantName().length() < 1) && item.isMaster()) {
                    Vector Participants = DesignSQLLayer.selectParticipants(this.mUnitsControl.getConMetaData(), -1L, true, false);
                    children = Participants.toArray();
                } else {
                    Object[] temp = new Object[]{new TablesNode(item, Resources.getString("UnitsTablesNode.Tables")), new UnitsNode(item)};
                    children = temp;
                }
            } else if (parentElement instanceof TablesNode) {
                Vector tables = DesignSQLLayer.selectUnitTables(this.mUnitsControl.getConMetaData(), ((TablesNode)parentElement).participantNode().getParticipantID(), ((TablesNode)parentElement).participantNode().getParticipantID());
                children = tables.toArray();
            } else if (parentElement instanceof UnitsNode) {
                Vector clients = DesignSQLLayer.selectParticipants(this.mUnitsControl.getConMetaData(), ((UnitsNode)parentElement).participantNode().getParticipantID(), false, true);
                children = clients.toArray();
            } else if (children == null) {
                children = new Object[]{};
            }
        }
        catch (SQLException ex) {
            children = new Object[]{};
            UnitControl.writeProt(ex);
        }
        return children;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element == null) {
            return false;
        }
        if (element instanceof Participant) {
            return ((Participant)element).hasChildren();
        }
        if (element instanceof TablesNode) {
            return ((TablesNode)element).hasChildren();
        }
        if (element instanceof UnitsNode) {
            return ((UnitsNode)element).hasChildren();
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement == null) {
            return null;
        }
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

