/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.gui.jface_dialog;

import com.sap.sdb.syncMan.tool.Resources;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class UserAuthorizationDialog
extends Dialog {
    private Text m_HostText;
    private Text m_DatabaseText;
    private Text m_UserText;
    private Text m_PasswordText;
    private Text m_PasswordTextConfirm;
    private Button m_UseSSLButton;
    private String m_Host = "";
    private String m_Database = "";
    private String m_User = "";
    private String m_Password = "";
    private boolean m_UseSSL;
    private boolean m_confirmPassword;
    private String _title = Resources.getString("Connect_to_Database");

    public UserAuthorizationDialog(Shell parentShell) {
        super(parentShell);
        this.m_confirmPassword = false;
    }

    public UserAuthorizationDialog(Shell parentShell, String server, String database, String user, String password, boolean useSSL) {
        super(parentShell);
        this.m_Host = server;
        this.m_Database = database;
        this.m_User = user;
        this.m_Password = password;
        this.m_UseSSL = useSSL;
        this.m_confirmPassword = false;
    }

    public void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this._title);
        shell.setImage(Resources.getImage("connect"));
    }

    protected Control createButtonBar(Composite parent) {
        return super.createButtonBar(parent);
    }

    protected Control createDialogArea(Composite parent) {
        Composite page = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 10;
        gridLayout.horizontalSpacing = 10;
        page.setLayout((Layout)gridLayout);
        Group machineGroup = new Group(page, 0);
        machineGroup.setText("");
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 10;
        gridLayout.horizontalSpacing = 10;
        machineGroup.setLayout((Layout)gridLayout);
        Label serverLabel = new Label((Composite)machineGroup, 0);
        serverLabel.setText(Resources.getString("Logon.Server"));
        GridData gridData = new GridData();
        gridData.widthHint = 100;
        serverLabel.setLayoutData((Object)gridData);
        this.m_HostText = new Text((Composite)machineGroup, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 100;
        this.m_HostText.setLayoutData((Object)gridData);
        if (this.m_Host != null) {
            this.m_HostText.setText(this.m_Host);
        }
        Label databaseLabel = new Label((Composite)machineGroup, 0);
        databaseLabel.setText(Resources.getString("Logon.Database"));
        this.m_DatabaseText = new Text((Composite)machineGroup, 2048);
        gridData = new GridData(768);
        this.m_DatabaseText.setLayoutData((Object)gridData);
        if (this.m_Database != null) {
            this.m_DatabaseText.setText(this.m_Database);
        }
        Group accountGroup = new Group(page, 0);
        accountGroup.setText("");
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 10;
        gridLayout.horizontalSpacing = 10;
        accountGroup.setLayout((Layout)gridLayout);
        Label userLabel = new Label((Composite)accountGroup, 0);
        userLabel.setText(Resources.getString("Logon.User"));
        gridData = new GridData();
        gridData.widthHint = 100;
        userLabel.setLayoutData((Object)gridData);
        this.m_UserText = new Text((Composite)accountGroup, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 100;
        this.m_UserText.setLayoutData((Object)gridData);
        if (this.m_User == null || this.m_User.length() < 1) {
            this.m_User = Resources.getString("DefaultUser");
        }
        this.m_UserText.setText(this.m_User);
        Label passwordLabel = new Label((Composite)accountGroup, 0);
        passwordLabel.setText(Resources.getString("Logon.Password"));
        this.m_PasswordText = new Text((Composite)accountGroup, 2048);
        gridData = new GridData(768);
        this.m_PasswordText.setLayoutData((Object)gridData);
        this.m_PasswordText.setEchoChar('*');
        this.m_PasswordText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (UserAuthorizationDialog.this.m_PasswordText.getText() != null && UserAuthorizationDialog.this.m_PasswordText.getText().length() > 0 && UserAuthorizationDialog.this.m_PasswordText.getText().charAt(0) != '\"' || (UserAuthorizationDialog.this.m_PasswordText.getText() == null || UserAuthorizationDialog.this.m_PasswordText.getText().length() < 1) && e.text.length() > 0 && e.text.charAt(0) != '\"') {
                    e.text = e.text.toUpperCase();
                }
            }
        });
        if (this.m_Password != null) {
            this.m_PasswordText.setText(this.m_Password);
        }
        this.m_PasswordText.setFocus();
        if (this.m_confirmPassword) {
            passwordLabel = new Label((Composite)accountGroup, 0);
            passwordLabel.setText("Confirm Password");
            this.m_PasswordTextConfirm = new Text((Composite)accountGroup, 2048);
            gridData = new GridData(768);
            this.m_PasswordTextConfirm.setLayoutData((Object)gridData);
            this.m_PasswordTextConfirm.setEchoChar('*');
            this.m_PasswordTextConfirm.setText(this.m_Password);
        }
        this.m_UserText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (UserAuthorizationDialog.this.m_UserText.getText() != null && UserAuthorizationDialog.this.m_UserText.getText().length() > 0 && UserAuthorizationDialog.this.m_UserText.getText().charAt(0) != '\"' || (UserAuthorizationDialog.this.m_UserText.getText() == null || UserAuthorizationDialog.this.m_UserText.getText().length() < 1) && e.text.length() > 0 && e.text.charAt(0) != '\"') {
                    e.text = e.text.toUpperCase();
                }
            }
        });
        this.m_UseSSLButton = new Button((Composite)accountGroup, 32);
        this.m_UseSSLButton.setText("SSL Connection");
        this.m_UseSSLButton.setSelection(this.m_UseSSL);
        this.m_HostText.setFocus();
        return page;
    }

    protected void okPressed() {
        this.m_Host = this.m_HostText.getText();
        this.m_Database = this.m_DatabaseText.getText();
        if (this.m_Database == null || this.m_Database.length() < 1) {
            this.m_DatabaseText.setFocus();
            return;
        }
        this.m_User = this.m_UserText.getText();
        if (this.m_User == null || this.m_User.length() < 1) {
            this.m_UserText.setFocus();
            return;
        }
        this.m_Password = this.m_PasswordText.getText();
        if (this.m_Password == null || this.m_Password.length() < 1) {
            this.m_PasswordText.setFocus();
            return;
        }
        if (this.m_confirmPassword && !this.m_Password.equals(this.m_PasswordTextConfirm.getText())) {
            MessageDialog.openError((Shell)this.getShell(), (String)Resources.getString("General.Error"), (String)Resources.getString("Password_mismatch"));
            this.m_PasswordText.setText("");
            this.m_PasswordTextConfirm.setText("");
            this.m_PasswordText.setFocus();
            return;
        }
        this.m_UseSSL = this.m_UseSSLButton.getSelection();
        super.okPressed();
    }

    public String getHost() {
        return this.m_Host;
    }

    public String getDatabase() {
        return this.m_Database;
    }

    public boolean getUseSSL() {
        return this.m_UseSSL;
    }

    public String getUser() {
        return this.m_User;
    }

    public String getPassword() {
        return this.m_Password;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public void setConfirmPassword(boolean confirmPassword) {
        this.m_confirmPassword = confirmPassword;
    }
}

