/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.gui.jface_dialog;

import com.sap.sdb.syncMan.tool.Resources;
import java.util.Vector;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MSDebugOptionsDialog
extends Dialog {
    public static final String VERBOSE_ADMIN = Resources.getString("MSDebugOptionsDialog.VerboseAdmin");
    public static final String VERBOSE_CONSUMER = Resources.getString("MSDebugOptionsDialog.VerboseConsumer");
    public static final String VERBOSE_EXCEPTION = Resources.getString("MSDebugOptionsDialog.VerboseException");
    public static final String VERBOSE_MSG_BUILDER = Resources.getString("MSDebugOptionsDialog.VerboseMessageBuilder");
    public static final String VERBOSE_SENDING_QUEUES = Resources.getString("MSDebugOptionsDialog.VerboseSendingQueues");
    public static final String VERBOSE_SENDORDER_STAT = Resources.getString("MSDebugOptionsDialog.VerboseSendOrderStat");
    public static final String VERBOSE_SEND_RECEIVE = Resources.getString("MSDebugOptionsDialog.VerboseSendReceive");
    public static final String VERBOSE_SQL_CONNECTION = Resources.getString("MSDebugOptionsDialog.VerboseSQLConnection");
    public static final String VERBOSE_TRACE_BACK = Resources.getString("MSDebugOptionsDialog.VerboseTraceBack");
    public static final String VERBOSE_WAIT = Resources.getString("MSDebugOptionsDialog.VerboseWait");
    public static final String DISPLAY_SERVER_STATE = Resources.getString("MSDebugOptionsDialog.DisplayServerStateInSec");
    private static final String SET_VERBOSE_LEVEL = Resources.getString("MSDebugOptionsDialog.set_level");
    private boolean mbVerboseAdmin = false;
    private boolean mbVerboseConsumer = false;
    private boolean mbVerboseException = false;
    private boolean mbVerboseMessageBuilder = false;
    private boolean mbVerboseSendingQueues = false;
    private boolean mbVerboseSendOrderStat = false;
    private boolean mbVerboseSendReceive = false;
    private boolean mbVerboseSQLConnection = false;
    private boolean mbVerboseTraceback = false;
    private boolean mbVerboseWait = false;
    private long mlDisplayTime = -1L;
    private Text mDisplayTime;
    private Button mVerboseAdmin;
    private Button mVerboseConsumer;
    private Button mVerboseException;
    private Button mVerboseMessageBuilder;
    private Button mVerboseSendingQueues;
    private Button mVerboseSendOrderStat;
    private Button mVerboseSendReceive;
    private Button mVerboseSQLConnection;
    private Button mVerboseTraceBack;
    private Button mVerboseWait;
    private Vector mServerOptions;
    private Vector mNewServerOptions;

    public MSDebugOptionsDialog(Shell parentShell) {
        super(parentShell);
    }

    public MSDebugOptionsDialog(Shell parentShell, Vector serverOptions) {
        super(parentShell);
        this.mServerOptions = serverOptions;
        this.mNewServerOptions = new Vector();
    }

    public void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Resources.getString("MSDebugOptionsDialog.Message_Server_Debug_Options"));
        shell.setImage(Resources.getImage("ms_server"));
    }

    protected Control createButtonBar(Composite parent) {
        return super.createButtonBar(parent);
    }

    protected Control createDialogArea(Composite parent) {
        Composite page = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 10;
        gridLayout.horizontalSpacing = 10;
        page.setLayout((Layout)gridLayout);
        Group debugGroup = new Group(page, 0);
        debugGroup.setText("");
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 10;
        gridLayout.horizontalSpacing = 10;
        debugGroup.setLayout((Layout)gridLayout);
        Group verboseGroup = new Group((Composite)debugGroup, 0);
        verboseGroup.setText(Resources.getString("MSDebugOptionsDialog.Verbose"));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 10;
        gridLayout.horizontalSpacing = 10;
        verboseGroup.setLayout((Layout)gridLayout);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 10;
        gridLayout.horizontalSpacing = 10;
        verboseGroup.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.widthHint = 150;
        this.mVerboseAdmin = new Button((Composite)verboseGroup, 32);
        this.mVerboseAdmin.setText(Resources.getString("MSDebugOptionsDialog.Admin"));
        this.mVerboseAdmin.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        gridData.widthHint = 150;
        this.mVerboseConsumer = new Button((Composite)verboseGroup, 32);
        this.mVerboseConsumer.setText(Resources.getString("MSDebugOptionsDialog.Consumer"));
        this.mVerboseConsumer.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        gridData.widthHint = 150;
        this.mVerboseException = new Button((Composite)verboseGroup, 32);
        this.mVerboseException.setText(Resources.getString("MSDebugOptionsDialog.Exception"));
        this.mVerboseException.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        gridData.widthHint = 150;
        this.mVerboseMessageBuilder = new Button((Composite)verboseGroup, 32);
        this.mVerboseMessageBuilder.setText(Resources.getString("MSDebugOptionsDialog.Message_Builder"));
        this.mVerboseMessageBuilder.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        gridData.widthHint = 150;
        this.mVerboseSendingQueues = new Button((Composite)verboseGroup, 32);
        this.mVerboseSendingQueues.setText(Resources.getString("MSDebugOptionsDialog.Sending_Queues"));
        this.mVerboseSendingQueues.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        gridData.widthHint = 150;
        this.mVerboseSendOrderStat = new Button((Composite)verboseGroup, 32);
        this.mVerboseSendOrderStat.setText(Resources.getString("MSDebugOptionsDialog.Send_Order_Stat"));
        this.mVerboseSendOrderStat.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        gridData.widthHint = 150;
        this.mVerboseSendReceive = new Button((Composite)verboseGroup, 32);
        this.mVerboseSendReceive.setText(Resources.getString("MSDebugOptionsDialog.Send_Receive"));
        this.mVerboseSendReceive.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        gridData.widthHint = 150;
        this.mVerboseSQLConnection = new Button((Composite)verboseGroup, 32);
        this.mVerboseSQLConnection.setText(Resources.getString("MSDebugOptionsDialog.SQL_Connection"));
        this.mVerboseSQLConnection.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        gridData.widthHint = 150;
        this.mVerboseTraceBack = new Button((Composite)verboseGroup, 32);
        this.mVerboseTraceBack.setText(Resources.getString("MSDebugOptionsDialog.Trace_Back"));
        this.mVerboseTraceBack.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        gridData.widthHint = 150;
        this.mVerboseWait = new Button((Composite)verboseGroup, 32);
        this.mVerboseWait.setText(Resources.getString("MSDebugOptionsDialog.Wait"));
        this.mVerboseWait.setLayoutData((Object)gridData);
        Label displayLabel = new Label((Composite)debugGroup, 0);
        displayLabel.setText(Resources.getString("MSDebugOptionsDialog.Status_Display_Intervall_in_Seconds"));
        gridData = new GridData();
        gridData.widthHint = 200;
        displayLabel.setLayoutData((Object)gridData);
        this.mDisplayTime = new Text((Composite)debugGroup, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 200;
        this.mDisplayTime.setLayoutData((Object)gridData);
        this.parseOptions();
        return page;
    }

    protected void okPressed() {
        boolean btmp;
        String value = this.mDisplayTime.getText();
        long tmp = -1L;
        String one = "1";
        String zero = "0";
        try {
            tmp = Long.parseLong(value);
        }
        catch (NumberFormatException ex) {
            MessageDialog.openError((Shell)this.getShell(), (String)Resources.getString("MSDebugOptionsDialog.Error"), (String)Resources.getString("MSDebugOptionsDialog.Enter_numeric_value"));
            this.mDisplayTime.setFocus();
            return;
        }
        if (tmp != this.mlDisplayTime) {
            this.mNewServerOptions.add(Resources.getString("MSDebugOptionsDialog.set") + DISPLAY_SERVER_STATE + " " + value);
        }
        if ((btmp = this.mVerboseAdmin.getSelection()) != this.mbVerboseAdmin) {
            this.mNewServerOptions.add(SET_VERBOSE_LEVEL + VERBOSE_ADMIN + " " + (btmp ? one : zero));
        }
        if ((btmp = this.mVerboseConsumer.getSelection()) != this.mbVerboseConsumer) {
            this.mNewServerOptions.add(SET_VERBOSE_LEVEL + VERBOSE_CONSUMER + " " + (btmp ? one : zero));
        }
        if ((btmp = this.mVerboseException.getSelection()) != this.mbVerboseException) {
            this.mNewServerOptions.add(SET_VERBOSE_LEVEL + VERBOSE_EXCEPTION + " " + (btmp ? one : zero));
        }
        if ((btmp = this.mVerboseMessageBuilder.getSelection()) != this.mbVerboseMessageBuilder) {
            this.mNewServerOptions.add(SET_VERBOSE_LEVEL + VERBOSE_MSG_BUILDER + " " + (btmp ? one : zero));
        }
        if ((btmp = this.mVerboseSendingQueues.getSelection()) != this.mbVerboseSendingQueues) {
            this.mNewServerOptions.add(SET_VERBOSE_LEVEL + VERBOSE_SENDING_QUEUES + " " + (btmp ? one : zero));
        }
        if ((btmp = this.mVerboseSendOrderStat.getSelection()) != this.mbVerboseSendOrderStat) {
            this.mNewServerOptions.add(SET_VERBOSE_LEVEL + VERBOSE_SENDORDER_STAT + " " + (btmp ? one : zero));
        }
        if ((btmp = this.mVerboseSendReceive.getSelection()) != this.mbVerboseSendReceive) {
            this.mNewServerOptions.add(SET_VERBOSE_LEVEL + VERBOSE_SEND_RECEIVE + " " + (btmp ? one : zero));
        }
        if ((btmp = this.mVerboseSQLConnection.getSelection()) != this.mbVerboseSQLConnection) {
            this.mNewServerOptions.add(SET_VERBOSE_LEVEL + VERBOSE_SQL_CONNECTION + " " + (btmp ? one : zero));
        }
        if ((btmp = this.mVerboseTraceBack.getSelection()) != this.mbVerboseTraceback) {
            this.mNewServerOptions.add(SET_VERBOSE_LEVEL + VERBOSE_TRACE_BACK + " " + (btmp ? one : zero));
        }
        if ((btmp = this.mVerboseWait.getSelection()) != this.mbVerboseWait) {
            this.mNewServerOptions.add(SET_VERBOSE_LEVEL + VERBOSE_WAIT + " " + (btmp ? one : zero));
        }
        super.okPressed();
    }

    private void parseOptions() {
        for (int i = 0; i < this.mServerOptions.size(); ++i) {
            String tmp = this.mServerOptions.get(i).toString();
            if (tmp.startsWith(DISPLAY_SERVER_STATE)) {
                String value = tmp.substring(DISPLAY_SERVER_STATE.length() + 1);
                this.mlDisplayTime = Long.parseLong(value);
                this.mDisplayTime.setText(value);
            }
            if (tmp.startsWith(VERBOSE_ADMIN)) {
                if (tmp.substring(VERBOSE_ADMIN.length() + 1).equalsIgnoreCase(Resources.getString("MSDebugOptionsDialog.true"))) {
                    this.mbVerboseAdmin = true;
                }
                this.mVerboseAdmin.setSelection(this.mbVerboseAdmin);
                this.mVerboseAdmin.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                    }
                });
            }
            if (tmp.startsWith(VERBOSE_CONSUMER)) {
                if (tmp.substring(VERBOSE_CONSUMER.length() + 1).equalsIgnoreCase(Resources.getString("MSDebugOptionsDialog.true"))) {
                    this.mbVerboseConsumer = true;
                }
                this.mVerboseConsumer.setSelection(this.mbVerboseConsumer);
                this.mVerboseConsumer.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                    }
                });
            }
            if (tmp.startsWith(VERBOSE_EXCEPTION)) {
                if (tmp.substring(VERBOSE_EXCEPTION.length() + 1).equalsIgnoreCase(Resources.getString("MSDebugOptionsDialog.true"))) {
                    this.mbVerboseException = true;
                }
                this.mVerboseException.setSelection(this.mbVerboseException);
                this.mVerboseException.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                    }
                });
            }
            if (tmp.startsWith(VERBOSE_MSG_BUILDER)) {
                if (tmp.substring(VERBOSE_MSG_BUILDER.length() + 1).equalsIgnoreCase(Resources.getString("MSDebugOptionsDialog.true"))) {
                    this.mbVerboseMessageBuilder = true;
                }
                this.mVerboseMessageBuilder.setSelection(this.mbVerboseMessageBuilder);
                this.mVerboseMessageBuilder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                    }
                });
            }
            if (tmp.startsWith(VERBOSE_SENDING_QUEUES)) {
                if (tmp.substring(VERBOSE_SENDING_QUEUES.length() + 1).equalsIgnoreCase(Resources.getString("MSDebugOptionsDialog.true"))) {
                    this.mbVerboseSendingQueues = true;
                }
                this.mVerboseSendingQueues.setSelection(this.mbVerboseSendingQueues);
                this.mVerboseSendingQueues.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                    }
                });
            }
            if (tmp.startsWith(VERBOSE_SENDORDER_STAT)) {
                if (tmp.substring(VERBOSE_SENDORDER_STAT.length() + 1).equalsIgnoreCase(Resources.getString("MSDebugOptionsDialog.true"))) {
                    this.mbVerboseSendOrderStat = true;
                }
                this.mVerboseSendOrderStat.setSelection(this.mbVerboseSendOrderStat);
                this.mVerboseSendOrderStat.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                    }
                });
            }
            if (tmp.startsWith(VERBOSE_SEND_RECEIVE)) {
                if (tmp.substring(VERBOSE_SEND_RECEIVE.length() + 1).equalsIgnoreCase(Resources.getString("MSDebugOptionsDialog.true"))) {
                    this.mbVerboseSendReceive = true;
                }
                this.mVerboseSendReceive.setSelection(this.mbVerboseSendReceive);
                this.mVerboseSendReceive.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                    }
                });
            }
            if (tmp.startsWith(VERBOSE_SQL_CONNECTION)) {
                if (tmp.substring(VERBOSE_SQL_CONNECTION.length() + 1).equalsIgnoreCase(Resources.getString("MSDebugOptionsDialog.true"))) {
                    this.mbVerboseSQLConnection = true;
                }
                this.mVerboseSQLConnection.setSelection(this.mbVerboseSQLConnection);
                this.mVerboseSQLConnection.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                    }
                });
            }
            if (tmp.startsWith(VERBOSE_TRACE_BACK)) {
                if (tmp.substring(VERBOSE_TRACE_BACK.length() + 1).equalsIgnoreCase(Resources.getString("MSDebugOptionsDialog.true"))) {
                    this.mbVerboseTraceback = true;
                }
                this.mVerboseTraceBack.setSelection(this.mbVerboseTraceback);
                this.mVerboseTraceBack.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                    }
                });
            }
            if (!tmp.startsWith(VERBOSE_WAIT)) continue;
            if (tmp.substring(VERBOSE_WAIT.length() + 1).equalsIgnoreCase(Resources.getString("MSDebugOptionsDialog.true"))) {
                this.mbVerboseWait = true;
            }
            this.mVerboseWait.setSelection(this.mbVerboseWait);
            this.mVerboseWait.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                }
            });
        }
    }

    public Vector getNewServerDebugOptions() {
        return this.mNewServerOptions;
    }
}

