/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.gui.jface_controls;

import com.sap.sdb.syncMan.design.Column;
import com.sap.sdb.syncMan.design.ColumnGroup;
import com.sap.sdb.syncMan.design.DesignSQLLayer;
import com.sap.sdb.syncMan.design.ReplicationTable;
import com.sap.sdb.syncMan.gui.SyncManGUI;
import com.sap.sdb.syncMan.gui.jface_controls.SyncManControl;
import com.sap.sdb.syncMan.gui.jface_dialog.ImportRepTableDialog;
import com.sap.sdb.syncMan.gui.jface_objects.Columns_Transfer;
import com.sap.sdb.syncMan.gui.jface_objects.Columns_Type;
import com.sap.sdb.syncMan.gui.jface_viewer.RepTableTreeContentProvider;
import com.sap.sdb.syncMan.gui.jface_viewer.RepTableTreeLabelProvider;
import com.sap.sdb.syncMan.tool.Resources;
import com.sap.sdb.syncMan.util.GenUID;
import java.util.Enumeration;
import java.util.Iterator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;

public class ReplicationTableControl
extends SyncManControl {
    private List lstTableColumns;
    private List lstGroupColumns;
    private Combo comboColumnGroups;
    private Button buttonVersioned;
    private Button buttonNewColumnGroup;
    private Button buttonDeleteColumnGroup;
    private Button buttonRemoveFromColumnGroup;
    private Button buttonAddColumnToColumnGroup;
    private ReplicationTable _selectedRepTable;
    private Column _dragDropCol;
    private boolean _atLeastOneBlobColumnGroup;
    private int colWidth = 150;

    public ReplicationTableControl(SyncManGUI syncManGUI, SashForm parent) {
        super(syncManGUI, parent);
        this.createContents();
    }

    private void createTableColumnList(Group groupColLists) {
        this.lstTableColumns = new List((Composite)groupColLists, 2818);
        GridData gridData2 = new GridData(272);
        int listHeight = this.lstTableColumns.getItemHeight() * 7;
        Rectangle trim = this.lstGroupColumns.computeTrim(0, 0, this.colWidth, listHeight);
        gridData2.heightHint = trim.height;
        gridData2.widthHint = trim.width;
        this.lstTableColumns.setLayoutData((Object)gridData2);
        this.lstTableColumns.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReplicationTableControl.this.checkAddColumnButton();
            }
        });
        Transfer[] types = new Transfer[]{Columns_Transfer.getInstance()};
        DragSource sourceTableColumns = new DragSource((Control)this.lstTableColumns, 2);
        sourceTableColumns.setTransfer(types);
        sourceTableColumns.addDragListener(new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                if (ReplicationTableControl.this.lstTableColumns.getSelectionIndex() < 0) {
                    event.doit = false;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                ColumnGroup cg;
                if (Columns_Transfer.getInstance().isSupportedType(event.dataType) && (cg = ReplicationTableControl.this._selectedRepTable.singleColumnGroup()) != null) {
                    String cols = ReplicationTableControl.this.lstTableColumns.getItem(ReplicationTableControl.this.lstTableColumns.getSelectionIndex());
                    Column col = cg.getColumnByName(cols);
                    Columns_Type tempTransfer = new Columns_Type();
                    tempTransfer.columnID = col.columnID();
                    event.data = new Columns_Type[]{tempTransfer};
                    ReplicationTableControl.this._dragDropCol = col;
                }
            }

            public void dragFinished(DragSourceEvent event) {
                if (event.detail == 2) {
                    // empty if block
                }
            }
        });
        DropTarget target2 = new DropTarget((Control)this.lstTableColumns, 2);
        final Columns_Transfer ColumnTransfer2 = Columns_Transfer.getInstance();
        Transfer[] types2 = new Transfer[]{ColumnTransfer2};
        target2.setTransfer(types2);
        target2.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 2) != 0 ? 2 : 0;
                }
            }

            public void dragOver(DropTargetEvent event) {
                event.feedback = 9;
                if (ColumnTransfer2.isSupportedType(event.currentDataType)) {
                    // empty if block
                }
            }

            public void dragOperationChanged(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 2) != 0 ? 2 : 0;
                }
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dropAccept(DropTargetEvent event) {
            }

            public void drop(DropTargetEvent event) {
                if (ColumnTransfer2.isSupportedType(event.currentDataType)) {
                    Columns_Type[] temp = (Columns_Type[])event.data;
                    if (ReplicationTableControl.this._dragDropCol != null && temp[0] != null && ReplicationTableControl.this._dragDropCol.columnID() == temp[0].columnID) {
                        ReplicationTableControl.this.removeOneColumnFromColGroup(ReplicationTableControl.this.getSelectedColumnGroup(), ReplicationTableControl.this._dragDropCol);
                        ReplicationTableControl.this.checkRemoveColumnsButton();
                        ReplicationTableControl.this.displayTableColumns();
                        ReplicationTableControl.this.applyChanges();
                        ReplicationTableControl.this._dragDropCol = null;
                    }
                }
            }
        });
    }

    private void createGroupColumnList(Group groupColLists) {
        this.lstGroupColumns = new List((Composite)groupColLists, 2818);
        GridData gridData = new GridData(272);
        int listHeight = this.lstGroupColumns.getItemHeight() * 7;
        Rectangle trim = this.lstGroupColumns.computeTrim(0, 0, this.colWidth, listHeight);
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.widthHint = trim.width;
        this.lstGroupColumns.setLayoutData((Object)gridData);
        this.lstGroupColumns.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = ReplicationTableControl.this.comboColumnGroups.getSelectionIndex();
                if (index > -1) {
                    ReplicationTableControl.this.checkRemoveColumnsButton();
                }
            }
        });
        Transfer[] types = new Transfer[]{Columns_Transfer.getInstance()};
        DragSource sourceGroupColumns = new DragSource((Control)this.lstGroupColumns, 2);
        sourceGroupColumns.setTransfer(types);
        sourceGroupColumns.addDragListener(new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                int index = ReplicationTableControl.this.lstGroupColumns.getSelectionIndex();
                if (index < 0) {
                    event.doit = false;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                ColumnGroup cg;
                if (Columns_Transfer.getInstance().isSupportedType(event.dataType) && (cg = ReplicationTableControl.this.getSelectedColumnGroup()) != null) {
                    String cols = ReplicationTableControl.this.lstGroupColumns.getItem(ReplicationTableControl.this.lstGroupColumns.getSelectionIndex());
                    Column col = cg.getColumnByName(cols);
                    Columns_Type tempTransfer = new Columns_Type();
                    tempTransfer.columnID = col.columnID();
                    event.data = new Columns_Type[]{tempTransfer};
                    ReplicationTableControl.this._dragDropCol = col;
                }
            }

            public void dragFinished(DragSourceEvent event) {
                if (event.detail == 2) {
                    // empty if block
                }
            }
        });
        DropTarget target = new DropTarget((Control)this.lstGroupColumns, 2);
        final Columns_Transfer ColumnTransfer = Columns_Transfer.getInstance();
        types = new Transfer[]{ColumnTransfer};
        target.setTransfer(types);
        target.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 2) != 0 ? 2 : 0;
                }
            }

            public void dragOver(DropTargetEvent event) {
                event.feedback = 9;
                if (ColumnTransfer.isSupportedType(event.currentDataType)) {
                    // empty if block
                }
            }

            public void dragOperationChanged(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 2) != 0 ? 2 : 0;
                }
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dropAccept(DropTargetEvent event) {
            }

            public void drop(DropTargetEvent event) {
                if (ColumnTransfer.isSupportedType(event.currentDataType)) {
                    Columns_Type[] temp = (Columns_Type[])event.data;
                    if (ReplicationTableControl.this._dragDropCol != null && temp[0] != null && ReplicationTableControl.this._dragDropCol.columnID() == temp[0].columnID) {
                        ColumnGroup cg = ReplicationTableControl.this.getSelectedColumnGroup();
                        if (cg != null) {
                            ReplicationTableControl.this.addOneColumnToColumnGroup(cg, ReplicationTableControl.this._dragDropCol);
                            ReplicationTableControl.this.displayColumnGroup(cg);
                            ReplicationTableControl.this.applyChanges();
                        }
                        ReplicationTableControl.this._dragDropCol = null;
                    }
                }
            }
        });
    }

    private void createWidgets(Composite parent) {
        ScrolledComposite scrollColumnGroups = new ScrolledComposite(parent, 768);
        Composite columnGroups = new Composite((Composite)scrollColumnGroups, 0);
        scrollColumnGroups.setContent((Control)columnGroups);
        scrollColumnGroups.setExpandHorizontal(true);
        scrollColumnGroups.setExpandVertical(true);
        GridLayout gridLayoutMain = new GridLayout();
        gridLayoutMain.numColumns = 1;
        columnGroups.setLayout((Layout)gridLayoutMain);
        GridLayout gridLayoutApply = new GridLayout();
        gridLayoutApply.numColumns = 1;
        gridLayoutApply.makeColumnsEqualWidth = true;
        GridData gridApplyData = new GridData(1808);
        gridApplyData.horizontalSpan = 2;
        Group groupApply = new Group(columnGroups, 0);
        groupApply.setLayoutData((Object)gridApplyData);
        groupApply.setLayout((Layout)gridLayoutApply);
        Group groupSelectedColGroup = new Group((Composite)groupApply, 0);
        GridLayout gridLayoutSelectedColGroup = new GridLayout();
        gridLayoutSelectedColGroup.numColumns = 2;
        gridLayoutSelectedColGroup.makeColumnsEqualWidth = true;
        this.comboColumnGroups = new Combo((Composite)groupSelectedColGroup, 12);
        this.comboColumnGroups.setText("");
        this.comboColumnGroups.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReplicationTableControl.this.displayColumnGroup(ReplicationTableControl.this.getSelectedColumnGroup());
            }
        });
        GridData gridDataCombo = new GridData(272);
        Rectangle trim = this.comboColumnGroups.computeTrim(0, 0, this.colWidth, 0);
        gridDataCombo.widthHint = trim.width;
        this.comboColumnGroups.setLayoutData((Object)gridDataCombo);
        this.buttonVersioned = new Button((Composite)groupSelectedColGroup, 32);
        this.buttonVersioned.setText(Resources.getString("ReplicationTable.Versioned"));
        this.buttonVersioned.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnGroup cg = ReplicationTableControl.this.getSelectedColumnGroup();
                if (cg != null) {
                    cg.setVersioned(ReplicationTableControl.this.buttonVersioned.getSelection());
                    try {
                        ReplicationTableControl.this._selectedRepTable.setVersionedColumnGroup(cg, ReplicationTableControl.this.buttonVersioned.getSelection());
                        ReplicationTableControl.this.applyChanges();
                    }
                    catch (Exception ex) {
                        SyncManControl.writeProt(ex);
                    }
                }
            }
        });
        this.buttonNewColumnGroup = new Button((Composite)groupSelectedColGroup, 8);
        this.buttonNewColumnGroup.setText(Resources.getString("ReplicationTable.New_Column_Group"));
        this.buttonNewColumnGroup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReplicationTableControl.this.displayNewColumnGroupDialog();
            }
        });
        this.buttonDeleteColumnGroup = new Button((Composite)groupSelectedColGroup, 8);
        this.buttonDeleteColumnGroup.setText(Resources.getString("ReplicationTable.Delete_Column_Group"));
        this.buttonDeleteColumnGroup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReplicationTableControl.this.deleteColumnGroup();
            }
        });
        GridData gridSelected = new GridData(272);
        gridSelected.horizontalSpan = 2;
        groupSelectedColGroup.setLayoutData((Object)gridSelected);
        groupSelectedColGroup.setLayout((Layout)gridLayoutSelectedColGroup);
        Group groupColLists = new Group((Composite)groupApply, 0);
        GridData gridColListsData = new GridData(1808);
        GridLayout gridLayoutColLists = new GridLayout();
        gridLayoutColLists.numColumns = 3;
        groupColLists.setLayout((Layout)gridLayoutColLists);
        groupColLists.setLayoutData((Object)gridColListsData);
        Label lblGroupColumns = new Label((Composite)groupColLists, 0);
        lblGroupColumns.setText(Resources.getString("ReplicationTable.Columns_of_ColGroup"));
        Label dummy = new Label((Composite)groupColLists, 0);
        dummy.setText("");
        Label lblTableColumns = new Label((Composite)groupColLists, 0);
        lblTableColumns.setText(Resources.getString("ReplicationTable.Columns_of_Table"));
        this.createGroupColumnList(groupColLists);
        Group groupColButtons = new Group((Composite)groupColLists, 0);
        this.createTableColumnList(groupColLists);
        this.buttonAddColumnToColumnGroup = new Button((Composite)groupColButtons, 0);
        this.buttonAddColumnToColumnGroup.setImage(Resources.getImage("coll"));
        this.buttonAddColumnToColumnGroup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ReplicationTableControl.this.lstTableColumns.getSelectionIndex() > -1) {
                    ReplicationTableControl.this.addColumnsToColumnGroup();
                }
            }
        });
        this.buttonRemoveFromColumnGroup = new Button((Composite)groupColButtons, 0);
        this.buttonRemoveFromColumnGroup.setImage(Resources.getImage("colr"));
        this.buttonRemoveFromColumnGroup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReplicationTableControl.this.removeColumnsFromColGroup();
            }
        });
        GridLayout gridLayoutColButtons = new GridLayout();
        gridLayoutColButtons.numColumns = 1;
        gridLayoutColButtons.makeColumnsEqualWidth = true;
        groupColButtons.setSize(40, 100);
        groupColButtons.setLayout((Layout)gridLayoutColButtons);
        Point pt = columnGroups.computeSize(-1, -1);
        scrollColumnGroups.setMinWidth(pt.x);
        scrollColumnGroups.setMinHeight(pt.y);
        this.comboColumnGroups.setEnabled(false);
        this.buttonNewColumnGroup.setEnabled(false);
        this.buttonDeleteColumnGroup.setEnabled(false);
        this.buttonAddColumnToColumnGroup.setEnabled(false);
        this.buttonRemoveFromColumnGroup.setEnabled(false);
        this.buttonVersioned.setEnabled(false);
        this.lstGroupColumns.setEnabled(false);
        this.lstTableColumns.setEnabled(false);
    }

    protected void createContents() {
        this._tree = new TreeViewer((Composite)this);
        this._tree.setContentProvider((IContentProvider)new RepTableTreeContentProvider(this));
        this._tree.setLabelProvider((IBaseLabelProvider)new RepTableTreeLabelProvider());
        this._tree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                try {
                    Object obj = selection.getFirstElement();
                    if (obj instanceof ReplicationTable) {
                        ReplicationTable temp = (ReplicationTable)obj;
                        ReplicationTableControl.this._selectedRepTable = new ReplicationTable(temp.getTableID(), temp.getHost(), temp.getDataBase(), temp.getSchema(), temp.getName());
                    } else {
                        ReplicationTableControl.this._selectedRepTable = null;
                    }
                    ReplicationTableControl.this.displayRepTable();
                }
                catch (Exception ex) {
                    SyncManControl.writeProt(ex);
                }
            }
        });
        this._tree.getTree().addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Point point = new Point(event.x, event.y);
                TreeItem item = ReplicationTableControl.this._tree.getTree().getItem(point);
                if (item != null && event.button == 3) {
                    Rectangle rect = item.getBounds();
                    point = new Point(rect.x, rect.y + rect.height);
                    Point pt = ReplicationTableControl.this._tree.getTree().toDisplay(point);
                    ReplicationTableControl.this.m_SyncManGUI.showRepTableContextMenu(pt);
                }
            }
        });
        this.createWidgets((Composite)this);
    }

    public void drawTree() {
        this._tree.setInput(new Object());
    }

    public void clearTree() {
        this._tree.setInput(null);
        this.checkWidgets();
    }

    private void displayColumnGroup(ColumnGroup cg) {
        this.lstGroupColumns.removeAll();
        if (cg == null) {
            this.checkAddColumnButton();
            this.checkRemoveColumnsButton();
            this.buttonDeleteColumnGroup.setEnabled(false);
            this.buttonVersioned.setSelection(false);
            this.buttonVersioned.setEnabled(false);
            return;
        }
        Enumeration cols = cg.columns();
        while (cols.hasMoreElements()) {
            Column col = (Column)cols.nextElement();
            this.lstGroupColumns.add(col.columnName());
        }
        this.buttonVersioned.setSelection(cg.versioned());
        this.buttonVersioned.setEnabled((this.getSelectedColumnGroup() != null && this._selectedRepTable.versionedColumnGroup() == null || this.getSelectedColumnGroup() == this._selectedRepTable.versionedColumnGroup()) && !this._atLeastOneBlobColumnGroup);
        this.buttonDeleteColumnGroup.setEnabled(!cg.containsBlobColumn());
        this.checkAddColumnButton();
        this.checkRemoveColumnsButton();
    }

    private void displayRepTable() {
        this.checkWidgets();
        if (this._selectedRepTable == null) {
            return;
        }
        this._atLeastOneBlobColumnGroup = false;
        try {
            this._selectedRepTable.loadColumnGroups(this.getConMetaData());
            this.comboColumnGroups.removeAll();
            ColumnGroup cg = null;
            for (int i = 0; i < this._selectedRepTable.getColumnGroups().size(); ++i) {
                cg = (ColumnGroup)this._selectedRepTable.getColumnGroups().get(i);
                this._atLeastOneBlobColumnGroup = cg.containsBlobColumn() && !this._atLeastOneBlobColumnGroup;
                this.comboColumnGroups.add(cg.columnGroupName());
            }
            if (this.comboColumnGroups.getItemCount() > 0) {
                this.comboColumnGroups.select(0);
                this.displayColumnGroup(this._selectedRepTable.getColumnGroup(0));
            } else {
                this.displayColumnGroup(null);
            }
        }
        catch (Exception ex) {
            ReplicationTableControl.writeProt(ex);
            return;
        }
        this.displayTableColumns();
    }

    private void checkVersionButton() {
        if (this.comboColumnGroups.getSelectionIndex() < 0) {
            this.buttonVersioned.setEnabled(false);
            this.buttonVersioned.setSelection(false);
        }
    }

    private void checkAddColumnButton() {
        if (this.lstTableColumns.getSelectionIndex() < 0 || this.comboColumnGroups.getSelectionIndex() < 0) {
            this.buttonAddColumnToColumnGroup.setEnabled(false);
        } else {
            this.buttonAddColumnToColumnGroup.setEnabled(true);
        }
    }

    private void checkRemoveColumnsButton() {
        if (this.lstGroupColumns.getSelectionIndex() < 0) {
            this.buttonRemoveFromColumnGroup.setEnabled(false);
        } else {
            String[] cols = this.lstGroupColumns.getSelection();
            if (cols != null) {
                this.buttonRemoveFromColumnGroup.setEnabled(true);
                ColumnGroup cg = this.getSelectedColumnGroup();
                for (int i = 0; i < cols.length; ++i) {
                    Column col = cg.getColumnByName(cols[i]);
                    if (col.sqlType() != -4 && col.sqlType() != -1) continue;
                    this.buttonRemoveFromColumnGroup.setEnabled(false);
                    break;
                }
            }
        }
    }

    private void displayNewColumnGroupDialog() {
        InputDialog dlg = new InputDialog(this.getShell(), Resources.getString("ReplicationTable.New_Column_Group"), Resources.getString("ReplicationTable.New_Column_Group_Name"), "", null);
        dlg.setBlockOnOpen(true);
        if (dlg.open() == 0) {
            String name = dlg.getValue();
            if (name != null && name.length() > 0) {
                long columnGroupID = GenUID.getNext();
                ColumnGroup cg = new ColumnGroup(name, columnGroupID);
                cg.setForReplication(true);
                try {
                    int index = this._selectedRepTable.addColumnGroup(cg);
                    if (index >= 0) {
                        this.comboColumnGroups.add(cg.columnGroupName(), index);
                        this.comboColumnGroups.select(index);
                        this.displayColumnGroup(cg);
                        this.applyChanges();
                    }
                    this.checkAddColumnButton();
                    this.checkRemoveColumnsButton();
                }
                catch (Exception ex) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Resources.getString("ReplicationTable.Error"), (String)ex.toString());
                }
            } else {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)Resources.getString("ReplicationTable.Invalid_Name_for_Column_Group"));
            }
        }
    }

    private void deleteColumnGroup() {
        ColumnGroup cg = this.getSelectedColumnGroup();
        if (cg != null && !cg.containsBlobColumn()) {
            try {
                this._selectedRepTable.removeColumnGroup(cg);
            }
            catch (Exception ex) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)ex.toString());
                return;
            }
            this.displayTableColumns();
            this.comboColumnGroups.remove(cg.columnGroupName());
            if (this.comboColumnGroups.getItemCount() > 0) {
                this.comboColumnGroups.select(0);
                this.displayColumnGroup(this._selectedRepTable.getColumnGroup(0));
            } else {
                this.comboColumnGroups.setText("");
                this.lstGroupColumns.removeAll();
            }
            this.checkVersionButton();
            this.checkAddColumnButton();
            this.checkRemoveColumnsButton();
            this.applyChanges();
        }
    }

    private void displayTableColumns() {
        this.lstTableColumns.removeAll();
        if (this._selectedRepTable == null) {
            return;
        }
        ColumnGroup singleCols = this._selectedRepTable.singleColumnGroup();
        Enumeration cols = singleCols.columns();
        while (cols.hasMoreElements()) {
            Column col = (Column)cols.nextElement();
            this.lstTableColumns.add(col.columnName());
        }
    }

    private ColumnGroup getSelectedColumnGroup() {
        int index = this.comboColumnGroups.getSelectionIndex();
        if (index < 0) {
            return null;
        }
        return this._selectedRepTable.getColumnGroup(index);
    }

    public ReplicationTable getSelectedRepTable() {
        return this._selectedRepTable;
    }

    private void removeColumnsFromColGroup() {
        ColumnGroup cg = this.getSelectedColumnGroup();
        if (cg != null) {
            String[] cols = this.lstGroupColumns.getSelection();
            for (int i = 0; i < cols.length; ++i) {
                Column col = cg.getColumnByName(cols[i]);
                if (this.removeOneColumnFromColGroup(cg, col)) continue;
                return;
            }
            this.checkRemoveColumnsButton();
            this.displayTableColumns();
            this.applyChanges();
        }
    }

    private boolean removeOneColumnFromColGroup(ColumnGroup cg, Column col) {
        if (col.sqlType() != -4 && col.sqlType() != -1) {
            try {
                this._selectedRepTable.withdrawColumnFromColumnGroup(cg, col);
                this.lstGroupColumns.remove(col.columnName());
            }
            catch (Exception ex) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)ex.toString());
                return false;
            }
        }
        return true;
    }

    private void addColumnsToColumnGroup() {
        ColumnGroup cg = this._selectedRepTable.singleColumnGroup();
        ColumnGroup target = this.getSelectedColumnGroup();
        if (cg != null) {
            String[] cols = this.lstTableColumns.getSelection();
            for (int i = 0; i < cols.length; ++i) {
                Column col = cg.getColumnByName(cols[i]);
                this.addOneColumnToColumnGroup(target, col);
            }
            this.displayColumnGroup(target);
            this.applyChanges();
        }
    }

    private void addOneColumnToColumnGroup(ColumnGroup cg, Column col) {
        try {
            this._selectedRepTable.assignColumnToColumnGroup(cg, col);
            this.lstTableColumns.remove(col.columnName());
        }
        catch (Exception ex) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)ex.toString());
        }
    }

    private void checkWidgets() {
        boolean empty;
        boolean bl = empty = !this.getConMetaData().isConnected() || this._selectedRepTable == null;
        if (empty) {
            this.comboColumnGroups.removeAll();
            this.lstTableColumns.removeAll();
            this.lstGroupColumns.removeAll();
            this.buttonVersioned.setSelection(false);
        }
        this.comboColumnGroups.setEnabled(!empty);
        this.buttonNewColumnGroup.setEnabled(!empty);
        this.buttonDeleteColumnGroup.setEnabled(!empty);
        this.buttonAddColumnToColumnGroup.setEnabled(!empty);
        this.buttonRemoveFromColumnGroup.setEnabled(!empty);
        this.buttonVersioned.setEnabled(!empty);
        this.lstGroupColumns.setEnabled(!empty);
        this.lstTableColumns.setEnabled(!empty);
    }

    public void displayImportRepTableDialog() {
        ImportRepTableDialog dlg = new ImportRepTableDialog(this.getShell(), this.getConMetaData(), this.getConMetaData());
        dlg.setBlockOnOpen(true);
        int returnCode = dlg.open();
        if (returnCode == 0) {
            this.drawTree();
        }
    }

    private void applyChanges() {
        if (this._selectedRepTable == null) {
            return;
        }
        try {
            long count = DesignSQLLayer.selectTableUsageCount(this.getConMetaData(), this._selectedRepTable.getTableID());
            if (count >= 1L) {
                throw new Exception(Resources.getString("ReplicationTable.Changes_not_possible.Base_Table") + this._selectedRepTable.getName() + Resources.getString("ReplicationTable.is_used_by") + String.valueOf(count) + Resources.getString("ReplicationTable.Replication_Participants"));
            }
            DesignSQLLayer.alterRepTable(this.getConMetaData(), this._selectedRepTable);
            SyncManGUI.commitConnection(this.getConMetaData());
        }
        catch (Exception ex) {
            ReplicationTableControl.writeProt(ex);
            SyncManGUI.rollBackConnection(this.getConMetaData());
            this._selectedRepTable = new ReplicationTable(this._selectedRepTable.getTableID(), this._selectedRepTable.getHost(), this._selectedRepTable.getDataBase(), this._selectedRepTable.getSchema(), this._selectedRepTable.getName());
            this.displayRepTable();
        }
    }

    public void deleteRepTable() {
        if (this._tree.getSelection().isEmpty()) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this._tree.getSelection();
        this._tree.getTree().setRedraw(false);
        try {
            Iterator iterator = selection.iterator();
            System.out.println(selection.size());
            ReplicationTable repTable = null;
            while (iterator.hasNext()) {
                repTable = (ReplicationTable)iterator.next();
                long count = DesignSQLLayer.selectTableUsageCount(this.getConMetaData(), repTable.getTableID());
                if (count < 1L) {
                    DesignSQLLayer.deleteRepTable(this.getConMetaData(), repTable.getTableID());
                    continue;
                }
                ReplicationTableControl.writeProt(Resources.getString("ReplicationTable.Removal_of_Prepared_Table_not_Possible") + repTable.getName() + Resources.getString("ReplicationTable.is_used_by") + String.valueOf(count) + Resources.getString("ReplicationTable.Replication_Unit"), true);
            }
            SyncManGUI.commitConnection(this.getConMetaData());
            if (repTable != null) {
                this._tree.refresh((Object)repTable.getParent());
            } else {
                this.drawTree();
            }
        }
        catch (Exception ex) {
            SyncManGUI.rollBackConnection(this.getConMetaData());
            ReplicationTableControl.writeProt(ex);
        }
        this._tree.getTree().setRedraw(true);
    }

    public void drawDepenendTables() {
    }
}

