/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.gui.jface_controls;

import com.sap.sdb.syncMan.design.DesignSQLLayer;
import com.sap.sdb.syncMan.design.Participant;
import com.sap.sdb.syncMan.design.TablesNode;
import com.sap.sdb.syncMan.gui.SyncManGUI;
import com.sap.sdb.syncMan.gui.jface_controls.SyncManControl;
import com.sap.sdb.syncMan.gui.jface_dialog.MSDebugOptionsDialog;
import com.sap.sdb.syncMan.gui.jface_viewer.MonitorTreeContentProvider;
import com.sap.sdb.syncMan.gui.jface_viewer.MonitorTreeLabelProvider;
import com.sap.sdb.syncMan.message.RowReceiveMessage;
import com.sap.sdb.syncMan.message.SyncManMessage;
import com.sap.sdb.syncMan.tool.ConDataBase;
import com.sap.sdb.syncMan.tool.Resources;
import com.sap.sdb.syncMan.util.SQLBuilder;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.jms.Message;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;

public class MonitorControl
extends SyncManControl {
    private WorkerThread m_WorkerThread;
    private TabItem m_TabTable;
    private TabFolder m_TabFolder;
    private Table m_Table;
    private Composite m_UnitTableWidget;
    private String mm_selectedDestination;
    private String m_selectedTable;
    private Button m_Continue;
    private ResultSet m_ResultSet;
    private ConDataBase m_DBSelect;
    private static final int RESULT_SIZE = 100;
    private static final String VECTOR_RESPOND = "Vector:";

    public MonitorControl(SyncManGUI syncManGUI, SashForm parent) {
        super(syncManGUI, parent);
        this.createContents();
    }

    protected void createContents() {
        this._tree = new TreeViewer((Composite)this);
        this._tree.setContentProvider((IContentProvider)new MonitorTreeContentProvider(this));
        this._tree.setLabelProvider((IBaseLabelProvider)new MonitorTreeLabelProvider());
        this._tree.addSelectionChangedListener(new ISelectionChangedListener(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void selectionChanged(SelectionChangedEvent event) {
                event.getSelection();
                try {
                    String temp;
                    TreeItem[] selections = MonitorControl.this._tree.getTree().getSelection();
                    MonitorControl.this.m_TabTable.setText("");
                    MonitorControl.this.m_TabTable.setControl(null);
                    if (selections == null) return;
                    if (selections.length <= 0) return;
                    MonitorControl.this.mm_selectedDestination = null;
                    MonitorControl.this.m_selectedParticipant = null;
                    MonitorControl.this.m_selectedTable = null;
                    Object obj = selections[0].getData();
                    if (obj instanceof String) {
                        temp = obj.toString();
                        if (temp.startsWith("SYNC_TOPIC_")) {
                            MonitorControl.this.mm_selectedDestination = temp.toString();
                            return;
                        }
                        if (temp.startsWith("SYNC_QUEUE_")) {
                            MonitorControl.this.mm_selectedDestination = temp.toString();
                            return;
                        }
                        if (temp.startsWith("_R_") || temp.startsWith("_R_A_") || temp.startsWith("_R_V_")) {
                            MonitorControl.this.m_TabTable.setControl((Control)MonitorControl.this.m_UnitTableWidget);
                            if (MonitorControl.this.isAsyncWorking()) {
                                SyncManControl.writeProt("Already selecting a syncman table.", true);
                                return;
                            }
                            MonitorControl.this.m_TabTable.setText(temp);
                            MonitorControl.this.clearTable();
                            MonitorControl.this.m_selectedParticipant = (Participant)selections[0].getParentItem().getParentItem().getData();
                            MonitorControl.this.m_selectedTable = temp;
                            MonitorControl.this.m_WorkerThread = new WorkerThread(MonitorControl.this, 0);
                            MonitorControl.this.m_WorkerThread.start();
                            return;
                        }
                    } else {
                        if (obj instanceof Participant) {
                            MonitorControl.this.m_selectedParticipant = (Participant)obj;
                            return;
                        }
                        if (!(obj instanceof TablesNode)) return;
                        MonitorControl.this.m_selectedParticipant = ((TablesNode)obj).participantNode();
                        return;
                    }
                    if (!temp.startsWith(Resources.getString("Monitor.Participants"))) return;
                    return;
                }
                catch (Exception ex) {
                    SyncManControl.writeProt(ex);
                }
            }
        });
        this._tree.getTree().addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Point point = new Point(event.x, event.y);
                TreeItem item = MonitorControl.this._tree.getTree().getItem(point);
                if (item != null && event.button == 3) {
                    Rectangle rect = item.getBounds();
                    point = new Point(rect.x, rect.y + rect.height);
                    Point pt = MonitorControl.this._tree.getTree().toDisplay(point);
                    MonitorControl.this.m_SyncManGUI.showMonitorContextMenu(pt);
                }
            }
        });
        SashForm sashHorizontal = new SashForm((Composite)this, 512);
        SashForm compositeConfig = new SashForm((Composite)sashHorizontal, 2048);
        this.m_TabFolder = new TabFolder((Composite)compositeConfig, 0);
        this.m_TabFolder.setLayoutData((Object)new GridData(1808));
        this.m_UnitTableWidget = this.createTableWidgets((Composite)this.m_TabFolder);
        this.m_TabTable = new TabItem(this.m_TabFolder, 0);
    }

    private void clearTable() {
        this.m_Table.removeAll();
        int col = this.m_Table.getColumnCount();
        while (col > 0) {
            TableColumn tc = this.m_Table.getColumn(--col);
            tc.dispose();
        }
    }

    public void drawTree() {
        this._tree.setInput(new Object());
    }

    public void clearTree() {
        this._tree.setInput(new Object());
    }

    public void showStatus() {
        try {
            String ret = this.m_SyncManGUI.getConMessageServer().send(Resources.getString("MonitorControl.cmd_status"), false);
            if (ret.startsWith(VECTOR_RESPOND)) {
                ret = ret.substring(VECTOR_RESPOND.length(), ret.length());
            }
            MonitorControl.writeProt(ret, false);
        }
        catch (IOException ex) {
            MonitorControl.writeProt(ex);
        }
    }

    public void showDestinationCount() {
        String dest = null;
        String item = null;
        TreeItem[] items = this._tree.getTree().getSelection();
        if (items.length < 1) {
            return;
        }
        item = (String)items[0].getData();
        try {
            dest = item.startsWith("SYNC_QUEUE_") ? "QUEUE" : "TOPIC";
            String ret = this.m_SyncManGUI.getConMessageServer().send("sendordercount " + dest + " " + item, false);
            MonitorControl.writeProt(Resources.getString("MonitorControl.Delivery_Status") + dest + " " + item + ":", false);
            if (ret.startsWith(VECTOR_RESPOND)) {
                ret = ret.substring(VECTOR_RESPOND.length(), ret.length());
            }
            MonitorControl.writeProt(ret, false);
        }
        catch (IOException ex) {
            MonitorControl.writeProt(ex);
        }
    }

    public void showDebugOptions() {
        try {
            String tmp = this.m_SyncManGUI.getConMessageServer().send(Resources.getString("MonitorControl.cmd_get_debug_options"), false);
            Vector serverOptions = this.m_SyncManGUI.getConMessageServer().parseVectorResponse(tmp);
            MSDebugOptionsDialog dlg = new MSDebugOptionsDialog(this.getShell(), serverOptions);
            dlg.setBlockOnOpen(true);
            int returnCode = dlg.open();
            if (returnCode == 0) {
                Vector tmpV = dlg.getNewServerDebugOptions();
                for (int i = 0; i < tmpV.size(); ++i) {
                    this.m_SyncManGUI.getConMessageServer().send(tmpV.get(i).toString(), true);
                }
            }
        }
        catch (IOException ex) {
            MonitorControl.writeProt(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getMessages() {
        String item = null;
        TreeItem[] items = this._tree.getTree().getSelection();
        if (items.length < 1) {
            return;
        }
        Vector msgs = null;
        item = (String)items[0].getData();
        try {
            IInputValidator inputValidator = new IInputValidator(){

                public String isValid(String newText) {
                    try {
                        Integer.parseInt(newText);
                    }
                    catch (NumberFormatException ex) {
                        return Resources.getString("MessageServer.Enter_Integer_Value");
                    }
                    return null;
                }
            };
            int count = 1;
            InputDialog dialog = new InputDialog(this.getShell(), Resources.getString("MessageServer.Get_Messages"), Resources.getString("MessageServer.Number_of_messages_to_get"), Resources.getString("MessageServer.Default_Message_Value"), inputValidator);
            if (dialog.open() == 0) {
                count = Integer.parseInt(dialog.getValue());
            }
            boolean isQueueDest = item.startsWith("SYNC_QUEUE_");
            String destName = item.toString();
            long designID = DesignSQLLayer.parseDesignID(destName);
            String[] pass = DesignSQLLayer.selectMsgDestPasswords(this.m_SyncManGUI.getConMetaData(), designID, isQueueDest);
            pass[1] = SQLBuilder.makeMsgSvrPassword((String)pass[1], (String)"com.sap.sdb.syncMan.util.0CAFFE");
            msgs = isQueueDest ? this.getConMessageServer().getQueueMessages(item.toString(), pass[1], count) : this.getConMessageServer().getTopicMessages(item.toString(), pass[1], count);
            if (msgs != null) {
                for (int j = 0; j < msgs.size(); ++j) {
                    RowReceiveMessage msg = SyncManMessage.createFromJMSMessage((Message)((Message)msgs.get(j)));
                    MonitorControl.writeProt(msg.toString(), false);
                }
            }
        }
        catch (Exception ex) {
            MonitorControl.writeProt(ex);
        }
        finally {
            SyncManGUI.commitConnection(this.m_SyncManGUI.getConMetaData());
        }
    }

    public String getSelectedDestrination() {
        return this.mm_selectedDestination;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Vector loadRepSystemTableNames(Participant part) throws Exception {
        ConDataBase dbTarget;
        Vector tables;
        block13: {
            block12: {
                tables = null;
                dbTarget = null;
                if (part != null) break block12;
                Vector vector = tables;
                Object var6_7 = null;
                if (!dbTarget.isConnected()) return vector;
                try {
                    dbTarget.disconnect();
                    return vector;
                }
                catch (SQLException ex2) {
                    MonitorControl.writeProt(ex2);
                }
                return vector;
            }
            DesignSQLLayer.checkParticipantParameters(this.getConMetaData(), part);
            dbTarget = new ConDataBase(this.m_SyncManGUI.getShell(), SyncManGUI.getSecurityProvider(), SyncManGUI.getSyncSchema(), false, false);
            dbTarget.setJDBCDriver(part.getConfig().jdbcDriver());
            dbTarget.setConnectParam(part.getHost(), part.getDataBase(), part.getUser(), part.getPassWord(), part.getConfig().getUseSSL(), true);
            if (!dbTarget.isMaxDB() && !dbTarget.isMinDB()) {
                throw new Exception(Resources.getString("Monitor.Function_only_possible_for_MaxDB_MinDB"));
            }
            dbTarget.connect();
            if (dbTarget.isConnected()) break block13;
            Vector vector = tables;
            Object var6_8 = null;
            if (!dbTarget.isConnected()) return vector;
            try {
                dbTarget.disconnect();
                return vector;
            }
            catch (SQLException ex2) {
                MonitorControl.writeProt(ex2);
            }
            return vector;
        }
        part.setPassWord(dbTarget.getPassWord());
        tables = DesignSQLLayer.selectRepSystemTables(dbTarget);
        Object var6_9 = null;
        if (!dbTarget.isConnected()) return tables;
        try {
            dbTarget.disconnect();
            return tables;
        }
        catch (SQLException ex2) {
            MonitorControl.writeProt(ex2);
        }
        return tables;
        {
            catch (SQLException ex) {
                throw new SQLException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode());
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (!dbTarget.isConnected()) throw throwable;
            try {
                dbTarget.disconnect();
                throw throwable;
            }
            catch (SQLException ex2) {
                MonitorControl.writeProt(ex2);
            }
            throw throwable;
        }
    }

    private Composite createTableWidgets(Composite parent) {
        ScrolledComposite scrollConfig = new ScrolledComposite(parent, 768);
        Composite tableContainer = new Composite((Composite)scrollConfig, 0);
        scrollConfig.setContent((Control)tableContainer);
        scrollConfig.setExpandHorizontal(true);
        scrollConfig.setExpandVertical(true);
        GridLayout gridLayoutMain = new GridLayout();
        gridLayoutMain.numColumns = 1;
        tableContainer.setLayout((Layout)gridLayoutMain);
        int style = 2820;
        this.m_Table = new Table(tableContainer, style);
        this.m_Table.setLinesVisible(true);
        this.m_Table.setHeaderVisible(true);
        this.m_Table.setLayoutData((Object)new GridData(1808));
        this.m_Continue = new Button(tableContainer, 8);
        this.m_Continue.setText(Resources.getString("Continue"));
        this.m_Continue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MonitorControl.this.isAsyncWorking()) {
                    return;
                }
                try {
                    MonitorControl.this.continueSyncManTable();
                }
                catch (SQLException ex) {
                    SyncManControl.writeProt(ex);
                }
            }
        });
        Point pt = tableContainer.computeSize(-1, -1);
        scrollConfig.setMinWidth(pt.x);
        scrollConfig.setMinHeight(pt.y);
        return scrollConfig;
    }

    public void drawDepenendTables() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectSyncManTable() throws Exception {
        if (this.m_selectedParticipant == null) {
            return;
        }
        if (this.m_selectedTable == null) {
            return;
        }
        try {
            if (this.m_ResultSet != null) {
                this.m_ResultSet.close();
                this.m_ResultSet = null;
            }
            if (this.m_DBSelect != null) {
                if (this.m_DBSelect.isConnected()) {
                    this.m_DBSelect.disconnect();
                }
                this.m_DBSelect = null;
            }
            DesignSQLLayer.checkParticipantParameters(this.getConMetaData(), this.m_selectedParticipant);
            this.m_DBSelect = new ConDataBase(this.m_SyncManGUI.getShell(), SyncManGUI.getSecurityProvider(), SyncManGUI.getSyncSchema(), false, false);
            this.m_DBSelect.setJDBCDriver(this.m_selectedParticipant.getConfig().jdbcDriver());
            this.m_DBSelect.setConnectParam(this.m_selectedParticipant.getHost(), this.m_selectedParticipant.getDataBase(), this.m_selectedParticipant.getUser(), this.m_selectedParticipant.getPassWord(), this.m_selectedParticipant.getConfig().getUseSSL(), true);
            this.m_DBSelect.connect();
            if (!this.m_DBSelect.isConnected()) {
                return;
            }
            Statement stmt = this.m_DBSelect.getConnection().createStatement();
            String query = "SELECT * FROM " + this.m_DBSelect.buildTableQualifier(this.m_selectedTable);
            this.m_ResultSet = stmt.executeQuery(query);
        }
        catch (Exception ex) {
            if (this.m_DBSelect.isConnected()) {
                try {
                    this.m_DBSelect.disconnect();
                }
                catch (SQLException ex2) {
                    MonitorControl.writeProt(ex2);
                }
                finally {
                    this.m_DBSelect = null;
                }
            }
            throw new Exception(ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSyncManTable() {
        block14: {
            if (this.m_selectedParticipant == null) {
                return;
            }
            if (this.m_selectedTable == null) {
                return;
            }
            if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)"Delete Table Content", (String)("Delete Table ." + this.m_selectedTable + " ?"))) {
                return;
            }
            if (!this.m_selectedTable.startsWith("_R_A_")) {
                return;
            }
            try {
                if (this.m_DBSelect != null) {
                    if (this.m_DBSelect.isConnected()) {
                        this.m_DBSelect.disconnect();
                    }
                    this.m_DBSelect = null;
                }
                DesignSQLLayer.checkParticipantParameters(this.getConMetaData(), this.m_selectedParticipant);
                this.m_DBSelect = new ConDataBase(this.m_SyncManGUI.getShell(), SyncManGUI.getSecurityProvider(), SyncManGUI.getSyncSchema(), false, false);
                this.m_DBSelect.setJDBCDriver(this.m_selectedParticipant.getConfig().jdbcDriver());
                this.m_DBSelect.setConnectParam(this.m_selectedParticipant.getHost(), this.m_selectedParticipant.getDataBase(), this.m_selectedParticipant.getUser(), this.m_selectedParticipant.getPassWord(), this.m_selectedParticipant.getConfig().getUseSSL(), true);
                this.m_DBSelect.connect();
                if (!this.m_DBSelect.isConnected()) {
                    return;
                }
                String query = "delete " + this.m_DBSelect.buildTableQualifier(this.m_selectedTable);
                MonitorControl.writeProt(query, false);
            }
            catch (Exception ex) {
                MonitorControl.writeProt(ex);
                if (!this.m_DBSelect.isConnected()) break block14;
                try {
                    this.m_DBSelect.disconnect();
                }
                catch (SQLException ex2) {
                    MonitorControl.writeProt(ex2);
                }
                finally {
                    this.m_DBSelect = null;
                }
            }
        }
    }

    private void drawSyncManTable() {
        if (this.m_DBSelect == null) {
            return;
        }
        if (this.m_ResultSet == null) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() {
                int count;
                block22: {
                    count = 0;
                    MonitorControl.this.clearTable();
                    ResultSetMetaData metaData = MonitorControl.this.m_ResultSet.getMetaData();
                    for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                        TableColumn tc = new TableColumn(MonitorControl.this.m_Table, 16384);
                        tc.setText(metaData.getColumnName(i));
                        tc.setWidth(metaData.getColumnName(i).length() * 10);
                    }
                    while (count < 100 && MonitorControl.this.m_ResultSet.next()) {
                        MonitorControl.this.drawResultRow(MonitorControl.this.m_ResultSet, metaData);
                        ++count;
                    }
                    if (count < 100) {
                        MonitorControl.this.m_ResultSet.close();
                        MonitorControl.this.m_ResultSet = null;
                        MonitorControl.this.m_Continue.setEnabled(false);
                        break block22;
                    }
                    MonitorControl.this.m_Continue.setEnabled(true);
                }
                Object var7_7 = null;
                if (!MonitorControl.this.m_DBSelect.isConnected() || count >= 100) return;
                try {
                    MonitorControl.this.m_DBSelect.disconnect();
                    return;
                }
                catch (SQLException ex2) {
                    SyncManControl.writeProt(ex2);
                    return;
                }
                finally {
                    MonitorControl.this.m_DBSelect = null;
                }
                {
                    catch (SQLException ex) {
                        MonitorControl.this.m_Continue.setEnabled(false);
                        if (MonitorControl.this.m_DBSelect.isConnected()) {
                            try {
                                MonitorControl.this.m_DBSelect.disconnect();
                            }
                            catch (SQLException ex2) {
                                SyncManControl.writeProt(ex2);
                            }
                            finally {
                                MonitorControl.this.m_DBSelect = null;
                            }
                        }
                        SyncManControl.writeProt(ex);
                        Object var7_8 = null;
                        if (!MonitorControl.this.m_DBSelect.isConnected()) return;
                        if (count >= 100) return;
                        try {
                            MonitorControl.this.m_DBSelect.disconnect();
                        }
                        catch (SQLException ex2) {
                            try {}
                            catch (Throwable throwable) {
                                MonitorControl.this.m_DBSelect = null;
                                throw throwable;
                            }
                            SyncManControl.writeProt(ex2);
                            MonitorControl.this.m_DBSelect = null;
                            return;
                        }
                        MonitorControl.this.m_DBSelect = null;
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    if (!MonitorControl.this.m_DBSelect.isConnected() || count >= 100) throw throwable;
                    try {
                        MonitorControl.this.m_DBSelect.disconnect();
                    }
                    catch (SQLException ex2) {
                        try {}
                        catch (Throwable throwable2) {
                            MonitorControl.this.m_DBSelect = null;
                            throw throwable2;
                        }
                        SyncManControl.writeProt(ex2);
                        MonitorControl.this.m_DBSelect = null;
                        throw throwable;
                    }
                    MonitorControl.this.m_DBSelect = null;
                    throw throwable;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void continueSyncManTable() throws SQLException {
        int count;
        block23: {
            if (this.m_DBSelect == null || !this.m_DBSelect.isConnected()) {
                return;
            }
            if (this.m_ResultSet == null) {
                return;
            }
            ResultSetMetaData metaData = this.m_ResultSet.getMetaData();
            for (count = 0; count < 100 && this.m_ResultSet.next(); ++count) {
                this.drawResultRow(this.m_ResultSet, metaData);
            }
            if (count < 100) {
                this.m_ResultSet.close();
                this.m_ResultSet = null;
                this.m_Continue.setEnabled(false);
                break block23;
            }
            this.m_Continue.setEnabled(true);
        }
        Object var6_4 = null;
        if (!this.m_DBSelect.isConnected() || count >= 100) return;
        try {
            this.m_DBSelect.disconnect();
            return;
        }
        catch (SQLException ex2) {
            MonitorControl.writeProt(ex2);
            return;
        }
        finally {
            this.m_DBSelect = null;
        }
        {
            catch (SQLException ex) {
                this.m_Continue.setEnabled(false);
                if (this.m_DBSelect.isConnected()) {
                    try {
                        this.m_DBSelect.disconnect();
                    }
                    catch (SQLException ex2) {
                        MonitorControl.writeProt(ex2);
                    }
                    finally {
                        this.m_DBSelect = null;
                    }
                }
                MonitorControl.writeProt(ex);
                Object var6_5 = null;
                if (!this.m_DBSelect.isConnected()) return;
                if (count >= 100) return;
                try {
                    this.m_DBSelect.disconnect();
                    this.m_DBSelect = null;
                    return;
                }
                catch (SQLException ex2) {
                    try {}
                    catch (Throwable throwable) {
                        this.m_DBSelect = null;
                        throw throwable;
                    }
                    MonitorControl.writeProt(ex2);
                    this.m_DBSelect = null;
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (!this.m_DBSelect.isConnected() || count >= 100) throw throwable;
            try {
                this.m_DBSelect.disconnect();
                this.m_DBSelect = null;
                throw throwable;
            }
            catch (SQLException ex2) {
                try {}
                catch (Throwable throwable2) {
                    this.m_DBSelect = null;
                    throw throwable2;
                }
                MonitorControl.writeProt(ex2);
                this.m_DBSelect = null;
                throw throwable;
            }
        }
    }

    private void drawResultRow(ResultSet resultSet, ResultSetMetaData metaData) throws SQLException {
        TableItem item = new TableItem(this.m_Table, 0);
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            String itemText = null;
            Object obj = resultSet.getObject(i);
            if (obj instanceof byte[]) {
                itemText = obj != null ? MonitorControl.byteArrayToHexStr((byte[])obj) : "?";
                TableColumn tc = this.m_Table.getColumn(i - 1);
                tc.setWidth(metaData.getColumnDisplaySize(i) * 15);
            } else {
                itemText = obj != null ? obj.toString().trim() : "?";
            }
            item.setText(i - 1, itemText);
        }
    }

    public synchronized boolean isAsyncWorking() {
        return this.m_WorkerThread != null && this.m_WorkerThread.isAlive();
    }

    private static String byteArrayToHexStr(byte[] bytes) {
        StringBuffer strBuf = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            int unsignedByte = bytes[i] & 0xFF;
            if (unsignedByte < 16) {
                strBuf.append('0');
            }
            strBuf.append(Integer.toHexString(unsignedByte).toUpperCase());
        }
        return strBuf.toString();
    }

    public void deleteDestination() {
        String dest = null;
        String item = null;
        TreeItem[] items = this._tree.getTree().getSelection();
        for (int i = 0; i < items.length; ++i) {
            dest = "topic";
            item = (String)items[i].getData();
            if (item.startsWith("SYNC_QUEUE_")) {
                dest = "queue";
            }
            try {
                this.getConMessageServer().send(Resources.getString("MessageServer.cmd_drop") + dest + " " + item, true);
                this._tree.remove((Object)item);
                continue;
            }
            catch (IOException ex) {
                MonitorControl.writeProt(ex);
            }
        }
    }

    public void deactivateDestination() {
        String consumerid = null;
        String item = null;
        int begin = 0;
        int end = 0;
        TreeItem[] items = this._tree.getTree().getSelection();
        for (int i = 0; i < items.length; ++i) {
            if (items[i].getParentItem() == null || !items[i].getParentItem().getData().toString().startsWith("SYNC_TOPIC_")) continue;
            item = (String)items[i].getData();
            begin = item.indexOf(Resources.getString("MessageServer.consumer_tag"));
            end = item.indexOf(",", begin);
            consumerid = item.substring(begin + Resources.getString("MessageServer.consumer_tag").length(), end);
            try {
                this.getConMessageServer().send(Resources.getString("MessageServer.cmd_unregister_consumer") + consumerid + Resources.getString("MessageServer.cmd_durable"), true);
                continue;
            }
            catch (IOException ex) {
                MonitorControl.writeProt(ex);
            }
        }
        this._tree.refresh();
    }

    public String getSelectedTable() {
        return this.m_selectedTable;
    }

    private class WorkerThread
    extends Thread {
        private MonitorControl _parent;
        private int _actionType;
        private static final int SELECT_TABLE = 0;

        private WorkerThread(MonitorControl parent, int actionType) {
            super(Resources.getString("MonitorControl.WorkerThread") + " " + actionType);
            this._parent = parent;
            this._actionType = actionType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block6: {
                try {
                    if (this._actionType == 0) {
                        MonitorControl monitorControl = this._parent;
                        synchronized (monitorControl) {
                            this._parent.selectSyncManTable();
                            this._parent.drawSyncManTable();
                            break block6;
                        }
                    }
                    SQLBuilder.writeProtAsync((String)Resources.getString("No_Valid_Action"), (boolean)true);
                }
                catch (Exception ex) {
                    SQLBuilder.writeProtAsync((Exception)ex);
                }
            }
        }
    }
}

