/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.gui;

import com.sap.sdb.programmargs.ToolParams;
import com.sap.sdb.syncMan.gui.SyncManGUI;
import com.sap.sdb.syncMan.tool.ConDataBase;
import com.sap.sdb.syncMan.tool.ConMessageServer;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

public class SyncGUIParams
extends ToolParams {
    private int MAX_LRU = 5;
    int m_x = 10;
    int m_y = 10;
    int m_width = 800;
    int m_height = 600;
    private MyLRU m_LRU_DB = new MyLRU();
    private MyLRU m_LRU_MSG = new MyLRU();
    private String m_x_name = "gui.x";
    private String m_y_name = "gui.y";
    private String m_width_name = "gui.width";
    private String m_height_name = "gui.height";
    private String msg_lru_name = "msg_lru";
    private String db_lru_name = "db_lru";

    SyncGUIParams() {
        super("syncmangui.properties", "Synchronization Manager Properties");
    }

    protected void setDefaults(Properties defaults) {
        defaults.put(this.m_x_name, new Integer(this.m_x).toString());
        defaults.put(this.m_y_name, new Integer(this.m_y).toString());
        defaults.put(this.m_width_name, new Integer(this.m_width).toString());
        defaults.put(this.m_height_name, new Integer(this.m_height).toString());
        this.m_LRU_DB = new MyLRU();
        this.m_LRU_MSG = new MyLRU();
    }

    protected void updatePropertiesFromSettings() {
        Object temp;
        this.m_properties.put(this.m_x_name, new Integer(this.m_x).toString());
        this.m_properties.put(this.m_y_name, new Integer(this.m_y).toString());
        this.m_properties.put(this.m_width_name, new Integer(this.m_width).toString());
        this.m_properties.put(this.m_height_name, new Integer(this.m_height).toString());
        Iterator it = this.m_LRU_DB.values().iterator();
        int i = this.m_LRU_DB.values().size();
        while (it.hasNext()) {
            temp = (ConDataBase)it.next();
            this.m_properties.put(this.db_lru_name + i + "_host", ((ConDataBase)temp).getHost());
            this.m_properties.put(this.db_lru_name + i + "_database", ((ConDataBase)temp).getDataBase());
            this.m_properties.put(this.db_lru_name + i + "_ssl", ((ConDataBase)temp).getUseSSL() ? "1" : "0");
            --i;
        }
        it = this.m_LRU_MSG.values().iterator();
        i = this.m_LRU_MSG.values().size();
        while (it.hasNext()) {
            temp = (ConMessageServer)it.next();
            this.m_properties.put(this.msg_lru_name + i + "_msghost", ((ConMessageServer)temp).getMsgHost());
            this.m_properties.put(this.msg_lru_name + i + "_adminport", String.valueOf(((ConMessageServer)temp).getAdminPort()));
            this.m_properties.put(this.msg_lru_name + i + "_ssl", ((ConMessageServer)temp).getUseSSL() ? "1" : "0");
            --i;
        }
    }

    protected void updateSettingsFromProperties() {
        Object con;
        boolean useSSL;
        int i;
        String tmp = this.m_properties.getProperty(this.m_x_name);
        this.m_x = new Integer(tmp);
        tmp = this.m_properties.getProperty(this.m_y_name);
        this.m_y = new Integer(tmp);
        tmp = this.m_properties.getProperty(this.m_width_name);
        this.m_width = new Integer(tmp);
        tmp = this.m_properties.getProperty(this.m_height_name);
        this.m_height = new Integer(tmp);
        for (i = 1; i <= this.MAX_LRU; ++i) {
            String host = this.m_properties.getProperty(this.db_lru_name + i + "_host");
            String database = this.m_properties.getProperty(this.db_lru_name + i + "_database");
            tmp = this.m_properties.getProperty(this.db_lru_name + i + "_ssl");
            useSSL = false;
            if (tmp != null) {
                useSSL = tmp.equalsIgnoreCase("1");
            }
            if (host == null || database == null) continue;
            con = new ConDataBase(SyncManGUI.getSecurityProvider(), SyncManGUI.getSyncSchema(), true, true);
            try {
                ((ConDataBase)con).setConnectParam(host, database, "", "", useSSL, false);
                this.m_LRU_DB.put(((ConDataBase)con).toString(), con);
                continue;
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        for (i = 1; i <= this.MAX_LRU; ++i) {
            String msghost = this.m_properties.getProperty(this.msg_lru_name + i + "_msghost");
            int adminport = -1;
            tmp = this.m_properties.getProperty(this.msg_lru_name + i + "_adminport");
            if (tmp != null) {
                adminport = Integer.parseInt(tmp);
            }
            tmp = this.m_properties.getProperty(this.msg_lru_name + i + "_ssl");
            useSSL = false;
            if (tmp != null) {
                useSSL = tmp.equalsIgnoreCase("1");
            }
            if (msghost == null) continue;
            con = new ConMessageServer();
            ((ConMessageServer)con).setConnectParam(msghost, -1, null, -1, adminport, "", useSSL);
            this.m_LRU_MSG.put(((ConMessageServer)con).toString(), con);
        }
    }

    public int getHeight() {
        return this.m_height;
    }

    public void setHeight(int height) {
        this.m_height = height;
    }

    public int getWidth() {
        return this.m_width;
    }

    public void setWidth(int width) {
        this.m_width = width;
    }

    public int getX() {
        return this.m_x;
    }

    public void setX(int x) {
        this.m_x = x;
    }

    public int getY() {
        return this.m_y;
    }

    public void setY(int y) {
        this.m_y = y;
    }

    public MyLRU getLRU_DB() {
        return this.m_LRU_DB;
    }

    public MyLRU getLRU_MSG() {
        return this.m_LRU_MSG;
    }

    protected class MyLRU
    extends LinkedHashMap {
        private MyLRU() {
            super(SyncGUIParams.this.MAX_LRU, 1.0f, true);
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > SyncGUIParams.this.MAX_LRU;
        }
    }
}

