/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.sqldbctest;

import com.sap.sapdb.sqldbctest.TestProgramRunner;
import com.sap.sapdb.testframe.driver.TestDatabase;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;

public class SQLDBCTest
extends TestCase {
    private static ArrayList testList;
    private int testInterruptionStatus = 0;
    private static long timeOut;
    private static String jtestRoot;
    private static boolean good;
    private static PrintStream protocolStream;
    private static File sqldbcTestRoot;
    private static Object semaphore;
    private static File protocolDir;
    private static String protocolStreamName;
    private static String testHostname;
    private static boolean testVariableInput;

    private static String getHostName() throws Exception {
        try {
            String string = InetAddress.getLocalHost().getHostName();
            if (string.equals("localhost")) {
                throw new Exception("Local host name not found, only localhost.");
            }
            return string;
        }
        catch (UnknownHostException unknownHostException) {
            throw new Exception("Could not determine the local host name, stopping test.");
        }
    }

    public static String getTestUser() {
        String string = null;
        string = testHostname.length() > 30 ? ("SQ" + testHostname.substring(0, 30)).toUpperCase().trim() : ("SQ" + testHostname).toUpperCase().trim();
        if (string.indexOf(".") != -1) {
            string = string.substring(0, string.indexOf("."));
        }
        return string;
    }

    public static boolean isTestVariableInput() {
        return testVariableInput;
    }

    public static void prepare() {
        good = true;
        try {
            testHostname = SQLDBCTest.getHostName();
            testList = SQLDBCTest.getUnnamedParameterList();
            if (testList.isEmpty()) {
                SQLDBCTest.addGlobalMessage((String)"", (char)'E', (String)"There are no tests for execution available.");
                good = false;
                return;
            }
            timeOut = SQLDBCTest.getParameterLong((String)"TIMEOUT", (long)-1L);
            if (timeOut == -1L) {
                timeOut = 60000 * testList.size();
            }
            SQLDBCTest.addGlobalMessage((String)"", (char)'I', (String)("Test timeout is " + timeOut));
            testVariableInput = SQLDBCTest.getParameterBoolean((String)"VARIABLEINPUT", (boolean)false);
            SQLDBCTest.addGlobalMessage((String)"", (char)'I', (String)("Variable input is  " + testVariableInput));
            jtestRoot = System.getProperty("jtest.root");
            SQLDBCTest.addGlobalMessage((String)"", (char)'I', (String)("Test root is " + jtestRoot));
            String string = SQLDBCTest.getParameterString((String)"PROTOCOLNAME", (String)"SQLDBCTest");
            SQLDBCTest.initProtocol(string);
            String string2 = jtestRoot.substring(0, jtestRoot.length() - "/jtest".length()) + File.separator + "tr_sqldbc.sar";
            String string3 = jtestRoot.substring(0, jtestRoot.length() - "/test/jtest".length());
            sqldbcTestRoot = new File(string3 + File.separator + "test" + File.separator + "sqldbc");
        }
        catch (Exception exception) {
            good = false;
            SQLDBCTest.addGlobalMessage((String)"", (char)'E', (String)("Exception in prepare: " + exception.getMessage()));
        }
    }

    public static File getSQLDBCTestRoot() {
        return sqldbcTestRoot;
    }

    public void run() {
        if (!good) {
            SQLDBCTest.addGlobalMessage((String)"", (char)'E', (String)"Error in prepare phase, see previous messages.");
        } else {
            String string = SQLDBCTest.getTestUser();
            Connection connection = null;
            Statement statement = null;
            try {
                TestDatabase testDatabase = SQLDBCTest.getDatabase();
                connection = testDatabase.connect();
                statement = connection.createStatement();
                try {
                    statement.execute("DROP USER \"" + string + "\"");
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                statement.execute("CREATE USER \"" + string + "\" PASSWORD \"" + "ABC123" + "\" DBA NOT EXCLUSIVE");
            }
            catch (Exception exception) {
                SQLDBCTest.addGlobalMessage((String)"", (char)'E', (String)("Exception in user creation:" + exception.getMessage()));
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                return;
            }
            for (int i = 0; i < testList.size(); ++i) {
                String string2 = (String)testList.get(i);
                TestProgramRunner testProgramRunner = new TestProgramRunner(string2, this);
                testProgramRunner.start();
                try {
                    testProgramRunner.join();
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    this.handleInterruption(testProgramRunner);
                    for (int j = i + 1; j < testList.size(); ++j) {
                        TestProgramRunner testProgramRunner2 = new TestProgramRunner((String)testList.get(j), this);
                        SQLDBCTest.addGlobalMessage((String)"", (char)'E', (String)("Test " + testProgramRunner2.getCommandLine() + " did not run (previous test was killed)."));
                    }
                    return;
                }
            }
            if (this.getErrorCounter() == 0) {
                SQLDBCTest.addGlobalMessage((String)"", (char)'I', (String)("Tests successful, dropping user " + string));
                try {
                    statement.execute("DROP USER \"" + string + "\"");
                }
                catch (SQLException sQLException) {}
            } else {
                SQLDBCTest.addGlobalMessage((String)"", (char)'I', (String)("Tests had errors, keeping user " + string));
            }
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleInterruption(TestProgramRunner testProgramRunner) {
        testProgramRunner.interruptExecution();
        try {
            Object object = semaphore;
            synchronized (object) {
                semaphore.wait(15000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.testInterruptionStatus == 0) {
            SQLDBCTest.addGlobalMessage((String)"", (char)'E', (String)("Could not interrupt test program, please cleanup by yourself.\nThe called program was:\n" + testProgramRunner.getCommandLine()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySuccessfulInterrupt(int n) {
        this.testInterruptionStatus = n;
        Object object = semaphore;
        synchronized (object) {
            semaphore.notify();
        }
    }

    public static long getTimeout() {
        return timeOut;
    }

    public void message(String string, char c, String string2) {
        TestCase.addGlobalMessage((String)string, (char)c, (String)string2);
    }

    public static synchronized void println(String string) {
        if (protocolStream != null) {
            protocolStream.println(string);
        }
    }

    public File getProtocolDir() {
        return protocolDir;
    }

    private static void initProtocol(String string) throws Exception {
        Object object;
        protocolDir = new File(jtestRoot + File.separator + "protocols");
        File file = protocolDir;
        File file2 = new File(file, string + ".prt");
        if (file2.exists()) {
            object = SQLDBCTest.makeTempFile(string, ".prt", file);
            file2.renameTo((File)object);
            SQLDBCTest.addGlobalMessage((String)"", (char)'I', (String)("Renaming old protocol file SQLDBCTest.prt to " + ((File)object).getCanonicalPath()));
        }
        protocolStreamName = file2.getCanonicalPath();
        object = new FileOutputStream(file2);
        protocolStream = new PrintStream((OutputStream)object);
        protocolStream.println("----------------------------------------------------------------------");
        protocolStream.println("SQLDBCTest started on " + new Date());
        protocolStream.println("----------------------------------------------------------------------");
    }

    private static File makeTempFile(String string, String string2, File file) {
        int n = 1;
        while (true) {
            String string3 = Integer.toString(n);
            String string4 = string + "0000".substring(0, 4 - string3.length()) + string3 + string2;
            File file2 = new File(file, string4);
            if (!file2.exists()) {
                return file2;
            }
            ++n;
        }
    }

    public String getLogFile() {
        return protocolStreamName;
    }

    static {
        semaphore = new Object();
    }

    private static class OutputReader
    extends Thread {
        private BufferedReader input;

        OutputReader(InputStream inputStream) {
            this.input = new BufferedReader(new InputStreamReader(inputStream));
        }

        public void run() {
            try {
                String string = null;
                while ((string = this.input.readLine()) != null) {
                    SQLDBCTest.println(string);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

