/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.test;

import com.sap.sdb.syncMan.test.ApplicationParam;
import com.sap.sdb.syncMan.test.CreateTestTables;
import com.sap.sdb.syncMan.test.InsertTestTables;
import com.sap.sdb.syncMan.util.DebugOutput;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class UpdateTestTables {
    private String m_prevPrintTab = null;
    private int m_updCount = 0;
    private static final String UPDATE_TAB1 = "UPDATE tab1 SET col1 = ? WHERE keyColB <= ?";
    private static final String UPDATE_TAB2 = "UPDATE tab2 SET field1 = ?, field2 = -keyfield, field4 = ? WHERE keyField >= ? AND keyField <= ?";
    private static final String UPDATE_TAB2_GROUP13 = "UPDATE tab2 SET field3 = ? WHERE keyField >= ? AND keyField <= ?";
    private static final String UPDATE_TAB2_GROUP456 = "UPDATE tab2 SET field5 = ?, field6 = ? WHERE keyField >= ? AND keyField <= ?";
    private static final String UPDATE_TAB2_WITHOUT_GROUPS = "UPDATE tab2 SET field2 = ?, field8 = ? WHERE keyField >= ? AND keyField <= ?";
    private static final String UPDATE_TAB3_CHAR = "UPDATE tab3 SET charCol = ? WHERE keyField >= ? AND keyField <= ?";
    private static final String UPDATE_TAB3_BLOB = "UPDATE tab3 SET blobCol = ? WHERE keyField > ?";
    private static final String UPDATE_TAB4_CHAR = "UPDATE tab4 SET charCol = ? WHERE keyField >= ? AND keyField <= ?";
    private static final String UPDATE_TAB4_CLOB = "UPDATE tab4 SET clobCol = ? WHERE keyField > ?";
    private static final String SELECT_MAX_FIELD1 = "SELECT max(field1) FROM tab2";

    public static void main(String[] argv) {
        DebugOutput.setVerboseTraceback();
        ApplicationParam param = new ApplicationParam(argv);
        param.enableParamUser(null, null);
        if (param.createProperties()) {
            new UpdateTestTables().doWork(param);
        }
    }

    private UpdateTestTables() {
    }

    private void doWork(ApplicationParam param) {
        try {
            Connection con = DriverManager.getConnection(param.getURL(), param.getUser(), param.getPassword());
            con.setAutoCommit(false);
            PreparedStatement updTab1 = con.prepareStatement(UPDATE_TAB1);
            PreparedStatement updTab2 = con.prepareStatement(UPDATE_TAB2);
            PreparedStatement updTab2Group13 = con.prepareStatement(UPDATE_TAB2_GROUP13);
            PreparedStatement updTab2Group456 = con.prepareStatement(UPDATE_TAB2_GROUP456);
            PreparedStatement updTab2WithoutGroups = con.prepareStatement(UPDATE_TAB2_WITHOUT_GROUPS);
            PreparedStatement updTab3Char = con.prepareStatement(UPDATE_TAB3_CHAR);
            PreparedStatement updTab3Blob = con.prepareStatement(UPDATE_TAB3_BLOB);
            PreparedStatement updTab4Char = con.prepareStatement(UPDATE_TAB4_CHAR);
            PreparedStatement updTab4Clob = con.prepareStatement(UPDATE_TAB4_CLOB);
            int maxRows = InsertTestTables.selectMaxKeyNo(con);
            int updOffset = this.selectNextUpdateOffset(con);
            if (maxRows / 4 < 1) {
                DebugOutput.println((String)("*** Table contains " + maxRows + " rows (UpdateTestTables requires at least 4 rows)"));
                return;
            }
            int keyLwb = maxRows / 4 * 2;
            int keyUpb = maxRows / 4 * 3;
            String param1 = "xyz" + (updOffset + 1);
            String param2 = "keyB_" + (10000 + maxRows / 2);
            updTab1.setString(1, param1);
            updTab1.setString(2, param2);
            DebugOutput.println();
            DebugOutput.println((String)UPDATE_TAB1);
            DebugOutput.println((String)("   SET col1 = " + param1));
            DebugOutput.println((String)("   WHERE keyColB <= " + param2));
            DebugOutput.println();
            int param5 = updOffset + 1;
            param2 = updOffset + 9876 + ".54";
            int param3 = keyLwb;
            int param4 = keyUpb;
            updTab2.setInt(1, param5);
            updTab2.setString(2, param2);
            updTab2.setInt(3, param3);
            updTab2.setInt(4, param4);
            DebugOutput.println();
            DebugOutput.println((String)UPDATE_TAB2);
            DebugOutput.println((String)("   SET field1 = " + param5));
            DebugOutput.println((String)("   SET field4 = " + param2));
            DebugOutput.println((String)("   WHERE keyField >= " + param3));
            DebugOutput.println((String)("   WHERE keyField <= " + param4));
            DebugOutput.println();
            updTab2Group13.setInt(1, updOffset + maxRows / 2 + 1);
            updTab2Group13.setInt(2, keyLwb);
            updTab2Group13.setInt(3, keyUpb);
            updTab2Group456.setString(1, "987654321098765432109876543210");
            updTab2Group456.setString(2, updOffset + 6543 + ".21");
            updTab2Group456.setInt(3, keyLwb);
            updTab2Group456.setInt(4, keyUpb);
            updTab2WithoutGroups.setInt(1, -updOffset);
            updTab2WithoutGroups.setString(2, "0.98765432109876543210987654321098765");
            updTab2WithoutGroups.setInt(3, keyLwb);
            updTab2WithoutGroups.setInt(4, keyUpb);
            updTab3Char.setString(1, "chr" + (updOffset + 1));
            updTab3Char.setInt(2, 1);
            updTab3Char.setInt(3, keyUpb);
            String blobMsgString = "blob" + (updOffset + maxRows + 1);
            byte[] blobMsgBytes = blobMsgString.getBytes();
            updTab3Blob.setBytes(1, blobMsgBytes);
            updTab4Char.setString(1, "chr" + (updOffset + 1));
            updTab4Char.setInt(2, 1);
            updTab4Char.setInt(3, keyUpb);
            updTab4Clob.setString(1, "clob" + (updOffset + 1));
            this.printUpd("tab1", null, this.update(UPDATE_TAB1, updTab1));
            this.printUpd("tab2", "mixed", this.update(UPDATE_TAB2, updTab2));
            this.printUpd("tab2", "group13", this.update(UPDATE_TAB2_GROUP13, updTab2Group13));
            this.printUpd("tab2", "group456", this.update(UPDATE_TAB2_GROUP456, updTab2Group456));
            this.printUpd("tab2", "without groups", this.update(UPDATE_TAB2_WITHOUT_GROUPS, updTab2WithoutGroups));
            this.printUpd("tab3", "char", this.update(UPDATE_TAB3_CHAR, updTab3Char));
            this.printUpd("tab3", "blob", this.updateLoop(UPDATE_TAB3_BLOB, updTab3Blob, keyLwb, keyUpb));
            this.printUpd("tab4", "char", this.update(UPDATE_TAB4_CHAR, updTab4Char));
            this.printUpd("tab4", "clob", this.updateLoop(UPDATE_TAB4_CLOB, updTab4Clob, keyLwb, keyUpb));
            con.commit();
            InsertTestTables.printFirstRow(con, "tab1", "keyColA = 'keyA' AND keyCOlB = 'keyB_10001'");
            InsertTestTables.printFirstRow(con, "tab2", "keyfield = 1");
            InsertTestTables.printFirstRow(con, "tab3", "keyfield = 1");
            InsertTestTables.printFirstRow(con, "tab4", "keyfield = 1");
            con.commit();
            DebugOutput.println();
            DebugOutput.println((String)"---------------------------------");
            CreateTestTables.printDatabaseConnection(con, param);
            DebugOutput.println((String)("update basis: " + updOffset));
            DebugOutput.println((String)(this.m_updCount + " rows updated"));
            con.close();
        }
        catch (Exception ex) {
            DebugOutput.printException((Exception)ex);
        }
    }

    private void printUpd(String tab, String option, int rowCount) {
        String tabStr;
        this.m_updCount += rowCount;
        String blanks = "                ";
        String optionStr = option == null ? ": " + blanks : " " + option + ":" + blanks.substring(0, blanks.length() - option.length());
        String string = tabStr = this.m_prevPrintTab == null || !this.m_prevPrintTab.equals(tab) ? tab : "    ";
        if (rowCount == 1) {
            DebugOutput.println((String)(tabStr + optionStr + "1 row  updated"));
        } else {
            DebugOutput.println((String)(tabStr + optionStr + rowCount + " rows updated"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int selectNextUpdateOffset(Connection con) throws SQLException {
        Statement stmt = con.createStatement();
        ResultSet result = stmt.executeQuery(SELECT_MAX_FIELD1);
        try {
            if (!result.next()) {
                int n = 10000;
                return n;
            }
            int number = result.getInt(1) / 10000;
            int n = number < 9 ? 10000 * (number + 1) : 10000;
            return n;
        }
        finally {
            result.close();
        }
    }

    private int update(String sql, PreparedStatement updStmt) throws SQLException {
        int rowCount = 0;
        try {
            rowCount = updStmt.executeUpdate();
            return rowCount;
        }
        catch (SQLException ex) {
            DebugOutput.println((String)("*** " + sql));
            DebugOutput.printException((Exception)ex);
            return rowCount;
        }
    }

    private int updateLoop(String sql, PreparedStatement updStmt, int lwbKey, int upbKey) throws SQLException {
        int rowCount = 0;
        int executeCount = 0;
        try {
            for (int currKey = lwbKey; currKey <= upbKey; ++currKey) {
                if (++executeCount % 100 == 1) {
                    System.out.println("updateLoop(" + executeCount + "): " + sql + "; keyField: " + currKey);
                }
                updStmt.setInt(2, currKey);
                rowCount += updStmt.executeUpdate();
            }
            return rowCount;
        }
        catch (SQLException ex) {
            DebugOutput.println((String)("*** " + sql));
            DebugOutput.printException((Exception)ex);
            return rowCount;
        }
    }
}

