/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.test;

import com.sap.sdb.syncMan.test.ApplicationParam;
import com.sap.sdb.syncMan.test.CreateTestTables;
import com.sap.sdb.syncMan.util.DebugOutput;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class InsertTestSubsetTables {
    private static final String TAB1 = "subset_tab1";
    private static final String TAB2 = "subset_tab2";
    private static final String INSERT_TAB1 = "INSERT INTO subset_tab1 VALUES (?, ?, ?)";
    private static final String INSERT_TAB2 = "INSERT INTO subset_tab2 VALUES (?, ?, ?, ?, ?, ?)";
    private static final String SELECT_MAX_TAB1_KEY = "SELECT MAX(key1) FROM subset_tab1";
    private static final String SELECT_MAX_TAB2_KEY = "SELECT MAX(keyCol) FROM subset_tab2";
    private static final String PARAM_MAX_ROWS = "rows";
    private static final String DEFAULT_MAX_ROWS = "10";
    private static final String BLANK30 = "                              ";

    public static void main(String[] argv) {
        DebugOutput.setVerboseTraceback();
        ApplicationParam param = new ApplicationParam(argv);
        param.enableParamUser(null, null);
        param.defineParam(PARAM_MAX_ROWS, "maxRows", DEFAULT_MAX_ROWS);
        if (param.createProperties()) {
            new InsertTestSubsetTables().doWork(param);
        }
    }

    private InsertTestSubsetTables() {
    }

    private void doWork(ApplicationParam param) {
        try {
            Connection con = DriverManager.getConnection(param.getURL(), param.getUser(), param.getPassword());
            con.setAutoCommit(false);
            int startOffset = InsertTestSubsetTables.selectMaxKeyNo(con);
            PreparedStatement insertTab1 = con.prepareStatement(INSERT_TAB1);
            PreparedStatement insertTab2 = con.prepareStatement(INSERT_TAB2);
            int maxRows = param.getInt(PARAM_MAX_ROWS);
            for (int i = startOffset + 1; i <= startOffset + maxRows; ++i) {
                insertTab1.setString(1, "keyA");
                insertTab1.setString(2, "keyB_" + (10000 + i));
                insertTab1.setString(3, "xyz" + (10000 + i));
                insertTab2.setInt(1, i);
                insertTab2.setString(2, "123456789012345678902244668899");
                insertTab2.setString(3, "12345678.11");
                insertTab2.setString(4, "12345678.88");
                insertTab2.setInt(5, 23456);
                insertTab2.setInt(6, 10000 + i);
                insertTab1.execute();
                insertTab2.execute();
                if (i % 500 != 0) continue;
                System.out.println(Integer.toString(i));
            }
            con.commit();
            InsertTestSubsetTables.printFirstRow(con, TAB1, "key1 = 'keyB_" + (10000 + startOffset + 1) + "' AND key2 = 'keyA'");
            InsertTestSubsetTables.printFirstRow(con, TAB2, "keyCol = " + (startOffset + 1));
            con.commit();
            DebugOutput.println();
            DebugOutput.println((String)"---------------------------------");
            CreateTestTables.printDatabaseConnection(con, param);
            DebugOutput.println((String)("first key value: " + (startOffset + 1)));
            DebugOutput.println((String)(maxRows + " rows inserted into each table"));
            con.close();
        }
        catch (Exception ex) {
            DebugOutput.printException((Exception)ex);
        }
    }

    static void printFirstRow(Connection con, String tab, String condition) throws SQLException {
        Statement stmt = con.createStatement();
        String selectStr = "SELECT * FROM " + tab;
        if (condition != null) {
            selectStr = selectStr + " WHERE " + condition;
        }
        ResultSet result = stmt.executeQuery(selectStr);
        ResultSetMetaData metaData = result.getMetaData();
        if (result.next()) {
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                String colName = tab + "." + metaData.getColumnName(i);
                String space = BLANK30.substring(0, colName.length());
                int colType = metaData.getColumnType(i);
                Object obj = result.getObject(i);
                String objStr = obj.toString();
                if (objStr.length() > 50) {
                    objStr = objStr.substring(0, 50) + "...";
                }
                String str = null;
                try {
                    str = result.getString(i);
                }
                catch (SQLException ex) {
                    str = "<conversion error>";
                }
                if (str.length() > 50) {
                    str = str.substring(0, 50) + "...";
                }
                DebugOutput.println();
                DebugOutput.println((String)(colName + " columnNo   : " + i));
                DebugOutput.println((String)(space + " columnType : " + colType));
                DebugOutput.println((String)(space + " precision  : " + metaData.getPrecision(i)));
                DebugOutput.println((String)(space + " scale      : " + metaData.getScale(i)));
                DebugOutput.println((String)(space + " objectClass: " + obj.getClass()));
                DebugOutput.println((String)(space + " Object     : " + objStr));
                DebugOutput.println((String)(space + " String     : " + str));
                if (colType == 4) {
                    DebugOutput.println((String)(space + " int        : " + result.getInt(i)));
                    continue;
                }
                if (colType == 3) {
                    DebugOutput.println((String)(space + " BigDecimal : " + result.getBigDecimal(i)));
                    continue;
                }
                if (colType != 6 && colType != 8) continue;
                DebugOutput.println((String)(space + " double     : " + result.getDouble(i)));
            }
            result.close();
        }
    }

    static int selectMaxKeyNo(Connection con) throws SQLException {
        String keyStr;
        Statement stmt = con.createStatement();
        ResultSet result = stmt.executeQuery(SELECT_MAX_TAB1_KEY);
        int maxKey = 0;
        if (result.next() && (keyStr = result.getString(1)) != null && keyStr.length() == 10) {
            maxKey = Integer.parseInt(keyStr.substring(5)) % 10000;
        }
        result.close();
        maxKey = InsertTestSubsetTables.selectMaxNumberKey(con, SELECT_MAX_TAB2_KEY, maxKey);
        return maxKey;
    }

    private static int selectMaxNumberKey(Connection con, String selectString, int oldMax) throws SQLException {
        Statement stmt = con.createStatement();
        ResultSet result = stmt.executeQuery(selectString);
        int currMax = result.next() ? result.getInt(1) : 0;
        result.close();
        return currMax > oldMax ? currMax : oldMax;
    }
}

