/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.test;

import com.sap.sdb.minDB.common.DatabaseOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.jms.BytesMessage;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class TopicSubscriberIntoFile
implements MessageListener,
ExceptionListener {
    private boolean m_isIdle = false;
    private boolean m_isTextMsg = false;
    private boolean m_verbose = false;
    private int m_timeout = 30;
    private int m_msgBytesLength = 0;
    private long m_msgCount = 0L;
    private long m_msgLimit = Long.MAX_VALUE;
    private String m_filename = "TopicMessages";
    private String m_password = "MSGSERVERADMIN";
    private String m_topicName = "TestTopic_1";
    private String m_durableTopicName = null;
    private String m_msgText = null;
    private File m_msgFile = null;
    private DataOutputStream m_outputStream = null;
    private TopicConnection m_topicConnection = null;
    private TopicSession m_topicSession = null;
    private TopicSubscriber m_subscriber = null;
    private byte[] m_allocatedBytes = new byte[32768];
    private byte[] m_msgBytes = null;
    private static final boolean IS_TRANSACTED = true;
    private static final int FILE_VERSION = 2059197953;
    private static final String DEFAULT_FILENAME = "TopicMessages";
    private static final String DEFAULT_PASSWORD = "MSGSERVERADMIN";
    private static final String DEFAULT_TOPIC_NAME = "TestTopic_1";
    private static final int DEFAULT_TIMEOUT = 30;
    private static final byte MSG_VERSION = 1;
    private static final byte MSG_BYTES = 2;
    private static final byte MSG_BYTES_NULL = 3;
    private static final byte MSG_TEXT = 4;
    private static final byte MSG_TEXT_NULL = 5;

    /*
     * Unable to fully structure code
     */
    public static void main(String[] argv) {
        block20: {
            messageSubscriber = new TopicSubscriberIntoFile();
            if (argv.length == 1 && (argv[0].equalsIgnoreCase("-h") || argv[0].equalsIgnoreCase("-help") || argv[0].equals("?"))) {
                System.out.println("-topic        <topicName>     // default: TestTopic_1");
                System.out.println("-durableTopic <topicName>     // default: null");
                System.out.println("-password <msgServerPassword> // default: MSGSERVERADMIN");
                System.out.println("-file     <filename>          // default: TopicMessages");
                System.out.println("-limit    <messagesPerFile>   // default: no limit");
                System.out.println("-timeout  <sec>               // default: 30");
                System.out.println("-verbose");
                System.out.println("The file 'jndi.properties' located in the classpath");
                System.out.println("   specifies the connection properties of the message server");
                return;
            }
            i = 0;
            while (i < argv.length) {
                if (argv[i].equalsIgnoreCase("-verbose")) {
                    messageSubscriber.m_verbose = true;
                    ++i;
                    continue;
                }
                if (i + 1 >= argv.length) {
                    System.out.println("*** invalid option: '" + argv[i] + "'");
                    return;
                }
                if (argv[i].equalsIgnoreCase("-password")) {
                    messageSubscriber.m_password = argv[i + 1];
                } else if (argv[i].equalsIgnoreCase("-topic")) {
                    messageSubscriber.m_filename = argv[i + 1];
                } else if (argv[i].equalsIgnoreCase("-file")) {
                    messageSubscriber.m_topicName = argv[i + 1];
                } else if (argv[i].equalsIgnoreCase("-limit")) {
                    try {
                        limit = Long.parseLong(argv[i + 1]);
                        if (limit <= 0L) ** GOTO lbl51
                        messageSubscriber.m_msgLimit = limit;
                    }
                    catch (Exception ex) {
                        System.out.println("*** invalid message limit: " + argv[i]);
                        return;
                    }
                } else if (argv[i].equalsIgnoreCase("-timeout")) {
                    try {
                        timeout = Integer.parseInt(argv[i + 1]);
                        if (timeout < 0) ** GOTO lbl51
                        messageSubscriber.m_timeout = timeout;
                    }
                    catch (Exception ex) {
                        System.out.println("*** invalid timeout: " + argv[i]);
                        return;
                    }
                } else {
                    System.out.println("*** invalid option: '" + argv[i] + "'");
                    return;
                }
lbl51:
                // 7 sources

                i += 2;
            }
            try {
                messageSubscriber.doWork();
            }
            catch (Exception ex) {
                System.out.println(ex.toString());
                if (!messageSubscriber.m_verbose && (ex instanceof IOException || ex instanceof NamingException || ex instanceof JMSException)) break block20;
                ex.printStackTrace();
            }
        }
    }

    private TopicSubscriberIntoFile() {
    }

    private void doWork() throws Exception {
        this.openFile();
        this.establishJMSConnection();
        this.m_topicConnection.setExceptionListener((ExceptionListener)this);
        this.m_subscriber.setMessageListener((MessageListener)this);
        this.m_topicConnection.start();
        if (this.m_timeout > 0) {
            while (true) {
                this.m_isIdle = true;
                Thread.sleep(this.m_timeout * 1000);
                if (!this.m_isIdle) continue;
                this.stopSubscriber();
            }
        }
    }

    private void establishJMSConnection() throws JMSException, NamingException {
        InitialContext jndi = new InitialContext();
        TopicConnectionFactory topicFactory = (TopicConnectionFactory)jndi.lookup("jms.TopicConnectionFactory");
        this.m_topicConnection = topicFactory.createTopicConnection("", this.m_password);
        this.m_topicSession = this.m_topicConnection.createTopicSession(true, 1);
        if (this.m_verbose) {
            System.out.println("topic session created");
        }
        Topic topic = (Topic)jndi.lookup("jms.topic." + this.m_topicName);
        if (this.m_verbose) {
            System.out.println("topic '" + this.m_topicName + "' accessed");
        }
        if (this.m_durableTopicName == null) {
            this.m_subscriber = this.m_topicSession.createSubscriber(topic);
            if (this.m_verbose) {
                System.out.println("topic subscriber established");
            }
        } else {
            this.m_subscriber = this.m_topicSession.createDurableSubscriber(topic, this.m_durableTopicName);
            if (this.m_verbose) {
                System.out.println("durable topic subscriber established for '" + this.m_durableTopicName + "'");
            }
        }
    }

    public void onException(JMSException ex) {
        System.out.println(ex.toString());
        if (this.m_verbose) {
            ex.printStackTrace();
        }
        System.exit(0);
    }

    public void onMessage(Message message) {
        block16: {
            this.m_isIdle = false;
            this.m_msgBytesLength = 0;
            this.m_msgBytes = null;
            this.m_msgText = null;
            try {
                if (message instanceof TextMessage) {
                    this.m_isTextMsg = true;
                    this.m_msgText = ((TextMessage)message).getText();
                    if (this.m_verbose) {
                        System.out.print("text message " + (this.m_msgCount + 1L) + " received: '");
                        if (this.m_msgText.length() > 50) {
                            System.out.println(this.m_msgText.substring(0, 50) + "'...");
                        } else {
                            System.out.println(this.m_msgText + "'");
                        }
                    }
                } else if (message instanceof BytesMessage) {
                    this.m_isTextMsg = false;
                    BytesMessage bytesMsg = (BytesMessage)message;
                    this.m_msgBytes = this.m_allocatedBytes;
                    this.m_msgBytesLength = bytesMsg.readBytes(this.m_msgBytes);
                    if (this.m_msgBytesLength < 0) {
                        this.m_msgBytesLength = 0;
                        this.m_msgBytes = null;
                    } else if (this.m_msgBytesLength == this.m_msgBytes.length) {
                        boolean readMore = true;
                        byte[] currBuf = new byte[this.m_allocatedBytes.length];
                        while (readMore) {
                            int length = bytesMsg.readBytes(currBuf);
                            if (length > 0) {
                                byte[] buf = new byte[this.m_msgBytesLength + length];
                                System.arraycopy(this.m_msgBytes, 0, buf, 0, this.m_msgBytesLength);
                                System.arraycopy(currBuf, 0, buf, this.m_msgBytesLength, length);
                                this.m_msgBytes = buf;
                                this.m_msgBytesLength += length;
                            }
                            readMore = length == currBuf.length;
                        }
                    }
                    if (this.m_verbose) {
                        System.out.print("bytes message received (length: " + this.m_msgBytesLength + ")");
                    }
                } else {
                    throw new JMSException(message.toString() + " not supported");
                }
                this.writeMessageIntoFile();
                if (this.m_msgCount >= this.m_msgLimit) {
                    this.stopSubscriber();
                }
            }
            catch (Exception ex) {
                System.out.println(ex.toString());
                if (!this.m_verbose && (ex instanceof IOException || ex instanceof JMSException)) break block16;
                ex.printStackTrace();
            }
        }
    }

    private void openFile() throws IOException {
        this.m_msgFile = new File(this.m_filename);
        this.m_outputStream = new DatabaseOutputStream((OutputStream)new FileOutputStream(this.m_msgFile));
        this.m_outputStream.writeInt(2059197953);
    }

    private synchronized void stopSubscriber() throws IOException, JMSException {
        this.m_topicSession.commit();
        this.m_topicConnection.close();
        this.m_topicSession = null;
        this.m_topicConnection = null;
        this.m_outputStream.writeByte(1);
        this.m_outputStream.writeInt(2059197953);
        this.m_outputStream.close();
        this.m_outputStream = null;
        System.out.println(this.m_msgCount + " messages written into '" + this.m_msgFile.getAbsolutePath() + "'");
        System.exit(0);
    }

    private void writeMessageIntoFile() throws IOException {
        if (this.m_isTextMsg) {
            if (this.m_msgText == null) {
                this.m_outputStream.writeByte(5);
            } else {
                this.m_outputStream.writeByte(4);
                this.m_outputStream.writeUTF(this.m_msgText);
            }
        } else if (this.m_msgBytes == null) {
            this.m_outputStream.writeByte(3);
        } else {
            this.m_outputStream.writeByte(2);
            this.m_outputStream.writeInt(this.m_msgBytesLength);
            this.m_outputStream.write(this.m_msgBytes, 0, this.m_msgBytesLength);
        }
        ++this.m_msgCount;
    }
}

