/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.test;

import com.sap.sdb.minDB.common.DatabaseInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class TopicPublisherFromFile {
    private boolean m_isEOF = false;
    private boolean m_isTextMsg = false;
    private boolean m_sendTransient = false;
    private boolean m_verbose = false;
    private int m_msgBytesLength = 0;
    private long m_msgCount = 0L;
    private String m_filename = "TopicMessages";
    private String m_password = "MSGSERVERADMIN";
    private String m_topicName = "TestTopic_1";
    private String m_msgText = null;
    private File m_msgFile = null;
    private DataInputStream m_inputStream = null;
    private TopicConnection m_topicConnection = null;
    private TopicSession m_topicSession = null;
    private TopicPublisher m_publisher = null;
    private BytesMessage m_bytesMessage = null;
    private TextMessage m_textMessage = null;
    private byte[] m_allocatedBytes = new byte[32768];
    private byte[] m_msgBytes = null;
    private static final boolean IS_TRANSACTED = true;
    private static final int FILE_VERSION = 2059197953;
    private static final String DEFAULT_FILENAME = "TopicMessages";
    private static final String DEFAULT_PASSWORD = "MSGSERVERADMIN";
    private static final String DEFAULT_TOPIC_NAME = "TestTopic_1";
    private static final byte MSG_VERSION = 1;
    private static final byte MSG_BYTES = 2;
    private static final byte MSG_BYTES_NULL = 3;
    private static final byte MSG_TEXT = 4;
    private static final byte MSG_TEXT_NULL = 5;

    public static void main(String[] argv) {
        block13: {
            TopicPublisherFromFile messagePublisher = new TopicPublisherFromFile();
            if (argv.length == 1 && (argv[0].equalsIgnoreCase("-h") || argv[0].equalsIgnoreCase("-help") || argv[0].equals("?"))) {
                System.out.println("-topic    <topicName>         // default: TestTopic_1");
                System.out.println("-password <msgServerPassword> // default: MSGSERVERADMIN");
                System.out.println("-file     <filename>          // default: TopicMessages");
                System.out.println("-transient                    // publishes transient");
                System.out.println("-verbose");
                System.out.println("The file 'jndi.properties' located in the classpath");
                System.out.println("   specifies the connection properties of the message server");
                return;
            }
            int i = 0;
            while (i < argv.length) {
                if (argv[i].equalsIgnoreCase("-transient")) {
                    messagePublisher.m_sendTransient = true;
                    ++i;
                    continue;
                }
                if (argv[i].equalsIgnoreCase("-verbose")) {
                    messagePublisher.m_verbose = true;
                    ++i;
                    continue;
                }
                if (i + 1 >= argv.length) {
                    System.out.println("*** invalid option: '" + argv[i] + "'");
                    return;
                }
                if (argv[i].equalsIgnoreCase("-password")) {
                    messagePublisher.m_password = argv[i + 1];
                } else if (argv[i].equalsIgnoreCase("-topic")) {
                    messagePublisher.m_filename = argv[i + 1];
                } else if (argv[i].equalsIgnoreCase("-file")) {
                    messagePublisher.m_topicName = argv[i + 1];
                } else {
                    System.out.println("*** invalid option: '" + argv[i] + "'");
                    return;
                }
                i += 2;
            }
            try {
                messagePublisher.doWork();
            }
            catch (Exception ex) {
                System.out.println(ex.toString());
                if (!messagePublisher.m_verbose && (ex instanceof IOException || ex instanceof NamingException || ex instanceof JMSException)) break block13;
                ex.printStackTrace();
            }
        }
    }

    private TopicPublisherFromFile() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWork() throws Exception {
        block10: {
            try {
                this.establishJMSConnection();
                this.openFile();
                while (!this.m_isEOF) {
                    this.readMessageFromFile();
                    if (this.m_isEOF) continue;
                    if (this.m_isTextMsg) {
                        this.m_textMessage.clearProperties();
                        this.m_textMessage.clearBody();
                        if (this.m_msgText != null) {
                            this.m_textMessage.setText(this.m_msgText);
                        }
                        this.m_publisher.publish((Message)this.m_textMessage);
                    } else {
                        this.m_bytesMessage.clearProperties();
                        this.m_bytesMessage.clearBody();
                        if (this.m_msgBytes != null) {
                            this.m_bytesMessage.writeBytes(this.m_msgBytes, 0, this.m_msgBytesLength);
                        }
                        this.m_publisher.publish((Message)this.m_bytesMessage);
                    }
                    ++this.m_msgCount;
                    if (!this.m_verbose || this.m_msgCount % 100L != 0L) continue;
                    System.out.println(this.m_msgCount + " messages transferred");
                }
                this.m_topicSession.commit();
                Object var2_1 = null;
                if (this.m_inputStream == null) break block10;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                if (this.m_inputStream != null) {
                    this.m_inputStream.close();
                }
                if (this.m_topicConnection != null) {
                    this.m_topicConnection.close();
                }
                throw throwable;
            }
            this.m_inputStream.close();
        }
        if (this.m_topicConnection != null) {
            this.m_topicConnection.close();
        }
        System.out.println(this.m_msgCount + " messages transferred from '" + this.m_msgFile.getAbsolutePath() + "'");
    }

    private void establishJMSConnection() throws JMSException, NamingException {
        InitialContext jndi = new InitialContext();
        TopicConnectionFactory topicFactory = (TopicConnectionFactory)jndi.lookup("jms.TopicConnectionFactory");
        this.m_topicConnection = topicFactory.createTopicConnection("", this.m_password);
        this.m_topicSession = this.m_topicConnection.createTopicSession(true, 1);
        if (this.m_verbose) {
            System.out.println("topic session created");
        }
        Topic topic = (Topic)jndi.lookup("jms.topic." + this.m_topicName);
        if (this.m_verbose) {
            System.out.println("topic '" + this.m_topicName + "' accessed");
        }
        this.m_publisher = this.m_topicSession.createPublisher(topic);
        if (this.m_sendTransient) {
            this.m_publisher.setDeliveryMode(1);
        }
        if (this.m_verbose) {
            System.out.println("topic pulisher established");
        }
        this.m_bytesMessage = this.m_topicSession.createBytesMessage();
        this.m_textMessage = this.m_topicSession.createTextMessage();
        if (this.m_verbose) {
            if (this.m_sendTransient) {
                System.out.print("transient ");
            }
            System.out.println("topic pulisher established");
        }
    }

    private void openFile() throws IOException {
        this.m_msgFile = new File(this.m_filename);
        this.m_inputStream = new DatabaseInputStream((InputStream)new FileInputStream(this.m_msgFile));
        int inputVersion = this.m_inputStream.readInt();
        if (inputVersion != 2059197953) {
            throw new IOException("Wrong file version " + inputVersion + " (expected version: " + 2059197953 + ")");
        }
    }

    private void readMessageFromFile() throws IOException {
        this.m_msgBytesLength = 0;
        this.m_msgBytes = null;
        this.m_msgText = null;
        int msgType = this.m_inputStream.readInt();
        switch (msgType) {
            case 1: {
                int inputVersion = this.m_inputStream.readInt();
                if (inputVersion != 2059197953) {
                    throw new IOException("Wrong end of file version " + inputVersion + " (expected version: " + 2059197953 + ")");
                }
                this.m_isEOF = true;
                break;
            }
            case 2: {
                this.m_isTextMsg = false;
                this.m_msgBytesLength = this.m_inputStream.readInt();
                this.m_msgBytes = this.m_msgBytesLength <= this.m_allocatedBytes.length ? this.m_allocatedBytes : new byte[this.m_msgBytesLength];
                this.m_inputStream.readFully(this.m_msgBytes, 0, this.m_msgBytesLength);
                break;
            }
            case 3: {
                this.m_isTextMsg = false;
                break;
            }
            case 4: {
                this.m_msgText = this.m_inputStream.readUTF();
                this.m_isTextMsg = true;
                break;
            }
            case 5: {
                this.m_isTextMsg = true;
                break;
            }
            default: {
                throw new IOException("Invalid message type " + msgType);
            }
        }
    }
}

