/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.test;

import java.io.PrintStream;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class SyncMultiQueueReceiver
implements ExceptionListener {
    private static PrintStream out = System.out;
    private static Queue a_queue = null;
    private static int receivers_numb = 0;
    private static int torecv = 0;
    private static int rcvd = 0;
    private QueueSession qSession = null;
    private QueueReceiver[] qReceivers = null;

    public SyncMultiQueueReceiver(QueueConnection q_conn) {
        try {
            this.qSession = q_conn.createQueueSession(false, 1);
            this.qReceivers = new QueueReceiver[receivers_numb];
            for (int i = 0; i < receivers_numb; ++i) {
                this.qReceivers[i] = this.qSession.createReceiver(a_queue);
                q_conn.setExceptionListener((ExceptionListener)this);
            }
            q_conn.start();
        }
        catch (JMSException jmse) {
            jmse.printStackTrace(out);
            System.exit(1);
        }
    }

    public void onException(JMSException jsme) {
        out.println("sender exit : " + jsme.toString());
        jsme.printStackTrace(out);
        System.exit(1);
    }

    private void sync_receive() {
        for (int i = 0; i < receivers_numb && rcvd < torecv; ++i) {
            try {
                TextMessage textMessage = (TextMessage)this.qReceivers[i].receive();
                textMessage.getText();
                ++rcvd;
                continue;
            }
            catch (JMSException jex) {
                this.onException(jex);
            }
        }
    }

    public static void main(String[] argv) {
        long lapse = System.currentTimeMillis();
        long endmillis = 0L;
        QueueConnectionFactory qFactory = null;
        InitialContext jndi = null;
        String queuename = argv[0];
        int conn_numb = Integer.parseInt(argv[1]);
        int sessions_numb = Integer.parseInt(argv[2]);
        int i = 0;
        int cidx = 0;
        SyncMultiQueueReceiver[][] i_list = new SyncMultiQueueReceiver[conn_numb][sessions_numb];
        QueueConnection[] q_conn_list = new QueueConnection[conn_numb];
        torecv = Integer.parseInt(argv[4]);
        receivers_numb = Integer.parseInt(argv[3]);
        out.println("_____________________________________________________");
        out.println("begin of main() at " + lapse);
        out.println("cmdl pars : \n   queuename                  : \"" + queuename + "\"\n" + "   number of connections      : " + conn_numb + "\n" + "   sessions per connection    : " + sessions_numb + "\n" + "   receivers per session      : " + receivers_numb + "\n" + "   msgs to receive (total)    : " + torecv);
        try {
            jndi = new InitialContext();
            a_queue = (Queue)jndi.lookup("jms.queue." + queuename);
            qFactory = (QueueConnectionFactory)jndi.lookup("jms.QueueConnectionFactory");
        }
        catch (NamingException jne) {
            jne.printStackTrace(out);
            System.exit(1);
        }
        out.println("_____________________________________________________\nbeginning to create " + conn_numb + " connection(s) at " + System.currentTimeMillis());
        for (cidx = 0; cidx < conn_numb; ++cidx) {
            try {
                q_conn_list[cidx] = qFactory.createQueueConnection("", "");
            }
            catch (JMSException jmse) {
                jmse.printStackTrace(out);
                System.exit(1);
            }
            out.println("beginning to create " + sessions_numb + " session(s) at      " + System.currentTimeMillis());
            for (i = 0; i < sessions_numb; ++i) {
                i_list[cidx][i] = new SyncMultiQueueReceiver(q_conn_list[cidx]);
            }
        }
        while (rcvd < torecv) {
            for (cidx = 0; cidx < conn_numb && rcvd < torecv; ++cidx) {
                for (i = 0; i < sessions_numb && rcvd < torecv; ++i) {
                    i_list[cidx][i].sync_receive();
                }
            }
        }
        for (cidx = 0; cidx < conn_numb; ++cidx) {
            try {
                q_conn_list[cidx].close();
                continue;
            }
            catch (JMSException jmse) {
                jmse.printStackTrace(out);
                System.exit(1);
            }
        }
        out.println("_____________________________________________________");
        endmillis = System.currentTimeMillis();
        out.println("end of main() at " + endmillis + " , duration : " + (endmillis - lapse));
        out.println("_____________________________________________________");
    }
}

