/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.test;

import java.util.Date;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class SeqTopicPublisher
extends Thread
implements ExceptionListener {
    private TopicConnection[] myConnection;
    private TopicSession[] qSession;
    private TopicPublisher[] qSender;
    private Topic[] produceTopic;
    TextMessage[] myTextMsg;
    private int myMessagesToSend = 0;
    private int mySentMessages = 0;
    private int myPriority = 0;
    private int myDeliverMode = 0;
    private int mySenderCount = 0;

    public SeqTopicPublisher(String producerCount, String topicName, String priority, String messagesToSend, String persistent) {
        try {
            this.mySenderCount = Integer.parseInt(producerCount);
            this.myPriority = Integer.parseInt(priority);
            this.myMessagesToSend = Integer.parseInt(messagesToSend);
            this.myPriority = Integer.parseInt(priority);
            this.myDeliverMode = persistent.equalsIgnoreCase("persistent") ? 2 : 1;
            TopicConnectionFactory qFactory = null;
            InitialContext jndi = null;
            jndi = new InitialContext();
            qFactory = (TopicConnectionFactory)jndi.lookup("jms.TopicConnectionFactory");
            this.myConnection = new TopicConnection[this.mySenderCount];
            this.qSession = new TopicSession[this.mySenderCount];
            this.qSender = new TopicPublisher[this.mySenderCount];
            this.produceTopic = new Topic[this.mySenderCount];
            this.myTextMsg = new TextMessage[this.mySenderCount];
            for (int i = 0; i < this.mySenderCount; ++i) {
                this.myConnection[i] = qFactory.createTopicConnection("", "");
                this.qSession[i] = this.myConnection[0].createTopicSession(false, 1);
                this.produceTopic[i] = (Topic)jndi.lookup("jms.topic." + topicName + new Integer(i + 1).toString());
                this.qSender[i] = this.qSession[i].createPublisher(this.produceTopic[i]);
                this.myConnection[i].setExceptionListener((ExceptionListener)this);
                this.myTextMsg[i] = this.qSession[i].createTextMessage();
            }
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
            System.exit(1);
        }
        catch (NamingException jne) {
            jne.printStackTrace();
            System.exit(1);
        }
    }

    public void onException(JMSException jsme) {
        System.out.println("Exit Sender due to: " + jsme.toString());
        this.exit();
    }

    private void produceAMessage(int iMessageNumber, int priority) {
        try {
            String prefix = iMessageNumber + " with Priority(" + priority + ")" + " ";
            for (int i = 0; i < this.mySenderCount; ++i) {
                this.myTextMsg[i].setText(prefix);
                System.out.println("Send Message: " + this.myTextMsg[i].getText());
                this.myTextMsg[i].setIntProperty("MsgNumber", iMessageNumber);
                this.myTextMsg[i].setIntProperty("TopicNumber", i);
                this.qSender[i].publish((Message)this.myTextMsg[i], this.myDeliverMode, priority, 0L);
            }
            ++this.mySentMessages;
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
        }
    }

    public void run() {
        Date start = new Date();
        while (this.mySentMessages < this.myMessagesToSend) {
            try {
                this.produceAMessage(this.mySentMessages, this.myPriority);
            }
            catch (Exception ex2) {
                ex2.printStackTrace();
            }
        }
        Date end = new Date();
        System.out.println(start.toString());
        System.out.println(end.toString());
    }

    private void exit() {
        try {
            for (int i = 0; i < this.mySenderCount; ++i) {
                this.myConnection[i].close();
            }
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
        }
        System.exit(0);
    }

    public static void main(String[] argv) {
        if (argv.length != 5) {
            System.out.println("SenderCount,TopicName,Priority,Messagenumber or (non)persistent missing");
        }
        SeqTopicPublisher qs = new SeqTopicPublisher(argv[0], argv[1], argv[2], argv[3], argv[4]);
        System.out.println("SeqTopicPublisher application started");
        qs.start();
    }
}

