/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.test;

import com.sap.sdb.msgServer.client.TopicBrowserImpl;
import com.sap.sdb.msgServer.client.TopicSessionImpl;
import java.util.Enumeration;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class OneTopicBrowser
implements ExceptionListener {
    private TopicConnection qConnect = null;
    private TopicSession session = null;
    private Topic receiveTopic = null;
    private int myMessagesReceived = 0;
    private int myMessagesToReceive = 0;

    public OneTopicBrowser(String TopicName, String messagesToReceive) {
        try {
            this.myMessagesToReceive = Integer.parseInt(messagesToReceive);
            TopicConnectionFactory qFactory = null;
            InitialContext jndi = null;
            jndi = new InitialContext();
            qFactory = (TopicConnectionFactory)jndi.lookup("jms.TopicConnectionFactory");
            this.qConnect = qFactory.createTopicConnection("", "");
            this.session = this.qConnect.createTopicSession(false, 1);
            this.receiveTopic = (Topic)jndi.lookup("jms.topic." + TopicName);
            this.qConnect.setExceptionListener((ExceptionListener)this);
            this.qConnect.start();
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
            System.exit(1);
        }
        catch (NamingException jne) {
            jne.printStackTrace();
            System.exit(1);
        }
    }

    public void onException(JMSException jsme) {
        System.out.println("Exit Receiver due to: " + jsme.toString());
        this.exit();
    }

    private void handleMessage(Message message) {
        try {
            TextMessage textMessage = (TextMessage)message;
            ++this.myMessagesReceived;
            String text = textMessage.getText();
            String out = "Received ";
            if (textMessage.getJMSRedelivered()) {
                out = out + "and redelivered: ";
            }
            if (text.length() > 64) {
                System.out.println(out + text.substring(0, 64));
            } else {
                System.out.println(out + text);
            }
            if (this.myMessagesReceived == this.myMessagesToReceive) {
                this.exit();
            }
        }
        catch (Exception rte) {
            rte.printStackTrace();
        }
    }

    public void doWork() {
        try {
            System.out.print("Creating TopicBrowser...");
            TopicBrowserImpl browser = ((TopicSessionImpl)this.session).createBrowser(this.receiveTopic);
            System.out.println("[done]");
            Enumeration e = browser.getEnumeration();
            while (this.myMessagesReceived < this.myMessagesToReceive) {
                while (e.hasMoreElements()) {
                    TextMessage message = (TextMessage)e.nextElement();
                    this.handleMessage((Message)message);
                }
                System.out.println("No Messages in Topic ... sleep 1 sec");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (JMSException ex) {
            ex.printStackTrace();
        }
    }

    public void exit() {
        try {
            this.qConnect.close();
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
        }
        System.exit(0);
    }

    public static void main(String[] argv) {
        if (argv.length != 2) {
            System.out.println("TopicName or Messagenumber missing");
        }
        OneTopicBrowser qb = new OneTopicBrowser(argv[0], argv[1]);
        System.out.println("OneTopicBrowser application started. Stop with 'exit'");
        qb.doWork();
        System.out.println("OneTopicBrowser application stopped");
    }
}

