/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.test;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class MultiTopicPublisher
extends Thread
implements ExceptionListener {
    private TopicPublisher[] t_publisher_list = new TopicPublisher[publishers_numb];
    private TopicSession t_session = null;
    private static Topic a_topic = null;
    private static int sessions_numb = 0;
    private static int msg_numb = 0;
    private static int publishers_numb = 0;
    private static String outstr = null;
    private static String payload = "";
    private static StringBuffer payload_buf = null;
    private static PrintStream out = System.out;

    public MultiTopicPublisher(String threadname, TopicConnection t_conn) {
        super(threadname);
        try {
            this.t_session = t_conn.createTopicSession(false, 1);
            for (int i = 0; i < publishers_numb; ++i) {
                this.t_publisher_list[i] = this.t_session.createPublisher(a_topic);
            }
            t_conn.setExceptionListener((ExceptionListener)this);
        }
        catch (JMSException jmse) {
            jmse.printStackTrace(out);
            System.exit(1);
        }
    }

    public void onException(JMSException jsme) {
        out.println("publisher exit : " + jsme.toString());
        jsme.printStackTrace(out);
        System.exit(1);
    }

    public void run() {
        try {
            TextMessage textMsg = this.t_session.createTextMessage();
            textMsg.setText(payload);
            for (int i = 0; i < msg_numb; ++i) {
                for (int j = 0; j < publishers_numb; ++j) {
                    this.t_publisher_list[j].publish((Message)textMsg);
                }
            }
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
        }
    }

    public static void main(String[] argv) throws FileNotFoundException {
        long startmillis = 0L;
        long endmillis = 0L;
        long total_msgs = 0L;
        long total_bytes = 0L;
        TopicConnectionFactory tFactory = null;
        InitialContext jndi = null;
        String topicname = argv[0];
        int conn_numb = 0;
        int payload_size = 0;
        int i = 0;
        int cidx = 0;
        MultiTopicPublisher[][] t_list = null;
        TopicConnection[] t_conn_list = null;
        try {
            Thread.sleep(20000L);
        }
        catch (InterruptedException iex) {
            // empty catch block
        }
        if (!argv[1].equals("-")) {
            out = new PrintStream(new FileOutputStream(argv[1], true));
        }
        payload_size = Integer.parseInt(argv[2]);
        conn_numb = Integer.parseInt(argv[3]);
        sessions_numb = Integer.parseInt(argv[4]);
        publishers_numb = Integer.parseInt(argv[5]);
        msg_numb = Integer.parseInt(argv[6]);
        total_msgs = msg_numb * publishers_numb * sessions_numb * conn_numb;
        total_bytes = total_msgs * (long)payload_size;
        outstr = "persistent , asynchronous , topic , sender   , nondurable , " + conn_numb + " , " + sessions_numb + " , " + publishers_numb + " , " + total_msgs + " , " + total_msgs + " , ";
        try {
            jndi = new InitialContext();
            a_topic = (Topic)jndi.lookup("jms.topic." + topicname);
            tFactory = (TopicConnectionFactory)jndi.lookup("jms.TopicConnectionFactory");
        }
        catch (NamingException jne) {
            jne.printStackTrace(out);
            System.exit(1);
        }
        t_list = new MultiTopicPublisher[conn_numb][sessions_numb];
        t_conn_list = new TopicConnection[conn_numb];
        payload_buf = new StringBuffer("");
        for (i = 0; i < payload_size; ++i) {
            payload_buf.append("a");
        }
        payload = payload_buf.toString();
        for (cidx = 0; cidx < conn_numb; ++cidx) {
            try {
                t_conn_list[cidx] = tFactory.createTopicConnection("", "");
            }
            catch (JMSException jmse) {
                jmse.printStackTrace(out);
                System.exit(1);
            }
            startmillis = System.currentTimeMillis();
            for (i = 0; i < sessions_numb; ++i) {
                t_list[cidx][i] = new MultiTopicPublisher("thread [" + cidx + "]" + "[" + i + "]", t_conn_list[cidx]);
                t_list[cidx][i].start();
            }
        }
        for (cidx = 0; cidx < conn_numb; ++cidx) {
            for (i = 0; i < sessions_numb; ++i) {
                if (t_list[cidx][i] == null) continue;
                try {
                    t_list[cidx][i].join();
                    continue;
                }
                catch (InterruptedException iex) {
                    // empty catch block
                }
            }
        }
        endmillis = System.currentTimeMillis();
        for (cidx = 0; cidx < conn_numb; ++cidx) {
            try {
                t_conn_list[cidx].close();
                continue;
            }
            catch (JMSException jmse) {
                jmse.printStackTrace(out);
                System.exit(1);
            }
        }
        outstr = outstr + total_bytes + " ," + startmillis + " , " + endmillis;
        out.println(outstr);
        out.flush();
        out.close();
        System.exit(0);
    }
}

