/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.test;

import com.sap.sdb.msgServer.test.ReceiveStatisticHandler;
import com.sap.sdb.msgServer.test.ReceiverClient;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.StreamMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class MassQueueStreamReceiver
implements MessageListener,
ExceptionListener,
ReceiverClient {
    private int m_ownThreadId;
    private int m_receiveCount;
    private int m_maxBoolean;
    private int m_maxByte;
    private int m_maxByteArray;
    private int m_maxChar;
    private int m_maxDouble;
    private int m_maxFloat;
    private int m_maxInt;
    private int m_maxLong;
    private int m_maxNumString;
    private int m_maxNumObject;
    private int m_maxShort;
    private int m_maxString;
    private long m_startTime;
    private Queue m_receiveQueue;
    private QueueConnection m_queueConnect;
    private QueueSession m_queueSession;
    private byte[] m_byteArray;
    private static ReceiveStatisticHandler m_receiveStat = null;
    private static int sm_clientsCount = 0;
    private static final int DISPLAY_MSG_COUNT = 100;
    private static final int DISPLAY_PROGRESS_COUNT = 500;

    public MassQueueStreamReceiver(int threadId, String queueName) {
        try {
            this.m_receiveCount = 0;
            this.m_ownThreadId = threadId;
            this.m_byteArray = null;
            InitialContext jndi = new InitialContext();
            QueueConnectionFactory qFactory = (QueueConnectionFactory)jndi.lookup("jms.QueueConnectionFactory");
            this.m_queueConnect = qFactory.createQueueConnection("", "");
            this.m_queueSession = this.m_queueConnect.createQueueSession(false, 1);
            this.m_receiveQueue = (Queue)jndi.lookup("jms.queue." + queueName);
            QueueReceiver qReceiver = this.m_queueSession.createReceiver(this.m_receiveQueue);
            qReceiver.setMessageListener((MessageListener)this);
            this.m_queueConnect.setExceptionListener((ExceptionListener)this);
            this.m_startTime = System.currentTimeMillis();
            this.m_queueConnect.start();
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
            System.exit(1);
        }
        catch (NamingException jne) {
            jne.printStackTrace();
            System.exit(1);
        }
    }

    public static void main(String[] argv) {
        if (argv.length == 1) {
            sm_clientsCount = 1;
        } else {
            if (argv.length < 3) {
                System.out.println("Parameter required: <QueueName1> <QueueName2> <maxClientPairs> [CLIENT_ACK | TRANSACTED]");
                return;
            }
            sm_clientsCount = 2 * Integer.parseInt(argv[2]);
        }
        int maxClients = sm_clientsCount;
        m_receiveStat = new ReceiveStatisticHandler(maxClients);
        m_receiveStat.start();
        for (int i = 0; i < maxClients; ++i) {
            System.out.println("initializing StreamReceiver T" + i);
            if (i % 2 == 0) {
                new MassQueueStreamReceiver(i, argv[0]);
                continue;
            }
            new MassQueueStreamReceiver(i, argv[1]);
        }
    }

    public void exit() {
        System.out.println("EXIT STREAM RECEIVER");
        try {
            this.m_queueConnect.close();
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
        }
        System.exit(0);
    }

    public long getErrorCount() {
        return 0L;
    }

    public long getMessageCount() {
        return this.m_receiveCount;
    }

    public int getThreadId() {
        return this.m_ownThreadId;
    }

    public void onException(JMSException jsme) {
        this.println("Exit Receiver due to: " + jsme.toString());
        this.exit();
    }

    public void onMessage(Message message) {
        ++this.m_receiveCount;
        try {
            int i;
            int i2;
            boolean outputWanted;
            if (this.m_receiveCount == 1) {
                m_receiveStat.clientStarted(this);
                this.m_maxBoolean = message.getIntProperty("booleanCount");
                this.m_maxByte = message.getIntProperty("byteCount");
                this.m_maxByteArray = message.getIntProperty("ByteArrayCount");
                this.m_maxChar = message.getIntProperty("charCount");
                this.m_maxDouble = message.getIntProperty("doubleCount");
                this.m_maxFloat = message.getIntProperty("floatCount");
                this.m_maxInt = message.getIntProperty("intCount");
                this.m_maxLong = message.getIntProperty("longCount");
                this.m_maxNumObject = message.getIntProperty("numObjectCount");
                this.m_maxNumString = message.getIntProperty("numStringCount");
                this.m_maxShort = message.getIntProperty("shortCount");
                this.m_maxString = message.getIntProperty("StringCount");
                this.m_byteArray = new byte[message.getIntProperty("ByteArrayLength")];
            }
            StreamMessage streamMsg = (StreamMessage)message;
            boolean bl = outputWanted = this.m_receiveCount <= 3 || this.m_receiveCount % 100 == 0;
            if (outputWanted) {
                System.out.println();
            }
            boolean booleanValue = false;
            byte byteValue = 0;
            char charValue = ' ';
            double doubleValue = 0.0;
            float floatValue = 0.0f;
            int intValue = 0;
            long longValue = 0L;
            short shortValue = 0;
            String stringValue = null;
            Object obj = null;
            String outline = null;
            String msgInfo = streamMsg.readString();
            obj = streamMsg.readObject();
            stringValue = streamMsg.readString();
            for (i2 = 3; i2 <= this.m_maxBoolean; ++i2) {
                booleanValue = streamMsg.readBoolean();
            }
            if (outputWanted) {
                outline = msgInfo + "; boolean: " + ((Boolean)obj).toString() + " '" + stringValue + "' " + String.valueOf(booleanValue);
            }
            obj = streamMsg.readObject();
            stringValue = streamMsg.readString();
            shortValue = streamMsg.readShort();
            intValue = streamMsg.readInt();
            longValue = streamMsg.readLong();
            for (i2 = 6; i2 <= this.m_maxByte; ++i2) {
                byteValue = streamMsg.readByte();
            }
            if (outputWanted) {
                outline = outline + "; byte: " + (Byte)obj + " '" + stringValue + "' " + shortValue + " " + intValue + " " + longValue + " " + byteValue;
                this.println(outline);
            }
            obj = streamMsg.readObject();
            int arrayLen = 0;
            for (i = 2; i <= this.m_maxByteArray; ++i) {
                arrayLen = streamMsg.readBytes(this.m_byteArray);
            }
            if (outputWanted) {
                outline = "     byteArray[" + arrayLen + "]: " + ((byte[])obj)[0] + " " + ((byte[])obj)[this.m_byteArray.length - 1] + " " + this.m_byteArray[0] + " " + this.m_byteArray[this.m_byteArray.length - 1];
            }
            obj = streamMsg.readObject();
            stringValue = streamMsg.readString();
            for (i = 3; i <= this.m_maxChar; ++i) {
                charValue = streamMsg.readChar();
            }
            if (outputWanted) {
                outline = outline + "; char: " + (Character)obj + " '" + stringValue + "' " + charValue;
            }
            obj = streamMsg.readObject();
            stringValue = streamMsg.readString();
            for (i = 3; i <= this.m_maxDouble; ++i) {
                doubleValue = streamMsg.readDouble();
            }
            if (outputWanted) {
                outline = outline + "; double: " + (Double)obj + " '" + stringValue + "' " + doubleValue;
                this.println(outline);
            }
            obj = streamMsg.readObject();
            stringValue = streamMsg.readString();
            doubleValue = streamMsg.readDouble();
            for (i = 4; i <= this.m_maxFloat; ++i) {
                floatValue = streamMsg.readFloat();
            }
            if (outputWanted) {
                outline = "     float: " + (Float)obj + " '" + stringValue + "' " + doubleValue + " " + floatValue;
            }
            obj = streamMsg.readObject();
            stringValue = streamMsg.readString();
            longValue = streamMsg.readLong();
            for (i = 4; i <= this.m_maxInt; ++i) {
                intValue = streamMsg.readInt();
            }
            if (outputWanted) {
                outline = outline + "; int: " + (Integer)obj + " '" + stringValue + "' " + longValue + " " + intValue;
            }
            obj = streamMsg.readObject();
            stringValue = streamMsg.readString();
            for (i = 3; i <= this.m_maxLong; ++i) {
                longValue = streamMsg.readLong();
            }
            if (outputWanted) {
                outline = outline + "; long: " + (Long)obj + " '" + stringValue + "' " + longValue;
                this.println(outline);
            }
            for (i = 1; i <= this.m_maxNumObject; ++i) {
                byteValue = streamMsg.readByte();
                doubleValue = streamMsg.readDouble();
                floatValue = streamMsg.readFloat();
                intValue = streamMsg.readInt();
                longValue = streamMsg.readLong();
                shortValue = streamMsg.readShort();
            }
            if (outputWanted) {
                this.println("     number object: " + byteValue + " " + doubleValue + " " + floatValue + " " + intValue + " " + longValue + " " + shortValue);
            }
            for (i = 1; i <= this.m_maxNumString; ++i) {
                byteValue = streamMsg.readByte();
                doubleValue = streamMsg.readDouble();
                floatValue = streamMsg.readFloat();
                intValue = streamMsg.readInt();
                longValue = streamMsg.readLong();
                shortValue = streamMsg.readShort();
            }
            if (outputWanted) {
                this.println("     number string: " + byteValue + " " + doubleValue + " " + floatValue + " " + intValue + " " + longValue + " " + shortValue);
            }
            obj = streamMsg.readObject();
            stringValue = streamMsg.readString();
            intValue = streamMsg.readInt();
            longValue = streamMsg.readLong();
            for (i = 5; i <= this.m_maxShort; ++i) {
                shortValue = streamMsg.readShort();
            }
            if (outputWanted) {
                outline = "     short: " + (Short)obj + " '" + stringValue + "' " + intValue + " " + longValue + " " + shortValue;
            }
            obj = streamMsg.readObject();
            for (i = 2; i <= this.m_maxString; ++i) {
                stringValue = streamMsg.readString();
            }
            if (outputWanted) {
                outline = outline + "; String: " + (String)obj + " '" + stringValue + "' ";
                this.println(outline);
            }
            if (this.m_receiveCount % 500 == 0) {
                long now = System.currentTimeMillis();
                long duration = now - this.m_startTime;
                if (duration > 0L) {
                    this.println(500000L / duration + " messages/sec");
                }
                this.m_startTime = now;
            }
            m_receiveStat.incrSumMessages();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void println(String msg) {
        System.out.println("T" + this.m_ownThreadId + ": " + msg);
    }
}

