/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import javax.jms.BytesMessage;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class AllMessagesQS
extends Thread
implements ExceptionListener {
    private QueueConnection qConnect = null;
    private QueueSession qSession = null;
    private QueueSender qSender = null;
    private Queue aQueue = null;
    private int sentMessages = 0;

    public AllMessagesQS(String qextension) {
        try {
            QueueConnectionFactory qFactory = null;
            InitialContext jndi = null;
            jndi = new InitialContext();
            qFactory = (QueueConnectionFactory)jndi.lookup("jms.QueueConnectionFactory");
            this.qConnect = qFactory.createQueueConnection("", "");
            this.qSession = this.qConnect.createQueueSession(false, 1);
            this.aQueue = (Queue)jndi.lookup("jms.queue.T1" + qextension);
            this.qSender = this.qSession.createSender(this.aQueue);
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
            System.exit(1);
        }
        catch (NamingException jne) {
            jne.printStackTrace();
            System.exit(1);
        }
    }

    private void sendAMessage(Date aDate, int iMessageNumber) {
        try {
            TextMessage textMsg = this.qSession.createTextMessage();
            textMsg.setText("TextMessage " + aDate.toString() + " Nr:" + new Integer(iMessageNumber).toString());
            this.qSender.send((Message)textMsg);
            BytesMessage bytesMsg = this.qSession.createBytesMessage();
            bytesMsg.writeBoolean(true);
            byte[] buf = new byte[10];
            for (int i = 0; i <= 9; i = (int)((byte)(i + 1))) {
                buf[i] = i;
            }
            bytesMsg.writeBytes(buf);
            this.qSender.send((Message)bytesMsg);
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
        }
    }

    public void run() {
        Date start = new Date();
        while (this.sentMessages < 1) {
            try {
                Date newT = new Date();
                this.sendAMessage(newT, this.sentMessages);
                ++this.sentMessages;
            }
            catch (Exception ex2) {
                ex2.printStackTrace();
            }
        }
        try {
            TextMessage textMsg = this.qSession.createTextMessage();
            textMsg.setText("This is the end !");
            this.qSender.send((Message)textMsg);
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
        }
        Date end = new Date();
        System.out.println(start.toString());
        System.out.println(end.toString());
    }

    public void onException(JMSException jsme) {
        this.exit();
    }

    private void exit() {
        try {
            this.qConnect.close();
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
        }
        System.exit(0);
    }

    public static void main(String[] argv) {
        if (argv.length != 1) {
            System.out.println("Queue extension missing");
        }
        AllMessagesQS t1qs = new AllMessagesQS(argv[0]);
        System.out.println("QueueSender application started");
        t1qs.start();
        while (true) {
            try {
                while (true) {
                    BufferedReader stdin;
                    String s;
                    if (!(s = (stdin = new BufferedReader(new InputStreamReader(System.in))).readLine()).equals("exit")) {
                        continue;
                    }
                    t1qs.interrupt();
                    t1qs.exit();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                continue;
            }
            break;
        }
    }
}

