/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import javax.jms.BytesMessage;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class AllMessagesQR
implements MessageListener,
ExceptionListener {
    private QueueConnection qConnect = null;
    private QueueSession qSession = null;
    private Queue receiveQueue = null;

    public AllMessagesQR(String qextension) {
        try {
            QueueConnectionFactory qFactory = null;
            InitialContext jndi = null;
            jndi = new InitialContext();
            qFactory = (QueueConnectionFactory)jndi.lookup("jms.QueueConnectionFactory");
            this.qConnect = qFactory.createQueueConnection("", "");
            this.qSession = this.qConnect.createQueueSession(false, 1);
            this.receiveQueue = (Queue)jndi.lookup("jms.queue.T1" + qextension);
            QueueReceiver qReceiver = this.qSession.createReceiver(this.receiveQueue);
            qReceiver.setMessageListener((MessageListener)this);
            this.qConnect.start();
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
            System.exit(1);
        }
        catch (NamingException jne) {
            jne.printStackTrace();
            System.exit(1);
        }
    }

    public void onException(JMSException jsme) {
        this.exit();
    }

    public void onMessage(Message message) {
        try {
            TextMessage textMessage;
            String text;
            if (message instanceof TextMessage && (text = (textMessage = (TextMessage)message).getText()).equals("This is the end !")) {
                Date end = new Date();
                System.out.println("Last Order received: " + text + " " + end.toString());
            }
            if (message instanceof BytesMessage) {
                BytesMessage bytesMsg = (BytesMessage)message;
                System.out.println(bytesMsg.readBoolean());
                byte[] buf = new byte[20];
                bytesMsg.readBytes(buf, 5);
                bytesMsg.readBytes(buf, 6);
                bytesMsg.readBytes(buf, 1);
                bytesMsg.reset();
                bytesMsg.readBytes(buf, 0);
                bytesMsg.readBytes(buf, 11);
            }
        }
        catch (Exception rte) {
            rte.printStackTrace();
        }
    }

    public void exit() {
        try {
            this.qConnect.close();
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
        }
        System.exit(0);
    }

    public static void main(String[] argv) {
        if (argv.length != 1) {
            System.out.println("Queue extension missing");
        }
        AllMessagesQR t1qr = new AllMessagesQR(argv[0]);
        System.out.println("QueueReceiver application started");
        while (true) {
            try {
                while (true) {
                    BufferedReader stdin;
                    String s;
                    if (!(s = (stdin = new BufferedReader(new InputStreamReader(System.in))).readLine()).equals("exit")) {
                        continue;
                    }
                    t1qr.exit();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                continue;
            }
            break;
        }
    }
}

