/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.ptest;

import com.sap.sdb.msgServer.ptest.PTestCase;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PTest {
    private Hashtable m_global_params = new Hashtable();
    private Node m_cubes = null;

    private PTest(String configFileName) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(new ErrorHandler(){

            public void warning(SAXParseException ex) throws SAXException {
                throw ex;
            }

            public void error(SAXParseException ex) throws SAXException {
                throw ex;
            }

            public void fatalError(SAXParseException ex) throws SAXException {
                throw ex;
            }
        });
        Document myConfigFile = builder.parse(configFileName);
        this.dump_g(myConfigFile, null, 0);
        this.set_cube_defaults();
    }

    public static void main(String[] argv) throws Exception {
        PTest test_obj = null;
        try {
            test_obj = new PTest(argv[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        test_obj.main_internal();
    }

    public void main_internal() throws Exception {
        this.dump_cs(this.m_cubes, 0);
    }

    public void runcase(Hashtable crds, long cube_timeout_millis, boolean restart, long server_shutdown_wait, String remark) throws Exception {
        PTestCase testcase_obj = null;
        String output_prefix = null;
        String special_client = null;
        int server_cpus = 0;
        int producer_cpus = 0;
        int consumer_cpus = 0;
        if ((!((String)crds.get("haveQueue")).equalsIgnoreCase("topic") || ((String)crds.get("haveSequential")).equalsIgnoreCase("parallel") || ((String)crds.get("haveNondurable")).equalsIgnoreCase("durable")) && !(((String)crds.get("haveAsync")).equalsIgnoreCase("sync") & Integer.parseInt((String)crds.get("clients_numb")) > 1)) {
            testcase_obj = new PTestCase((String)this.m_global_params.get("ptest_log_dir") + (String)this.m_global_params.get("ptest_log_name"), (String)this.m_global_params.get("ptest_log_dir") + (String)this.m_global_params.get("server_log_name"), (String)this.m_global_params.get("client_output_suffix"), (String)this.m_global_params.get("inst_dir"), (String)this.m_global_params.get("run_dir"), (String)this.m_global_params.get("jrun"), (String)this.m_global_params.get("jrun_options"), (String)this.m_global_params.get("jrun_classpath"), (String)this.m_global_params.get("db_clean_prog"), (String)this.m_global_params.get("db_clean_options"), (String)this.m_global_params.get("db_clean_script"), (String)this.m_global_params.get("proc_aff_prog"), (String)this.m_global_params.get("proc_aff_options"), (String)this.m_global_params.get("server_class"), (String)this.m_global_params.get("server_options"), (String)this.m_global_params.get("shutdown_class"), (String)this.m_global_params.get("shutdown_options"), (String)this.m_global_params.get("producer_class"), (String)this.m_global_params.get("consumer_class"), Long.parseLong((String)this.m_global_params.get("dbclean_sleep_millis")), Long.parseLong((String)this.m_global_params.get("server_sleep_millis")), Long.parseLong((String)this.m_global_params.get("test_sleep_millis")), server_shutdown_wait, cube_timeout_millis, (String)this.m_global_params.get("ptest_log_dir"), (String)this.m_global_params.get("killall_prog"), (String)this.m_global_params.get("killall_prog_options"), (String)this.m_global_params.get("createdest_class"), (String)this.m_global_params.get("createdest_options"));
            output_prefix = remark + ",,,,,,";
            special_client = "vanilla";
            server_cpus = PTest.cpu_numb((String)crds.get("server_affinity"));
            producer_cpus = PTest.cpu_numb((String)crds.get("producer_affinity"));
            consumer_cpus = PTest.cpu_numb((String)crds.get("consumer_affinity"));
            try {
                testcase_obj.main_internal(output_prefix, special_client, Integer.parseInt((String)crds.get("server_agents")), Integer.parseInt((String)crds.get("server_so_polling_time")), Integer.parseInt((String)crds.get("server_send_queue_len")), Integer.parseInt((String)crds.get("server_so_polling_push_sz")), Integer.parseInt((String)crds.get("server_gc_time")), Integer.parseInt((String)crds.get("server_status_output_time")), (String)crds.get("server_affinity"), server_cpus, (String)crds.get("producer_affinity"), producer_cpus, (String)crds.get("consumer_affinity"), consumer_cpus, !((String)crds.get("haveSequential")).equalsIgnoreCase("parallel"), !((String)crds.get("haveAsync")).equalsIgnoreCase("sync"), !((String)crds.get("haveNondurable")).equalsIgnoreCase("durable"), !((String)crds.get("havePersistent")).equalsIgnoreCase("transient"), !((String)crds.get("haveQueue")).equalsIgnoreCase("topic"), Integer.parseInt((String)crds.get("conn_numb")), Integer.parseInt((String)crds.get("sessions_numb")), Integer.parseInt((String)crds.get("clients_numb")), Integer.parseInt((String)crds.get("msg_numb")), Integer.parseInt((String)crds.get("payload_size")), Long.parseLong((String)crds.get("consumer_timeout")), !((String)crds.get("runMsgSel")).equalsIgnoreCase("noselector"), (String)crds.get("message_selector_string"), Integer.parseInt((String)crds.get("dest_numb")), Integer.parseInt((String)crds.get("subscriptions_numb")));
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
                System.out.flush();
            }
        }
    }

    private void dump_g(Node node, Node parent, int level) {
        if (level == 2 && node.getNodeType() == 1 && node.getNodeName().equals("cubes")) {
            this.m_cubes = node;
        } else {
            if (parent != null && parent.getNodeType() == 1 && level == 3) {
                this.m_global_params.put(parent.getNodeName(), node.getNodeValue() == null ? "" : node.getNodeValue());
            }
            NodeList childs = node.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                this.dump_g(childs.item(i), node, level + 1);
            }
        }
    }

    private void set_cube_defaults() {
        int i;
        NodeList cubes_childs = this.m_cubes.getChildNodes();
        Node defcube = null;
        NamedNodeMap defcube_attributes = null;
        NodeList defcube_childs = null;
        for (i = 0; i < cubes_childs.getLength(); ++i) {
            if (!cubes_childs.item(i).getNodeName().equals("defaultcube")) continue;
            defcube = (Element)cubes_childs.item(i);
        }
        defcube_attributes = defcube.getAttributes();
        defcube_childs = defcube.getChildNodes();
        for (i = 0; i < cubes_childs.getLength(); ++i) {
            Element cube = null;
            if (!cubes_childs.item(i).getNodeName().equals("cube")) continue;
            cube = (Element)cubes_childs.item(i);
            for (int j = 0; j < defcube_attributes.getLength(); ++j) {
                Attr def_attr = (Attr)defcube_attributes.item(j);
                String def_attr_name = def_attr.getNodeName();
                if (cube.getAttribute(def_attr_name) != null && !cube.getAttribute(def_attr_name).equals("")) continue;
                cube.setAttribute(def_attr.getName(), def_attr.getValue());
            }
            NodeList cube_childs = cube.getChildNodes();
            for (int j = 0; j < defcube_childs.getLength(); ++j) {
                Node cube_child;
                int k;
                Node defcube_child = defcube_childs.item(j);
                if (defcube_child.getNodeType() != 1 || !defcube_child.getNodeName().equals("list")) continue;
                Element defcube_child_element = (Element)defcube_child;
                String defcube_child_element_name = defcube_child_element.getAttribute("name");
                for (k = 0; !(k >= cube_childs.getLength() || (cube_child = cube_childs.item(k)).getNodeType() == 1 && cube_child.getNodeName().equals("list") && ((Element)cube_child).getAttribute("name").equals(defcube_child_element_name)); ++k) {
                }
                if (k < cube_childs.getLength()) continue;
                cube.insertBefore(defcube_child.cloneNode(true), cube.getFirstChild());
            }
        }
    }

    private void dump_cs(Node node, int level) throws Exception {
        NodeList childs = node.getChildNodes();
        if (level == 1 && node.getNodeType() == 1 && node.getNodeName().equals("cube")) {
            Hashtable cube_coords = new Hashtable();
            for (int i = 0; i < childs.getLength(); ++i) {
                if (childs.item(i).getNodeType() != 1) continue;
                this.dump_c(childs.item(i), cube_coords, node);
                break;
            }
        }
        for (int i = 0; i < childs.getLength(); ++i) {
            this.dump_cs(childs.item(i), level + 1);
        }
    }

    private void dump_c(Node listnode, Hashtable coords, Node cube) throws Exception {
        if (listnode.getNodeType() == 1) {
            NodeList childs = listnode.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                if (childs.item(i).getNodeType() != 1) continue;
                coords.put(((Element)listnode).getAttribute("name"), childs.item(i).getChildNodes().item(0).getNodeValue());
                Node sibling = null;
                for (sibling = listnode.getNextSibling(); sibling != null && sibling.getNodeType() != 1; sibling = sibling.getNextSibling()) {
                }
                if (sibling != null) {
                    this.dump_c(sibling, coords, cube);
                    continue;
                }
                this.runcase(coords, Long.parseLong(((Element)cube).getAttribute("timeout")), !((Element)cube).getAttribute("restart").equals("false"), Long.parseLong(((Element)cube).getAttribute("server_shutdown_wait")), ((Element)cube).getAttribute("remark"));
            }
        }
    }

    public static String format(String s, int lead, int trunc) {
        int comma;
        int dec;
        String retval = s;
        int dot = s.lastIndexOf(".");
        int n = dec = dot < (comma = s.lastIndexOf(",")) ? comma : dot;
        if (dec >= 0 && s.indexOf("e") < 0 && s.indexOf("E") < 0) {
            retval = s.substring(0, dec + trunc + 1 <= s.length() ? dec + trunc + 1 : s.length());
        }
        retval = PTest.toLB(retval, lead + (dec >= 0 ? trunc + 1 : 0));
        return retval;
    }

    private static String toLB(String s, int len) {
        String retval = s;
        if (s.length() < len) {
            retval = "                                                             ".substring(0, len - s.length()) + s;
        }
        return retval;
    }

    public static String format(int i, int lead, int trunc) {
        return PTest.format(Integer.toString(i), lead, trunc);
    }

    public static String format(long i, int lead, int trunc) {
        return PTest.format(Long.toString(i), lead, trunc);
    }

    public static String format(float i, int lead, int trunc) {
        return PTest.format(Float.toString(i), lead, trunc);
    }

    public static String format(double i, int lead, int trunc) {
        return PTest.format(Double.toString(i), lead, trunc);
    }

    private static int cpu_numb(String procaff_mask) {
        int pow;
        int mask = Integer.parseInt(procaff_mask);
        int retval = 0;
        if (mask == 0) {
            return 0;
        }
        for (pow = 1; pow <= mask; pow *= 2) {
        }
        pow /= 2;
        while (mask > 0) {
            mask -= pow;
            ++retval;
            pow /= 2;
        }
        return retval;
    }
}

