/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.msgselector;

import com.sap.sdb.msgServer.client.MessageHeaderFields;
import com.sap.sdb.msgServer.client.MessageProperties;
import com.sap.sdb.msgServer.msgselector.DemonstrationData;
import com.sap.sdb.msgServer.msgselector.DemonstrationDataOld1;
import com.sap.sdb.msgServer.msgselector.DemonstrationDataOld2;
import com.sap.sdb.msgServer.msgselector.DemonstrationDataOld3;
import com.sap.sdb.msgServer.msgselector.DemonstrationDataOld4;
import com.sap.sdb.msgServer.msgselector.DemonstrationDataOld5;
import com.sap.sdb.msgServer.msgselector.GlobalContextSupplier;
import com.sap.sdb.msgServer.msgselector.parsing.AbstractTreeNode;
import com.sap.sdb.msgServer.msgselector.parsing.ExpressionTreeBuilder;
import com.sap.sdb.msgServer.msgselector.parsing.Set;
import com.sap.sdb.msgServer.msgselector.parsing.Token;
import com.sap.sdb.msgServer.msgselector.parsing.Tokenizer;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Vector;

public class Demonstration {
    private static String[][] st_m_queries = new String[6][];
    private static String[][][] st_m_testcases = new String[6][][];
    private static MessageHeaderFields st_m_header;
    private static MessageProperties st_m_props;
    private static GlobalContextSupplier st_m_globCtx;
    private static boolean st_m_init_failed;
    private static String st_m_init_error;
    private static final boolean TEST_TESTFRAME = true;

    private static void initialize() {
        try {
            Demonstration.st_m_queries[0] = DemonstrationDataOld1.getTestExpressions();
            Demonstration.st_m_queries[1] = DemonstrationDataOld2.getTestExpressions();
            Demonstration.st_m_queries[2] = DemonstrationDataOld3.getTestExpressions();
            Demonstration.st_m_queries[3] = DemonstrationDataOld4.getTestExpressions();
            Demonstration.st_m_queries[4] = DemonstrationDataOld5.getTestExpressions();
            Demonstration.st_m_queries[5] = DemonstrationData.getTestExpressions();
            Demonstration.st_m_testcases[0] = DemonstrationDataOld1.getTestCases();
            Demonstration.st_m_testcases[1] = DemonstrationDataOld2.getTestCases();
            Demonstration.st_m_testcases[2] = DemonstrationDataOld3.getTestCases();
            Demonstration.st_m_testcases[3] = DemonstrationDataOld4.getTestCases();
            Demonstration.st_m_testcases[4] = DemonstrationDataOld5.getTestCases();
            Demonstration.st_m_testcases[5] = DemonstrationData.getTestCases();
            st_m_header = DemonstrationData.createTestHeader();
            st_m_props = DemonstrationData.createTestProps();
            st_m_globCtx = new GlobalContextSupplier(st_m_header, st_m_props);
        }
        catch (Exception e) {
            st_m_init_error = e.toString();
            return;
        }
        st_m_init_failed = false;
    }

    private static String[] parseAndExecute(String qry) {
        String[] retval = new String[4];
        Vector vecTokens = null;
        AbstractTreeNode expressionRootNode = null;
        Object resultobj = null;
        retval[0] = qry;
        retval[1] = "";
        retval[2] = "";
        retval[3] = "";
        try {
            int len = qry.length();
            char[] buf = new char[len];
            qry.getChars(0, len, buf, 0);
            vecTokens = Tokenizer.tokenize((char[])buf);
            for (int i = 0; i < vecTokens.size(); ++i) {
                retval[1] = retval[1] + "[" + ((Token)vecTokens.elementAt(i)).getSQLToken() + "] ";
            }
            expressionRootNode = ExpressionTreeBuilder.buildExpressionTree((Vector)vecTokens);
            retval[2] = Demonstration.dumpTree(expressionRootNode, 0);
            MessageHeaderFields header = new MessageHeaderFields();
            MessageProperties props = new MessageProperties();
            GlobalContextSupplier globCtx = new GlobalContextSupplier(header, props);
            expressionRootNode.evaluate((Set)globCtx, true);
            resultobj = expressionRootNode.evaluate((Set)st_m_globCtx, false);
            retval[3] = resultobj == null ? "*** null value ***" : resultobj.toString();
        }
        catch (Exception ex) {
            retval[3] = ex.getClass().getName() + ":" + ex.getMessage();
        }
        return retval;
    }

    private static String JavaLiteralize(String[] arry) {
        StringBuffer sbuf = new StringBuffer("{ ");
        for (int i = 0; i < arry.length; ++i) {
            sbuf.append(Demonstration.JavaLiteralize(arry[i]) + ", ");
        }
        sbuf.append(" }");
        return sbuf.toString();
    }

    private static String dumpTree(AbstractTreeNode node, int level) {
        String retval = Demonstration.level(node.toString(), level);
        int len = node.getChildrenCount();
        for (int i = 0; i < len; ++i) {
            retval = retval + Demonstration.dumpTree(node.getChildAt(i), level + 1);
        }
        return retval;
    }

    private static String level(String s, int n) {
        char[] ca = new char[n];
        Arrays.fill(ca, '#');
        return new String(ca) + s;
    }

    private static String JavaLiteralize(String inp) {
        StringBuffer sbuf = new StringBuffer("\"");
        char[] bbuf = new char[inp.length()];
        inp.getChars(0, inp.length(), bbuf, 0);
        block9: for (int i = 0; i < bbuf.length; ++i) {
            switch (bbuf[i]) {
                case '\b': {
                    sbuf.append('\\');
                    sbuf.append('b');
                    continue block9;
                }
                case '\t': {
                    sbuf.append('\\');
                    sbuf.append('t');
                    continue block9;
                }
                case '\n': {
                    sbuf.append('\\');
                    sbuf.append('n');
                    continue block9;
                }
                case '\f': {
                    sbuf.append('\\');
                    sbuf.append('f');
                    continue block9;
                }
                case '\r': {
                    sbuf.append('\\');
                    sbuf.append('r');
                    continue block9;
                }
                case '\"': {
                    sbuf.append('\\');
                    sbuf.append('\"');
                    continue block9;
                }
                case '\\': {
                    sbuf.append('\\');
                    sbuf.append('\\');
                    continue block9;
                }
                default: {
                    if (bbuf[i] > '\u00ff') {
                        sbuf.append("\\u");
                        sbuf.append(Demonstration.toTZ(Integer.toHexString(bbuf[i]), 4));
                        continue block9;
                    }
                    sbuf.append(bbuf[i]);
                }
            }
        }
        sbuf.append('\"');
        return new String(sbuf);
    }

    public static Vector TestframeMain() {
        return Demonstration.TestframeMain(null);
    }

    public static Vector TestframeMain(PrintStream cons) {
        Vector<String> retval = new Vector<String>();
        if (st_m_init_failed) {
            String errtext = "static initialization of test case driver failed : \n" + st_m_init_error;
            Demonstration.println_aux(cons, errtext);
            retval.add(errtext);
        } else {
            int k;
            int tlen = 0;
            for (k = 0; k < st_m_testcases.length; ++k) {
                tlen += st_m_testcases[k].length;
            }
            int tcount = 0;
            for (k = 0; k < st_m_testcases.length; ++k) {
                int i = 0;
                while (i < st_m_testcases[k].length) {
                    int j;
                    String progress = Demonstration.toLZ(tcount + 1, 4) + "/" + Demonstration.toLZ(tlen, 4);
                    Demonstration.println_aux(cons, progress + " :" + Demonstration.JavaLiteralize(st_m_testcases[k][i][0]));
                    String[] output = Demonstration.parseAndExecute(st_m_testcases[k][i][0]);
                    for (j = 0; j < st_m_testcases[k][i].length && st_m_testcases[k][i][j].equals(output[j]); ++j) {
                    }
                    if (j < st_m_testcases[k][i].length) {
                        String errtext = progress + " SHOULD BE : " + Demonstration.JavaLiteralize(st_m_testcases[k][i]) + "\n" + progress + "   ,BUT IS : " + Demonstration.JavaLiteralize(output) + "\n";
                        retval.add(errtext);
                    }
                    ++i;
                    ++tcount;
                }
            }
        }
        return retval;
    }

    private static String toLZ(int i, int len) {
        String s = Integer.toString(i);
        if (s.length() > len) {
            return s.substring(0, len);
        }
        if (s.length() < len) {
            return "000000000000000000000000000".substring(0, len - s.length()) + s;
        }
        return s;
    }

    private static String toTZ(String s, int len) {
        if (s.length() > len) {
            return s.substring(0, len);
        }
        if (s.length() < len) {
            return s + "000000000000000000000000000".substring(0, len - s.length());
        }
        return s;
    }

    private static void println_aux(PrintStream cons, String str) {
        if (cons != null) {
            cons.println(str);
        }
    }

    private static void TestTestframeMain() {
        Vector errs = Demonstration.TestframeMain(System.out);
        System.out.println("ERROR SUMMARY :");
        for (int i = 0; i < errs.size(); ++i) {
            System.out.print((String)errs.elementAt(i));
        }
        System.out.println("END OF ERROR SUMMARY.");
    }

    private static void GenMain() {
        System.out.println("-----------------------------------------------------------------------------");
        if (st_m_init_failed) {
            System.out.println("static initialization failed : " + st_m_init_error);
        } else {
            System.out.println("{");
            for (int k = 0; k < st_m_testcases.length; ++k) {
                for (int i = 0; i < st_m_queries[k].length; ++i) {
                    String[] output = Demonstration.parseAndExecute(st_m_queries[k][i]);
                    System.out.print(Demonstration.JavaLiteralize(output));
                    System.out.println(",");
                }
            }
            System.out.println("};");
        }
        System.out.println("-----------------------------------------------------------------------------");
    }

    public static void main(String[] args) {
        Demonstration.TestTestframeMain();
    }

    static {
        st_m_init_failed = true;
        st_m_init_error = "";
        Demonstration.initialize();
    }
}

