/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.utilities.webdav.protocol;

import com.sap.sapdb.testframe.utilities.webdav.protocol.WebDAVException;
import com.sap.sapdb.testframe.utilities.webdav.protocol.WebDAVPrepareCore;
import java.io.File;
import java.net.URL;
import java.util.Vector;

public class WebDAVTimoutHandler
implements Runnable {
    protected WebDAVPrepareCore core = null;
    protected static final int UPLOAD = 1;
    protected static final int DOWNLOAD = 2;
    protected static final int EXISTS = 3;
    protected static final int LIST = 4;
    protected static final int CREATE = 5;
    protected int action;
    protected File mFile;
    protected String mString;
    protected String mResource;
    protected Vector mVector;
    protected Vector mSizeVector;
    protected int mMode;
    protected boolean result;
    protected int status;

    public WebDAVTimoutHandler(URL url) {
        this.core = new WebDAVPrepareCore(url);
    }

    public void run() {
        this.status = 0;
        try {
            if (this.action == 1) {
                if (this.mFile != null) {
                    this.result = this.core.upload(this.mFile, this.mResource);
                } else if (this.mString != null) {
                    this.result = this.core.upload(this.mString, this.mResource);
                }
            } else if (this.action == 2) {
                this.result = this.core.download(this.mResource, this.mFile);
            } else if (this.action == 3) {
                this.result = this.core.exists(this.mResource);
            } else if (this.action == 4) {
                this.mVector = this.core.list(this.mResource, this.mMode);
            } else if (this.action == 5) {
                this.result = this.core.create(this.mResource);
            }
        }
        catch (WebDAVException wde) {
            this.status = wde.getStatusCode();
        }
    }

    public void setActionList(String resource, int mode) {
        this.action = 4;
        this.mResource = resource;
        this.mMode = mode;
        this.mVector = null;
    }

    public void setActionUpload(String content, String resource) {
        this.action = 1;
        this.mResource = resource;
        this.mString = content;
        this.mFile = null;
        this.result = false;
    }

    public void setActionUpload(File file, String resource) {
        this.action = 1;
        this.mResource = resource;
        this.mFile = file;
        this.mString = null;
        this.result = false;
    }

    public void setActionDownload(String resource, File file) {
        this.action = 2;
        this.mResource = resource;
        this.mFile = file;
        this.result = false;
    }

    public void setActionExists(String resource) {
        this.action = 3;
        this.mResource = resource;
        this.result = false;
    }

    public void setActionCreate(String resource) {
        this.action = 5;
        this.mResource = resource;
    }

    public Vector getVector() {
        return this.mVector;
    }

    public Vector getSizeVector() {
        return this.mSizeVector;
    }

    public boolean getResult() {
        return this.result;
    }

    public int getStatusCode() {
        return this.status;
    }
}

